/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class ModelNBBuildSettingsPanel
extends AbstractPropertiesPanel {
    private boolean _isDatabaseVersion12_2andUp = false;
    private boolean isModelPartitioned = false;
    private JLabel jLabelPair;
    private JLabel jLabelSingleton;
    private JScrollPane jScrollPane1;
    private JTextField jTextPair;
    private JTextField jTextSingleton;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public ModelNBBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        Version version = ConfigUtils.getDatabaseVersion(advancedSettingsPanel.getContext());
        this._isDatabaseVersion12_2andUp = DbVersionHelper.isDB122Up((Version)version);
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        PartitionExpressions partitionExpressions = commonSettingDataObject.getParentPanel().getMetadataCopy().getPartitionExpressions();
        if (partitionExpressions != null && partitionExpressions.getPartitionExpression() != null && partitionExpressions.getPartitionExpression().size() > 0) {
            this.isModelPartitioned = true;
        }
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jLabelSingleton = new JLabel();
        this.jTextSingleton = new NumberTextField();
        this.jLabelPair = new JLabel();
        this.jTextPair = new NumberTextField();
        this.jScrollPane1.setBorder(null);
        this.jLabelSingleton.setText("Singleton Threshold:");
        this.jTextSingleton.setText("0.01");
        this.jTextSingleton.setToolTipText("Range: >= 0 and <= 0.01");
        this.jLabelPair.setText("Pairwise Threshold:");
        this.jTextPair.setText("0.01");
        this.jTextPair.setToolTipText("Range: >= 0 and <= 0.01");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabelPair, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelSingleton, GroupLayout.Alignment.LEADING, -1, 107, Short.MAX_VALUE)).addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextPair).addComponent(this.jTextSingleton, -1, 110, Short.MAX_VALUE)).addGap(0, 151, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 52, -2).addGap(22, 22, 22).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSingleton).addComponent(this.jTextSingleton, -2, -1, -2)).addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPair).addComponent(this.jTextPair, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void initUI() {
        this.loadDescription(this._jDescription, this.jScrollPane1);
        ResourceUtils.resLabel((JLabel)this.jLabelSingleton, (Component)this.jTextSingleton, (String)AlgSettingsLrb.get("SINGLTETON_THRESHOLD"));
        this.jTextSingleton.setToolTipText(AlgSettingsLrb.get("SINGLTETON_THRESHOLD_TIP"));
        String string = this.getPanelState().getModelSettingStringValue("NABS_SINGLETON_THRESHOLD");
        this.setDataType(this.jTextSingleton, Double.class);
        ((NumberTextField)this.jTextSingleton).setDecimal(true, 4);
        this.setSigned(this.jTextSingleton, false);
        this.setLocale(this.jTextSingleton, this.getPanelState().getLocale());
        this.setNumber(this.jTextSingleton, string != null && !string.isEmpty() ? Double.valueOf(string) : 0.01);
        ResourceUtils.resLabel((JLabel)this.jLabelPair, (Component)this.jTextPair, (String)AlgSettingsLrb.get("PAIRWISE_THRESHOLD"));
        this.jTextPair.setToolTipText(AlgSettingsLrb.get("PAIRWISE_THRESHOLD_TIP"));
        string = this.getPanelState().getModelSettingStringValue("NABS_PAIRWISE_THRESHOLD");
        this.setDataType(this.jTextPair, Double.class);
        ((NumberTextField)this.jTextPair).setDecimal(true, 4);
        this.setSigned(this.jTextPair, false);
        this.setLocale(this.jTextPair, this.getPanelState().getLocale());
        this.setNumber(this.jTextPair, string != null && !string.isEmpty() ? Double.valueOf(string) : 0.01);
    }

    @Override
    public void processInput() {
        Number number = this.getNumber(this.jTextSingleton);
        if (null == number || number.doubleValue() < 0.0 || number.doubleValue() > 1.0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("NABS_SINGLETON_THRESHOLD_OUT_OF_RANGE"));
            return;
        }
        this.setObjectValue("NABS_SINGLETON_THRESHOLD", number);
        number = this.getNumber(this.jTextPair);
        if (null == number || number.doubleValue() < 0.0 || number.doubleValue() > 1.0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("NABS_PAIRWISE_THRESHOLD_OUT_OF_RANGE"));
            return;
        }
        this.setObjectValue("NABS_PAIRWISE_THRESHOLD", number);
        this.getPanelState().setCommonPerformanceOption();
    }
}

