/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.NavigatorAddin;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.EventLog;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.runner.EventLogPanel;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.runner.RunnerPreferencesSettings;
import oracle.dmt.dataminer.runner.TasksWindow;
import oracle.dmt.dataminer.utils.DataMinerConnections;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleWorkflowDialog;
import oracle.dmt.dataminer.workflow.scheduler.SchedulerModel;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.jdeveloper.db.ConnectionException;

public final class SchedulePanel
extends JPanel
implements DataminerGUIPanel,
ConnectionListener {
    private static final Logger theLogger = Logger.getLogger(SchedulePanel.class.getName());
    protected DockableWindow _dockableWindow;
    private boolean _autoSwitchConnection;
    private boolean _connectionLost;
    private DataMinerTable _jobsTable;
    private JScrollPane _scrollPane;
    private Toolbar _toolbar;
    private String _connectionName;
    private ScheduleTableModel _tableModel;
    private JComboBox _connCombo;
    private ToolButton _btnLog;
    private ToolButton _btnCancel;
    private ToolButton _btnCancelSchedule;
    private ToolButton _btnEditSchedule;
    private ToolButton _btnRefresh;
    private static int EVENTLOG_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.openEventLog");
    private static int TERMINATE_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.doTerminate");
    private static int REFRESH_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.runManagerRefresh");
    private static int CANCEL_SCHEDULE_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.cancelSchedule");
    private static int EDIT_SCHEDULE_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.editSchedule");
    private static Object syncForSwitchConnection = new Object();
    private transient List<Object> commandQueue = new ArrayList<Object>();

    public SchedulePanel(DockableWindow dockableWindow) {
        this.initComponents();
        this._dockableWindow = dockableWindow;
        this._connectionLost = false;
        RunnerPreferencesSettings runnerPreferencesSettings = RunnerPreferencesSettings.getInstance();
        this._autoSwitchConnection = runnerPreferencesSettings.getAutoSelectConnection();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._toolbar = new Toolbar();
        this._scrollPane = new JScrollPane();
        this._jobsTable = new DataMinerTable();
        this.setLayout(new BorderLayout());
        this._scrollPane.setViewportView((Component)((Object)this._jobsTable));
        this.add((Component)this._toolbar, "First");
        this.add((Component)this._scrollPane, "Center");
    }

    @Override
    public void initRes() {
    }

    private boolean isInSelectedWorkflows(BigDecimal bigDecimal) {
        for (int n : this._jobsTable.getSelectedRowsInModel()) {
            if (!((ScheduleTableModel)((Object)this._jobsTable.getModel())).getDataList().get(n).getWorkflowId().equals(bigDecimal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initUI() {
        Object object;
        this._tableModel = new ScheduleTableModel(new ArrayList<WorkflowJob>());
        List<Object> list = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            list = Connections.getInstance().getConnections();
            Connections.getInstance().addListener(this);
            arrayList.addAll(list);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)RunManagerLrb.get("JOB_UI_INIT_FAIL"), (String)RunManagerLrb.get("JOB_UI_INIT_FAIL_DESCR"), null);
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        IdeAction ideAction = IdeAction.get((int)EVENTLOG_CMDID);
        IdeAction ideAction2 = IdeAction.get((int)TERMINATE_CMDID);
        IdeAction ideAction3 = IdeAction.get((int)REFRESH_CMDID);
        IdeAction ideAction4 = IdeAction.get((int)CANCEL_SCHEDULE_CMDID);
        IdeAction ideAction5 = IdeAction.get((int)EDIT_SCHEDULE_CMDID);
        this._btnCancel = new ToolButton((Action)ideAction2);
        this._btnLog = new ToolButton((Action)ideAction);
        this._btnRefresh = new ToolButton((Action)ideAction3);
        this._btnCancelSchedule = new ToolButton((Action)ideAction4);
        this._btnEditSchedule = new ToolButton((Action)ideAction5);
        this._btnLog.setIcon(OracleIcons.getIcon((String)"log.png"));
        this._btnLog.setToolTipText(RunManagerLrb.get("VIEW_LOG"));
        this._btnRefresh.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this._btnRefresh.setToolTipText(RunManagerLrb.get("REFRESH_TIP"));
        this._btnCancelSchedule.setIcon(OracleIcons.getIcon((String)"terminate.png"));
        this._btnCancelSchedule.setToolTipText(RunManagerLrb.get("CANCEL_SCHEDULE"));
        this._btnEditSchedule.setIcon(OracleIcons.getIcon((String)"edit.png"));
        this._btnEditSchedule.setToolTipText(RunManagerLrb.get("EDIT_SCHEDULE"));
        this._connCombo = new JComboBox();
        this._connCombo.setRenderer(new ConnectionItemRenderer());
        this._connCombo.setToolTipText(RunManagerLrb.get("CONNECTION_TOOLTIP"));
        this._connCombo.setModel(defaultComboBoxModel);
        this._connCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchedulePanel.this.switchConnection();
            }
        });
        RunnerPreferencesSettings runnerPreferencesSettings = RunnerPreferencesSettings.getInstance();
        runnerPreferencesSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                for (int i = 0; i < changeInfoArray.length; ++i) {
                    ChangeInfo changeInfo = changeInfoArray[i];
                    if (changeInfo.getPropertyName().equals("autoSelectConnection")) {
                        SchedulePanel.this._autoSwitchConnection = changeInfo.getNewValueAsBoolean();
                        continue;
                    }
                    if (!changeInfo.getPropertyName().equals("maxJobAge")) continue;
                    RunManager.setUserMaxJobAgePreference(changeInfo.getNewValueAsInt());
                    SchedulePanel.this.switchConnection();
                }
            }
        });
        if (list.size() != 0) {
            object = runnerPreferencesSettings.getDefaultConnectionName();
            if (object != null) {
                this._connCombo.setSelectedItem(object);
            } else {
                this._connectionName = objectArray[0];
                this._connCombo.setSelectedIndex(0);
            }
        } else {
            this._connectionName = null;
            this._connCombo.setEnabled(false);
            this._btnLog.setEnabled(false);
            this._btnCancel.setEnabled(false);
            this._btnCancelSchedule.setEnabled(false);
            this._btnEditSchedule.setEnabled(false);
        }
        this._btnLog.addActionListener(actionEvent -> this.openLog());
        this._btnRefresh.addActionListener(actionEvent -> this.refresh());
        this._btnCancelSchedule.addActionListener(actionEvent -> {
            ArrayList<WorkflowJob> arrayList = new ArrayList<WorkflowJob>();
            for (int n : this._jobsTable.getSelectedRowsInModel()) {
                WorkflowJob workflowJob = this._tableModel.getDataList().get(n);
                if (!workflowJob.isScheduled()) continue;
                arrayList.add(workflowJob);
            }
            this.cancelScheduleJob(arrayList);
        });
        this._btnEditSchedule.addActionListener(actionEvent -> {
            int[] nArray = this._jobsTable.getSelectedRowsInModel();
            if (nArray.length > 0) {
                WorkflowJob workflowJob = this._tableModel.getDataList().get(nArray[0]);
                this.editScheduleJob(workflowJob);
            }
        });
        this._jobsTable.setAutoResizeMode(3);
        this._jobsTable.setColumnSelectorAvailable(false);
        this._jobsTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            this.updateButtonStates();
        });
        object = new JMenuItem(RunManagerLrb.get("OPEN_WORKFLOW"));
        ((AbstractButton)object).addActionListener(actionEvent -> this.openWorkflow());
        final JMenuItem jMenuItem = new JMenuItem(RunManagerLrb.get("CANCEL_SCHEDULE"));
        jMenuItem.setIcon(OracleIcons.getIcon((String)"terminate.png"));
        jMenuItem.addActionListener(actionEvent -> {
            ArrayList<WorkflowJob> arrayList = new ArrayList<WorkflowJob>();
            for (int n : this._jobsTable.getSelectedRowsInModel()) {
                WorkflowJob workflowJob = this._tableModel.getDataList().get(n);
                if (!workflowJob.isScheduled()) continue;
                arrayList.add(workflowJob);
            }
            this.cancelScheduleJob(arrayList);
        });
        final JMenuItem jMenuItem2 = new JMenuItem(RunManagerLrb.get("EDIT_SCHEDULE"));
        jMenuItem2.setIcon(OracleIcons.getIcon((String)"edit.png"));
        jMenuItem2.addActionListener(actionEvent -> {
            int[] nArray = this._jobsTable.getSelectedRowsInModel();
            if (nArray.length > 0) {
                WorkflowJob workflowJob = this._tableModel.getDataList().get(nArray[0]);
                this.editScheduleJob(workflowJob);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(RunManagerLrb.get("VIEW_LOG"));
        jMenuItem3.setIcon(OracleIcons.getIcon((String)"log.png"));
        jMenuItem3.addActionListener(actionEvent -> this.openLog());
        this._jobsTable.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = SchedulePanel.this._jobsTable.rowAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                int n2 = SchedulePanel.this._jobsTable.convertRowIndexToModel(n);
                BigDecimal bigDecimal = ((ScheduleTableModel)((Object)SchedulePanel.this._jobsTable.getModel())).getDataList().get(n2).getWorkflowId();
                if (!SchedulePanel.this.isInSelectedWorkflows(bigDecimal)) {
                    SchedulePanel.this._jobsTable.setSelectedRowInModel(n2);
                }
                if (mouseEvent.getClickCount() == 2) {
                    SchedulePanel.this.openWorkflow();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }
        });
        this._jobsTable.addMouseListener(new MouseAdapter((JMenuItem)object, jMenuItem3){
            final /* synthetic */ JMenuItem val$goToItem;
            final /* synthetic */ JMenuItem val$openLogItem;
            {
                this.val$goToItem = jMenuItem3;
                this.val$openLogItem = jMenuItem4;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private boolean isOneJobScheduled(List<WorkflowJob> list) {
                for (WorkflowJob workflowJob : list) {
                    if (!workflowJob.isScheduled()) continue;
                    return true;
                }
                return false;
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ContextMenu contextMenu = new ContextMenu();
                    JPopupMenu jPopupMenu = (JPopupMenu)contextMenu.getGUI(true);
                    List list = SchedulePanel.this.getJobsSelection();
                    if (!list.isEmpty()) {
                        if (this.isOneJobScheduled(list)) {
                            jPopupMenu.add(jMenuItem);
                            if (list.size() == 1) {
                                jPopupMenu.add(jMenuItem2);
                            }
                            jPopupMenu.addSeparator();
                        }
                        if (list.size() == 1) {
                            jPopupMenu.add(this.val$goToItem);
                            jPopupMenu.add(this.val$openLogItem);
                        }
                    }
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    jPopupMenu = null;
                }
            }
        });
        this._toolbar.add((Component)this._connCombo);
        this._toolbar.add((Component)this._btnRefresh);
        this._toolbar.forcePrimaryViewToolbar(true);
        this.updateButtonStates();
    }

    private void refresh() {
        try {
            this.switchConnection(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
    }

    protected void openLog() {
        WorkflowJob workflowJob = null;
        int[] nArray = this._jobsTable.getSelectedRowsInModel();
        if (nArray.length > 0) {
            workflowJob = this._tableModel.getDataList().get(nArray[0]);
        }
        if (workflowJob == null) {
            return;
        }
        String string = this._tableModel.getJobConnectionName(workflowJob);
        EventLog.EntryInfo entryInfo = new EventLog.EntryInfo(null);
        if (workflowJob != null) {
            entryInfo.setJob(workflowJob);
            entryInfo.setJobId(workflowJob.getWorkflowId());
            entryInfo.setProjectId(workflowJob.getProjectId());
            entryInfo.setWorkflowId(workflowJob.getWorkflowId());
        }
        EventLogPanel eventLogPanel = new EventLogPanel(string, entryInfo.getJob().getProjectId(), entryInfo.getJob().getWorkflowId(), entryInfo, false);
        DialogHelper dialogHelper = new DialogHelper(eventLogPanel);
        dialogHelper.showAsDialog(this);
    }

    protected void openWorkflow() {
        WorkflowJob workflowJob = null;
        int[] nArray = this._jobsTable.getSelectedRowsInModel();
        if (nArray.length > 0) {
            workflowJob = this._tableModel.getDataList().get(nArray[0]);
        }
        if (workflowJob == null) {
            return;
        }
        URL uRL = DMURLFormatHelper.getURL(this.getConnectionName() + "/" + workflowJob.getProjectName() + "/" + workflowJob.getWorkflowName());
        AddinManager addinManager = AddinManager.getAddinManager();
        NavigatorAddin navigatorAddin = (NavigatorAddin)addinManager.getAddin(NavigatorAddin.class);
        NavigatorWindow navigatorWindow = navigatorAddin.getNavigatorManager().getNavigatorWindow();
        final TreeExplorer treeExplorer = navigatorWindow.getTreeExplorer();
        try {
            final WorkflowNode workflowNode = (WorkflowNode)NodeFactory.findOrCreate((URL)uRL);
            class ExpandTask
            implements Runnable {
                private TNode targetNode = null;
                ProgressBar progressBar;

                @Override
                public void run() {
                    this.progressBar.updateProgress(RunManagerLrb.get("OPEN_LOCATING"), "");
                    URL uRL = DMURLFormatHelper.getURL(SchedulePanel.this.getConnectionName());
                    ConnectionFolder connectionFolder = (ConnectionFolder)NodeFactory.find((URL)uRL);
                    TNode tNode = treeExplorer.searchTNodeBreadthFirst((Element)connectionFolder, treeExplorer.getRoot());
                    this.targetNode = BaseDeferredFilter.findTreeNode((BaseTreeNode)workflowNode, tNode);
                    if (this.targetNode == null) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)new Exception(), (String)RunManagerLrb.get("OPEN_ERROR"));
                        this.progressBar.setDoneStatus();
                        return;
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                progressBar.updateProgress(RunManagerLrb.get("OPEN_OPENING"), "");
                                if (progressBar.hasUserCancelled()) {
                                    return;
                                }
                                EditorManager editorManager = EditorManager.getEditorManager();
                                Context context = Context.newIdeContext((Node)workflowNode);
                                editorManager.openDefaultEditorInFrame(context);
                            }
                        });
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)RunManagerLrb.get("OPEN_ERROR"));
                    }
                    this.progressBar.setDoneStatus();
                }

                public void setProgressBar(ProgressBar progressBar) {
                    this.progressBar = progressBar;
                }
            }
            ExpandTask expandTask = new ExpandTask();
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), RunManagerLrb.get("OPEN_OPEN"), (Runnable)expandTask, false);
            progressBar.setCancelable(true);
            expandTask.setProgressBar(progressBar);
            progressBar.start(RunManagerLrb.get("OPEN_LOCATING"), "");
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unable to open workflow", (String)"Unable to open workflow due to internal error");
        }
    }

    private List<WorkflowJob> getJobsSelection() {
        if (!(this._jobsTable.getModel() instanceof ScheduleTableModel)) {
            return Collections.emptyList();
        }
        ScheduleTableModel scheduleTableModel = (ScheduleTableModel)((Object)this._jobsTable.getModel());
        ArrayList<WorkflowJob> arrayList = new ArrayList<WorkflowJob>();
        Arrays.stream(this._jobsTable.getSelectedRowsInModel()).forEach(n -> arrayList.add(scheduleTableModel.getDataList().get(n)));
        return arrayList;
    }

    private void cancelScheduleJob(final List<WorkflowJob> list) {
        if (list.isEmpty()) {
            return;
        }
        if (this._jobsTable.getModel() instanceof ScheduleTableModel) {
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)RunManagerLrb.get("WORKFLOW_SCHEDULE_WILL_BE_CANCELED"), (String)RunManagerLrb.get("WORKFLOW_SCHEDULE_CANCEL_WARNING_TITLE"), null)) {
                String string;
                WorkflowEditor workflowEditor;
                final EditorManager editorManager = EditorManager.getEditorManager();
                for (WorkflowJob workflowJob : list) {
                    workflowEditor = null;
                    string = workflowJob.getWorkflowId().toString();
                    for (Editor editor : editorManager.getAllEditors()) {
                        if (!(editor instanceof WorkflowEditor) || !(workflowEditor = (WorkflowEditor)editor).getWorkflowId().equals(string)) continue;
                        workflowEditor.displayOverLayPanel(editor.getViewWithoutDecoration(), BlockingComponent.Message.CANCELLING);
                    }
                }
                try {
                    RunManager.stopWorkflow(list, this._connectionName, new Runnable(){

                        @Override
                        public void run() {
                            SchedulePanel.this.refresh();
                            for (WorkflowJob workflowJob : list) {
                                WorkflowEditor workflowEditor = null;
                                String string = workflowJob.getWorkflowId().toString();
                                for (Editor editor : editorManager.getAllEditors()) {
                                    if (!(editor instanceof WorkflowEditor) || !(workflowEditor = (WorkflowEditor)editor).getWorkflowId().equals(string)) continue;
                                    workflowEditor.refresh(true);
                                }
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)RunManagerLrb.get("JOB_UI_CANCEL_FAIL"), (String)RunManagerLrb.get("JOB_UI_CANCEL_FAIL_DESCR"), null);
                }
                for (WorkflowJob workflowJob : list) {
                    workflowEditor = null;
                    string = workflowJob.getWorkflowId().toString();
                    for (Editor editor : editorManager.getAllEditors()) {
                        if (!(editor instanceof WorkflowEditor) || !(workflowEditor = (WorkflowEditor)editor).getWorkflowId().equals(string)) continue;
                        workflowEditor.setLockOwner(true);
                    }
                }
            } else {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)RunManagerLrb.get("WORKFLOW_RUNNING_DESCR"), (String)RunManagerLrb.get("WORKFLOW_RUNNING"), null);
            }
        }
    }

    private void editScheduleJob(WorkflowJob workflowJob) {
        if (workflowJob == null) {
            return;
        }
        try {
            URL uRL = DMURLFormatHelper.getURL(this.getConnectionName());
            ConnectionFolder connectionFolder = (ConnectionFolder)NodeFactory.find((URL)uRL);
            final Context context = Context.newIdeContext((Node)connectionFolder);
            final SchedulerModel schedulerModel = new SchedulerModel(context, workflowJob.getProjectId(), workflowJob.getWorkflowId(), null, null);
            final class Initialization
            extends ProgressRunnable {
                Initialization() {
                }

                protected Object doWork() throws Exception {
                    schedulerModel.loadSchedules();
                    schedulerModel.load();
                    return null;
                }

                protected void finish(Object object) {
                }
            }
            Initialization initialization = new Initialization();
            initialization.setTitle(WorkflowEditorLrb.get("SCHEDULE_WORKFLOW"));
            initialization.setMessage(WorkflowEditorLrb.get("SCHEDULE_LOAD_SCHEDULE_DESCR"));
            initialization.setCancelable(false);
            try {
                initialization.start(true);
            }
            catch (ProgressException progressException) {
                theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
            }
            ScheduleWorkflowDialog scheduleWorkflowDialog = new ScheduleWorkflowDialog((JFrame)Ide.getMainWindow(), context, schedulerModel, true);
            scheduleWorkflowDialog.setVisible(true);
            if (scheduleWorkflowDialog.isDialogOk()) {
                final class EditScheduleWorkflowProgressRunnable
                extends ProgressRunnable {
                    EditScheduleWorkflowProgressRunnable() {
                    }

                    protected Object doWork() throws Exception {
                        try {
                            ConnectionFolder connectionFolder = (ConnectionFolder)context.getNode();
                            schedulerModel.editSchedule(connectionFolder.getConnection());
                        }
                        catch (Exception exception) {
                            if (exception.getMessage().contains("ORA-24098")) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("SCHEDULE_WORKFLOW_EMAIL_SERVER_INVALID"), (String)WorkflowEditorLrb.get("SCHEDULE_ERROR_TITLE"), null);
                            }
                            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                            throw exception;
                        }
                        SchedulePanel.this.refresh();
                        return true;
                    }
                }
                EditScheduleWorkflowProgressRunnable editScheduleWorkflowProgressRunnable = new EditScheduleWorkflowProgressRunnable();
                editScheduleWorkflowProgressRunnable.setTitle(WorkflowEditorLrb.get("SCHEDULE_WORKFLOW"));
                editScheduleWorkflowProgressRunnable.setMessage(WorkflowEditorLrb.get("SCHEDULE_CREATE_SCHEDULE_DESCR"));
                editScheduleWorkflowProgressRunnable.setCancelable(false);
                editScheduleWorkflowProgressRunnable.start(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unable to edit workflow schedule", (String)"Unable to edit workflow schedule due to internal error");
        }
    }

    private void updateButtonStates() {
        int n = this._jobsTable.getSelectedRowCount();
        if (n >= 1) {
            ScheduleTableModel scheduleTableModel = (ScheduleTableModel)((Object)this._jobsTable.getModel());
            boolean bl = scheduleTableModel.isJobActive(this._jobsTable.getSelectedRowsInModel());
            this._btnCancel.setEnabled(bl);
            boolean bl2 = scheduleTableModel.isJobScheduled(this._jobsTable.getSelectedRowsInModel());
            this._btnCancelSchedule.setEnabled(bl2);
            this._btnEditSchedule.setEnabled(bl2);
            this._btnLog.setEnabled(n == 1);
        } else {
            this.enableSelectionSensitiveControls(false);
        }
    }

    private void showLoading(boolean bl) {
        if (bl) {
            this.enableSelectionSensitiveControls(false);
            this._jobsTable.setNoEntryInstructionText(CommonLrb.get("LOADING"));
            this._tableModel.clearJobs();
        } else {
            this._jobsTable.setModel((TableModel)((Object)this._tableModel));
            this._jobsTable.setNoEntryInstructionText(RunManagerLrb.get("NO_SCHEDULED_JOBS"));
            this.setupTable(false);
        }
    }

    private void setupTable(boolean bl) {
        if (this._jobsTable.getColumnModel().getColumnCount() < 1) {
            return;
        }
    }

    private void enableSelectionSensitiveControls(boolean bl) {
        this._btnCancel.setEnabled(bl);
        this._btnCancelSchedule.setEnabled(bl);
        this._btnEditSchedule.setEnabled(bl);
        this._btnLog.setEnabled(bl);
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void autoSwitchConnection(String string) {
        if (!this._autoSwitchConnection) {
            return;
        }
        String string2 = (String)this._connCombo.getSelectedItem();
        if (string2 != null && !string2.equals(string)) {
            this._connCombo.setSelectedItem(string);
        }
    }

    public void switchConnection(final boolean bl) {
        this._connectionLost = false;
        final String string = this._connectionName;
        this._connectionName = (String)this._connCombo.getSelectedItem();
        if (this._connectionName == null) {
            this._jobsTable.setNoEntryInstructionText(RunManagerLrb.get("NO_SCHEDULED_JOBS"));
            this._tableModel.clearJobs();
            this._connCombo.setEnabled(false);
            this._btnLog.setEnabled(false);
            return;
        }
        this._connCombo.setEnabled(true);
        final Object object = new Object();
        this.add(object);
        SwingWorker<Boolean, Object> swingWorker = new SwingWorker<Boolean, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean doInBackground() {
                Object object2 = syncForSwitchConnection;
                synchronized (object2) {
                    if (SchedulePanel.this._connectionName.equals(string) && !bl) {
                        return Boolean.FALSE;
                    }
                    if (!SchedulePanel.this.isLastUIRequest(object)) {
                        return Boolean.FALSE;
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                SchedulePanel.this.showLoading(true);
                            }
                        });
                        final Collection<WorkflowJob> collection = RunManager.getScheduledJobs(SchedulePanel.this._connectionName).values();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                SchedulePanel.this.removeAllJobItems();
                                SchedulePanel.this.addJobItems(collection);
                                SchedulePanel.this.showLoading(false);
                            }
                        });
                    }
                    catch (SQLException | RunManager.UnmonitorableConnectionException | ConnectionException throwable) {
                        SchedulePanel.this.removeAllJobItems();
                        SchedulePanel.this.setConnectionFailed((Exception)throwable);
                        theLogger.log(Level.SEVERE, throwable.getMessage(), throwable);
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
                return Boolean.TRUE;
            }

            @Override
            public void done() {
                SchedulePanel.this.remove(object);
            }
        };
        swingWorker.execute();
    }

    public void switchConnection() {
        this.switchConnection(false);
    }

    private boolean isLastUIRequest(Object object) {
        int n = this.commandQueue.indexOf(object);
        if (n == this.commandQueue.size() - 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void remove(Object object) {
        this.commandQueue.remove(object);
    }

    private void add(Object object) {
        this.commandQueue.add(object);
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
        String string = DataMinerConnections.getUnqualifiedName(connectionEvent.getConnectionName());
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._connCombo.getModel();
        if (defaultComboBoxModel.getSize() == 0) {
            defaultComboBoxModel.insertElementAt(string, 0);
            this._connCombo.setEnabled(true);
            this._btnLog.setEnabled(true);
            this._connCombo.setSelectedIndex(0);
            return;
        }
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            int n = string2.compareTo(string);
            if (n <= 0) continue;
            defaultComboBoxModel.insertElementAt(string, i);
            return;
        }
        defaultComboBoxModel.addElement(string);
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        String string = DataMinerConnections.getUnqualifiedName(connectionEvent.getConnectionName());
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._connCombo.getModel();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            if (!string2.equals(string)) continue;
            defaultComboBoxModel.removeElementAt(i);
            if (defaultComboBoxModel.getSize() != 0) break;
            AddinManager addinManager = AddinManager.getAddinManager();
            RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
            runManager.removeListener((TasksWindow)this._dockableWindow, string);
            break;
        }
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
        String string = DataMinerConnections.getUnqualifiedName(connectionEvent.getOldName());
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._connCombo.getModel();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            if (!string2.equals(string)) continue;
            int n = defaultComboBoxModel.getIndexOf(string2);
            int n2 = this._connCombo.getSelectedIndex();
            defaultComboBoxModel.removeElementAt(i);
            defaultComboBoxModel.insertElementAt(DataMinerConnections.getUnqualifiedName(connectionEvent.getConnectionName()), n);
            if (n2 != n) break;
            this._connCombo.setSelectedIndex(n);
            this.switchConnection();
            break;
        }
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    void clearTasks() {
        this._tableModel.clearJobs();
    }

    private void removeAllJobItems() {
        this._tableModel.clearJobs();
        this.updateButtonStates();
    }

    private void addJobItems(Collection<WorkflowJob> collection) {
        this._tableModel.addJobItems(collection, this._connectionName);
        this.updateButtonStates();
    }

    public void setConnectionFailed(Exception exception) {
        this._connectionLost = true;
        this._connCombo.repaint();
        this._connCombo.setToolTipText(RunManagerLrb.get("CONNECTION_FAILED"));
        this._jobsTable.setNoEntryInstructionText(RunManagerLrb.get("FAILED_TO_LOAD_SCHEDULE"));
    }

    public void saveSettings() {
    }

    private static class ScheduleTableModel
    extends SimpleBaseTableModel {
        private transient List<WorkflowJob> _data;
        private transient Map<WorkflowJob, String> _connNames;
        public static final int NAME = 0;
        public static final int PROJECT = 1;
        public static final int TIME = 2;
        public static final int COLUMN_COUNT = 3;
        private String[] columnNames = new String[]{RunManagerLrb.get("RUN_COL_WF"), RunManagerLrb.get("RUN_COL_PROJ"), RunManagerLrb.get("NEXT_RUN_TIME")};

        public ScheduleTableModel(List<WorkflowJob> list) {
            this._data = list;
            this._connNames = new HashMap<WorkflowJob, String>();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this._data != null ? this._data.size() : 0;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public void addJobItems(Collection<WorkflowJob> collection, String string) {
            this._data.addAll(collection);
            for (WorkflowJob workflowJob : collection) {
                this._connNames.put(workflowJob, string);
            }
            this.fireTableStructureChanged();
        }

        public void clearJobs() {
            this._data.clear();
            this._connNames.clear();
            this.fireTableDataChanged();
        }

        public String getJobConnectionName(WorkflowJob workflowJob) {
            return this._connNames.get(workflowJob);
        }

        @Override
        public Class getColumnClass(int n) {
            if (n == 2) {
                return Timestamp.class;
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            WorkflowJob workflowJob = this._data.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = workflowJob.getWorkflowName();
                    break;
                }
                case 1: {
                    object = workflowJob.getProjectName();
                    break;
                }
                case 2: {
                    object = workflowJob.getStartTime();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isJobActive(int[] nArray) {
            boolean bl = true;
            WorkflowJob workflowJob = null;
            if (nArray.length == 0) {
                return false;
            }
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    workflowJob = this._data.get(nArray[i]);
                    if (workflowJob.isRunning()) continue;
                    bl = false;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }

        public boolean isJobScheduled(int[] nArray) {
            boolean bl = true;
            WorkflowJob workflowJob = null;
            if (nArray.length == 0) {
                return false;
            }
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    workflowJob = this._data.get(nArray[i]);
                    if (workflowJob.isScheduled()) continue;
                    bl = false;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }

        public List<WorkflowJob> getSelectedJobs(int[] nArray) {
            ArrayList<WorkflowJob> arrayList = new ArrayList<WorkflowJob>();
            WorkflowJob workflowJob = null;
            if (nArray.length == 0) {
                return arrayList;
            }
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    workflowJob = this._data.get(nArray[i]);
                    arrayList.add(workflowJob);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return arrayList;
        }

        public List<WorkflowJob> getDataList() {
            return this._data;
        }
    }

    class ConnectionItemRenderer
    extends JLabel
    implements ListCellRenderer {
        public ConnectionItemRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)object;
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setIcon(null);
            if (n == -1) {
                if (SchedulePanel.this._connectionLost) {
                    this.setIcon(OracleIcons.getIcon((String)"error.png"));
                } else {
                    this.setIcon(OracleIcons.getIcon((String)"dbconn.png"));
                }
            }
            return this;
        }
    }
}

