/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.repository.RepositoryObject;

public class Result
extends RepositoryObject {
    public static final String RESULT_NAME = "RESULT_NAME";
    public static final String RESULT_TYPE = "RESULT_TYPE";
    public static final String MINING_FUNCTION = "MINING_FUNCTION";
    public static final String MINING_ALGORITHM = "MINING_ALGORITHM";
    public static final String CREATION_TIME = "CREATION_TIME";
    public static final String USER_MINING_MODEL_ATTRIBUTES = "USER_MINING_MODEL_ATTRIBUTES";
    public static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    public static final String DATA_TYPE = "DATA_TYPE";
    public static final String COLUMN_ALIAS_NAME = "COLUMN_ALIAS_NAME";
    public static final String MODEL_NAME = "MODEL_NAME";
    public static final String MODEL_ID = "MODEL_ID";
    public static final String TARGET = "TARGET";
    public static final String MODEL_SCHEMA = "MODEL_SCHEMA";
    protected TreeMap<String, Object> _data = new TreeMap();

    public Result(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    protected void loadResultObject(ResultSet resultSet) throws SQLException {
        this._data.put(MODEL_NAME, resultSet.getString(MODEL_NAME));
        this._data.put(RESULT_NAME, resultSet.getString(RESULT_NAME));
        this._data.put(RESULT_TYPE, resultSet.getString(RESULT_TYPE));
        this._data.put(MINING_FUNCTION, resultSet.getString(MINING_FUNCTION));
        this._data.put(MINING_ALGORITHM, resultSet.getString(MINING_ALGORITHM));
        this._data.put(CREATION_TIME, resultSet.getTimestamp(CREATION_TIME));
        this._data.put(ATTRIBUTE_NAME, resultSet.getString(ATTRIBUTE_NAME));
        this._data.put(DATA_TYPE, resultSet.getString(DATA_TYPE));
    }

    public void setValue(String string, Object object) {
        this._data.put(string, object);
    }

    public Object getValue(String string) {
        return this._data.get(string);
    }

    public String getModelName() {
        return (String)this._data.get(MODEL_NAME);
    }

    public String getModelSchema() {
        return (String)this._data.get(MODEL_SCHEMA);
    }

    public String getModelId() {
        return (String)this._data.get(MODEL_ID);
    }

    public String getResultName() {
        return (String)this._data.get(RESULT_NAME);
    }

    public String getMiningFunction() {
        return (String)this._data.get(MINING_FUNCTION);
    }

    public String getMiningAlgorithm() {
        return (String)this._data.get(MINING_ALGORITHM);
    }

    public Date getCreationTime() {
        XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)this._data.get(CREATION_TIME);
        java.sql.Date date = null;
        if (xMLGregorianCalendar != null) {
            Date date2 = xMLGregorianCalendar.toGregorianCalendar().getTime();
            date = new java.sql.Date(date2.getTime());
        }
        return date;
    }

    public Date getCreationTimeOLD() {
        String string = (String)this._data.get(CREATION_TIME);
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n, n + 5);
        String string4 = string.substring(n);
        n = string4.indexOf(" ");
        string4 = string4.substring(n);
        string4 = string4.replace(":", "");
        string = string2 + string3 + string4;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy hh.mm.ss.SS a Z");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        return date;
    }

    public Timestamp getCreationTimestamp() {
        return null;
    }

    public String getColumnName() {
        return (String)this._data.get(ATTRIBUTE_NAME);
    }

    public String getDataType() {
        return (String)this._data.get(DATA_TYPE);
    }

    @Override
    public String toString() {
        return this.getResultName();
    }

    public String getResultType() {
        return (String)this._data.get(RESULT_TYPE);
    }

    public static synchronized StringBuffer buildSQLQuery(BigDecimal bigDecimal) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer;
    }

    public static boolean contains(ArrayList<Result> arrayList, Result result) {
        if (arrayList == null || arrayList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Result result2 = arrayList.get(i);
            if (!result2.getId().equals(result.getId()) || !result2.getParentId().equals(result.getParentId()) || 0 != result2.getName().compareTo(result.getName())) continue;
            return true;
        }
        return false;
    }
}

