/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.model.CoreServerConstantsLrb;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;

public class RegressTestResult
extends TestResult {
    private static final Logger theLogger = Logger.getLogger(RegressTestResult.class.getName());
    private static final String RESIDUAL_PLOT_TABLE_NAME = "RESIDUAL_PLOT_TABLE_NAME";
    private static final String MEAN_RMS_ERROR = "MEAN_RMS_ERROR";
    private static final String MEAN_ABSOLUTE_ERROR = "MEAN_ABSOLUTE_ERROR";
    private static final String MEAN_PREDICATED_VALUE = "MEAN_PREDICATED_VALUE";
    private static final String MEAN_ACTUAL_VALUE = "MEAN_ACTUAL_VALUE";

    public RegressTestResult(RegressTestResult regressTestResult) {
        super(regressTestResult);
    }

    public RegressTestResult(Context context, BuildNodeType buildNodeType, MiningResultType miningResultType) {
        super(context, buildNodeType, miningResultType);
        RBuildNodeType rBuildNodeType;
        RBuildNodeType.Models models;
        List list;
        Optional<RModelType> optional;
        assert (miningResultType instanceof RegressionResultType);
        if (buildNodeType instanceof RegressionBuildNodeType) {
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)buildNodeType;
            RegressionBuildNodeType.Models models2 = regressionBuildNodeType.getModels();
            List list2 = models2.getRSupportVectorMachineModel();
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("REGRESSION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            boolean bl = false;
            for (Object object : list2) {
                if (object.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                this._data.put("MODEL_NAME", object.getName());
                this._data.put("MODEL_ID", object.getId());
                this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
                bl = true;
                break;
            }
            if (!bl) {
                Object object;
                List list3 = models2.getRGeneralizedLinearModel();
                object = list3.iterator();
                while (object.hasNext()) {
                    RGeneralizedLinearModelType rGeneralizedLinearModelType = (RGeneralizedLinearModelType)object.next();
                    if (rGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", rGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", rGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_GENERALIZED_LINEAR_MODEL"));
                    bl = true;
                    break;
                }
            }
            this.putResultTablesToMap((RegressionResultType)miningResultType);
        } else if (buildNodeType instanceof RBuildNodeType && (optional = (list = (models = (rBuildNodeType = (RBuildNodeType)buildNodeType).getModels()).getRModel()).stream().filter(rModelType -> rModelType.getId().equalsIgnoreCase(miningResultType.getModelId())).findAny()).isPresent()) {
            RModelType rModelType2 = optional.get();
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", CoreServerConstantsLrb.get((String)"REGRESSION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            this._data.put("MODEL_NAME", rModelType2.getName());
            this._data.put("MODEL_ID", rModelType2.getId());
            this._data.put("MINING_ALGORITHM", CoreServerConstantsLrb.get((String)"ALGO_R_USER_DEFINED"));
            this.putResultTablesToMap((RegressionResultType)miningResultType);
        }
    }

    private void putResultTablesToMap(RegressionResultType regressionResultType) {
        if (regressionResultType.getTestMetrics() != null) {
            this._data.put("PERFORM_METRICS_TABLE_NAME", regressionResultType.getTestMetrics().getName());
        }
        if (regressionResultType.getResidualPlot() != null) {
            this._data.put(RESIDUAL_PLOT_TABLE_NAME, regressionResultType.getResidualPlot().getName());
        }
        this.loadMetrics();
    }

    public RegressTestResult(Context context, TestNodeType testNodeType, MiningResultType miningResultType) {
        super(context, testNodeType, miningResultType);
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (model.getModelId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("REGRESSION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            this._data.put("MODEL_SCHEMA", model.getSchema());
            this._data.put("MODEL_NAME", model.getName());
            this._data.put("MODEL_ID", model.getModelId());
            this._data.put("MINING_ALGORITHM", ServerConstants.Algorithm.getUIAlgorithmName((String)model.getMiningAlgorithm().value()));
            break;
        }
        this.putResultTablesToMap((RegressionResultType)miningResultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetrics() {
        String string = null;
        String string2 = this.getPerformanceMatrixTable();
        string = "Select metric_name, metric_num_value from " + string2 + " where metric_name in ( 'PREDICTIVE_CONFIDENCE', 'MEAN_RMS_ERROR', 'MEAN_ABSOLUTE_ERROR', 'MEAN_PREDICATED_VALUE', 'MEAN_ACTUAL_VALUE')";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(this._context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(1);
                if ("PREDICTIVE_CONFIDENCE".equals(string3)) {
                    this._data.put("PREDICTIVE_CONFIDENCE", sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (MEAN_RMS_ERROR.equals(string3)) {
                    this._data.put(MEAN_RMS_ERROR, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (MEAN_ABSOLUTE_ERROR.equals(string3)) {
                    this._data.put(MEAN_ABSOLUTE_ERROR, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (MEAN_PREDICATED_VALUE.equals(string3)) {
                    this._data.put(MEAN_PREDICATED_VALUE, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (!MEAN_ACTUAL_VALUE.equals(string3)) continue;
                this._data.put(MEAN_ACTUAL_VALUE, sQLHelper.rs.getBigDecimal(2));
            }
        }
    }

    public String getResidualPlotTable() {
        return (String)this._data.get(RESIDUAL_PLOT_TABLE_NAME);
    }

    public boolean residualPlotExists() {
        return this._data.get(RESIDUAL_PLOT_TABLE_NAME) != null;
    }

    public BigDecimal getPredictiveConfidence() {
        return (BigDecimal)this._data.get("PREDICTIVE_CONFIDENCE");
    }

    public BigDecimal getRootMeanSquareError() {
        return (BigDecimal)this._data.get(MEAN_RMS_ERROR);
    }

    public BigDecimal getMeanAbsoluteError() {
        return (BigDecimal)this._data.get(MEAN_ABSOLUTE_ERROR);
    }

    public BigDecimal getMeanPredictedValue() {
        return (BigDecimal)this._data.get(MEAN_PREDICATED_VALUE);
    }

    public BigDecimal getMeanActualValue() {
        return (BigDecimal)this._data.get(MEAN_ACTUAL_VALUE);
    }

    public boolean isAccuracyMetricsResult() {
        if (this._result instanceof RegressionResultType) {
            RegressionResultType regressionResultType = (RegressionResultType)this._result;
            return regressionResultType.getTestMetrics() != null;
        }
        return false;
    }

    public boolean isResidualsResult() {
        if (this._result instanceof RegressionResultType) {
            RegressionResultType regressionResultType = (RegressionResultType)this._result;
            return regressionResultType.getResidualPlot() != null;
        }
        return false;
    }
}

