/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;

public final class Project
extends LoadableRepositoryObject {
    private static final Logger LOGGER = Logger.getLogger(Project.class.getName());
    private Timestamp _creationTime;
    private Timestamp _lastUpdatedTime;
    public static final int NAME_MAX_LENGTH = 30;
    public static final int COMMENT_MAX_LENGTH = 4000;
    public static final String PROJECT_ID = "PROJECT_ID";
    public static final String DB_USER_ID = "DB_USER_ID";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String CREATION_TIME = "CREATION_TIME";
    public static final String LAST_UPDATED_TIME = "LAST_UPDATED_TIME";
    public static final String COMMENTS = "COMMENTS";
    public static final String ODMR_USER_PROJECTS = "ODMR_USER_PROJECTS";

    public Project(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    @Override
    public void load(ConnectionManager connectionManager) throws Exception {
        String string = null;
        SQLHelper sQLHelper = new SQLHelper();
        String[] stringArray = new String[]{PROJECT_NAME, CREATION_TIME, LAST_UPDATED_TIME, COMMENTS};
        stringArray = Project.delimit(stringArray, ODMR_USER_PROJECTS);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECTS};
        String string2 = Project.delimit(PROJECT_ID, ODMR_USER_PROJECTS) + " = ?";
        string = Project.buildQuery(stringArray, stringArray2, string2);
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setBigDecimal(1, this._id);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                this._name = sQLHelper.rs.getString(PROJECT_NAME);
                this._comment = sQLHelper.rs.getString(COMMENTS);
                this._creationTime = sQLHelper.rs.getTimestamp(CREATION_TIME);
                this._lastUpdatedTime = sQLHelper.rs.getTimestamp(LAST_UPDATED_TIME);
            } else assert (false) : "Project not found.";
            this.setLoaded(true);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    @Override
    public void unload() throws Exception {
        this._comment = null;
        this._creationTime = null;
        this._lastUpdatedTime = null;
        this.setLoaded(false);
    }

    @Override
    public void refresh(ConnectionManager connectionManager) throws Exception {
        this.load(connectionManager);
    }

    public static boolean validateProjectNameLength(String string) {
        return string.length() <= 30;
    }

    public static boolean validateCommentLength(String string) {
        return string.length() <= 4000;
    }

    public static boolean validateCommentLengthAtDB(ConnectionManager connectionManager, String string) {
        return StringUtils.checkStringDBLengthMaxLong(string, connectionManager, 4000);
    }

    private void loadedCheck() {
        assert (this.isLoaded()) : "Can not access state prior to object being loaded.";
    }

    public Timestamp getCreationTime() {
        this.loadedCheck();
        return this._creationTime;
    }

    public Timestamp getLastUpdatedTime() {
        this.loadedCheck();
        return this._lastUpdatedTime;
    }

    @Override
    public String getComment() {
        this.loadedCheck();
        return super.getComment();
    }
}

