/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.pca;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.fe.pca.PCACoefficient;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.pca.PCAValuesTableModel;
import oracle.dmt.dataminer.mviewer.pca.ScreePlotLrb;
import oracle.dmt.dataminer.server.model.GlobalDetails;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;

public class ScreePlotViewerState
extends BaseViewerState {
    private static final Color[] colors = new Color[]{Color.RED, Color.BLUE};
    private boolean loaded;
    private GraphDataModel graphDataModel;
    private PCAValuesTableModel model = new PCAValuesTableModel();
    private List<String> features = new ArrayList<String>();
    private List<Double> variances = new ArrayList<Double>();
    private List<Double> pctCumVariances = new ArrayList<Double>();
    private List<NameValuePair> settings;

    public ScreePlotViewerState(Context context) {
        super(context);
    }

    public HelpInfo getHelpInfo() {
        String string = "pca_viewer_scree";
        return new HelpInfo(string);
    }

    public int getNumberOfFeatures() {
        return this.features.size();
    }

    public String getSuggetsedCutofValue() {
        Object object = null;
        for (NameValuePair nameValuePair : this.settings) {
            if (!"SUGGESTED_CUTOFF".equals(nameValuePair.getName())) continue;
            object = nameValuePair.getValue();
            break;
        }
        return object != null ? object.toString() : "";
    }

    public void load(String string) throws Exception {
        this.loaded = false;
        ModelDescriptor modelDescriptor = new ModelDescriptor(this.getUserName(), this.getModelName(), string);
        this.settings = GlobalDetails.getModelDetailsGlobal(this.connectionManager, modelDescriptor);
        this.loadScreePlotData(string);
        this.loaded = true;
    }

    public void loadScreePlotData(String string) throws Exception {
        boolean bl;
        this.features.clear();
        this.variances.clear();
        this.pctCumVariances.clear();
        this.getSvd().setPartitionId(string);
        this.getSvd().loadScreePlotValues(this.features, this.variances, this.pctCumVariances);
        if (this.pctCumVariances.isEmpty() || this.variances.isEmpty() || this.features.isEmpty()) {
            throw new Exception(ScreePlotLrb.get("SCREE_PLOT_DATA_IS_NOTAVAILABLE"));
        }
        boolean bl2 = bl = this.features.size() == this.variances.size() && this.features.size() == this.pctCumVariances.size();
        if (!bl) {
            throw new Exception(ScreePlotLrb.get("SCREE_PLOT_DATA_IS_NOTAVAILABLE"));
        }
        int n = this.features.size();
        int n2 = 2;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[]{ScreePlotLrb.get("SCREE_PLOT_VARIANCE"), ScreePlotLrb.get("SCREE_PLOT_PCT_CUM_VARIANCE")};
        Vector<PCACoefficient> vector = new Vector<PCACoefficient>();
        for (int i = 0; i < this.features.size(); ++i) {
            objectArray2[i] = this.features.get(i);
            objectArray[i][0] = this.variances.get(i);
            objectArray[i][1] = this.pctCumVariances.get(i);
            PCACoefficient pCACoefficient = new PCACoefficient(this.features.get(i), Double.valueOf(this.variances.get(i) * this.variances.get(i)), this.variances.get(i), this.pctCumVariances.get(i));
            vector.add(pCACoefficient);
        }
        this.model = new PCAValuesTableModel(vector);
        this.graphDataModel = new DefaultGraphDataModel(null, 43, null, null, null);
        this.graphDataModel.addColumnLabels(objectArray2);
        this.graphDataModel.addRowLabels(objectArray3);
        this.graphDataModel.addGraphData(objectArray);
        this.graphDataModel.addRowColors(colors);
        this.graphDataModel.setLegendVisible(true);
        this.graphDataModel.setTitle(this.getModelName());
    }

    public GraphDataModel getGraphDataModel() {
        return this.graphDataModel;
    }

    public PCAValuesTableModel getTableModel() {
        return this.model;
    }

    public void clearRows() {
        this.model.clearRows();
    }

    public boolean isFeatureLabelUnique(String string) {
        return this.getSvd().isFeatureLabelUnique(string);
    }

    public void renameFeature(String string, String string2) throws Exception {
        this.getSvd().renameFeature(string, string2);
    }

    public void updateFeature(String string, String string2) {
        int n = this.features.indexOf(string);
        if (-1 != n) {
            this.features.set(n, string2);
            Object[] objectArray = this.graphDataModel.getColumnLabels();
            Object[] objectArray2 = this.graphDataModel.getRowLabels();
            Object[][] objectArray3 = this.graphDataModel.getGraphData();
            objectArray[n] = string2;
            this.graphDataModel.clear();
            this.graphDataModel.addColumnLabels(objectArray);
            this.graphDataModel.addRowLabels(objectArray2);
            this.graphDataModel.addGraphData(objectArray3);
            this.graphDataModel.addRowColors(colors);
            this.graphDataModel.setLegendVisible(true);
            this.graphDataModel.setTitle(this.getModelName());
        }
    }
}

