/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import ilog.views.util.IlvColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.TransferableCellRenderer;
import oracle.dmt.dataminer.mviewer.dt.schema.ScoreDistribution;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.dmt.dataminer.mviewer.dtree.model.DecisionTreeSDMModel;
import oracle.javatools.ui.table.GenericTableModel;

public class TargetValuesPane
extends JPanel
implements DataminerGUIPanel {
    private DTTreeNode treeNode;
    private DataMinerTablePanel valuesTablePanel;
    private final int VALUE = 0;
    private final int RECORD_COUNT = 1;
    private final int PERCENTAGE = 2;
    private final int COLUMN_COUNT = 3;
    private static Border selectedBorder = null;
    private static Border unselectedBorder = null;

    public TargetValuesPane(DTTreeNode dTTreeNode) {
        this.treeNode = dTTreeNode;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.valuesTablePanel = new DataMinerTablePanel();
        this.valuesTablePanel.setMinimumSize(new Dimension(0, 0));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.valuesTablePanel, -1, 513, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.valuesTablePanel, -1, 192, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this.valuesTablePanel.getTable().setColumnSelectorAvailable(true);
        this.valuesTablePanel.getTable().setAutoResizeMode(3);
        this.valuesTablePanel.getTable().setRolloverHighlightingEnabled(false);
        String[] stringArray = new String[]{DecisionTreeEditorLrb.get("TARGET_VALUE"), DecisionTreeEditorLrb.get("TARGET_VALUE_RECORD_COUNT"), DecisionTreeEditorLrb.get("TARGET_VALUE_PERCENTAGE")};
        this.valuesTablePanel.setup(new ValuesTableModel(this.treeNode.getScoreDistributions(), stringArray), DecisionTreeEditorLrb.get("TARGET_VALUES_LABEL"), 0);
        TableColumn tableColumn = this.valuesTablePanel.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new ProgressCellRenderer());
    }

    private static class ProgressCellRenderer
    implements TableCellRenderer,
    TransferableCellRenderer {
        private NumberFormat formatter = NumberFormat.getPercentInstance();

        public ProgressCellRenderer() {
            this.formatter.setMaximumFractionDigits(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JProgressBar jProgressBar = new JProgressBar(0, 10000);
            jProgressBar.setValue((Integer)object);
            String string = this.formatValue((Integer)object);
            jProgressBar.setStringPainted(true);
            jProgressBar.setString(string);
            ValuesTableModel valuesTableModel = (ValuesTableModel)jTable.getModel();
            String string2 = (String)valuesTableModel.getValueAt(n, 0);
            Color color = valuesTableModel.getBarColor(string2);
            jProgressBar.setForeground(color);
            if (bl) {
                if (selectedBorder == null) {
                    selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                }
                jProgressBar.setBorder(selectedBorder);
                jProgressBar.setBackground(jTable.getSelectionBackground());
            } else {
                if (unselectedBorder == null) {
                    unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                }
                jProgressBar.setBorder(unselectedBorder);
                jProgressBar.setBackground(jTable.getBackground());
            }
            jProgressBar.setBorderPainted(false);
            return jProgressBar;
        }

        @Override
        public String getTransferableString(Object object) {
            return this.formatValue((Integer)object);
        }

        private String formatValue(int n) {
            double d = (double)n / 10000.0;
            return this.formatter.format(d);
        }
    }

    class ValuesTableModel
    extends DefaultTableModel
    implements GenericTableModel {
        private List<ScoreDistribution> _data;

        public ValuesTableModel(List<ScoreDistribution> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this._data.size());
            this.setColumnCount(3);
        }

        public int getColumnAlignment(int n) {
            return 2;
        }

        public boolean canHide(int n) {
            return true;
        }

        public Color getBarColor(String string) {
            DecisionTreeSDMModel decisionTreeSDMModel = TargetValuesPane.this.treeNode.getModel();
            return IlvColorUtil.toColor((String)decisionTreeSDMModel.getColorForTargetValue(string));
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return String.class;
            }
            if (n == 2) {
                return DTTreeNode.class;
            }
            return String.class;
        }

        public void reload(List<ScoreDistribution> list) {
            this._data = list;
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ScoreDistribution scoreDistribution = this._data.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = scoreDistribution.getValue();
                    break;
                }
                case 1: {
                    object = scoreDistribution.getRecordCount();
                    break;
                }
                case 2: {
                    double d = Double.valueOf(scoreDistribution.getRecordCount());
                    double d2 = Double.valueOf(TargetValuesPane.this.treeNode.getData().getRecordCount());
                    Double d3 = d / d2 * 100.0;
                    Integer n3 = Double.valueOf(d3 * 100.0).intValue();
                    object = n3;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        public List<ScoreDistribution> getDataList() {
            return this._data;
        }
    }
}

