/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.tree.IlvTreeLayout;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.core.editor.ScrollManagerView;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.framework.menu.DefaultDiagramMainMenuPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.framework.readonly.DefaultDiagramReadOnlyPlugin;
import oracle.diagram.framework.readonly.DiagramReadOnlyPlugin;
import oracle.diagram.framework.toolbar.DefaultDiagramToolbarPlugin;
import oracle.diagram.framework.toolbar.ToolbarPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.exception.InvalidNodeTypeException;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.TreeRulesPanel;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusTreeRule;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringQuerySettingsDialog;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeContextMenu;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeDiagram;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.NodeDetailPane;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeLink;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.EMClusterModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.util.Version;

public class ClusteringTreeEditor
extends DataMinerDiagramEditor {
    private static final Logger LOGGER = Logger.getLogger(ClusteringTreeEditor.class.getName());
    private static final int MAX_VISIBLE_ATTRIBUTES = 10;
    private static final int MIN_VISIBLE_ATTRIBUTES = 1;
    private static final int DEFAULT_SELECTED_ATTRIBUTES = 4;
    private int treeFlowDirection;
    private int maxAttributeLength;
    private int maxValueLength;
    private NumberFormat percentFormat;
    private Integer detailTabIndex;
    private int topNAttributes;
    private NodeDetailPane detailPane;
    private ClusteringModelNode clustNode;
    private BlockingComponent overLayPanel;
    private TreeViewerToolbarPlugin tvtp;
    private ModelViewerPartitionToolbar partitionToolbar;
    private JSplitPane splitComponent;
    private JScrollPane detailView;
    private JEditorPane textEditorPane;
    private static final int DOLAYOUT_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.doLayout");
    private static final int TOGGLE_DETAIL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.toggleDetailedHeader");
    private static final int EXPAND_ALL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.expandAllNodes");

    public ClusteringTreeEditor() {
        super((Diagram)new ClusteringTreeDiagram());
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this.topNAttributes = clusteringTreePreferencesSettings.getTopNCentroidAttributes();
        this.treeFlowDirection = clusteringTreePreferencesSettings.isHorizontalLayout() ? 2 : 8;
        this.maxAttributeLength = clusteringTreePreferencesSettings.getMaxAttributeDisplayLength();
        this.maxValueLength = clusteringTreePreferencesSettings.getMaxValueDisplayLength();
        this.setPreferredLayoutBaseName("Tree");
        this.percentFormat = Formats.ModelViewer.getPercentage();
        this.partitionToolbar = new ModelViewerPartitionToolbar();
    }

    protected void getEditorContent(Context context) {
        this.load();
        super.getEditorContent(context);
    }

    @Override
    public void openImpl(boolean bl) throws OpenAbortedException {
        super.openImpl(bl);
        if (bl) {
            this.loadSuccess();
        }
    }

    public NumberFormat getNumberFormat() {
        return this.percentFormat;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("cluster_tree_diagram_editor");
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = super.getContextMenu();
        ClusteringTreeContextMenu clusteringTreeContextMenu = ClusteringTreeContextMenu.getInstance();
        contextMenu.addMenuFilter((MenuFilter)clusteringTreeContextMenu);
        return contextMenu;
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return ClusteringTreeContextMenu.getInstance();
    }

    public void reload() {
        ReloadUI reloadUI = new ReloadUI(this.overLayPanel);
        reloadUI.execute();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.reload();
    }

    protected void installEditorPlugins(Diagram diagram) {
        super.installEditorPlugins(diagram);
        DiagramContext diagramContext = diagram.getDiagramContext();
        diagramContext.addPlugin(DiagramMainMenuPlugin.class, (Plugin)DefaultDiagramMainMenuPlugin.getInstance());
        diagramContext.addPlugin(DiagramReadOnlyPlugin.class, (Plugin)new OdmrReadOnlyPlugin(diagramContext));
        this.tvtp = new TreeViewerToolbarPlugin(diagramContext, this);
        diagramContext.addPlugin(ToolbarPlugin.class, (Plugin)this.tvtp);
        diagramContext.addPlugin(SelectionChangeNotificationPlugin.class, (Plugin)new SelectionChangePlugin());
    }

    public void initializeLayout(Layout layout) {
        super.initializeLayout(layout);
        layout.setProperty("Layout.ShowUnifiedThumbnail", Boolean.TRUE.toString());
    }

    private void load() {
        this.clustNode = this.getContextNode();
        this.clustNode.ensureOpen();
        assert (this.clustNode.getRepositoryData() instanceof ModelType);
        this.partitionToolbar.load((Editor)this);
        PartitionVO partitionVO = this.partitionToolbar.getPartitionVO();
        this.clustNode.setPartitionId(partitionVO.getPartitionID());
        this.clustNode.setPartitionName(partitionVO.getPartitionName());
        this.clustNode.load();
    }

    private void reloadSuccess() {
        if (this.clustNode.isKMnoneOptionEnabled()) {
            if (this.detailPane == null) {
                this.detailPane = new NodeDetailPane();
            } else if (this.detailPane.getTabCount() > 0) {
                this.detailPane.removeAll();
                this.textEditorPane.removeAll();
            }
        } else {
            this.textEditorPane.removeAll();
        }
    }

    private void loadSuccess() {
        final IlvSDMEngine ilvSDMEngine = this.clustNode.getEngine();
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        final ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)this.clustNode.getFilteredModel(sDMUndoFilter);
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        clusterTreeSDMModel.setHeaderDetailVisible(clusteringTreePreferencesSettings.isShowNodeDetailHeader());
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance();
        clusteringTreePreferencesSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                boolean bl = false;
                for (int i = 0; i < changeInfoArray.length; ++i) {
                    ChangeInfo changeInfo = changeInfoArray[i];
                    if (changeInfo.getPropertyName().equals("treeNodeAttributeMaxLength")) {
                        ClusteringTreeEditor.this.maxAttributeLength = changeInfo.getNewValueAsInt();
                        bl = true;
                        continue;
                    }
                    if (!changeInfo.getPropertyName().equals("treeNodeAttributeMaxValLength")) continue;
                    ClusteringTreeEditor.this.maxValueLength = changeInfo.getNewValueAsInt();
                    bl = true;
                }
                if (bl) {
                    clusterTreeSDMModel.fireDataChanged(null);
                    ClusteringTreeEditor.this.doLayout(ilvSDMEngine, ClusteringTreeEditor.this.treeFlowDirection, false);
                }
            }
        });
        modelViewerPreferenceSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                boolean bl = false;
                for (int i = 0; i < changeInfoArray.length; ++i) {
                    ChangeInfo changeInfo = changeInfoArray[i];
                    if (!changeInfo.getPropertyName().equals("percentage_precision_level")) continue;
                    ClusteringTreeEditor.this.percentFormat = NumericFormat.getInstance((boolean)true, (int)changeInfo.getNewValueAsInt(), (int)changeInfo.getNewValueAsInt(), (int)1);
                    bl = true;
                }
                if (bl) {
                    clusterTreeSDMModel.fireDataChanged(null);
                    ClusteringTreeEditor.this.doLayout(ilvSDMEngine, ClusteringTreeEditor.this.treeFlowDirection, false);
                }
            }
        });
        if (this.clustNode != null) {
            this.clustNode.setModelExists(true);
            this.loadTreeModel(this.clustNode, clusterTreeSDMModel);
            this.displayNoModelDetailsMessage(this.clustNode);
            ilvSDMEngine.setModel((IlvSDMModel)sDMUndoFilter);
            this.doLayout(ilvSDMEngine, this.treeFlowDirection, true);
            this.tvtp.initTopItemsCombo(clusterTreeSDMModel);
        }
        this.setPropertyChangeListener(ilvSDMEngine, clusterTreeSDMModel);
    }

    private void displayNoModelDetailsMessage(ClusteringModelNode clusteringModelNode) {
        if (clusteringModelNode.isKMnoneOptionEnabled()) {
            String string = ClusteringTreeEditorLrb.get("KM_NOMODEL_DETAILS_MESSAGE");
            this.createMessagePanel(string);
        }
    }

    private void createMessagePanel(String string) {
        this.textEditorPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        int n = this.textEditorPane.getGraphics() != null ? this.textEditorPane.getGraphics().getFontMetrics(font2).stringWidth(string) : 400;
        Dimension dimension = this.textEditorPane.getSize();
        jPanel.add(Box.createHorizontalStrut((dimension.width - n) / 2));
        jPanel.add(jLabel);
        this.textEditorPane.add(jPanel);
    }

    private IlvSDMEngine getEngine() {
        ClusteringModelNode clusteringModelNode = this.getContextNode();
        return clusteringModelNode.getEngine();
    }

    private void setPropertyChangeListener(IlvSDMEngine ilvSDMEngine, ClusterTreeSDMModel clusterTreeSDMModel) {
        Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
        while (enumeration.hasMoreElements()) {
            IlvSDMNode ilvSDMNode = enumeration.nextElement();
            if (!(ilvSDMNode instanceof ClusTreeNode)) continue;
            ClusTreeNode clusTreeNode = (ClusTreeNode)ilvSDMNode;
            clusTreeNode.assignPropertyChangeListener(ilvSDMEngine);
        }
        clusterTreeSDMModel.addSDMPropertyChangeListener(new ModelListener());
    }

    public int getMaxAttributeLength() {
        return this.maxAttributeLength;
    }

    public int getMaxValueLength() {
        return this.maxValueLength;
    }

    public void setDetailTabIndex(int n) {
        this.detailTabIndex = n;
    }

    public Integer getDetailTabIndex() {
        return this.detailTabIndex;
    }

    public void refreshLayout(ClusTreeNode clusTreeNode) {
        this.doLayout(this.getEngine(), this.treeFlowDirection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLayout(IlvSDMEngine ilvSDMEngine, int n, boolean bl) {
        List<ClusTreeNode> list;
        try {
            list = this.getSelectedDiagramNodes();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
            return;
        }
        IlvTreeLayout ilvTreeLayout = new IlvTreeLayout();
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        ilvTreeLayout.attach(ilvGrapher);
        ilvTreeLayout.setFlowDirection(n);
        ilvTreeLayout.setGlobalLinkStyle(2);
        try {
            ilvTreeLayout.performLayout();
            ilvSDMEngine.setSelected(list.toArray(), true);
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            LOGGER.log(Level.FINEST, ilvGraphLayoutException.getMessage());
        }
        finally {
            IlvManagerView ilvManagerView;
            if (bl && (ilvManagerView = this.getDiagram().getDiagramContext().getManagerView()) != null) {
                ilvManagerView.fitTransformerToContent();
            }
        }
        ilvTreeLayout.detach();
    }

    private void expandAllNodes() {
        IlvSDMEngine ilvSDMEngine;
        SDMUndoFilter sDMUndoFilter;
        ClusterTreeSDMModel clusterTreeSDMModel;
        Enumeration<IlvSDMNode> enumeration;
        if (this.clustNode == null) {
            this.clustNode = this.getContextNode();
        }
        if ((enumeration = (clusterTreeSDMModel = (ClusterTreeSDMModel)this.clustNode.getFilteredModel(sDMUndoFilter = (SDMUndoFilter)(ilvSDMEngine = this.clustNode.getEngine()).getModel())).getObjects()) == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            IlvSDMNode ilvSDMNode = enumeration.nextElement();
            if (!(ilvSDMNode instanceof ClusTreeNode)) continue;
            sDMUndoFilter.setObjectProperty((Object)ilvSDMNode, "expanded", (Object)1);
        }
    }

    private void loadTreeModel(ClusteringModelNode clusteringModelNode, ClusterTreeSDMModel clusterTreeSDMModel) {
        if (clusteringModelNode.exists()) {
            clusterTreeSDMModel.load(clusteringModelNode.getClusterRowDetails(), this.getContext());
            clusteringModelNode.setReadOnly(true);
        }
    }

    public ClusTreeNode getSelectedDiagramNode() {
        List<ClusTreeNode> list = this.getSelectedDiagramNodes();
        if (list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public List<ClusTreeNode> getSelectedDiagramNodes() {
        ArrayList<ClusTreeNode> arrayList = new ArrayList<ClusTreeNode>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof ClusTreeNode)) continue;
                arrayList.add((ClusTreeNode)e);
            }
        }
        return arrayList;
    }

    public ClusTreeLink getSelectedDiagramLink() {
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return null;
        }
        IlvManager ilvManager = ilvManagerView.getManager();
        ClusteringModelNode clusteringModelNode = this.getContextNode();
        IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getSelectedObjects();
        if (ilvManager.getSelectedObjectsCount() > 1 || ilvManager.getSelectedObjectsCount() == 0) {
            return null;
        }
        IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
        Object object = ilvSDMEngine.getObject(ilvGraphic);
        if (object instanceof ClusTreeLink) {
            return (ClusTreeLink)((Object)object);
        }
        return null;
    }

    public List<ClusTreeLink> getSelectedDiagramLinks() {
        ArrayList<ClusTreeLink> arrayList = new ArrayList<ClusTreeLink>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof ClusTreeLink)) continue;
                arrayList.add((ClusTreeLink)((Object)e));
            }
        }
        return arrayList;
    }

    public List<Object> getSelectedDiagramObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    @Override
    public void closeEditor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(ClusteringTreeEditor.this));
            }
        });
    }

    public Component createGUI() {
        this.detailView = new JScrollPane();
        this.detailView.setLayout(new ScrollPaneLayout());
        this.textEditorPane = new JEditorPane();
        this.textEditorPane.setEditable(false);
        this.textEditorPane.setContentType("text/html");
        this.detailView.getViewport().add(this.textEditorPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ToolbarPlugin toolbarPlugin = (ToolbarPlugin)this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
        if (toolbarPlugin != null) {
            Toolbar toolbar = toolbarPlugin.getToolbar();
            if (toolbar == null) {
                toolbarPlugin.createToolbar((View)this);
                toolbar = toolbarPlugin.getToolbar();
            }
            jPanel.add((Component)toolbar, "North");
        }
        jPanel.add((Component)new ScrollManagerView(this.getDiagram().getDiagramContext().getManagerView()), "Center");
        this.splitComponent = new JSplitPane(0, jPanel, this.detailView);
        if (this.overLayPanel == null) {
            this.overLayPanel = new BlockingComponent((JComponent)jPanel);
            this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            this.overLayPanel.setMessage(BlockingComponent.Message.LOADING);
            this.splitComponent.setLeftComponent(this.overLayPanel.getBlockingComponent());
        }
        this.splitComponent.setDividerLocation(0.8);
        this.splitComponent.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusteringTreeEditor.this.splitComponent.setDividerLocation(0.8);
                ClusteringTreeEditor.this.splitComponent.setResizeWeight(0.8);
            }
        });
        return this.splitComponent;
    }

    public Component getDetailView() {
        return this.splitComponent.getBottomComponent();
    }

    public Component getHorizontalScrollBar() {
        return null;
    }

    public Component getVerticalScrollBar() {
        return null;
    }

    private ClusterTreeSDMModel getModel(ClusteringModelNode clusteringModelNode) {
        IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)clusteringModelNode.getFilteredModel(sDMUndoFilter);
        return clusterTreeSDMModel;
    }

    private ClusteringModelNode getContextNode() {
        Node node = this.getContext().getNode();
        if (node instanceof ClusteringModelNode) {
            return (ClusteringModelNode)node;
        }
        throw new InvalidNodeTypeException(node, ClusteringModelNode.class);
    }

    public class TreeViewerToolbarPlugin
    extends DefaultDiagramToolbarPlugin
    implements Controller {
        private IdeAction _doFitToWindow;
        private IdeAction _toggleHeaderAction;
        private IdeAction _expandAllAction;
        private JComboBox<Object> comboMaxTargetValues;
        private ClusteringTreeEditor parentEditor;

        public TreeViewerToolbarPlugin(DiagramContext diagramContext, ClusteringTreeEditor clusteringTreeEditor2) {
            super(diagramContext);
            this._doFitToWindow = IdeAction.get((int)DOLAYOUT_CMDID);
            this._toggleHeaderAction = IdeAction.get((int)TOGGLE_DETAIL_CMDID);
            this._expandAllAction = IdeAction.get((int)EXPAND_ALL_CMDID);
            this.comboMaxTargetValues = new JComboBox();
            this.parentEditor = clusteringTreeEditor2;
            this._doFitToWindow.addController((Controller)this);
            this._toggleHeaderAction.addController((Controller)this);
            this._expandAllAction.addController((Controller)this);
        }

        public void update(Context context) {
            super.update(context);
            if (this._doFitToWindow != null) {
                this._doFitToWindow.updateAction(context);
            }
        }

        protected Toolbar createToolbarImpl(View view) {
            ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
            boolean bl = true;
            ClusteringModelNode clusteringModelNode = ClusteringTreeEditor.this.getContextNode();
            ClusterTreeSDMModel clusterTreeSDMModel = ClusteringTreeEditor.this.getModel(clusteringModelNode);
            bl = clusteringModelNode.isStatsEnabled() && !clusteringModelNode.isModelEmpty();
            final ClusterTreeSDMModel clusterTreeSDMModel2 = clusterTreeSDMModel;
            final ClusteringModelNode clusteringModelNode2 = clusteringModelNode;
            Toolbar toolbar = super.createToolbarImpl(view);
            ToolButton toolButton = new ToolButton((Action)this._doFitToWindow);
            toolButton.setIcon(OracleIcons.getIcon((String)"fit_to_window.png"));
            toolButton.setToolTipText(ModelViewerLrb.get("FIT_TO_WINDOW_TIP"));
            ToolButton toolButton2 = new ToolButton((Action)this._expandAllAction);
            toolButton2.setIcon(OracleIcons.getIcon((String)"expandall.png"));
            toolButton2.setToolTipText(ModelViewerLrb.get("EXPAND_ALL_TIP"));
            this._toggleHeaderAction.setState(clusteringTreePreferencesSettings.isShowNodeDetailHeader());
            ToggleToolButton toggleToolButton = new ToggleToolButton((ToggleAction)this._toggleHeaderAction);
            toggleToolButton.setIcon((Icon)DataMinerIcons.get(Icons.TOGGLE_DETAIL));
            toggleToolButton.setToolTipText(ClusteringTreeEditorLrb.get("HEADER_SHOW_DETAIL_TIP"));
            ButtonGroup buttonGroup = new ButtonGroup();
            final DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
            final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(ClusteringTreeEditorLrb.get("HORIZONTAL_LAYOUT"));
            final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(ClusteringTreeEditorLrb.get("VERTICAL_LAYOUT"));
            buttonGroup.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem2);
            jRadioButtonMenuItem2.setIcon(DataMinerIcons.get(Icons.TREE_DIAGRAM_V));
            jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ClusteringTreeEditor.this.treeFlowDirection = 8;
                    dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_V));
                    ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this.getEngine(), ClusteringTreeEditor.this.treeFlowDirection, true);
                }
            });
            jRadioButtonMenuItem.setIcon(DataMinerIcons.get(Icons.TREE_DIAGRAM_H));
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ClusteringTreeEditor.this.treeFlowDirection = 2;
                    dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_H));
                    ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this.getEngine(), ClusteringTreeEditor.this.treeFlowDirection, true);
                }
            });
            dropDownMenuButton.setToolTipText(ModelViewerLrb.get("LAYOUT_TIP"));
            jRadioButtonMenuItem2.setSelected(ClusteringTreeEditor.this.treeFlowDirection != 2);
            jRadioButtonMenuItem.setSelected(ClusteringTreeEditor.this.treeFlowDirection == 2);
            if (ClusteringTreeEditor.this.treeFlowDirection == 2) {
                dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_H));
            } else if (ClusteringTreeEditor.this.treeFlowDirection == 8) {
                dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_V));
            }
            dropDownMenuButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem2);
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem);
                    } else if (itemEvent.getStateChange() == 2) {
                        dropDownMenuButton.removeAllPopupItems();
                    }
                }
            });
            JLabel jLabel = new JLabel(ClusteringTreeEditorLrb.get("MAX_DISPLAYED_ATTRIBUTES"));
            Dimension dimension = this.comboMaxTargetValues.getPreferredSize();
            this.comboMaxTargetValues.setMaximumSize(dimension);
            this.comboMaxTargetValues.setMinimumSize(dimension);
            this.initTopItemsCombo(clusterTreeSDMModel2);
            this.comboMaxTargetValues.setToolTipText(ClusteringTreeEditorLrb.get("MAX_DISPLAYED_ATTRIBUTES_TIP"));
            this.comboMaxTargetValues.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Integer n = (Integer)jComboBox.getSelectedItem();
                    clusterTreeSDMModel2.setMaxTargetValuesDisplayed(n);
                    ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this.getEngine(), ClusteringTreeEditor.this.treeFlowDirection, false);
                    ClusteringTreeEditor.this.setPropertyChangeListener(clusteringModelNode2.getEngine(), clusterTreeSDMModel2);
                    clusteringModelNode2.getEngine().setSelected(list.toArray(), true);
                }
            });
            JButton jButton = new JButton(ClusteringTreeEditorLrb.get("SETTINGS"));
            jButton.setToolTipText(ClusteringTreeEditorLrb.get("SETTINGS_TIP"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n = TreeViewerToolbarPlugin.this.getSelectedNodeId();
                    ClusteringQuerySettingsDialog clusteringQuerySettingsDialog = new ClusteringQuerySettingsDialog((Frame)Ide.getMainWindow(), true);
                    clusteringQuerySettingsDialog.setTopNAttributes(ClusteringTreeEditor.this.topNAttributes);
                    clusteringQuerySettingsDialog.setVisible(true);
                    if (!clusteringQuerySettingsDialog.isCancelled()) {
                        ClusteringTreeEditor.this.topNAttributes = clusteringQuerySettingsDialog.getTopNAttributes();
                        ReloadUI reloadUI = new ReloadUI(ClusteringTreeEditor.this.overLayPanel);
                        reloadUI.execute();
                        TreeViewerToolbarPlugin.this.initTopItemsCombo(clusterTreeSDMModel2);
                        TreeViewerToolbarPlugin.this.setSelectedNodeUsingId(n, clusterTreeSDMModel2, clusteringModelNode2);
                    }
                }
            });
            JButton jButton2 = new JButton();
            jButton2.setToolTipText(ClusteringTreeEditorLrb.get("REFRESH_TIP"));
            jButton2.setIcon(OracleIcons.getIcon((String)"refresh.png"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n = TreeViewerToolbarPlugin.this.getSelectedNodeId();
                    ReloadUI reloadUI = new ReloadUI(ClusteringTreeEditor.this.overLayPanel);
                    reloadUI.execute();
                    TreeViewerToolbarPlugin.this.initTopItemsCombo(clusterTreeSDMModel2);
                    TreeViewerToolbarPlugin.this.setSelectedNodeUsingId(n, clusterTreeSDMModel2, clusteringModelNode2);
                }
            });
            toolbar.add((Component)ClusteringTreeEditor.this.partitionToolbar, 0);
            toolbar.add((Component)toolButton);
            toolbar.addSeparator();
            toolbar.add((Component)toolButton);
            toolbar.add((Component)dropDownMenuButton);
            toolbar.add((Component)toolButton2);
            toolbar.addSeparator();
            toolbar.addFiller();
            toolbar.add((Component)toggleToolButton);
            toolbar.addSeparator(new Dimension(10, 0));
            if (bl) {
                toolbar.add((Component)jLabel);
                toolbar.addFiller();
                toolbar.add(this.comboMaxTargetValues);
                toolbar.addFiller();
            }
            toolbar.addSeparator();
            toolbar.add((Component)jButton2);
            if (bl) {
                toolbar.add((Component)jButton);
            }
            toolbar.add(Box.createHorizontalGlue());
            JButton jButton3 = new JButton(ModelViewerLrb.get("TREE_SAVE_RULES_BTN"));
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreeRulesPanel treeRulesPanel = new TreeRulesPanel(TreeViewerToolbarPlugin.this.parentEditor.getContext(), (Node)ClusteringTreeEditor.this.getContextNode());
                    treeRulesPanel.showAsDialog();
                }
            });
            toolbar.add((Component)jButton3);
            return toolbar;
        }

        private Integer getSelectedNodeId() {
            IlvSDMNode ilvSDMNode;
            Integer n = null;
            List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
            if (!list.isEmpty() && (ilvSDMNode = (IlvSDMNode)list.get(0)) instanceof ClusTreeNode) {
                n = ((ClusTreeNode)ilvSDMNode).getData().getId();
            }
            return n;
        }

        private void setSelectedNodeUsingId(Integer n, ClusterTreeSDMModel clusterTreeSDMModel, ClusteringModelNode clusteringModelNode) {
            if (n != null) {
                Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
                while (enumeration.hasMoreElements()) {
                    Integer n2;
                    IlvSDMNode ilvSDMNode = enumeration.nextElement();
                    if (!(ilvSDMNode instanceof ClusTreeNode) || !(n2 = ((ClusTreeNode)ilvSDMNode).getData().getId()).equals(n)) continue;
                    clusteringModelNode.getEngine().setSelected((Object)ilvSDMNode, true);
                    break;
                }
            }
        }

        private Object[] getTopItems(ClusterTreeSDMModel clusterTreeSDMModel) {
            int n = clusterTreeSDMModel.getAttributeCount() > 10 ? 10 : clusterTreeSDMModel.getAttributeCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = i + 1;
            }
            return objectArray;
        }

        public void initTopItemsCombo(ClusterTreeSDMModel clusterTreeSDMModel) {
            Integer n = (Integer)this.comboMaxTargetValues.getSelectedItem();
            Object[] objectArray = this.getTopItems(clusterTreeSDMModel);
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
            this.comboMaxTargetValues.setModel(defaultComboBoxModel);
            boolean bl = false;
            if (objectArray.length != 0) {
                for (Object object : objectArray) {
                    if (!object.equals(n)) continue;
                    this.comboMaxTargetValues.setSelectedItem(object);
                    bl = true;
                }
                if (!bl) {
                    Integer n2 = (Integer)(objectArray.length > 4 ? objectArray[4] : objectArray[objectArray.length - 1]);
                    this.comboMaxTargetValues.setSelectedItem(n2);
                }
            }
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            View view = context.getView();
            if (!(view instanceof ClusteringTreeEditor)) {
                return false;
            }
            ClusteringModelNode clusteringModelNode = ClusteringTreeEditor.this.getContextNode();
            ClusterTreeSDMModel clusterTreeSDMModel = ClusteringTreeEditor.this.getModel(clusteringModelNode);
            if (ideAction.getCommandId() == DOLAYOUT_CMDID) {
                ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this.getEngine(), ClusteringTreeEditor.this.treeFlowDirection, true);
                return true;
            }
            if (ideAction.getCommandId() == EXPAND_ALL_CMDID) {
                ClusteringTreeEditor.this.expandAllNodes();
                return true;
            }
            if (ideAction.getCommandId() == TOGGLE_DETAIL_CMDID) {
                List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                clusterTreeSDMModel.toggleHeaderDetailVisible();
                clusterTreeSDMModel.fireDataChanged(null);
                ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this.getEngine(), ClusteringTreeEditor.this.treeFlowDirection, false);
                ClusteringTreeEditor.this.setPropertyChangeListener(clusteringModelNode.getEngine(), clusterTreeSDMModel);
                clusteringModelNode.getEngine().setSelected(list.toArray(), true);
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            View view = context.getView();
            return view instanceof ClusteringTreeEditor;
        }
    }

    public class SelectionChangePlugin
    extends AbstractPlugin
    implements SelectionChangeNotificationPlugin {
        private boolean isEnabled = true;

        public void selectionChanged(DiagramContext diagramContext) {
            List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
            ClusteringModelNode clusteringModelNode = ClusteringTreeEditor.this.getContextNode();
            Version version = ConfigUtils.getDatabaseVersion(ClusteringTreeEditor.this.getContext());
            if (list.size() > 1) {
                this.displayNoSelectionMessage(clusteringModelNode);
            } else if (list.size() == 1) {
                if (DbVersionHelper.isDB122Up((Version)version) && clusteringModelNode instanceof KMModelNode && !clusteringModelNode.isStatsEnabled()) {
                    ClusteringTreeEditor.this.detailPane = new NodeDetailPane();
                    return;
                }
                Object object = list.get(0);
                if (object instanceof ClusTreeNode) {
                    ClusTreeNode clusTreeNode = (ClusTreeNode)object;
                    ClusteringTreeEditor.this.detailPane = new NodeDetailPane(clusTreeNode, ClusteringTreeEditor.this.partitionToolbar.getSelectedPartitionID());
                    int n = ClusteringTreeEditor.this.splitComponent.getDividerLocation();
                    ClusteringTreeEditor.this.splitComponent.setBottomComponent(ClusteringTreeEditor.this.detailPane);
                    ClusteringTreeEditor.this.splitComponent.setDividerLocation(n);
                } else if (object instanceof ClusTreeLink && clusteringModelNode instanceof OCModelNode) {
                    ClusTreeLink clusTreeLink = (ClusTreeLink)((Object)object);
                    ClusTreeNode clusTreeNode = (ClusTreeNode)clusTreeLink.getTo();
                    String string = ClusTreeRule.getSplitRulesHtml(clusTreeNode, true);
                    int n = ClusteringTreeEditor.this.splitComponent.getDividerLocation();
                    ClusteringTreeEditor.this.splitComponent.setBottomComponent(ClusteringTreeEditor.this.detailView);
                    ClusteringTreeEditor.this.splitComponent.setDividerLocation(n);
                    ClusteringTreeEditor.this.textEditorPane.setText(string);
                    ClusteringTreeEditor.this.textEditorPane.select(0, 0);
                }
            } else if (DbVersionHelper.isDB122Up((Version)version)) {
                if (clusteringModelNode.isKMnoneOptionEnabled()) {
                    ClusteringTreeEditor.this.detailPane.add(ClusteringTreeEditor.this.textEditorPane);
                } else if (clusteringModelNode.isStatsEnabled() || !(clusteringModelNode instanceof KMModelNode)) {
                    this.displayNoSelectionMessage(clusteringModelNode);
                }
            } else {
                this.displayNoSelectionMessage(clusteringModelNode);
            }
        }

        private void displayNoSelectionMessage(ClusteringModelNode clusteringModelNode) {
            String string;
            if (clusteringModelNode instanceof KMModelNode || clusteringModelNode instanceof EMClusterModelNode) {
                string = ClusteringTreeEditorLrb.get("KM_NOSELECT_MESSAGE");
            } else if (clusteringModelNode instanceof OCModelNode) {
                string = ClusteringTreeEditorLrb.get("OC_NOSELECT_MESSAGE");
            } else {
                throw new RuntimeException("Unknown clustering node type");
            }
            ClusteringTreeEditor.this.createMessagePanel(string);
            if (ClusteringTreeEditor.this.splitComponent != null && ClusteringTreeEditor.this.detailView != null) {
                int n = ClusteringTreeEditor.this.splitComponent.getDividerLocation();
                ClusteringTreeEditor.this.splitComponent.setBottomComponent(ClusteringTreeEditor.this.detailView);
                ClusteringTreeEditor.this.splitComponent.setDividerLocation(n);
            }
        }

        public void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    private static class OdmrReadOnlyPlugin
    extends DefaultDiagramReadOnlyPlugin {
        public OdmrReadOnlyPlugin(DiagramContext diagramContext) {
            super(diagramContext);
        }

        protected boolean checkWritableDiagram() {
            return false;
        }
    }

    public static class ModelListener
    implements SDMPropertyChangeListener {
        public void propertyChanged(SDMPropertyChangeEvent sDMPropertyChangeEvent) {
            String string = sDMPropertyChangeEvent.getPropertyName();
            Object object = sDMPropertyChangeEvent.getObject();
            if ("expanded".equals(string) && object instanceof ClusTreeNode) {
                ((ClusTreeNode)object).setChildrenVisibility();
            }
        }
    }

    private class ReloadUI
    extends ODMrSwingWorker<Void, Void> {
        public ReloadUI(BlockingComponent blockingComponent) {
            super(null, blockingComponent);
            assert (ClusteringTreeEditor.this.clustNode.getRepositoryData() instanceof ModelType);
        }

        @Override
        protected Void doInBackground() throws Exception {
            ClusteringTreeEditor.this.load();
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ClusteringTreeEditor.this.reloadSuccess();
            ClusteringTreeEditor.this.loadSuccess();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(ClusteringTreeEditor.this.getContext(), throwable, ModelViewerLrb.get("FAILED_ERROR_TITLE"), ModelViewerLrb.get("FAILED_OPEN"));
        }
    }
}

