/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.compare;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.clus.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersLrb;
import oracle.dmt.dataminer.utils.Formats;

public class ClusterCompareTableModel
extends ODMrTableModel<CompareClustersModelRow> {
    public static final String[] COL_NAMES = new String[]{CompareClustersLrb.get("DETAIL_TABLE_COLUMN_NAME"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_RANK"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_DIVERGENCE"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_DISTRIBUTION"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_CENTROID"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_CENTROID")};
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_RANK = 1;
    public static final int _COLUMN_DIVERGENCE = 2;
    public static final int _COLUMN_DISTRIBUTION = 3;
    public static final int _COLUMN_CENTROID1 = 4;
    public static final int _COLUMN_CENTROID2 = 5;
    private String cluster1;
    private String cluster2;
    private Hashtable<String, CompareClustersModelRow> _attributeNameToRowMap = new Hashtable();

    public ClusterCompareTableModel(List<CompareClustersModelRow> list, String string, String string2) {
        super(list);
        this.cluster1 = string;
        this.cluster2 = string2;
        Object[] objectArray = Arrays.copyOf(COL_NAMES, COL_NAMES.length);
        objectArray[4] = this.cluster1 != null ? objectArray[4] + "(" + this.cluster1 + ")" : "";
        objectArray[5] = this.cluster2 != null ? (String)objectArray[5] + "(" + this.cluster2 + ")" : "";
        this.setColumnIdentifiers(objectArray);
        this.setDataList(list);
    }

    public ClusterCompareTableModel(Boolean bl) {
        super(COL_NAMES);
        if (bl.booleanValue()) {
            CompareClustersModelRow compareClustersModelRow = new CompareClustersModelRow(ClusterLrb.get("DETAIL_CLUSTER_EDITOR_LOADING"));
            this.addDataItem(compareClustersModelRow);
        }
    }

    private void addDataItem(CompareClustersModelRow compareClustersModelRow) {
        this.srcData.add(compareClustersModelRow);
    }

    @Override
    public void clear() {
        for (CompareClustersModelRow compareClustersModelRow : this.srcData) {
            compareClustersModelRow.setGraphDataModel(null);
            compareClustersModelRow.setFirstClusterHistogram(null);
            compareClustersModelRow.setSecondClusterHistogram(null);
        }
        super.clear();
        this._attributeNameToRowMap.clear();
    }

    public CompareClustersModelRow getClusterDetailRow(String string) {
        return this._attributeNameToRowMap.get(string);
    }

    public void setDataList(List<CompareClustersModelRow> list) {
        this.setSrcData(list);
        this._attributeNameToRowMap.clear();
        for (CompareClustersModelRow compareClustersModelRow : list) {
            this._attributeNameToRowMap.put(compareClustersModelRow.getFullAttributeName(), compareClustersModelRow);
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        CompareClustersModelRow compareClustersModelRow = (CompareClustersModelRow)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = compareClustersModelRow.getFullAttributeName();
                break;
            }
            case 1: {
                object = compareClustersModelRow.getRank();
                break;
            }
            case 2: {
                object = compareClustersModelRow.getDivergence();
                break;
            }
            case 4: {
                object = this.getCentroid(compareClustersModelRow.getCentroid1());
                break;
            }
            case 5: {
                object = this.getCentroid(compareClustersModelRow.getCentroid2());
                break;
            }
            case 3: {
                object = compareClustersModelRow.getGraphDataModel();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing cluster details";
                break;
            }
        }
        return object != null ? object : "";
    }

    private String getCentroid(String string) {
        String string2 = string;
        try {
            NumberFormat numberFormat = Formats.ModelViewer.getNumeric();
            NumberFormat numberFormat2 = NumberFormat.getInstance();
            Number number = numberFormat2.parse(string);
            string2 = numberFormat.format(number.doubleValue());
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }
}

