/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;

public abstract class ODMrTableModel<E>
extends SimpleBaseTableModel {
    protected List<E> srcData;

    public ODMrTableModel() {
        this.srcData = new ArrayList();
    }

    public ODMrTableModel(List<E> list) {
        this(new String[0], list);
    }

    public ODMrTableModel(String[] stringArray) {
        this(stringArray, new ArrayList());
    }

    public ODMrTableModel(String[] stringArray, List<E> arrayList) {
        assert (stringArray != null) : "Can not pass null columns in to the constructor";
        this.srcData = arrayList == null ? new ArrayList() : arrayList;
        this.setColumnIdentifiers(stringArray);
    }

    public int getRowCount() {
        return this.srcData == null ? 0 : this.srcData.size();
    }

    public List<E> getSrcData() {
        return this.srcData;
    }

    public void setSrcData(List<E> list) {
        if (list == null) {
            list = new ArrayList(0);
        }
        this.srcData = list;
        this.fireTableDataChanged();
    }

    public void addRows(List<E> list) {
        this.srcData.addAll(list);
        this.fireTableDataChanged();
    }

    public void addRow(E e) {
        int n = this.getRowCount();
        this.srcData.add(e);
        this.fireTableRowsInserted(n, n);
    }

    public void removeRows(List<E> list) {
        this.srcData.removeAll(list);
        this.fireTableDataChanged();
    }

    public void removeRows(int[] nArray) {
        Arrays.sort(nArray);
        int n = 0;
        for (int n2 : nArray) {
            this.srcData.remove(n2 - n++);
        }
        this.fireTableDataChanged();
    }

    public void removeRow(int n) {
        this.srcData.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public E getRow(int n) {
        return this.srcData.get(n);
    }

    public List<E> getRows(int[] nArray) {
        ArrayList<E> arrayList = new ArrayList<E>(nArray.length);
        for (int n : nArray) {
            arrayList.add(this.srcData.get(n));
        }
        return arrayList;
    }

    public void clear() {
        if (this.srcData != null && this.srcData.size() > 0) {
            this.srcData.clear();
            this.fireTableDataChanged();
        }
    }

    @Deprecated
    public Vector<E> getDataVector() {
        return new Vector<E>(this.srcData);
    }

    public String getStringValueAt(int n, int n2) {
        String string = null;
        Object object = this.getValueAt(n, n2);
        if (object != null) {
            assert (object instanceof String) : "Not a String type, can't be used to filter";
            string = object.toString();
        }
        return string;
    }
}

