/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.string;

public final class StringChange {
    private final int _offset;
    private final String _insertedChars;
    private final int _removalCount;
    public static final short INSERTION = 0;
    public static final short REMOVAL = 1;
    public static final short REPLACEMENT = 2;
    public static final short NO_CHANGE = 3;

    public StringChange(int offset, String insertedChars, int removalCount) {
        if (offset < 0) {
            throw new IllegalArgumentException("negative offset");
        }
        if ("".equals(insertedChars)) {
            insertedChars = null;
        }
        if (removalCount < 0) {
            removalCount = 0;
        }
        this._insertedChars = insertedChars;
        this._removalCount = removalCount;
        this._offset = this.getChangeType() == 3 ? 0 : offset;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getRemovalCount() {
        return this._removalCount;
    }

    public int getInsertionCount() {
        return this._insertedChars == null ? 0 : this._insertedChars.length();
    }

    public String getInsertedChars() {
        return this._insertedChars;
    }

    public short getChangeType() {
        if (this._removalCount > 0) {
            if (this._insertedChars != null) {
                return 2;
            }
            return 1;
        }
        if (this._insertedChars != null) {
            return 0;
        }
        return 3;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("StringChange(offset=");
        buf.append(this._offset);
        if (this._insertedChars != null) {
            buf.append(", insertedChars=");
            buf.append(this._insertedChars);
        }
        if (this._removalCount > 0) {
            buf.append(", removalCount=");
            buf.append(this._removalCount);
        }
        buf.append(")");
        return buf.toString();
    }
}

