/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreationContext;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.AbstractPositionTargetingOperation;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;

public class XmlCreatableOperation
extends AbstractPositionTargetingOperation {
    @Override
    public boolean apply(AbstractModel model, DomPosition pos, TransferDataInfo data, TransactionToken token) throws IOException, XmlCommitException {
        XmlCreatable creatable = (XmlCreatable)data.getData(FetchMode.STANDARD, false);
        if (creatable != null) {
            XmlCreationContext context = XmlCreationContext.create(model, "xmlef-model", pos);
            creatable.createAtPosition(context, pos, token);
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        String infoDesc;
        String string = infoDesc = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (infoDesc == null) {
            return model.getTranslatedString("DragCreate");
        }
        return model.getTranslatedString("DragCreate_Data", infoDesc);
    }

    @Override
    public float getSuitabilityRank() {
        return 0.9f;
    }

    @Override
    public int getSupportedActions() {
        return 1;
    }

    @Override
    protected DataFlavor getRequiredDataFlavor() {
        return XmlTransferUtils.FLAVOR_XMLCREATABLE;
    }

    @Override
    protected DomPosition convertPosition(AbstractModel model, DomPosition originalPos, Object datum) {
        return model.convertInsertionPosition(originalPos);
    }

    @Override
    protected boolean isValidData(AbstractModel model, TransferDataInfo info, Object datum) {
        return super.isValidData(model, info, datum) && (datum == null || datum instanceof XmlCreatable);
    }

    @Override
    protected boolean isValidPosition(AbstractModel model, DomPosition pos, TransferDataInfo info, Object datum) {
        if (!super.isValidPosition(model, pos, info, datum)) {
            return false;
        }
        if (pos == null) {
            return false;
        }
        if (!model.getXmlMetadataResolver().canAddChild(pos)) {
            return false;
        }
        if (datum == null) {
            return true;
        }
        XmlCreationContext context = XmlCreationContext.create(model, "xmlef-model", pos);
        XmlCreatable creatable = (XmlCreatable)datum;
        return creatable.isValidPosition(context, pos);
    }
}

