/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.annotation.AnnotationGrammarEvent;
import oracle.bali.xml.model.annotation.AnnotationGrammarListener;
import oracle.bali.xml.model.annotation.AnnotationPropertyDef;
import oracle.bali.xml.share.SafeListenerManager;
import org.w3c.dom.Node;

public abstract class AnnotationGrammar {
    private final SafeListenerManager _listenerManager = new SafeListenerManager();

    public abstract Map<QualifiedName, AnnotationPropertyDef> getAnnotationPropertyDefMap(Node var1);

    public final Collection<AnnotationPropertyDef> getAnnotationPropertyDefs(Node node) {
        if (node == null) {
            return Collections.emptySet();
        }
        return this.getAnnotationPropertyDefMap(node).values();
    }

    public final AnnotationPropertyDef getAnnotationPropertyDef(Node node, QualifiedName name) {
        if (node == null || name == null) {
            return null;
        }
        return this.getAnnotationPropertyDefMap(node).get(name);
    }

    public final void addGrammarListener(AnnotationGrammarListener l) {
        this._listenerManager.addListener(l);
    }

    public final void removeGrammarListener(AnnotationGrammarListener l) {
        this._listenerManager.removeListener(l);
    }

    protected AnnotationGrammar() {
    }

    protected final void fireAnnotationGrammarEvent() {
        AnnotationGrammarEvent e = new AnnotationGrammarEvent(this);
        this.fireAnnotationGrammarEvent(e);
    }

    protected final void fireAnnotationGrammarEvent(AnnotationGrammarEvent e) {
        Iterator iter = this._listenerManager.iterator();
        while (iter.hasNext()) {
            AnnotationGrammarListener listener = (AnnotationGrammarListener)iter.next();
            listener.annotationGrammarChanged(e);
        }
    }
}

