/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.action.ClearAction;
import oracle.bali.xml.model.action.CopyAction;
import oracle.bali.xml.model.action.ModelAction;
import oracle.bali.xml.model.task.SelectionBasedTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.XmlTransferableSelectionAction;
import org.w3c.dom.Node;

public class CutAction
extends XmlTransferableSelectionAction {
    public CutAction(String mnemonicAndDisplayName) {
        super(mnemonicAndDisplayName, KeyStroke.getKeyStroke(88, 2), "cut", true, true);
        this.putValue("XmlContext.MUTATES_MODEL", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this._doCut(this);
        }
        catch (XmlCommitException e) {
            this.getModel().getLogger().log(Level.SEVERE, "Validation failed in:" + this, e);
        }
    }

    private void _doCut(ModelAction action) throws XmlCommitException {
        new Task(action).runThrowingXCE(action.getModel());
    }

    private static class Task
    extends SelectionBasedTransactionTask {
        private final ModelAction _action;

        public Task(ModelAction action) {
            this._action = action;
        }

        @Override
        protected TransactionOptions getTransactionOptions(String txnName) {
            return new TransactionOptions(txnName, false, true, false);
        }

        @Override
        protected void performTask(AbstractModel model) throws XmlCommitException {
            boolean copyOK = CopyAction.__doCopy(this._action);
            if (!copyOK) {
                this.cancelTask();
            }
            ClearAction.__doClear(this._action);
        }

        @Override
        protected String computeMultipleSelectionTransactionName(AbstractModel model, int numSelected) {
            String transFormat = model.getTranslatedString("CUT_DESCRIPTION_SINGULAR_FORMAT");
            Node selectedNode = model.getSelection().getFirstSelectedNode();
            String nodeDisplayName = model.getXmlMetadataResolver().getShortDisplayName(selectedNode);
            return FastMessageFormat.formatMessage(transFormat, nodeDisplayName);
        }

        @Override
        protected String computeSingleSelectionTransactionName(AbstractModel model) {
            return model.getTranslatedString("CUT_DESCRIPTION_MULTIPLE");
        }
    }
}

