/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import oracle.bali.xml.gui.GuiEventProcessor;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.resource.PaternalResourceBundle;
import oracle.bali.xml.share.ActionProxy;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.Node;

public abstract class XmlGui {
    private static final Logger _LOGGER = Logger.getLogger(XmlGui.class.getName());
    private boolean _shown = false;
    private XmlUsage _usage;
    private GuiEventProcessor _processor;
    private final XmlView _view;
    private final ResourceBundle _bundle;
    private final XmlModelListener _viewListener = new GuiListener();
    private final SafeListenerManager _listeners = new SafeListenerManager();

    public XmlGui(XmlView view) {
        if (view == null) {
            throw new IllegalArgumentException("No view specified");
        }
        this._view = view;
        ResourceBundle guiBundle = this.createBundle();
        ResourceBundle contextBundle = ((GuiXmlContext)view.getContext()).getBundle();
        this._bundle = guiBundle != null ? PaternalResourceBundle.getOrCreateCachedBundle(guiBundle, contextBundle) : contextBundle;
    }

    public void addModelListener(XmlModelListener listener) {
        this._deliverHelloGoodbye(listener, true);
        this._listeners.addListener(listener);
    }

    public void removeModelListener(XmlModelListener listener) {
        this._listeners.removeListener(listener);
        this._deliverHelloGoodbye(listener, false);
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public final void shown() {
        if (!this._shown) {
            this._shown = true;
            this.handleShown();
        }
    }

    public final void hidden() {
        if (this._shown) {
            this._shown = false;
            this.handleHidden();
        }
    }

    public void dispose() {
        this.getView().removeModelListener(this._viewListener);
        this.getGuiContext().__destroyGuiReference(this);
    }

    public boolean isGuiActivatable() {
        return true;
    }

    public final List getContextActions() {
        List viewList = this.getView().getContextActions();
        if (viewList.isEmpty()) {
            return viewList;
        }
        ArrayList<Action> guiList = new ArrayList<Action>(viewList.size());
        for (Action viewAction : viewList) {
            Action guiAction = this.translateViewAction(viewAction);
            if (guiAction == null || this._actionRequiresMutation(guiAction) && !this.isUserEditable() || !this._showIfEnabled(guiAction)) continue;
            guiList.add(guiAction);
        }
        return guiList;
    }

    public Action getAction(String actionString) {
        return this.translateViewAction(this.getView().getAction(actionString));
    }

    public final GuiXmlContext getGuiContext() {
        return (GuiXmlContext)this.getView().getContext();
    }

    public final XmlView getView() {
        return this._view;
    }

    public final boolean isShown() {
        return this._shown;
    }

    public boolean isUserEditable() {
        XmlView view = this.getView();
        view.acquireReadLock();
        try {
            boolean bl = this.getGuiContext().isUserEditable() && !view.isReadOnly();
            return bl;
        }
        finally {
            view.releaseReadLock();
        }
    }

    public String getTranslatedString(String key) {
        ResourceBundle bundle = this.getBundle();
        if (bundle != null) {
            try {
                String translatedString = bundle.getString(key);
                return translatedString;
            }
            catch (MissingResourceException e) {
                this.getLogger().log(Level.SEVERE, "Could not find resource key:" + key + " in bundle:" + bundle);
            }
        }
        return "??" + key + "??";
    }

    public final XmlUsage getUsage() {
        if (this._usage == null) {
            throw new IllegalStateException("getUsage called before postCreationHook");
        }
        return this._usage;
    }

    public final Logger getLogger() {
        return _LOGGER;
    }

    public String getHelpTopic(Node node, XmlKey key) {
        assert (this.getView().getDomModel().getLockStatus() == 1 || this.getView().getDomModel().getLockStatus() == 2) : "XmlGui.getHelpTopic requires a lock";
        return node == null ? this.getView().getXmlMetadataResolver().getHelpTopic(key) : this.getView().getXmlMetadataResolver().getHelpTopic(node);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String className = this.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1 && className.length() > lastDot + 1) {
            className = className.substring(lastDot + 1);
        }
        buf.append(className);
        buf.append("(");
        buf.append(this.getView());
        buf.append(")");
        return buf.toString();
    }

    protected final ResourceBundle getBundle() {
        return this._bundle;
    }

    protected ResourceBundle createBundle() {
        return null;
    }

    protected FastMessageFormat getMessageFormat(String formatKey) {
        String formatString = this.getTranslatedString(formatKey);
        if (formatString != null) {
            return new FastMessageFormat(formatString);
        }
        return null;
    }

    protected void postCreationHook() {
        this.getView().addModelListener(this._viewListener);
    }

    protected void handleViewAttached(XmlModelEvent event) {
    }

    protected void handleModelInvalidateEvent(XmlModelEvent event) {
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "XmlGui event: {0} received {1}", new Object[]{this, event});
        }
    }

    protected void handleViewDetached(XmlModelEvent event) {
    }

    protected void handleShown() {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.finer("XmlGui shown: " + this);
        }
    }

    protected void handleHidden() {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.finer("XmlGui hidden: " + this);
        }
    }

    protected Action translateViewAction(Action viewAction) {
        if (viewAction != null) {
            return new GuiActionProxy(viewAction);
        }
        return viewAction;
    }

    void __setUsage(XmlUsage usage) {
        assert (usage != null);
        assert (this._usage == null);
        this._usage = usage;
    }

    void __setEventProcessor(GuiEventProcessor processor) {
        assert (processor != null);
        assert (this._processor == null);
        this._processor = processor;
    }

    void __notifyGuiListenersModelChange(XmlModelEvent event) {
        this._notifyGuiListeners(event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deliverHelloGoodbye(XmlModelListener listener, boolean isHello) {
        XmlModelEvent event = this.getView().createHelloGoodbyeEvent(isHello);
        event.prepareForDelivery();
        this.getView().acquireReadLock();
        try {
            if (isHello) {
                listener.listenerAttached(event);
            } else {
                listener.listenerDetached(event);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)("Exception in " + (isHello ? "hello" : "goodbye") + "event delivery " + "to listener {0}. gui={1} event={2}"), (Object[])new Object[]{listener, this, event}, (Throwable)t);
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    private void _notifyGuiListeners(XmlModelEvent event, boolean isInvalidate) {
        if (!this._listeners.isEmpty()) {
            Iterator itor = this._listeners.iterator();
            while (itor.hasNext()) {
                XmlModelListener l = (XmlModelListener)itor.next();
                try {
                    if (isInvalidate) {
                        l.invalidate(event);
                        continue;
                    }
                    l.modelChanged(event);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Exception notifying gui listener {0} on gui {1} of event {2}", (Object[])new Object[]{l, this, event}, (Throwable)t);
                }
            }
        }
    }

    private boolean _actionRequiresMutation(Action action) {
        Object propVal = action.getValue("XmlContext.MUTATES_MODEL");
        return Boolean.TRUE.equals(propVal);
    }

    private boolean _showIfEnabled(Action action) {
        Object propValue = action.getValue("XmlContext._HIDE_WHEN_DISABLED");
        if (!Boolean.TRUE.equals(propValue)) {
            return true;
        }
        return action.isEnabled();
    }

    private class GuiListener
    extends XmlModelAdapter {
        private GuiListener() {
        }

        @Override
        public void listenerAttached(XmlModelEvent event) {
            XmlGui.this.handleViewAttached(event);
        }

        @Override
        public void invalidate(XmlModelEvent event) {
            XmlGui.this.handleModelInvalidateEvent(event);
            XmlGui.this._notifyGuiListeners(event, true);
        }

        @Override
        public void modelChanged(XmlModelEvent event) {
            XmlGui.this._processor.processEvent(XmlGui.this, event);
        }

        @Override
        public void listenerDetached(XmlModelEvent event) {
            XmlGui.this.handleViewDetached(event);
        }
    }

    protected class GuiActionProxy
    extends ActionProxy {
        private final Action _base;

        public GuiActionProxy(Action base) {
            this._base = base;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && (!XmlGui.this._actionRequiresMutation(this) || XmlGui.this.isUserEditable());
        }

        @Override
        protected Action getBaseAction() {
            return this._base;
        }
    }
}

