/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.util;

import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.DocumentTypeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentHandler;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.dom.buffer.parser.XmlDocumentScanner;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;

public class EncodingParser
implements DocumentHandler {
    private XmlDocumentScanner _scanner = null;
    private AttributeLocator _encodingLocator = null;

    public EncodingParser(XmlDocumentScanner scanner) {
        this._scanner = scanner;
    }

    public AttributeLocator findEncodingLocator(ReadTextBuffer buffer) {
        this._encodingLocator = null;
        if (buffer != null) {
            LineMap lineMap = null;
            if (buffer instanceof TextBuffer) {
                TextBuffer textBuffer = (TextBuffer)buffer;
                lineMap = textBuffer.getLineMap();
            }
            LocatorManager manager = new LocatorManager(lineMap);
            this._scanner.scanDocument(buffer, this, manager);
        }
        return this._encodingLocator;
    }

    @Override
    public void handleXMLDeclaration(String version, String encoding, String standalone, DeclarationLocator locator) {
        if (this._encodingLocator == null) {
            this._encodingLocator = locator.getEncodingLocator();
        }
        this._scanner.stopScanning();
    }

    @Override
    public void handleStartElement(ResolvedName name, AttributeDeclarations attributes, ElementLocator locator) {
        this._scanner.stopScanning();
    }

    @Override
    public void handleEmptyElement(ResolvedName name, AttributeDeclarations attributes, ElementLocator locator) {
        this._scanner.stopScanning();
    }

    @Override
    public void handleEndElement(ResolvedName name, SimpleLocator locator, boolean complete) {
        this._scanner.stopScanning();
    }

    @Override
    public void handleCDATASection(String characters, SimpleLocator locator) {
        this._scanner.stopScanning();
    }

    @Override
    public void handleDocumentType(ResolvedName name, String publicID, String systemID, SimpleLocator locator, DocumentTypeLocator docTypeLocator) {
        this._scanner.stopScanning();
    }

    @Override
    public void handleText(String characters, TextLocator locator) {
    }

    @Override
    public void handleProcessingInstruction(String target, String data, SimpleLocator locator) {
    }

    @Override
    public void handleComment(String text, SimpleLocator locator) {
    }
}

