/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.graphic.IlvLabel;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.sdm.graphic.IlvGeneralLink;
import java.awt.Color;
import oracle.diagram.core.graphic.CoreLabel;
import oracle.diagram.core.graphic.CoreText;
import oracle.diagram.core.graphic.CoreZoomableLabel;

public class SDMGeneralLink
extends IlvGeneralLink {
    public SDMGeneralLink() {
    }

    public SDMGeneralLink(IlvGeneralLink source) {
        super(source);
    }

    public SDMGeneralLink(IlvGraphic from, IlvGraphic to) {
        super(from, to);
    }

    public SDMGeneralLink(IlvGraphic from, IlvGraphic to, boolean oriented) {
        super(from, to, oriented);
    }

    public SDMGeneralLink(IlvGraphic from, IlvGraphic to, boolean backoriented, boolean oriented, IlvPoint[] points) {
        super(from, to, backoriented, oriented, points);
    }

    public SDMGeneralLink(IlvGraphic from, IlvGraphic to, boolean oriented, IlvPoint[] points) {
        super(from, to, oriented, points);
    }

    public SDMGeneralLink(IlvInputStream stream) throws IlvReadFileException {
        super(stream);
    }

    public void addObject(IlvGraphic ilvGraphic, boolean b) {
        super.addObject(ilvGraphic, b);
    }

    public void setDecorations(IlvGraphic[] decorations) {
        if (decorations != null && decorations.length != 0) {
            IlvGraphic[] tmp = new IlvGraphic[decorations.length];
            System.arraycopy(decorations, 0, tmp, 0, decorations.length);
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = this.convertLabel(tmp[i]);
            }
            super.setDecorations(tmp);
        } else {
            super.setDecorations(decorations);
        }
    }

    public void setDecorations(int index, IlvGraphic decoration) {
        super.setDecorations(index, this.convertLabel(decoration));
    }

    private IlvGraphic convertLabel(IlvGraphic src) {
        if (src != null) {
            if (src.getClass().equals(IlvText.class)) {
                return new CoreText((IlvText)src);
            }
            if (src.getClass().equals(IlvLabel.class)) {
                return new CoreLabel((IlvLabel)src);
            }
            if (src.getClass().equals(IlvZoomableLabel.class)) {
                return new CoreZoomableLabel((IlvZoomableLabel)src);
            }
        }
        return src;
    }

    public void setLabel(String string) {
        this.getLabelGraphic();
        super.setLabel(string);
    }

    protected final IlvGraphic getLabelGraphic() {
        IlvGraphic[] decorations = this.getDecorations();
        if (decorations == null || decorations.length == 0 || decorations[0] == null) {
            IlvGraphic label = this.createDefaultLabelGraphic();
            if (!(label instanceof IlvLabelInterface)) {
                throw new IllegalArgumentException("createDefaultLabelGraphic() must return IlvGraphic that implements IlvLabelInterface");
            }
            this.setDecorations(0, label);
        }
        return this.getDecorations(0);
    }

    protected IlvGraphic createDefaultLabelGraphic() {
        CoreZoomableLabel zlabel = new CoreZoomableLabel();
        zlabel.move(0.0f, 0.0f);
        zlabel.setAntialiasing(true);
        zlabel.setMultilineSpacing(-10.0f);
        return zlabel;
    }

    public void setLabelColor(Color c) {
        this.getLabelGraphic().setForeground(c);
    }
}

