/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.awt.Color;
import java.awt.Font;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPParseConstants;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPXMLElementAdapter;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public final class OPPGraphicalProperties
extends OPPXMLElementAdapter
implements OPPParseConstants {
    private final OPPContainer _parent;
    private final Set<Property> _mask;
    private final Map<Property, Object> _values = new HashMap<Property, Object>();

    OPPGraphicalProperties(OPPContainer parent, XMLElement xmlSource) {
        super(xmlSource);
        NodeList colors;
        NodeList fonts;
        int i;
        int isize;
        NodeList ints;
        this._parent = parent;
        NodeList floats = xmlSource.getChildrenByTagName("float");
        if (floats != null) {
            int isize2 = floats.getLength();
            for (int i2 = 0; i2 < isize2; ++i2) {
                XMLElement f = (XMLElement)floats.item(i2);
                String name = OPPParseUtil.getNameAttribute(f);
                Float fv = (Float)OPPParseUtil.parseTypedProperty(f);
                if (!"lineWidth".equals(name)) continue;
                this._values.put(Property.LINE_WIDTH, fv);
            }
        }
        if ((ints = xmlSource.getChildrenByTagName("integer")) != null) {
            isize = ints.getLength();
            for (i = 0; i < isize; ++i) {
                XMLElement el = (XMLElement)ints.item(i);
                String name = OPPParseUtil.getNameAttribute(el);
                Integer iv = (Integer)OPPParseUtil.parseTypedProperty(el);
                if (!"lineStyle".equals(name)) continue;
                this._values.put(Property.LINE_STYLE, iv);
            }
        }
        if ((fonts = xmlSource.getChildrenByTagName("font")) != null) {
            isize = fonts.getLength();
            for (i = 0; i < isize; ++i) {
                XMLElement font = (XMLElement)fonts.item(i);
                String name = OPPParseUtil.getNameAttribute(font);
                if (!"fontType".equals(name)) continue;
                this._values.put(Property.FONT, OPPParseUtil.parseTypedProperty(font));
            }
        }
        if ((colors = xmlSource.getChildrenByTagName("color")) != null) {
            int isize3 = colors.getLength();
            for (int i3 = 0; i3 < isize3; ++i3) {
                XMLElement color = (XMLElement)colors.item(i3);
                String name = OPPParseUtil.getNameAttribute(color);
                Color c = (Color)OPPParseUtil.parseTypedProperty(color);
                if ("fillColor".equals(name)) {
                    this._values.put(Property.FILL_COLOR, c);
                    continue;
                }
                if ("lineColor".equals(name)) {
                    this._values.put(Property.LINE_COLOR, c);
                    continue;
                }
                if ("fontColor".equals(name)) {
                    this._values.put(Property.FONT_COLOR, c);
                    continue;
                }
                if (!"secondaryColor".equals(name)) continue;
                this._values.put(Property.SECONDARY_COLOR, c);
            }
        }
        this._mask = Collections.unmodifiableSet(this._values.keySet());
    }

    public final Set<Property> getSupportedProperties() {
        return this._mask;
    }

    public final boolean isSupported(Property property) {
        return this.getSupportedProperties().contains((Object)property);
    }

    public final boolean supportsFillColor() {
        return this.isSupported(Property.FILL_COLOR);
    }

    public final Color getFillColor() {
        return (Color)this._values.get((Object)Property.FILL_COLOR);
    }

    public final boolean supportsLineColor() {
        return this.isSupported(Property.LINE_COLOR);
    }

    public final Color getLineColor() {
        return (Color)this._values.get((Object)Property.LINE_COLOR);
    }

    public final boolean supportsFontColor() {
        return this.isSupported(Property.FONT_COLOR);
    }

    public final Color getFontColor() {
        return (Color)this._values.get((Object)Property.FONT_COLOR);
    }

    public final boolean supportsSecondaryColor() {
        return this.isSupported(Property.SECONDARY_COLOR);
    }

    public final Color getSecondaryColor() {
        return (Color)this._values.get((Object)Property.SECONDARY_COLOR);
    }

    public final boolean supportsFont() {
        return this.isSupported(Property.FONT);
    }

    public final Font getFont() {
        return (Font)this._values.get((Object)Property.FONT);
    }

    public final boolean supportsLineWidth() {
        return this.isSupported(Property.LINE_WIDTH);
    }

    public final float getLineWidth() {
        return this.getFloatProperty(Property.LINE_WIDTH);
    }

    public final boolean supportsLineStyle() {
        return this.isSupported(Property.LINE_STYLE);
    }

    public final int getLineStyle() {
        return this.getIntegerProperty(Property.LINE_STYLE);
    }

    public final Object getProperty(Property p) {
        return this._values.get((Object)p);
    }

    public final OPPContainer getParent() {
        return this._parent;
    }

    private final float getFloatProperty(Property p) {
        Float value = (Float)this._values.get((Object)p);
        if (value != null) {
            return value.floatValue();
        }
        return 0.0f;
    }

    private int getIntegerProperty(Property p) {
        Integer value = (Integer)this._values.get((Object)p);
        if (value != null) {
            return value;
        }
        return 0;
    }

    public static enum Property {
        FILL_COLOR,
        LINE_COLOR,
        FONT_COLOR,
        SECONDARY_COLOR,
        FONT,
        LINE_WIDTH,
        LINE_STYLE;

    }
}

