/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import java.util.HashSet;
import java.util.Set;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.interaction.MoveGraphicsHelper;
import oracle.diagram.framework.interaction.MoveGraphicsHelperProvider;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.swimlanes.interaction.AbstractSwimlanesMoveGraphicsHelper;
import oracle.diagram.framework.swimlanes.interaction.AutoExpandSwimlanesMoveGraphicsHelper;
import oracle.diagram.framework.swimlanes.interaction.NoExpandSwimlanesMoveGraphicsHelper;

public abstract class SwimlanesMoveGraphicsHelperProvider
implements MoveGraphicsHelperProvider {
    private DiagramContext _context;

    public SwimlanesMoveGraphicsHelperProvider(DiagramContext context) {
        this._context = context;
    }

    @Override
    public MoveGraphicsHelper createMoveGraphicsHelper(Set<IlvGraphic> graphics) {
        SwimlanesPlugin plugin = this._context.getPlugin(SwimlanesPlugin.class);
        if (plugin != null) {
            IlvManager topManager = this._context.getManagerView().getManager();
            HashSet<IlvGraphic> helperGraphics = new HashSet<IlvGraphic>();
            for (IlvGraphic g : graphics) {
                if (!topManager.isManaged(g) || plugin.getSwimlaneForGraphic(g) == null) continue;
                helperGraphics.add(g);
            }
            if (!helperGraphics.isEmpty()) {
                SwimlaneGraphic topSwimlane = plugin.getTopSwimlane(topManager);
                AbstractSwimlanesMoveGraphicsHelper helper = topSwimlane.isAutoExpand() ? new AutoExpandSwimlanesMoveGraphicsHelper(this._context, plugin, topManager, helperGraphics){

                    @Override
                    protected void removeGraphicFromSwimlane(IlvGraphic g, SwimlaneGraphic sg) {
                        SwimlanesMoveGraphicsHelperProvider.this.removeGraphicFromSwimlane(g, sg);
                    }

                    @Override
                    protected void addGraphicToSwimlane(IlvGraphic g, SwimlaneGraphic sg) {
                        SwimlanesMoveGraphicsHelperProvider.this.addGraphicToSwimlane(g, sg);
                    }
                } : new NoExpandSwimlanesMoveGraphicsHelper(this._context, plugin, topManager, helperGraphics){

                    @Override
                    protected void removeGraphicFromSwimlane(IlvGraphic g, SwimlaneGraphic sg) {
                        SwimlanesMoveGraphicsHelperProvider.this.removeGraphicFromSwimlane(g, sg);
                    }

                    @Override
                    protected void addGraphicToSwimlane(IlvGraphic g, SwimlaneGraphic sg) {
                        SwimlanesMoveGraphicsHelperProvider.this.addGraphicToSwimlane(g, sg);
                    }
                };
                graphics.removeAll(helperGraphics);
                return helper;
            }
        }
        return null;
    }

    protected abstract void removeGraphicFromSwimlane(IlvGraphic var1, SwimlaneGraphic var2);

    protected abstract void addGraphicToSwimlane(IlvGraphic var1, SwimlaneGraphic var2);
}

