/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import java.util.ArrayList;
import java.util.List;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.framework.preference.PreferenceStore;
import oracle.diagram.framework.preference.PreferenceStoreListener;
import oracle.diagram.framework.preference.event.PreferenceStoreEvent;

public class LayeredPreferenceStore
implements PreferenceStore {
    private final PreferenceStore _store;
    private final PreferenceStore _other;
    private final List<PreferenceStoreListener> _listeners = new ArrayList<PreferenceStoreListener>();
    private final PreferenceStoreListener _listener;

    public LayeredPreferenceStore(PreferenceStore primary, PreferenceStore alternate) {
        this._store = primary;
        this._other = alternate;
        this._listener = new PreferenceStoreListener(){

            @Override
            public void preferenceStoreChanged(PreferenceStoreEvent event) {
                LayeredPreferenceStore.this.firePreferenceStoreEvent(event);
            }
        };
        this._store.addPreferenceStoreListener(this._listener);
    }

    @Override
    public void addPreferenceStoreListener(PreferenceStoreListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public void removePreferenceStoreListener(PreferenceStoreListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public boolean hasPreferenceValue(PreferenceDefinition preference) {
        if (this._store.hasPreferenceValue(preference)) {
            return true;
        }
        return this._other.hasPreferenceValue(preference);
    }

    @Override
    public final Object getPreferenceValue(PreferenceDefinition preference) {
        if (this._store.hasPreferenceValue(preference)) {
            return this._store.getPreferenceValue(preference);
        }
        return this._other.getPreferenceValue(preference);
    }

    @Override
    public final Object setPreferenceValue(PreferenceDefinition preference, Object value) {
        return this._store.setPreferenceValue(preference, value);
    }

    @Override
    public final void setPreferenceValues(PreferenceDefinition[] preferences, Object[] values) {
        this._store.setPreferenceValues(preferences, values);
    }

    private void firePreferenceStoreEvent(PreferenceStoreEvent ev) {
        PreferenceStoreListener[] copy;
        int count = ev.getChangesCount();
        PreferenceDefinition[] prefs = new PreferenceDefinition[count];
        Object[] oldValues = new Object[count];
        Object[] newValues = new Object[count];
        for (int i = 0; i < count; ++i) {
            prefs[i] = ev.getChangedPreference(i);
            oldValues[i] = ev.getOldValue(i);
            newValues[i] = ev.getNewValue(i);
        }
        PreferenceStoreEvent event = new PreferenceStoreEvent(this, prefs, oldValues, newValues);
        for (PreferenceStoreListener l : copy = this._listeners.toArray(new PreferenceStoreListener[this._listeners.size()])) {
            try {
                l.preferenceStoreChanged(event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

