/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.interactor.IlvMoveRectangleInteractor;
import ilog.views.interactor.IlvSelectInteractor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import oracle.diagram.core.util.CoreGraphicUtils;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.interaction.EditInteractor;
import oracle.diagram.framework.interaction.InPlaceEditor;
import oracle.diagram.framework.manager.ManagerUtil;

public abstract class MouseOverGraphicTracker {
    private IlvManagerView m_view;
    private IlvManagerViewInteractor m_interactor;
    private Listener m_listener;
    private IlvGraphic m_currentGraphic;
    private IlvGraphic m_currentRootShape;
    private IlvManager m_currentRootShapeMgr;
    private IlvPoint m_tempPoint;
    private MouseEvent m_lastEvent;
    private boolean m_enabled;

    public MouseOverGraphicTracker(IlvManagerView view) {
        this.m_view = view;
        this.m_tempPoint = new IlvPoint(0.0f, 0.0f);
        this.m_enabled = false;
        this.m_listener = new Listener();
        this.m_view.addInteractorListener((InteractorListener)this.m_listener);
        this.processNewInteractor(this.m_view.getInteractor());
    }

    public void clean() {
        if (this.m_currentGraphic != null) {
            this.graphicExited(this.m_currentGraphic);
            this.setCurrentGraphic(null);
        }
        if (this.m_listener != null) {
            this.m_view.removeInteractorListener((InteractorListener)this.m_listener);
            this.removeCurrentInteractor();
            this.m_listener = null;
        }
        this.m_lastEvent = null;
        this.m_view = null;
    }

    private void setCurrentGraphic(IlvGraphic g) {
        if (this.m_currentRootShapeMgr != null && this.m_listener != null) {
            this.m_currentRootShapeMgr.removeManagerContentChangedListener((ManagerContentChangedListener)this.m_listener);
        }
        this.m_currentRootShapeMgr = null;
        this.m_currentRootShape = null;
        this.m_currentGraphic = null;
        if (g != null) {
            this.m_currentGraphic = g;
            this.m_currentRootShape = CoreGraphicUtils.getManagedParentNode(this.m_currentGraphic);
            this.m_currentRootShapeMgr = ManagerUtil.getManager(this.m_currentRootShape);
            this.m_currentRootShapeMgr.addManagerContentChangedListener((ManagerContentChangedListener)this.m_listener);
        }
    }

    protected final IlvManagerView getManagerView() {
        return this.m_view;
    }

    protected final IlvManagerViewInteractor getCurrentInteractor() {
        return this.m_interactor;
    }

    protected abstract void graphicEntered(IlvGraphic var1);

    protected abstract void graphicExited(IlvGraphic var1);

    protected void graphicRemoved(IlvGraphic graphic) {
    }

    protected void mouseDraggedOverGraphic(IlvGraphic graphic, MouseEvent e) {
    }

    protected IlvGraphic getNotificationGraphic(IlvGraphic mainObject, IlvPoint p, IlvManagerView view) {
        IlvGrapher grapher;
        IlvGraphicBag bag;
        IlvGraphic g = null;
        if (mainObject != null && (bag = mainObject.getGraphicBag()) instanceof IlvGrapher && (grapher = (IlvGrapher)bag).isNode(mainObject) && grapher.isVisible(mainObject)) {
            g = mainObject;
        }
        return g;
    }

    protected boolean isNotificationEnabled(IlvManagerViewInteractor i) {
        return i instanceof IlvSelectInteractor || i instanceof EditInteractor || i instanceof InPlaceEditor;
    }

    protected void removeCurrentInteractor() {
        if (this.m_interactor != null) {
            this.m_interactor.removeMouseMotionListener((MouseMotionListener)this.m_listener);
            this.m_interactor = null;
        }
    }

    protected void processNewInteractor(IlvManagerViewInteractor newInteractor) {
        boolean wasEnabled = this.m_enabled;
        this.m_enabled = false;
        if (newInteractor != null) {
            this.m_interactor = newInteractor;
            this.m_interactor.addMouseMotionListener((MouseMotionListener)this.m_listener);
            this.m_enabled = this.isNotificationEnabled(this.m_interactor);
            if (!wasEnabled && this.m_enabled && this.m_lastEvent != null) {
                this.setCurrentGraphic(null);
                this.m_listener.mouseMoved(this.m_lastEvent);
            }
        }
        if (wasEnabled && !this.m_enabled && this.m_currentGraphic != null) {
            this.graphicExited(this.m_currentGraphic);
            this.setCurrentGraphic(null);
        }
    }

    private class Listener
    implements InteractorListener,
    ManagerContentChangedListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MouseOverGraphicTracker.this.m_lastEvent = e;
            if (MouseOverGraphicTracker.this.m_interactor != null && MouseOverGraphicTracker.this.m_interactor instanceof IlvMoveRectangleInteractor) {
                this.processMouseEvent(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.processMouseEvent(e);
        }

        private void processMouseEvent(MouseEvent e) {
            IlvGraphic newGraphic;
            MouseOverGraphicTracker.this.m_lastEvent = e;
            if (!MouseOverGraphicTracker.this.m_enabled) {
                return;
            }
            IlvManager manager = MouseOverGraphicTracker.this.m_view.getManager();
            MouseOverGraphicTracker.this.m_tempPoint.setLocation((Point2D)e.getPoint());
            IlvGraphic g = manager.getObject(MouseOverGraphicTracker.this.m_tempPoint, MouseOverGraphicTracker.this.m_view, true);
            if (g instanceof IMultipresentationView) {
                g = ((IMultipresentationView)g).getContainer();
            }
            if ((newGraphic = MouseOverGraphicTracker.this.getNotificationGraphic(g, MouseOverGraphicTracker.this.m_tempPoint, MouseOverGraphicTracker.this.m_view)) != MouseOverGraphicTracker.this.m_currentGraphic) {
                if (MouseOverGraphicTracker.this.m_currentGraphic != null) {
                    MouseOverGraphicTracker.this.graphicExited(MouseOverGraphicTracker.this.m_currentGraphic);
                    MouseOverGraphicTracker.this.setCurrentGraphic(null);
                }
                if (newGraphic != null) {
                    MouseOverGraphicTracker.this.graphicEntered(newGraphic);
                    MouseOverGraphicTracker.this.setCurrentGraphic(newGraphic);
                }
            }
            if (MouseOverGraphicTracker.this.m_currentGraphic != null && e.getID() == 506) {
                MouseOverGraphicTracker.this.mouseDraggedOverGraphic(MouseOverGraphicTracker.this.m_currentGraphic, e);
            }
        }

        public void interactorChanged(InteractorChangedEvent interactorChangedEvent) {
            MouseOverGraphicTracker.this.removeCurrentInteractor();
            MouseOverGraphicTracker.this.processNewInteractor(MouseOverGraphicTracker.this.getManagerView().getInteractor());
        }

        public void contentsChanged(ManagerContentChangedEvent evt) {
            if (evt.getType() == 2 && MouseOverGraphicTracker.this.m_currentGraphic != null && MouseOverGraphicTracker.this.m_currentRootShape != null) {
                ObjectRemovedEvent ore = (ObjectRemovedEvent)evt;
                if (MouseOverGraphicTracker.this.m_currentRootShape.equals(ore.getGraphicObject())) {
                    MouseOverGraphicTracker.this.graphicExited(MouseOverGraphicTracker.this.m_currentGraphic);
                    MouseOverGraphicTracker.this.graphicRemoved(MouseOverGraphicTracker.this.m_currentGraphic);
                    MouseOverGraphicTracker.this.setCurrentGraphic(null);
                }
            }
        }
    }
}

