/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout.row;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.graphic.IlvLine;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.interaction.CoreSelectInteractor;
import oracle.diagram.core.interaction.IdeObjectInteractorContext;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.row.ResizeRowUndoableStep;
import oracle.diagram.framework.graphic.layout.row.RowContainer;
import oracle.diagram.framework.undo.UndoableStep;
import oracle.diagram.framework.undo.UndoableStepManager;

public class ResizeRowInteractor
extends IlvObjectInteractor {
    private IlvPoint m_pt = new IlvPoint();
    private RowContainer m_container;
    private IlvLine m_divider;
    private boolean m_dragging;
    private int m_rowIndex;
    private IlvPoint m_initialPressPoint;
    private IlvRect m_initialDividerRect;
    private Cursor m_oldCursor;
    private float m_minHeight;
    private UndoableStep m_undoStep;
    private MouseEvent m_lastDragEvent;
    private IlvObjectInteractorContext m_lastContext;
    private MyTransformerListener m_transformerListener;

    public boolean processEvent(IlvGraphic g, AWTEvent awtEvent, IlvObjectInteractorContext context) {
        if (g instanceof RowContainer && awtEvent instanceof MouseEvent) {
            RowContainer cg = (RowContainer)g;
            MouseEvent mouseEvent = (MouseEvent)awtEvent;
            this.m_pt.x = mouseEvent.getX();
            this.m_pt.y = mouseEvent.getY();
            if (!this.m_dragging) {
                IlvManagerView view = this.getView(context);
                IlvGraphic subshape = cg.getSubShape(this.m_pt, view);
                if (subshape != null && subshape instanceof IlvLine && subshape.getGraphicBag() instanceof RowContainer) {
                    this.m_container = (RowContainer)subshape.getGraphicBag();
                    this.m_divider = (IlvLine)subshape;
                    this.m_rowIndex = this.m_container.getRowIndex(this.m_divider);
                } else {
                    this.m_container = null;
                    this.m_divider = null;
                    this.m_rowIndex = -1;
                }
            }
            switch (awtEvent.getID()) {
                case 503: {
                    return this.mouseMoved(context);
                }
                case 501: {
                    return this.mousePressed(context);
                }
                case 506: {
                    this.m_lastDragEvent = mouseEvent;
                    this.m_lastContext = context;
                    return this.mouseDragged(context);
                }
                case 502: {
                    this.mouseDragged(context);
                    return this.mouseReleased(context);
                }
            }
        }
        return false;
    }

    private boolean mousePressed(IlvObjectInteractorContext context) {
        if (this.m_container != null && this.m_container.canResizeRows() && this.m_rowIndex != -1) {
            this.m_dragging = true;
            this.m_initialPressPoint = new IlvPoint(this.m_pt);
            IlvManagerView view = this.getView(context);
            view.getTransformer().inverse(this.m_initialPressPoint);
            this.m_initialDividerRect = new IlvRect(this.m_divider.boundingBox(null));
            this.m_minHeight = this.m_container.getMinimumRowSize((int)this.m_rowIndex, (DimensionFloat)new DimensionFloat()).height + 1.0f;
            this.m_undoStep = new ResizeRowUndoableStep(this.m_container, this.m_rowIndex);
            this.m_undoStep.storeUndoState();
            this.m_transformerListener = new MyTransformerListener();
            view.addTransformerListener((TransformerListener)this.m_transformerListener);
            if (view.getInteractor() instanceof CoreSelectInteractor) {
                ((CoreSelectInteractor)view.getInteractor()).setCanAutoscroll(true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mouseDragged(IlvObjectInteractorContext context) {
        if (this.m_dragging) {
            IlvPoint newPoint = new IlvPoint(this.m_pt);
            IlvManagerView view = this.getView(context);
            view.getTransformer().inverse(newPoint);
            ExtendedGraphic row = this.m_container.getRowGraphic(this.m_rowIndex);
            IlvRect bbox = ((IlvGraphic)row).boundingBox(null);
            float y1 = newPoint.y - (this.m_initialPressPoint.y - this.m_initialDividerRect.y);
            float newHeight = Double.valueOf(Math.floor(Float.valueOf(y1 - bbox.y).floatValue())).floatValue();
            if (newHeight < this.m_minHeight) {
                newHeight = this.m_minHeight;
            }
            if (newHeight != bbox.height) {
                int redrawMode = view.getRedrawMode();
                view.setRedrawMode(1);
                view.getManager().initReDraws();
                try {
                    this.m_container.resizeRow(this.m_rowIndex, newHeight);
                    view.getManager().reDrawViews();
                }
                finally {
                    view.setRedrawMode(redrawMode);
                }
            }
            return true;
        }
        return false;
    }

    private boolean mouseReleased(IlvObjectInteractorContext context) {
        if (this.m_dragging) {
            IlvManagerView view = this.getView(context);
            view.removeTransformerListener((TransformerListener)this.m_transformerListener);
            if (view.getInteractor() instanceof CoreSelectInteractor) {
                ((CoreSelectInteractor)view.getInteractor()).setCanAutoscroll(false);
            }
            this.m_undoStep.storeRedoState();
            UndoableStepManager usm = this.getUndoableStepManager((IlvGraphic)this.m_container);
            if (usm != null) {
                usm.addUndoableStep(this.m_undoStep, this.getUndoDescription((IlvGraphic)this.m_container));
            }
            this.m_undoStep = null;
            this.m_transformerListener = null;
            this.m_lastDragEvent = null;
            this.m_lastContext = null;
            this.m_dragging = false;
            this.m_container = null;
            this.m_divider = null;
            this.m_rowIndex = -1;
            DiagramContext dc = DiagramContext.getDiagramContext(this.getView(context));
            dc.getPlugin(IdeContextPlugin.class).getContext().getNode().markDirty(true);
            return true;
        }
        return false;
    }

    private boolean mouseMoved(IlvObjectInteractorContext context) {
        if (this.m_container != null && this.m_container.canResizeRows() && this.m_rowIndex != -1) {
            Cursor cursor = Cursor.getPredefinedCursor(9);
            this.m_oldCursor = context.getCursor();
            context.setCursor(cursor);
            return true;
        }
        if (this.m_rowIndex == -1 && this.m_oldCursor != null) {
            context.setCursor(this.m_oldCursor);
            this.m_oldCursor = null;
        }
        return false;
    }

    protected String getUndoDescription(IlvGraphic graphic) {
        return null;
    }

    protected UndoableStepManager getUndoableStepManager(IlvGraphic graphic) {
        return null;
    }

    protected IlvManagerView getView(IlvObjectInteractorContext context) {
        if (context instanceof IlvManagerView) {
            return (IlvManagerView)context;
        }
        if (context instanceof IdeObjectInteractorContext) {
            return ((IdeObjectInteractorContext)context).getView();
        }
        throw new IllegalStateException("Unable to determine view");
    }

    private class MyTransformerListener
    implements TransformerListener {
        private MyTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (ResizeRowInteractor.this.m_lastDragEvent != null && ResizeRowInteractor.this.m_container != null) {
                final MouseEvent event = new MouseEvent(ResizeRowInteractor.this.m_lastDragEvent.getComponent(), 506, System.currentTimeMillis(), ResizeRowInteractor.this.m_lastDragEvent.getModifiers(), ResizeRowInteractor.this.m_lastDragEvent.getX(), ResizeRowInteractor.this.m_lastDragEvent.getY(), ResizeRowInteractor.this.m_lastDragEvent.getClickCount(), false, ResizeRowInteractor.this.m_lastDragEvent.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ResizeRowInteractor.this.m_container != null && ResizeRowInteractor.this.m_lastContext != null) {
                            ResizeRowInteractor.this.processEvent((IlvGraphic)ResizeRowInteractor.this.m_container, event, ResizeRowInteractor.this.m_lastContext);
                        }
                    }
                });
            }
        }
    }
}

