/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.dragdrop;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetListener;
import java.util.HashSet;
import java.util.Set;
import oracle.diagram.core.util.Translator;
import oracle.diagram.framework.datatransfer.SelectionTransferable;
import oracle.diagram.framework.dragdrop.ManagerViewDragAndDropController;
import oracle.diagram.framework.manager.ManagerAction;
import oracle.diagram.framework.manager.ManagerUtil;

public class DiagramManagerViewDragAndDropController
extends ManagerViewDragAndDropController
implements DragSourceListener {
    private IlvGraphicVector _selection = null;

    public DiagramManagerViewDragAndDropController(DragSource ds, IlvManagerView view, Autoscroll autoscrollComponent, int actions, DropTargetListener dtl) {
        super(ds, view, autoscrollComponent, actions, dtl);
    }

    public DiagramManagerViewDragAndDropController(DragSource ds, IlvManagerView view, Autoscroll autoscrollComponent, int actions, DataFlavor nativeFlavor, DropTargetListener dtl) {
        super(ds, view, autoscrollComponent, actions, nativeFlavor, dtl);
    }

    @Override
    protected void dragGestureRecognized(DragGestureEvent ev) {
        IlvManagerView view = (IlvManagerView)((DragGestureRecognizer)ev.getSource()).getComponent();
        IlvManager mgr = view.getManager();
        if ((ev.getDragAction() & this.getSupportedActions()) != 0) {
            this._selection = new IlvGraphicVector(mgr.getSelectedObjectsCount(true));
            IlvGraphicEnumeration e = mgr.getSelectedObjects(true);
            while (e.hasMoreElements()) {
                this._selection.addElement(e.nextElement());
            }
            try {
                this.startDrag(ev, null, this.createTransferable(mgr, this._selection, this.getNativeFlavor()), this);
            }
            catch (UnsupportedOperationException uoe) {
                System.out.println(uoe.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    private Set<IlvGraphic> buildSelectionSet(IlvGraphicVector selection) {
        HashSet<IlvGraphic> set = new HashSet<IlvGraphic>();
        IlvGraphicEnumeration e = selection.elements();
        while (e.hasMoreElements()) {
            set.add(e.nextElement());
        }
        return set;
    }

    private void resetConnectedLinks(IlvGraphic g, Set<IlvGraphic> selection, Set<IlvLinkImage> resetLinks) {
        IlvGraphicBag bag = g.getGraphicBag();
        if (bag != null && bag instanceof IlvGrapher) {
            IlvGrapher grapher = (IlvGrapher)bag;
            IlvGraphicEnumeration e = grapher.getLinks(g);
            while (e.hasMoreElements()) {
                IlvLinkImage link = (IlvLinkImage)e.nextElement();
                if (selection.contains(link) || resetLinks.contains(link)) continue;
                resetLinks.add(link);
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess() && !this._dropPerformed) {
            IlvManagerView view = (IlvManagerView)dsde.getDragSourceContext().getComponent();
            IlvManager mgr = view.getManager();
            try {
                ManagerUtil.performAction(mgr, new ManagerAction(){

                    @Override
                    public Object performAction(IlvManager mgr) {
                        Translator translator = new Translator();
                        HashSet<IlvLinkImage> snappedBackLinks = new HashSet<IlvLinkImage>();
                        Set selectionSet = DiagramManagerViewDragAndDropController.this.buildSelectionSet(DiagramManagerViewDragAndDropController.this._selection);
                        IlvGraphicEnumeration e = DiagramManagerViewDragAndDropController.this._selection.elements();
                        while (e.hasMoreElements()) {
                            IlvGraphic g = e.nextElement();
                            if (g instanceof IlvLinkImage) {
                                snappedBackLinks.add((IlvLinkImage)g);
                            } else {
                                DiagramManagerViewDragAndDropController.this.resetInitialRect(translator, g);
                                DiagramManagerViewDragAndDropController.this.resetConnectedLinks(g, selectionSet, snappedBackLinks);
                            }
                            for (IlvGraphicBag bag = g.getGraphicBag(); bag != null; bag = bag.getGraphicBag()) {
                                if (!(bag instanceof IlvGraphic)) continue;
                                DiagramManagerViewDragAndDropController.this.resetInitialRect(translator, (IlvGraphic)bag);
                            }
                        }
                        for (IlvLinkImage link : snappedBackLinks) {
                            DiagramManagerViewDragAndDropController.this.resetInitialLinkPoints(link);
                        }
                        return null;
                    }
                }, 13);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this._selection = null;
    }

    protected Transferable createTransferable(IlvManager manager, IlvGraphicVector selection, DataFlavor flavor) throws Exception {
        return new SelectionTransferable(manager, flavor, null);
    }

    protected void resetInitialLinkPoints(IlvLinkImage link) {
        IlvPoint[] points = (IlvPoint[])link.getProperty("__InitialLinkPoints");
        if (points != null) {
            link.setIntermediateLinkPoints(points, 1, points.length - 2);
            link.removeProperty("__InitialLinkPoints");
        }
    }

    protected void resetInitialRect(Translator translator, IlvGraphic g) {
        IlvRect initialRect = (IlvRect)g.getProperty("__InitialRect");
        IlvManager mgr = ManagerUtil.getManager(g);
        if (initialRect != null && mgr != null) {
            IlvRect currentRect = g.boundingBox();
            translator.init((float)(initialRect.getX() - currentRect.getX()), (float)(initialRect.getY() - currentRect.getY()), null);
            translator.translateObj(mgr, g, true);
            if (initialRect.getWidth() != currentRect.getWidth() || initialRect.getHeight() != currentRect.getHeight()) {
                mgr.reshapeObject(g, initialRect, true);
            }
        }
    }
}

