/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLLOBColumnAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLPartitionsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSchemaObjAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSegmentAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTableColumnsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTableConstraintsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTableIOTAccessor;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTableAccessor
extends XMLSchemaObjAccessor {
    private static final int TABLE_CONST_ORG_STANDARD = 0;
    private static final int TABLE_CONST_ORG_IOT = 1;
    private static final int TABLE_CONST_ORG_CLUSTERED = 2;
    private static final int TABLE_CONST_ORG_EXTERNAL = 3;
    private static final int TABLE_CONST_ORG_COLUMNAR = 4;
    private static final int TABLE_CONST_TEMP_NOT_TEMPORARY = 0;
    private static final int TABLE_CONST_TEMP_SESSION = 1;
    private static final int TABLE_CONST_TEMP_TRANSACTION = 2;
    private static final byte TABLE_CONST_ROW_MOVEMENT_DEFAULT = 0;
    private static final byte TABLE_CONST_ROW_MOVEMENT_ENABLED = 1;
    private static final byte TABLE_CONST_ROW_MOVEMENT_DISABLED = 2;
    private static final String TABLE_CONST_S_UNINITIALIZED = "-1";
    protected static String TABLE = "TABLE";
    private Vector m_columns = null;
    private Vector m_constraints = null;
    private XMLSegmentAccessor m_segment = null;
    private XMLPartitionsAccessor m_partitions = null;
    private XMLTableIOTAccessor m_IOTOverflowSegment = null;
    public static final short TR_NO_CONSTRAINTS = 0;
    public static final short TR_NOT_DROP_CONSTRAINTS = 1;
    public static final short TR_ONLY_DROP_CONSTRAINTS = 2;
    public static final short TR_ENTIRE_STATEMENT = 3;
    public static final short TR_ONLY_ADD_CONSTRAINTS = 4;
    private static String X_TABLE_SCHEMA_PATH = "/sxml:" + TABLE + "/sxml:" + "SCHEMA";
    private static String X_TABLE_NAME_PATH = "/sxml:" + TABLE + "/sxml:" + "NAME";
    private static String RELATIONAL_TABLE = "RELATIONAL_TABLE";
    private static String X_RELATIONAL_TABLE = "/sxml:" + TABLE + "/sxml:" + RELATIONAL_TABLE;
    private static String OBJECT_TABLE = "OBJECT_TABLE";
    private static String X_OBJECT_TABLE = "/sxml:" + TABLE + "/sxml:" + OBJECT_TABLE;
    private static String XMLTYPE_TABLE = "XMLTYPE_TABLE";
    private static String X_XMLTYPE_TABLE = "/sxml:" + TABLE + "/sxml:" + XMLTYPE_TABLE;
    private static final String X_GLOBAL_TEMP_TABLE = "/sxml:" + TABLE + "/sxml:" + "GLOBAL_TEMPORARY";
    private static final String X_PHYSICAL_PROPERTIES = "sxml:PHYSICAL_PROPERTIES";
    private static final String X_HEAP_TABLE = "sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE";
    private static final String X_INDEX_ORGANIZED_TABLE = "sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE";
    private static final String X_INDEX_ORGANIZED_OVERFLOW = "sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:OVERFLOW";
    private static final String X_EXTERNAL_TABLE = "sxml:PHYSICAL_PROPERTIES/sxml:EXTERNAL_TABLE";
    private static final String X_CLUSTER_TABLE = "sxml:PHYSICAL_PROPERTIES/sxml:CLUSTER_TABLE";
    private static final String X_TABLE_PROPERTIES = "sxml:TABLE_PROPERTIES";
    private static final String X_RANGE_PART = "sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING";
    private static final String X_LIST_PART = "sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING";
    private static final String X_HASH_PART = "sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING";
    private static final String X_ROW_MOVEMENT = "sxml:TABLE_PROPERTIES/sxml:ROW_MOVEMENT";
    private static final String X_CACHE = "sxml:TABLE_PROPERTIES/sxml:CACHE";
    private static final String X_MONITORING = "sxml:TABLE_PROPERTIES/sxml:MONITORING";
    private static final String X_PARALLEL = "sxml:TABLE_PROPERTIES/sxml:PARALLEL";
    private static final String X_PARALLEL_DEGREE = "sxml:TABLE_PROPERTIES/sxml:PARALLEL_DEGREE";
    private static final String X_ON_COMMIT = "sxml:ON_COMMIT";
    private static final String X_LOB_PROP_STORAGE_TABLE = "sxml:TABLE_PROPERTIES/sxml:COLUMN_PROPERTIES/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:LOB_PROPERTIES/sxml:STORAGE_TABLE";
    private static final String X_STATS = "/sxml:" + TABLE + "/sxml:" + "STATISTICS" + "/sxml:";
    private static final String X_STATS_LASTANALYZED = X_STATS + "ANALYZETIME";
    private static final String X_STATS_AVGSPC = X_STATS + "AVGSPC";
    private static final String X_STATS_AVGSPCFLBLK = X_STATS + "AVGSPC_FLB";
    private static final String X_STATS_AVGROWLN = X_STATS + "AVGRLN";
    private static final String X_STATS_CHNCNT = X_STATS + "CHNCNT";
    private static final String X_STATS_EMPCNT = X_STATS + "EMPCNT";
    private static final String X_STATS_ROWCNT = X_STATS + "ROWCNT";
    private static final String X_STATS_FLBLK = X_STATS + "FLBCNT";
    private static final String X_STATS_SAMPLESIZE = X_STATS + "SAMPLESIZE";
    private static final String X_SCHEMA_URL = "sxml:XMLSCHEMA";
    private static final String X_SCHEMA_ELEMENT = "sxml:OF_TYPE/sxml:ELEMENT";
    private static final String X_SCHEMA_OWNER = "sxml:OF_TYPE/sxml:SCHEMA";
    private static final String X_SCHEMA_NAME = "sxml:OF_TYPE/sxml:NAME";

    protected XMLTableAccessor() {
    }

    protected XMLTableAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    protected String getTypePathElement() {
        return TABLE;
    }

    @Override
    public void setXmlDoc(XMLNode xmlDoc) throws XMLAccessorException {
        XMLNode n = XMLTableAccessor.getNode(this.getXmlRoot(), X_RELATIONAL_TABLE);
        if (n == null) {
            n = XMLTableAccessor.getNode(this.getXmlRoot(), X_OBJECT_TABLE);
        }
        if (n == null) {
            n = XMLTableAccessor.getNode(this.getXmlRoot(), X_XMLTYPE_TABLE);
        }
        if (n != null) {
            this.setXmlNode(n);
        } else {
            System.out.println("Unable to find TABLE subnode!");
        }
    }

    @Override
    public void initializeAll() throws XMLAccessorException {
        this.initializeColumns();
        this.initializeConstraints();
        this.markPrimaryKeyColumns();
        this.markUniqueKeyColumns();
        this.initializeSegments();
        this.initializePartitions();
    }

    @Override
    public XMLSegmentAccessor getSegment() {
        return this.m_segment;
    }

    public Vector getColumns() {
        return this.m_columns;
    }

    public Vector getColumns(boolean getFresh) {
        return this.getColumns();
    }

    public XMLTableColumnsAccessor getColumnByName(String colName) {
        int delimPos;
        XMLTableColumnsAccessor theTca = null;
        if (colName != null && colName.startsWith("\"") && colName.endsWith("\"") && (delimPos = colName.indexOf("\".\"")) > 0) {
            colName = colName.substring(1, delimPos);
        }
        if (this.m_columns != null) {
            for (int i = 0; i < this.m_columns.size(); ++i) {
                XMLTableColumnsAccessor ca = (XMLTableColumnsAccessor)this.m_columns.elementAt(i);
                if (!ca.getColumnName().equals(colName)) continue;
                theTca = ca;
                break;
            }
        }
        return theTca;
    }

    public Vector getConstraints() {
        return this.m_constraints;
    }

    public void removeConstraint(int index) {
        if (this.m_constraints != null) {
            XMLTableConstraintsAccessor tca = (XMLTableConstraintsAccessor)this.m_constraints.elementAt(index);
            tca.markAsRemoved();
        }
    }

    private void initializeColumns() throws XMLAccessorException {
        this.m_columns = new Vector();
        NodeList cols = this.selectNodes(X_COLUMN_LIST);
        int len = 0;
        if (cols != null && (len = cols.getLength()) > 0) {
            for (int i = 0; i < len; ++i) {
                XMLNode colNode = (XMLNode)cols.item(i);
                XMLAccessor accessor = XMLTableAccessor.getXMLAccessorForType(100, colNode, this.getAccessorClient());
                this.m_columns.add(accessor);
            }
        } else {
            System.out.println("No column list found.");
        }
    }

    private void initializeConstraints() throws XMLAccessorException {
        this.m_constraints = new Vector();
        this.initializeConstraintsUsing(XMLTableConstraintsAccessor.X_CON_CK_LIST);
        this.initializeConstraintsUsing(XMLTableConstraintsAccessor.X_CON_PK_LIST);
        this.initializeConstraintsUsing(XMLTableConstraintsAccessor.X_CON_UK_LIST);
        this.initializeConstraintsUsing(XMLTableConstraintsAccessor.X_CON_FK_LIST);
        this.initializeConstraintsUsing(XMLTableConstraintsAccessor.X_CON_COL_NN_LIST);
    }

    private void initializeConstraintsUsing(String path) throws XMLAccessorException {
        NodeList consList = XMLTableAccessor.selectNodes(this.getXmlRoot(), path);
        int len = 0;
        if (consList != null && (len = consList.getLength()) > 0) {
            for (int i = 0; i < len; ++i) {
                XMLNode consNode = (XMLNode)consList.item(i);
                XMLAccessor consAcc = XMLTableAccessor.getXMLAccessorForType(102, consNode, this.getAccessorClient());
                this.m_constraints.add(consAcc);
            }
        }
    }

    private void markPrimaryKeyColumns() {
        if (this.m_constraints != null && this.m_constraints.size() > 0) {
            for (int i = 0; i < this.m_constraints.size(); ++i) {
                XMLTableConstraintsAccessor consAcc = (XMLTableConstraintsAccessor)this.m_constraints.elementAt(i);
                if (!consAcc.getConstraintType().equals("PRIMARY")) continue;
                NodeList cols = consAcc.getConstraintColumns();
                if (cols == null) break;
                for (int j = 0; j < cols.getLength(); ++j) {
                    String colName = XMLTableAccessor.getColumnName(cols.item(j));
                    XMLTableColumnsAccessor colAcc = this.getColumnByName(colName);
                    if (colAcc == null) continue;
                    colAcc.setIsPrimaryKeyColumn(true);
                }
                break;
            }
        }
    }

    private void markUniqueKeyColumns() {
        if (this.m_constraints != null && this.m_constraints.size() > 0) {
            for (int i = 0; i < this.m_constraints.size(); ++i) {
                NodeList cols;
                XMLTableConstraintsAccessor consAcc = (XMLTableConstraintsAccessor)this.m_constraints.elementAt(i);
                if (!consAcc.getConstraintType().equals("UNIQUE") || (cols = consAcc.getConstraintColumns()) == null) continue;
                for (int j = 0; j < cols.getLength(); ++j) {
                    String colName = XMLTableAccessor.getColumnName(cols.item(j));
                    XMLTableColumnsAccessor colAcc = this.getColumnByName(colName);
                    if (colAcc == null) continue;
                    colAcc.setIsUniqueKeyColumn(true);
                }
            }
        }
    }

    private void initializeSegments() throws XMLAccessorException {
        XMLAccessor accessor = XMLTableAccessor.getXMLAccessorForType(101, this.getXmlRoot(), this.getAccessorClient());
        this.m_segment = (XMLSegmentAccessor)accessor;
        if (this.hasOverflowSegment()) {
            accessor = XMLTableAccessor.getXMLAccessorForType(103, this.getXmlRoot(), this.getAccessorClient());
            this.m_IOTOverflowSegment = (XMLTableIOTAccessor)accessor;
        }
    }

    private void initializePartitions() throws XMLAccessorException {
        if (this.getPartitioned()) {
            this.m_partitions = (XMLPartitionsAccessor)XMLTableAccessor.getXMLAccessorForType(200, this.getXmlRoot(), this.getAccessorClient());
        }
    }

    @Override
    public void applySchemaMap(HashMap schemaMap, int changeMode) {
        XMLAccessor ca;
        int i;
        super.applySchemaMap(schemaMap, changeMode);
        String onSchema = this.getSchemaOwner();
        if (onSchema != null && schemaMap.containsKey(onSchema)) {
            this.setSchemaOwner((String)schemaMap.get(onSchema), changeMode);
        }
        if (this.m_columns != null) {
            for (i = 0; i < this.m_columns.size(); ++i) {
                ca = (XMLTableColumnsAccessor)this.m_columns.elementAt(i);
                ((XMLTableColumnsAccessor)ca).applySchemaMap(schemaMap, changeMode);
            }
        }
        if (this.m_constraints != null) {
            for (i = 0; i < this.m_constraints.size(); ++i) {
                ca = (XMLTableConstraintsAccessor)this.m_constraints.elementAt(i);
                ((XMLTableConstraintsAccessor)ca).applySchemaMap(schemaMap, changeMode);
            }
        }
    }

    @Override
    public String getSchemaPath() {
        return X_TABLE_SCHEMA_PATH;
    }

    @Override
    protected String getNamePath() {
        return X_TABLE_NAME_PATH;
    }

    public boolean getCache() {
        return this.nodeExists(X_CACHE);
    }

    public int getOrganization() {
        int org = -1;
        if (this.m_segment != null && this.m_segment.getXmlNode() != null) {
            String orgType = this.m_segment.getXmlNode().getParentNode().getNodeName();
            if (orgType.equals("HEAP_TABLE")) {
                org = 0;
            } else if (orgType.equals("INDEX_ORGANIZED_TABLE")) {
                org = 1;
            } else if (orgType.equals("CLUSTER_TABLE")) {
                org = 2;
            } else if (orgType.equals("EXTERNAL_TABLE")) {
                org = 3;
            }
        }
        return org;
    }

    public boolean hasOverflowSegment() {
        return this.getOrganization() == 1 && XMLTableAccessor.nodeExists((XMLNode)this.m_segment.getXmlNode().getParentNode(), "sxml:OVERFLOW");
    }

    public void setPctThreshold(short pctThreshold) {
        if (this.m_segment != null) {
            this.m_segment.setIOTPctThreshold(pctThreshold);
        }
    }

    public void setIncludingColumn(String incCol) {
        if (this.m_IOTOverflowSegment != null) {
            this.m_IOTOverflowSegment.setIncluding(incCol);
        }
    }

    @Override
    public boolean getPartitioned() {
        boolean isPartitioned = false;
        if (this.nodeExists(X_RANGE_PART) || this.nodeExists(X_LIST_PART) || this.nodeExists(X_HASH_PART)) {
            isPartitioned = true;
        }
        return isPartitioned;
    }

    @Override
    public XMLPartitionsAccessor getPartitions() {
        return this.m_partitions;
    }

    public XMLTableIOTAccessor getOverflowSegment() {
        return this.m_IOTOverflowSegment;
    }

    public XMLLOBColumnAccessor getLOBColumn(String colName) throws XMLAccessorException {
        String path = XMLTableAccessor.getColumnPropStorageTablePath(colName);
        XMLNode storageTableNode = this.getNode(path);
        if (storageTableNode == null) {
            this.printXmlRoot(System.out);
            return null;
        }
        return new XMLLOBColumnAccessor(storageTableNode, this.getAccessorClient());
    }

    public Vector getLOBColumns() throws XMLAccessorException {
        Vector<XMLLOBColumnAccessor> colVec = null;
        NodeList lCols = this.selectNodes(X_LOB_PROP_STORAGE_TABLE);
        if (lCols != null) {
            int numCols = lCols.getLength();
            colVec = new Vector<XMLLOBColumnAccessor>(numCols);
            for (int i = 0; i < numCols; ++i) {
                XMLNode colNode = (XMLNode)lCols.item(i);
                colVec.addElement(new XMLLOBColumnAccessor(colNode, this.getAccessorClient()));
            }
        }
        return colVec;
    }

    public static Node getPartitionsTreeNode(Node xml) {
        XMLNode n = XMLTableAccessor.getNode((XMLNode)xml, "//sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING");
        if (n == null) {
            n = XMLTableAccessor.getNode((XMLNode)xml, "//sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING");
        }
        if (n == null) {
            n = XMLTableAccessor.getNode((XMLNode)xml, "//sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING");
        }
        return n;
    }

    public boolean getMonitoring() {
        String monitoring = this.selectTextValue(X_MONITORING);
        return monitoring != null && "Y".equalsIgnoreCase(monitoring);
    }

    public int getTempType() {
        String onCommit = this.selectTextValue(X_ON_COMMIT);
        if ("PRESERVE".equals(onCommit)) {
            return 1;
        }
        if ("DELETE".equals(onCommit)) {
            return 2;
        }
        return 0;
    }

    public long getObjNum() {
        return -1L;
    }

    public byte getRowMovement() {
        boolean rowm = this.nodeExists(X_ROW_MOVEMENT);
        return rowm ? (byte)1 : 2;
    }

    public boolean getIsRowMovement() {
        return this.nodeExists(X_ROW_MOVEMENT);
    }

    public void setIsRowMovement(boolean rm) {
        if (rm) {
            this.createNode(X_ROW_MOVEMENT, "ROW_MOVEMENT");
        } else {
            this.removeNode(X_ROW_MOVEMENT);
        }
    }

    public boolean setDefinedUsing(boolean defUsing) {
        return false;
    }

    public boolean getIsClusterTable() {
        boolean isClustered = this.getOrganization() == 2;
        return isClustered;
    }

    public boolean getIsClustered() {
        return this.getIsClusterTable();
    }

    public String getLogging() {
        int logging = this.getSegment().getLogging();
        if (logging == 1) {
            return "Y";
        }
        return "N";
    }

    public void setLogging(String logging) {
        this.getSegment().setLogging(logging);
    }

    public Vector getSQLVector(short scope) throws XMLAccessorException {
        Vector<String> sqlVector = new Vector<String>();
        int flags = this.getAccessorClient().getSXMLToDDLTransformParamFlags(this.getObjType());
        switch (scope) {
            case 0: {
                flags += 32;
                flags += 64;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                flags += 0x8000000;
                break;
            }
            default: {
                throw new XMLAccessorException("Unrecognized value for scope: " + scope);
            }
        }
        String[] sqls = null;
        sqls = (flags & 0x8000000) != 0 ? this.genConstraintsAsAlters() : this.generateDDLs(flags);
        for (int i = 0; sqls != null && i < sqls.length; ++i) {
            String sql = sqls[i];
            sqlVector.add(sql);
        }
        return sqlVector;
    }

    private String[] genConstraintsAsAlters() {
        String[] consDDLs = null;
        Vector consVector = this.getConstraints();
        if (consVector != null) {
            int numCnstrs = consVector.size();
            int numNewCnstrs = 0;
            for (int i = 0; i < numCnstrs; ++i) {
                XMLTableConstraintsAccessor tca = (XMLTableConstraintsAccessor)consVector.elementAt(i);
                if (!tca.getIsNew()) continue;
                ++numNewCnstrs;
            }
            if (numNewCnstrs > 0) {
                consDDLs = new String[numNewCnstrs];
                int j = 0;
                for (int i = 0; i < numCnstrs; ++i) {
                    XMLTableConstraintsAccessor tca = (XMLTableConstraintsAccessor)consVector.elementAt(i);
                    if (!tca.getIsNew()) continue;
                    String consDef = tca.getConstraintBody();
                    consDDLs[j++] = this.getAlterHeader() + consDef;
                }
            }
        }
        return consDDLs;
    }

    private String getAlterHeader() {
        return "ALTER TABLE " + this.getQuotedFullName() + " ";
    }

    public void setIsClustered(boolean isClustered) throws XMLAccessorException {
        if (!isClustered) {
            throw new XMLAccessorException("Trying to set a clustered table unclustered!");
        }
    }

    public void setGenConstraintStorage(boolean genCS) {
    }

    public static String getSafeString(Node n, String xp) {
        if (n == null || xp == null) {
            return TABLE_CONST_S_UNINITIALIZED;
        }
        String v = XMLTableAccessor.selectTextValue((XMLNode)n, xp);
        return v == null || v.trim().equals("") ? TABLE_CONST_S_UNINITIALIZED : v;
    }

    public String getLastAnalyzed() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_LASTANALYZED);
    }

    public String getEmptyBlocks() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_EMPCNT);
    }

    public String getAvgSpace() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_AVGSPC);
    }

    public String getNumRows() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_ROWCNT);
    }

    public String getSampleSize() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_SAMPLESIZE);
    }

    public String getAvgRowLen() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_AVGROWLN);
    }

    public String getChainCnt() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_CHNCNT);
    }

    public String getAvgSpaceFreelistBlocks() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_AVGSPCFLBLK);
    }

    public String getNumFreelistBlocks() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_FLBLK);
    }

    public String getSchemaOwner() {
        return this.selectTextValue(X_SCHEMA_OWNER);
    }

    public void setSchemaOwner(String schema) {
        this.setTextValue(X_SCHEMA_OWNER, schema);
    }

    private void setSchemaOwner(String schema, int changeMode) {
        this.setTextValue(X_SCHEMA_OWNER, schema, changeMode);
    }

    public String getSchemaName() {
        return this.selectTextValue(X_SCHEMA_NAME);
    }

    public String getSchemaURL() {
        return this.selectTextValue(X_SCHEMA_URL);
    }

    public String getSchemaElement() {
        return this.selectTextValue(X_SCHEMA_ELEMENT);
    }

    @Override
    protected XMLElement findAlternateElement(XMLElement parent, String path) {
        XMLElement altElement = null;
        String parentName = parent.getNodeName();
        if (parentName.equals("PHYSICAL_PROPERTIES")) {
            System.out.println("Looking for alternate to " + path + " under " + parentName);
            if (!path.equals("sxml:HEAP_TABLE")) {
                altElement = (XMLElement)XMLTableAccessor.getNode((XMLNode)parent, "sxml:HEAP_TABLE");
            }
            if (altElement == null && !path.equals("sxml:INDEX_ORGANIZED_TABLE")) {
                altElement = (XMLElement)XMLTableAccessor.getNode((XMLNode)parent, "sxml:INDEX_ORGANIZED_TABLE");
            }
            if (altElement == null && !path.equals("sxml:CLUSTER_TABLE")) {
                altElement = (XMLElement)XMLTableAccessor.getNode((XMLNode)parent, "sxml:CLUSTER_TABLE");
            }
            if (altElement == null && !path.equals("sxml:EXTERNAL_TABLE")) {
                altElement = (XMLElement)XMLTableAccessor.getNode((XMLNode)parent, "sxml:EXTERNAL_TABLE");
            }
        }
        if (altElement != null) {
            System.out.println(" Found alternate element " + altElement.getNodeName());
        } else {
            System.out.println(" Failed to find alternate element.");
        }
        return altElement;
    }

    @Override
    protected String getParallelPath() {
        return X_PARALLEL;
    }

    @Override
    protected String getParallelDegreePath() {
        return X_PARALLEL_DEGREE;
    }

    @Override
    protected String getParallelDegreeDegreePath() {
        return "sxml:TABLE_PROPERTIES/sxml:PARALLEL_DEGREE/sxml:DEGREE";
    }

    @Override
    protected boolean isCommentableType() {
        return true;
    }

    @Override
    protected boolean canHaveStats() {
        return true;
    }

    private static String getColumnPropStorageTablePath(String colName) {
        return "sxml:TABLE_PROPERTIES/sxml:COLUMN_PROPERTIES/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=\"" + colName + "\"]" + "/sxml:" + "LOB_PROPERTIES" + "/sxml:" + "STORAGE_TABLE";
    }

    @Override
    public String toString() {
        String organization = "Unknown";
        int org = this.getOrganization();
        switch (org) {
            case 0: {
                organization = "Heap";
                break;
            }
            case 1: {
                organization = "Index Organized";
                break;
            }
            case 2: {
                organization = "Clustered";
                break;
            }
            case 3: {
                organization = "External";
            }
        }
        String columns = "None\n";
        if (this.m_columns != null && this.m_columns.size() > 0) {
            columns = "\n";
            for (int i = 0; i < this.m_columns.size(); ++i) {
                XMLTableColumnsAccessor ca = (XMLTableColumnsAccessor)this.m_columns.elementAt(i);
                columns = columns + ca.toString();
            }
        }
        String constraints = "None\n";
        if (this.m_constraints != null && this.m_constraints.size() > 0) {
            constraints = "\n";
            for (int i = 0; i < this.m_constraints.size(); ++i) {
                XMLTableConstraintsAccessor ca = (XMLTableConstraintsAccessor)this.m_constraints.elementAt(i);
                constraints = constraints + ca.toString();
            }
        }
        String segatts = "";
        if (this.m_segment != null) {
            segatts = this.m_segment.toString();
        }
        String overflowAtts = "";
        if (this.m_IOTOverflowSegment != null) {
            overflowAtts = this.m_IOTOverflowSegment.toString();
        }
        String partitions = "";
        if (this.m_partitions != null) {
            partitions = "  Partitioning: " + this.m_partitions.toString();
        }
        return super.toString() + "  Parallel: " + XMLTableAccessor.YorN(this.getParallel()) + "\n" + "   Degree default: " + XMLTableAccessor.YorN(this.getDegreeDefault()) + "\n" + "   Degree: " + this.getDegree() + "\n" + "  Cache: " + XMLTableAccessor.YorN(this.getCache()) + "\n" + "  Organization: " + organization + "\n" + "  Partitioned: " + XMLTableAccessor.YorN(this.getPartitioned()) + "\n" + "  Monitoring: " + XMLTableAccessor.YorN(this.getMonitoring()) + "\n" + "  Columns: " + columns + "  Constraints: " + constraints + segatts + overflowAtts + partitions;
    }
}

