/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.token;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.util.ModelUtil;

public class Token<T extends Token> {
    private Type m_type;
    private int m_start;
    private int m_end;
    private Token m_startToken;
    private Token m_nextToken;
    private Token m_prevToken;
    private String m_source;
    private List<Token> m_index;
    private static final int INDEX_WIDTH = 1000;

    protected Token(Type type, int n, Token token) {
        if (token != null) {
            int n2;
            this.m_startToken = token.m_startToken;
            if (type != Type.END_MARKER && (n2 = n / 1000) >= this.m_startToken.m_index.size()) {
                this.m_startToken.m_index.add(this);
            }
        } else {
            this.m_startToken = this;
            this.m_index = new ArrayList<Token>();
        }
        this.m_type = type;
        this.m_start = n;
        this.m_end = -1;
        if (token == null) {
            this.m_prevToken = null;
            this.m_nextToken = null;
        } else {
            this.m_nextToken = token.getNextToken();
            this.m_prevToken = token;
            if (this.m_nextToken != null) {
                this.m_nextToken.setPrevToken(this);
            }
            this.m_prevToken.setNextToken(this);
        }
    }

    protected void setHeaderSourceImpl(String string) {
        if (this.m_prevToken != null) {
            throw new IllegalStateException("Can only set source on start token");
        }
        this.m_source = string;
    }

    public Type getType() {
        return this.m_type;
    }

    protected final void setType(Type type) {
        this.m_type = type;
    }

    public int getStart() {
        return this.m_start;
    }

    public int getEnd() {
        return this.m_end;
    }

    public void setEnd(int n) {
        this.m_end = n;
    }

    public T getNextToken() {
        return (T)this.m_nextToken;
    }

    public void setNextToken(Token token) {
        this.m_nextToken = token;
    }

    public T getPrevToken() {
        return (T)this.m_prevToken;
    }

    public void setPrevToken(Token token) {
        this.m_prevToken = token;
    }

    public boolean isCode() {
        return this.isCode(false);
    }

    public boolean isWord() {
        return this.isCode(true);
    }

    public boolean isPunctuation() {
        return this.m_type == Type.PUNCTUATION;
    }

    public boolean isWhiteSpace() {
        return this.m_type == Type.WHITESPACE;
    }

    public boolean isComment() {
        return this.m_type == Type.SINGLE_LINE_COMMENT || this.m_type == Type.MULTI_LINE_COMMENT;
    }

    public boolean isEndMarker() {
        return this.m_type == Type.END_MARKER;
    }

    public boolean isCode(boolean bl) {
        if (bl) {
            if (this.m_type == Type.SINGLE_QUOTED_STRING || this.m_type == Type.PUNCTUATION || this.m_type == Type.USER_TOKEN) {
                return false;
            }
            if (this.m_type == Type.DOUBLE_QUOTED_STRING) {
                return true;
            }
            if (this.m_type == Type.ALPHANUMERIC) {
                return !this.isNumber();
            }
            return false;
        }
        return this.m_type == Type.SINGLE_QUOTED_STRING || this.m_type == Type.DOUBLE_QUOTED_STRING || this.m_type == Type.ALPHANUMERIC || this.m_type == Type.PUNCTUATION || this.m_type == Type.USER_TOKEN;
    }

    public boolean isNumber() {
        char c = this.getFullSource().charAt(this.m_start);
        return c >= '0' && c <= '9';
    }

    public T getPrevCodeToken() {
        T t;
        for (t = this.getPrevToken(); t != null && ((Token)t).getType() != Type.END_MARKER && !((Token)t).isCode(); t = ((Token)t).getPrevToken()) {
        }
        return t;
    }

    public T getNextCodeToken() {
        return this.getNextCodeToken(1);
    }

    public T getNextCodeToken(int n) {
        T t;
        int n2 = 0;
        for (t = this.getNextToken(); t != null && ((Token)t).getType() != Type.END_MARKER; t = ((Token)t).getNextToken()) {
            if (((Token)t).isCode()) {
                ++n2;
            }
            if (n2 >= n) break;
        }
        return t;
    }

    public String getSource() {
        return this.getSource(false, null);
    }

    public String getSource(boolean bl) {
        return this.getSource(bl, null);
    }

    public String getSource(boolean bl, Token token) {
        String string;
        if (bl) {
            if (token == null || token == this) {
                return this.formattedSource();
            }
            StringBuffer stringBuffer = new StringBuffer(this.formattedSource());
            T t = this.getNextCodeToken();
            while (((Token)t).getType() != Type.END_MARKER) {
                if (((Token)t).getType() != Type.PUNCTUATION && (((Token)((Token)t).getPrevCodeToken()).getType() != Type.PUNCTUATION || ((Token)((Token)t).getPrevCodeToken()).matches(")"))) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(super.formattedSource());
                if (t == token) break;
                t = ((Token)t).getNextCodeToken();
            }
            return stringBuffer.toString();
        }
        int n = this.getStart();
        int n2 = token == null ? this.getEnd() : token.getEnd();
        if (n2 > (string = this.getFullSource()).length() - 1) {
            n2 = string.length() - 1;
        }
        if (n2 < n || n < 0) {
            return "";
        }
        return string.substring(n, n2 + 1);
    }

    protected String getFullSource() {
        return this.m_startToken.m_source;
    }

    private String formattedSource() {
        if (this.getType() == Type.END_MARKER) {
            return "";
        }
        if (this.getType() == Type.ALPHANUMERIC) {
            return this.getSource().toUpperCase();
        }
        return this.getSource();
    }

    public boolean matches(String string) {
        String string2 = this.getSource();
        return string2.equals(string) || ModelUtil.hasLength((String)string2) && string2.charAt(0) != '\"' && string2.equalsIgnoreCase(string);
    }

    @Deprecated
    public boolean firstCodeTokenOnLine() {
        T t = this.getPrevToken();
        while (((Token)t).getType() != Type.END_MARKER) {
            if (((Token)t).getType() == Type.WHITESPACE && ((Token)t).getSource().contains("\n")) {
                return true;
            }
            if (((Token)t).isCode()) {
                return false;
            }
            t = ((Token)t).getPrevToken();
        }
        return true;
    }

    public T getTokenAt(int n) {
        Token token = null;
        if (this.m_startToken != null) {
            int n2 = n / 1000;
            Token<T> token2 = this.m_startToken;
            if (token2 != null && token2.m_index != null && token2.m_index.size() > n2) {
                token2 = token2.m_index.get(n2);
                token2 = token2.getPrevToken();
            }
            while (token2.getEnd() < n && (token2 = token2.getNextToken()).getType() != Type.END_MARKER) {
            }
            token = token2;
        }
        if (token != null && token.isEndMarker()) {
            token = null;
        }
        return (T)token;
    }

    public static enum Type {
        WHITESPACE,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        SINGLE_QUOTED_STRING,
        DOUBLE_QUOTED_STRING,
        ALPHANUMERIC,
        USER_TOKEN,
        PUNCTUATION,
        END_MARKER,
        UNKNOWN;

    }
}

