/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.em_cm;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.em_cm.CmAddinArb;
import oracle.dbtools.em_cm.CmBadType;
import oracle.dbtools.em_cm.CmUtil;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.util.Util;
import oracle.ide.Ide;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItem;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;

public class CmDropListener
implements DropTargetListener {
    private JRadioButton addAction;
    private JRadioButton monitorAction;
    private JRadioButton dropAction;
    private ButtonGroup radioGroup;
    private JCheckBox applyAll;
    private JTextField desc;
    JEWTDialog _dialog;
    private boolean doAll = false;
    private String action = new String();

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void getStateDialog(DBObjectNode dBObjectNode, Boolean bl) {
        String string = CmAddinArb.getString("NEWITEMDIALOGTITLE");
        JPanel jPanel = new JPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_cmNewItem_html");
        jPanel.setLayout(new GridBagLayout());
        this.addAction = new JRadioButton(CmAddinArb.getString("ADD_BUTTON"), true);
        this.monitorAction = new JRadioButton(CmAddinArb.getString("MONITOR_BUTTON"), false);
        this.dropAction = new JRadioButton(CmAddinArb.getString("DROP_BUTTON"), false);
        this.radioGroup = new ButtonGroup();
        this.radioGroup.add(this.addAction);
        this.radioGroup.add(this.monitorAction);
        this.radioGroup.add(this.dropAction);
        this.desc = new JTextField();
        JLabel jLabel = new JLabel(CmAddinArb.getString("INFO_LABEL"));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel(CmAddinArb.getString("NAME_LABEL") + dBObjectNode.getObjectName());
        JLabel jLabel3 = new JLabel(CmAddinArb.getString("TYPE_LABEL") + dBObjectNode.getObjectType());
        JLabel jLabel4 = new JLabel(CmAddinArb.getString("SCHEMA_LABEL") + dBObjectNode.getSchemaName());
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel5 = new JLabel(CmAddinArb.getString("REQUEST_ACTION_LABEL"));
        jPanel.add((Component)jLabel5, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.addAction, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.dropAction, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.monitorAction, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel6 = new JLabel(CmAddinArb.getString("DESCR_LABEL"));
        jPanel.add((Component)jLabel6, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.desc, new GridBagConstraints(1, 8, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.applyAll = new JCheckBox("Apply to all?");
        if (bl.booleanValue()) {
            jPanel.add((Component)this.applyAll, new GridBagConstraints(1, 9, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    if (CmDropListener.this.addAction.isSelected()) {
                        CmDropListener.this.action = "ADD";
                    } else if (CmDropListener.this.monitorAction.isSelected()) {
                        CmDropListener.this.action = "MONITOR";
                    } else if (CmDropListener.this.dropAction.isSelected()) {
                        CmDropListener.this.action = "DROP";
                    } else {
                        CmDropListener.this.action = "UNKNOWN";
                    }
                } else {
                    CmDropListener.this.action = "CANCEL";
                }
                CmDropListener.this.doAll = CmDropListener.this.applyAll.isSelected();
                CmDropListener.this._dialog.setVisible(false);
                CmDropListener.this._dialog.dispose();
            }
        };
        this._dialog.addActionListener(actionListener);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 250;
        this._dialog.setSize(n2, n);
        this._dialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dialog);
        this._dialog.setVisible(true);
        if (this._dialog.isCancelled()) {
            this.doAll = this.applyAll.isSelected();
            this.action = "CANCEL";
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.doAll = false;
        StringBuilder stringBuilder = new StringBuilder();
        ChangeItem changeItem = null;
        try {
            DataFlavor[] dataFlavorArray;
            boolean bl = true;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
                Object object = transferable.getTransferData(dataFlavor);
                if (!(object instanceof TransferableContext)) continue;
                TransferableContext transferableContext = (TransferableContext)transferable.getTransferData(dataFlavor);
                Element[] elementArray = transferableContext.getContext().getSelection();
                Boolean bl2 = false;
                bl2 = elementArray.length > 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                for (Element element : elementArray) {
                    if (element instanceof ObjectNode || element instanceof PlSqlNode) {
                        DatabaseNode databaseNode = (DatabaseNode)element;
                        String string = element instanceof ObjectNode ? ((ObjectNode)element).getConnectionName() : (element instanceof PlSqlNode ? ((PlSqlNode)element).getConnectionName() : "");
                        int n = CmUtil.getTableModel().rowExists(databaseNode.getObjectName(), databaseNode.getObjectType(), databaseNode.getSchemaName());
                        if (n == -1) {
                            if (!this.doAll) {
                                this.getStateDialog((DBObjectNode)databaseNode, bl2);
                            }
                            try {
                                boolean bl3 = false;
                                if (this.action.equals("ADD")) {
                                    changeItem = CmUtil.GetChangeitem(string, databaseNode.getObjectName(), databaseNode.getObjectType(), databaseNode.getSchemaName(), 1, this.desc.getText());
                                } else if (this.action.equals("MONITOR")) {
                                    changeItem = CmUtil.GetChangeitem(string, databaseNode.getObjectName(), databaseNode.getObjectType(), databaseNode.getSchemaName(), 4, this.desc.getText());
                                } else if (this.action.equals("DROP")) {
                                    changeItem = CmUtil.GetChangeitem(string, databaseNode.getObjectName(), databaseNode.getObjectType(), databaseNode.getSchemaName(), 3, this.desc.getText());
                                } else if (this.action.equals("CANCEL")) {
                                    bl3 = true;
                                }
                                if (bl3) continue;
                                CmUtil.addChangeItem(changeItem, CmUtil.getPlan());
                                continue;
                            }
                            catch (CmBadType cmBadType) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)(CmAddinArb.getString("DROP_ACTION_BAD_TYPE") + cmBadType.getLocalizedMessage()), (String)CmAddinArb.getString("DROP_FAILED"), null);
                                dropTargetDropEvent.rejectDrop();
                                return;
                            }
                        }
                        ChangeItemInfo changeItemInfo = CmUtil.getTableModel().getRow(n);
                        ChangeItem changeItem2 = CmUtil.getPlan().getOneChangeItem(changeItemInfo);
                        if (changeItem2.getItemAction() == 4) {
                            CmUtil.updateItem(changeItem2, 2, string);
                            continue;
                        }
                        CmUtil.syncItem(changeItem2, string);
                        stringBuilder.append(changeItem2.getObjectName() + " - " + changeItem2.getObjectType() + " - " + changeItem2.getObjectSchema() + " - " + CmAddinArb.getString("POPUP_SYNC") + Util.getIdeNewLineChar());
                        continue;
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, CmAddinArb.getString("NO_PROCESS") + element);
                    bl = false;
                }
            }
            if (bl) {
                if (stringBuilder.length() > 0) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)stringBuilder.toString(), (String)CmAddinArb.getString("DROP_RESULTS_TITLE"), null);
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (ChangePlanAccessException changePlanAccessException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)changePlanAccessException.getLocalizedMessage(), (String)CmAddinArb.getString("DROP_FAILED"), null);
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, CmAddinArb.getString("DROP_FAILED") + exception.getStackTrace()[0].toString(), exception);
            dropTargetDropEvent.rejectDrop();
        }
    }
}

