/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.tooltip;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.tooltip.ToolTipContext;
import oracle.ide.insight.tooltip.ToolTipPopup;
import oracle.ide.insight.tooltip.ToolTipProvider;
import oracle.ide.insight.tooltip.ToolTipSupport;
import oracle.ide.insight.tooltip.ToolTipWorker;
import oracle.javatools.buffer.ExpiredTextBufferException;

final class ToolTipInsight<T>
implements InsightController<ToolTipContext> {
    private static ToolTipInsight INSTANCE = new ToolTipInsight();
    private boolean working = false;
    private final WorkerListener workerListener = new WorkerListener();
    private final List<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private final ToolTipPopup insightPopup = new ToolTipPopup();
    private ToolTipContext toolTipInsightContext;
    private Map<ToolTipProvider<T>, List<T>> results;
    static final String PROPERTY_STATE = "state";

    private ToolTipInsight() {
        this.insightPopup.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("visible")) {
                    ToolTipInsight.this.firePropertyChangeEvent(new PropertyChangeEvent(this, ToolTipInsight.PROPERTY_STATE, evt.getOldValue(), evt.getNewValue()));
                    if (evt.getNewValue() == InsightController.State.HIDDEN) {
                        ToolTipInsight.this.dispose();
                    }
                }
            }
        });
    }

    static ToolTipInsight getInstance() {
        return INSTANCE;
    }

    private void dispose() {
        this.toolTipInsightContext = null;
        this.results = null;
    }

    @Override
    public void show(ToolTipContext toolTipInsightContext) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.working) {
            return;
        }
        this.working = true;
        this.toolTipInsightContext = toolTipInsightContext;
        ToolTipWorker worker = new ToolTipWorker(toolTipInsightContext);
        worker.addPropertyChangeListener(this.workerListener);
        worker.execute();
    }

    void triggerUpdate() {
        assert (SwingUtilities.isEventDispatchThread());
        assert (this.getState() == InsightController.State.SHOWING);
        if (this.working || this.toolTipInsightContext == null) {
            return;
        }
        ToolTipSupport support = new ToolTipSupport(this.toolTipInsightContext.getContext(), this.toolTipInsightContext.getTextComponent(), ((ToolTipSupport)this.toolTipInsightContext.getSupport()).getLanguageSupport());
        this.toolTipInsightContext = new ToolTipContext(support, this.toolTipInsightContext.getProviders(), true);
        ToolTipWorker<T> worker = new ToolTipWorker<T>(this.toolTipInsightContext, this.results);
        worker.addPropertyChangeListener(this.workerListener);
        worker.execute();
        this.working = true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener l : this.propertyChangeListeners) {
            l.propertyChange(event);
        }
    }

    @Override
    public InsightController.State getState() {
        return this.insightPopup.getState();
    }

    private void gotData(ToolTipContext insightContext, Map<ToolTipProvider<T>, List<T>> results) {
        assert (SwingUtilities.isEventDispatchThread());
        this.results = results;
        try {
            if (insightContext.hasTextChanged()) {
                return;
            }
        }
        catch (ExpiredTextBufferException etbe) {
            return;
        }
        if (!this.hasAnyItem(results) || !insightContext.getTextComponent().isShowing()) {
            this.hide();
            return;
        }
        try {
            if (this.getState() == InsightController.State.HIDDEN) {
                this.insightPopup.showPopup(insightContext, results);
            } else {
                this.insightPopup.updatePopup(insightContext, results);
            }
        }
        catch (Exception ex) {
            Logger.getLogger("global").log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            this.insightPopup.closePopup();
        }
    }

    private boolean hasAnyItem(Map<ToolTipProvider<T>, List<T>> results) {
        if (results == null || results.isEmpty()) {
            return false;
        }
        for (List<T> items : results.values()) {
            if (items.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void hide() {
        if (this.getState() == InsightController.State.SHOWING) {
            this.insightPopup.closePopup();
        }
        this.dispose();
    }

    private class WorkerListener
    implements PropertyChangeListener {
        private WorkerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(ToolTipInsight.PROPERTY_STATE) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                try {
                    ToolTipWorker worker = (ToolTipWorker)evt.getSource();
                    worker.removePropertyChangeListener(this);
                    ToolTipContext context = worker.getInsightContext();
                    try {
                        Map list = (Map)worker.get();
                        ToolTipInsight.this.gotData(context, list);
                    }
                    catch (InterruptedException e) {
                        ToolTipInsight.this.gotData(context, null);
                    }
                    catch (ExecutionException e) {
                        ToolTipInsight.this.gotData(context, null);
                    }
                }
                finally {
                    ToolTipInsight.this.working = false;
                }
            }
        }
    }
}

