/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.spatial.rdf.server.BindRewriteOptimizer;
import oracle.spatial.rdf.server.BindingsRewriteOptimizer;
import oracle.spatial.rdf.server.ConstructExpandOptimizer;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.GGPReduceOptimizer;
import oracle.spatial.rdf.server.GenerateQuery;
import oracle.spatial.rdf.server.GroupByAliasRewriteOptimizer;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLEngine;
import oracle.spatial.rdf.server.SQLEntryPoints;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.TurtleExpandOptimizer;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.URIset;
import oracle.spatial.rdf.server.ValuesRewriteOptimizer;
import oracle.spatial.rdf.server.VariableSet;
import oracle.spatial.rdf.server.parser.sparql.ASTInput;
import oracle.spatial.rdf.server.parser.sparql.ASTTopLevelQueryNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;
import oracle.spatial.rdf.server.sparqlSemAnalyzer;

public class TranslateEngine {
    sparqlParse parser = new sparqlParse((Reader)null);
    Connection conn;
    int flag;
    static final String RDF_TERMS_ONLY = "RDFT_ONLY=T";
    static final String PLUS_RDF_TERMS = "PLUS_RDFT=T";
    static final String VC_TERMS_ONLY = "RDFT_ONLY=VC";
    static final String PLUS_VC_TERMS = "PLUS_RDFT=VC";
    static final String TOP_DOWN_TRANS = "TOP_DOWN_TRANS=T";
    static final String PG_MATCH = "PG_MATCH=T";
    static final String NO_SRID_MSG = "Unable to retrieve SRID value for semantic network";
    static final String NO_DIM_MSG = "Unable to retrieve Dimension value for semantic network";
    static final int FLAG_PROJECTALL = 1;
    static final int FLAG_ENFORCEVPD = 2;
    static final int FLAG_FROM_START = 4;
    static final int FLAG_CTX_SPEC_SPARQL = 8;
    static final int FLAG_CTX_PLUS_SPARQL = 16;
    static final int FLAG_NG_ALL_UNNAMED = 32;
    static final int FLAG_USE_ENT_UNNAMED = 64;
    static final int FLAG_MATCH_UNNAMED = 128;
    static final int FLAG_NONEMPTY_NAMED = 256;
    static final int FLAG_STRICT_DEFAULT = 512;
    static final int FLAG_CONS_STRICT = 1024;
    static final int FLAG_CONS_UNIQUE = 2048;
    static final int FLAG_CONS_NO_CONST_PROJ = 4096;
    static final int FLAG_PROJ_CANON = 8192;
    static final int FLAG_BAD_FILTER = 1;
    static final int FLAG_LONG_QUERY = 2;
    static final int FLAG_UNION_QUERY = 4;
    static final int FLAG_ORDER_BY_QUERY = 8;
    static final int FLAG_DISTICT_QUERY = 16;
    static final int MAX_REWRITE_LENGTH = 64536;
    public static final int MAX_VC_LEN = 4000;
    public static final int CLOB_CHUNK_SIZE = 3500;
    public static final String MDSYS_RDFVTAB = "MDSYS.RDF_VALUE$";
    public static String DEFAULT_Q_HINT = "LEADING(R) NO_MERGE(R)";
    public static String NO_SWAP_HINT = "NO_SWAP_JOIN_INPUTS(R)";
    private String m_szOptions = " ";

    public String getOptions() {
        return this.m_szOptions;
    }

    public void setOptions(String string) {
        if (string == null) {
            this.m_szOptions = " ";
        } else {
            if (string.indexOf("ENF_VPD=T") > 0) {
                this.flag |= 2;
            }
            this.m_szOptions = string;
        }
    }

    TranslateEngine(int n) throws SQLException {
        this.conn = DriverManager.getConnection("jdbc:oracle:kprb:");
        this.flag = n;
    }

    public TranslateEngine(int n, Connection connection) throws SQLException {
        this.conn = connection;
        this.flag = n;
    }

    TranslateEngine() throws SQLException {
        this.conn = DriverManager.getConnection("jdbc:oracle:kprb:");
    }

    public String parseAndUnparse(String string) throws ParseException, RDFException, SQLException {
        HashMap hashMap = SQLEntryPoints.setupNamespaceMap(null);
        Node node = this.parser.parse(string, hashMap, this.getOptions());
        GroupByAliasRewriteOptimizer groupByAliasRewriteOptimizer = new GroupByAliasRewriteOptimizer();
        BindRewriteOptimizer bindRewriteOptimizer = new BindRewriteOptimizer();
        TurtleExpandOptimizer turtleExpandOptimizer = new TurtleExpandOptimizer();
        ConstructExpandOptimizer constructExpandOptimizer = new ConstructExpandOptimizer();
        BindingsRewriteOptimizer bindingsRewriteOptimizer = new BindingsRewriteOptimizer();
        ValuesRewriteOptimizer valuesRewriteOptimizer = new ValuesRewriteOptimizer();
        GGPReduceOptimizer gGPReduceOptimizer = new GGPReduceOptimizer();
        ArrayList<SparqlQueryOptimizer> arrayList = new ArrayList<SparqlQueryOptimizer>();
        arrayList.add(groupByAliasRewriteOptimizer);
        arrayList.add(bindRewriteOptimizer);
        arrayList.add(turtleExpandOptimizer);
        arrayList.add(constructExpandOptimizer);
        arrayList.add(bindingsRewriteOptimizer);
        arrayList.add(valuesRewriteOptimizer);
        arrayList.add(gGPReduceOptimizer);
        try {
            for (SparqlQueryOptimizer sparqlQueryOptimizer : arrayList) {
                node = sparqlQueryOptimizer.optimizeQuery(node);
            }
        }
        catch (ParseException parseException) {
            throw new RDFException(parseException.getMessage());
        }
        return node.printSPARQLText();
    }

    public String[] getPatternVariables(String string, String string2) throws ParseException, SQLException, RDFException {
        return this.getPatternVariables(string, string2, true);
    }

    public String[] getPatternVariables(String string, String string2, boolean bl) throws ParseException, SQLException, RDFException {
        Node node;
        String[] stringArray = null;
        if (bl) {
            this.parser.reset();
            node = this.parser.parse(string, null, string2);
        }
        if (this.parser.hasTopLevelQueryNode()) {
            node = this.parser.getTopLevelQueryNode();
            String string3 = "";
            if (string2 != null) {
                string3 = string2.toUpperCase();
            }
            stringArray = string3.indexOf(PG_MATCH) >= 0 ? node.getselDesc().returnPGSignature() : (string3.indexOf(RDF_TERMS_ONLY) >= 0 ? node.getselDesc().returnSignature(false) : (string3.indexOf(PLUS_RDF_TERMS) >= 0 ? node.getselDesc().returnVDollarSignature(true, false) : (string3.indexOf(VC_TERMS_ONLY) >= 0 ? node.getselDesc().returnSignature(true) : (string3.indexOf(PLUS_VC_TERMS) >= 0 ? node.getselDesc().returnVDollarSignature(true, true) : node.getselDesc().returnVDollarSignature(false, false)))));
        } else {
            stringArray = this.parser.variables.returnSignature();
        }
        return stringArray;
    }

    public void getSources(String string, HashMap hashMap, Collection<String> collection, Collection<String> collection2) throws ParseException, SQLException, RDFException {
        this.parser.reset();
        ASTInput aSTInput = this.parser.parse(string, hashMap, true, this.getOptions());
        if (this.parser.hasTopLevelQueryNode()) {
            ASTTopLevelQueryNode aSTTopLevelQueryNode = this.parser.getTopLevelQueryNode();
            collection.addAll(aSTTopLevelQueryNode.getsourceDesc().getDefaultGraphs());
            collection2.addAll(aSTTopLevelQueryNode.getsourceDesc().getNamedGraphs());
        }
    }

    public String translateQueryPattern(int[] nArray, String string, String[] stringArray, String string2, long l, String string3, long[] lArray, long[] lArray2, long[] lArray3, String[] stringArray2, HashMap hashMap, String string4, String[][] stringArray3, int[] nArray2, List<Integer> list, String[] stringArray4, int[] nArray3, int n) throws SQLException, ParseException, RDFException, TypeException, FilterException {
        String string5;
        Object object;
        boolean bl;
        Object object2;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        sparqlSemAnalyzer sparqlSemAnalyzer2 = null;
        SQLGenContext sQLGenContext = new SQLGenContext();
        this.parser.reset();
        ASTInput aSTInput = this.parser.parse(string, hashMap, this.getOptions());
        sQLGenContext.queryOptions = this.getOptions();
        if ((this.flag & 1) != 0) {
            object2 = this.getPatternVariables(string, sQLGenContext.queryOptions, false);
            nArray = new int[((String[])object2).length / 2];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
        }
        if (aSTInput.id == 0) {
            SimpleNode simpleNode = (SimpleNode)aSTInput.jjtGetChild(0);
            if (simpleNode.id == 3) {
                bl4 = true;
                sQLGenContext.syntaxType = 3;
            } else if (simpleNode.id == 5) {
                bl2 = true;
                sQLGenContext.syntaxType = 5;
            } else if (simpleNode.id == 2) {
                bl3 = true;
                sQLGenContext.syntaxType = 2;
            } else {
                System.out.println("Unexpected AST firstChild id: " + simpleNode.id + "\n");
            }
        } else {
            System.out.println("Unexpected AST root id: " + aSTInput.id + "\n");
        }
        if (!(bl2 || bl4 || bl3)) {
            return "Unrecognized RDF Query format!";
        }
        object2 = MDSYS_RDFVTAB;
        String string6 = QueryUtils.extractBracketedOption(sQLGenContext.queryOptions.toUpperCase(), "USE_LOCAL_VALUES");
        if (string6 != null && !QueryUtils.isSafeTabName((String)(object2 = string6))) {
            throw new RDFException("Invalid local values table name");
        }
        this.parser.URIs.resolve(this.conn, (String)object2);
        if (sQLGenContext.queryOptions.indexOf("OPT_SAMEAS=T") != -1) {
            if (!((String)object2).equals(MDSYS_RDFVTAB)) {
                throw new RDFException("Local values table not supported for optimized owl:sameAs Handling");
            }
            this.parser.URIs.updateToCanonicalIDs(this.conn, string2);
        }
        this.parser.literals.resolve(this.conn, (String)object2);
        if ((this.flag & 2) > 0) {
            if (!bl3) {
                throw new ParseException("VPD: Unrecognized RDF Query format for VPD. Use Curly Brace Syntax");
            }
            sparqlSemAnalyzer2 = new sparqlSemAnalyzer(stringArray, true, this.conn, this.parser.URIs, this.parser.literals);
            if (aSTInput instanceof ASTInput) {
                sparqlSemAnalyzer2.applyVPDPolicy(aSTInput);
            } else {
                throw new RDFException("RDFVPD Internal Error [root node is not of ASTInput type]");
            }
        }
        sQLGenContext.srcTabName = "BASIC_TRIPLES";
        sQLGenContext.URImap = this.parser.URIs;
        sQLGenContext.varMap = this.parser.variables;
        sQLGenContext.litMap = this.parser.literals;
        sQLGenContext.models = stringArray;
        sQLGenContext.model_types = nArray3;
        sQLGenContext.isRdfVWModel = n == 1;
        if ((this.flag & 0x98) > 0) {
            if (!bl3) {
                throw new ParseException("CTX: Unrecognized RDF Query format for Semantic Search. Use Curly Brace Syntax");
            }
            if ((this.flag & 0x80) > 0) {
                sQLGenContext.contextFlags |= 4;
            }
            if ((this.flag & 8) > 0) {
                sQLGenContext.contextFlags |= 1;
            }
            if ((this.flag & 0x10) > 0) {
                sQLGenContext.contextFlags |= 2;
            }
        }
        if (this.parser.baseURISet) {
            sQLGenContext.baseURI = this.parser.baseURI.getBaseURI();
            sQLGenContext.baseURIset = 1;
        }
        boolean bl5 = bl = sQLGenContext.queryOptions.indexOf(TOP_DOWN_TRANS) >= 0;
        if (!bl && (bl2 || bl3)) {
            object = null;
            if (sQLGenContext.queryOptions.indexOf("__localBindQ=[") >= 0) {
                int n2 = sQLGenContext.queryOptions.indexOf("__localBindQ=[");
                int n3 = sQLGenContext.queryOptions.indexOf("]", n2);
                object = sQLGenContext.queryOptions.substring(n2 + 14, n3);
                System.out.println("bindSQL=[" + (String)object + "]");
            }
            SPARQLEngine.setQueryOptions(sQLGenContext, this.flag);
            SPARQLEngine.setTripleRowSources(sQLGenContext, stringArray, string2, l, string3, string4, lArray, lArray2, lArray3, stringArray2, this.flag);
            string5 = SPARQLEngine.translateSPARQL(sQLGenContext, aSTInput, this.parser.getTopLevelQueryNode(), nArray, (String)object);
        } else {
            sQLGenContext.usingTopDownTrans = true;
            sQLGenContext.filterFlags |= 4;
            GenerateQuery generateQuery = new GenerateQuery(string.endsWith(" "), sQLGenContext.queryOptions);
            object = generateQuery.resolveModels(sQLGenContext, stringArray, string2, l, string3, string4, lArray, lArray2, lArray3, stringArray2, this.flag);
            generateQuery.addWithMap("BASIC_TRIPLES", (String)object);
            if (bl2 || bl3) {
                if (bl2 && bl) {
                    throw new ParseException("Top-down translation is not allowed with full SPARQL syntax");
                }
                string5 = generateQuery.buildSQLfromSPARQL(sQLGenContext, aSTInput, this.parser.getTopLevelQueryNode(), nArray, this.flag, nArray2, list, stringArray4);
            } else {
                generateQuery.buildHint(sQLGenContext, false);
                generateQuery.buildJoin_LINK(sQLGenContext, aSTInput);
                if ((this.flag & 1) != 0) {
                    generateQuery.buildJoin_VALUE(sQLGenContext, null);
                } else {
                    generateQuery.buildJoin_VALUE(sQLGenContext, nArray);
                }
                generateQuery.buildHint(sQLGenContext, true);
                if (generateQuery.hint0present) {
                    generateQuery.adjustWhereVec(sQLGenContext);
                }
                string5 = generateQuery.buildSQLQuery(true);
            }
        }
        if (this.parser.hasTopLevelQueryNode()) {
            object = this.parser.getTopLevelQueryNode();
            String string7 = "";
            if (this.getOptions() != null) {
                string7 = this.getOptions().toUpperCase();
            }
            stringArray3[0] = string7.indexOf(PG_MATCH) >= 0 ? object.getselDesc().returnPGSignature() : (string7.indexOf(RDF_TERMS_ONLY) >= 0 ? object.getselDesc().returnSignature(false) : (string7.indexOf(PLUS_RDF_TERMS) >= 0 ? object.getselDesc().returnVDollarSignature(true, false) : (string7.indexOf(VC_TERMS_ONLY) >= 0 ? object.getselDesc().returnSignature(true) : (string7.indexOf(PLUS_VC_TERMS) >= 0 ? object.getselDesc().returnVDollarSignature(true, true) : object.getselDesc().returnVDollarSignature(false, false)))));
        } else {
            stringArray3[0] = this.parser.variables.returnSignature();
        }
        if ((this.flag & 4) == 0 && string5.length() > 64536) {
            object = "Query length [" + string5.length() + "] exceedes max query rewrite length [" + 64536 + "] ... falling back to start-fetch-close strategy\n";
            QueryUtils.log((String)object);
            string5 = "";
            nArray2[0] = nArray2[0] | 2;
        }
        return string5;
    }

    public String unparse(Vector vector, HashSet hashSet, URIset uRIset) {
        String string = "";
        for (ASTTripleAtom[] aSTTripleAtomArray : vector) {
            string = string + "(";
            block9: for (int i = 0; i < 3; ++i) {
                ASTTripleAtom aSTTripleAtom = aSTTripleAtomArray[i];
                if (i > 0) {
                    string = string + " ";
                }
                switch (aSTTripleAtom.type) {
                    case 0: {
                        string = string + "?" + aSTTripleAtom.name;
                        continue block9;
                    }
                    case 1: {
                        string = string + "<" + aSTTripleAtom.name + ">";
                        if (i != 1 || hashSet == null) continue block9;
                        hashSet.add(uRIset.get(aSTTripleAtom.name));
                        continue block9;
                    }
                    case 2: {
                        string = string + aSTTripleAtom.name;
                        continue block9;
                    }
                    case 3: {
                        string = string + "\"" + aSTTripleAtom.name + "\"";
                        continue block9;
                    }
                    case 4: {
                        string = string + "\"" + aSTTripleAtom.name + "\"@" + aSTTripleAtom.litLang;
                        continue block9;
                    }
                    case 5: 
                    case 6: {
                        string = string + "\"" + aSTTripleAtom.name + "\"^^<" + aSTTripleAtom.litType + ">";
                    }
                }
            }
            string = string + ")";
        }
        return string;
    }

    public long[] expandPattern(String[] stringArray, String[] stringArray2, HashMap hashMap, int[] nArray, int[] nArray2) throws ParseException, SQLException, RDFException {
        Set set;
        VariableSet variableSet;
        ASTInput aSTInput;
        HashSet hashSet = new HashSet();
        this.parser.reset();
        if (stringArray[0].equals("")) {
            aSTInput = null;
            variableSet = null;
            set = null;
        } else {
            aSTInput = this.parser.parse(stringArray[0], hashMap, this.getOptions());
            variableSet = this.parser.variables;
            set = variableSet.set.keySet();
        }
        ASTInput aSTInput2 = this.parser.parse(stringArray2[0], hashMap, this.getOptions());
        VariableSet variableSet2 = this.parser.variables;
        Set set2 = variableSet2.set.keySet();
        if (set != null) {
            set2.removeAll(set);
        }
        if (!set2.isEmpty()) {
            throw new RDFException("Consequent variable '" + (String)set2.iterator().next() + "' is unbound in antecedent.");
        }
        this.parser.URIs.resolve(this.conn);
        this.parser.URIs.createUnresolved(this.conn);
        this.parser.literals.resolve(this.conn);
        this.parser.literals.createUnresolved(this.conn);
        if (aSTInput != null) {
            aSTInput.collect();
            stringArray[0] = this.unparse(aSTInput.getTriples(), hashSet, this.parser.URIs);
        }
        aSTInput2.collect();
        stringArray2[0] = this.unparse(aSTInput2.getTriples(), hashSet, this.parser.URIs);
        nArray[0] = aSTInput2.getNTriples();
        nArray2[0] = aSTInput2.getNVars();
        if (hashSet.isEmpty()) {
            return null;
        }
        long[] lArray = new long[hashSet.size()];
        Iterator iterator = hashSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            long l;
            String string = (String)iterator.next();
            lArray[n] = l = Long.parseLong(string);
            ++n;
        }
        return lArray;
    }

    public ArrayList<String> processVPDPatterns(String[] stringArray, String[] stringArray2, HashMap hashMap) throws ParseException, RDFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.parser.reset();
        ASTInput aSTInput = this.parser.parse(stringArray[0], hashMap, this.getOptions());
        VariableSet variableSet = this.parser.variables;
        Set set = variableSet.set.keySet();
        ASTInput aSTInput2 = this.parser.parse(stringArray2[0], hashMap, this.getOptions());
        VariableSet variableSet2 = this.parser.variables;
        Set set2 = variableSet2.set.keySet();
        int n = set2.size();
        if (set != null) {
            set2.removeAll(set);
        }
        if (n == set2.size()) {
            throw new RDFException("invalid apply pattern with all unbound variables");
        }
        try {
            this.parser.URIs.resolve(this.conn);
            this.parser.URIs.createUnresolved(this.conn);
            this.parser.literals.resolve(this.conn);
            this.parser.literals.createUnresolved(this.conn);
        }
        catch (SQLException sQLException) {
            throw new RDFException("URI/Literal resolution error:" + sQLException.getMessage());
        }
        GGPReduceOptimizer gGPReduceOptimizer = new GGPReduceOptimizer();
        try {
            aSTInput = (ASTInput)gGPReduceOptimizer.optimizeQuery(aSTInput);
            aSTInput2 = (ASTInput)gGPReduceOptimizer.optimizeQuery(aSTInput2);
        }
        catch (Exception exception) {
            throw new RDFException(exception.getMessage());
        }
        sparqlSemAnalyzer.processVPDConstraint(set2, aSTInput, aSTInput2, this.parser.URIs, this.parser.literals, arrayList);
        stringArray[0] = sparqlSemAnalyzer.unparseSparql(aSTInput);
        stringArray2[0] = sparqlSemAnalyzer.unparseSparql(aSTInput2);
        return arrayList;
    }
}

