/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.naming.RefAddr;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.xml.bind.DatatypeConverter;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.javatools.annotations.Concealed;
import oracle.jdeveloper.db.adapter.DatabaseProviderFactory;
import oracle.jdevimpl.db.adapter.DatabaseProviderFactory1212;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

@Concealed
public abstract class ReferenceWorker {
    public static final String KEY = ReferenceWorker.class.getName();

    public RefAddr encrypt(String string, char[] cArray, String string2) {
        return new SecureRefAddr(string, cArray);
    }

    public char[] decrypt(RefAddr refAddr, String string) {
        char[] cArray = null;
        if (refAddr instanceof SecureRefAddr) {
            cArray = ((SecureRefAddr)refAddr).getCharValue();
        }
        return cArray;
    }

    public Class<? extends ObjectFactory> getFactoryClass() {
        return DatabaseProviderFactory1212.class;
    }

    public static ReferenceWorker createNullWorker() {
        return new ReferenceWorker(){

            @Override
            public RefAddr encrypt(String string, char[] cArray, String string2) {
                return null;
            }
        };
    }

    public static ReferenceWorker createDefaultWorker(String string) {
        return new PBEWorker(string);
    }

    public static ReferenceWorker createLegacyWorker() {
        return new LegacyWorker();
    }

    private static class PBEWorker
    extends ReferenceWorker {
        private final AlgorithmParameterSpec m_paramSpec;
        private final SecretKey m_key;
        private Cipher m_encoder;
        private Cipher m_decoder;

        public PBEWorker(String string) {
            PBEParameterSpec pBEParameterSpec = null;
            SecretKey secretKey = null;
            try {
                byte[] byArray = new byte[]{5, 19, -103, 66, -109, 114, -24, -83};
                PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), byArray, 42);
                secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec);
                pBEParameterSpec = new PBEParameterSpec(byArray, 42);
            }
            catch (Exception exception) {
                DatabaseProviderHelper.getLogger().log(Level.SEVERE, "setup failure", exception);
            }
            this.m_paramSpec = pBEParameterSpec;
            this.m_key = secretKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RefAddr encrypt(String string, char[] cArray, String string2) {
            Object object;
            String string3 = null;
            if (this.m_key != null) {
                try {
                    if (this.m_encoder == null) {
                        this.m_encoder = Cipher.getInstance(this.m_key.getAlgorithm());
                        this.m_encoder.init(1, (Key)this.m_key, this.m_paramSpec);
                    }
                    object = new String(cArray);
                    byte[] byArray = ((String)object).getBytes("UTF8");
                    byte[] byArray2 = this.m_encoder.doFinal(byArray);
                    Thread thread = Thread.currentThread();
                    ClassLoader classLoader = thread.getContextClassLoader();
                    try {
                        thread.setContextClassLoader(this.getClass().getClassLoader());
                        string3 = DatatypeConverter.printBase64Binary((byte[])byArray2);
                    }
                    finally {
                        thread.setContextClassLoader(classLoader);
                    }
                }
                catch (Exception exception) {
                    Logger logger = DatabaseProviderHelper.getLogger();
                    String string4 = "Password encryption failed for connection " + string2;
                    logger.severe(string4);
                    logger.log(Level.FINE, string4, exception);
                    this.m_encoder = null;
                }
            }
            object = string3 == null ? super.encrypt(string, cArray, string2) : new StringRefAddr(string, string3);
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char[] decrypt(RefAddr refAddr, String string) {
            char[] cArray = null;
            if (this.m_key != null && refAddr instanceof StringRefAddr) {
                try {
                    byte[] byArray;
                    if (this.m_decoder == null) {
                        this.m_decoder = Cipher.getInstance(this.m_key.getAlgorithm());
                        this.m_decoder.init(2, (Key)this.m_key, this.m_paramSpec);
                    }
                    Thread thread = Thread.currentThread();
                    ClassLoader classLoader = thread.getContextClassLoader();
                    try {
                        thread.setContextClassLoader(this.getClass().getClassLoader());
                        byArray = DatatypeConverter.parseBase64Binary((String)((String)refAddr.getContent()));
                    }
                    finally {
                        thread.setContextClassLoader(classLoader);
                    }
                    byte[] byArray2 = this.m_decoder.doFinal(byArray);
                    cArray = new String(byArray2, "UTF8").toCharArray();
                }
                catch (Exception exception) {
                    Logger logger = DatabaseProviderHelper.getLogger();
                    String string2 = "Password decryption failed for connection " + string;
                    logger.severe(string2);
                    logger.log(Level.FINE, string2, exception);
                    this.m_decoder = null;
                }
            }
            if (cArray == null) {
                return super.decrypt(refAddr, string);
            }
            return cArray;
        }
    }

    private static class LegacyWorker
    extends ReferenceWorker {
        private LegacyWorker() {
        }

        @Override
        public Class<? extends ObjectFactory> getFactoryClass() {
            return DatabaseProviderFactory.class;
        }

        @Override
        public char[] decrypt(RefAddr refAddr, String string) {
            String string2;
            char[] cArray = refAddr instanceof StringRefAddr ? ((string2 = DatabaseProviderHelper.comingIn((String)refAddr.getContent())) == null ? null : string2.toCharArray()) : super.decrypt(refAddr, string);
            return cArray;
        }

        @Override
        public RefAddr encrypt(String string, char[] cArray, String string2) {
            return new StringRefAddr(string, DatabaseProviderHelper.goingOut(new String(cArray)));
        }
    }
}

