/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.annotations.Concealed;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.ReferenceWorker;
import oracle.security.misc.Checksum;

@Concealed
public final class DatabaseProviderHelper {
    @Concealed
    public static final String STRINGS_TO_FILE = "INTERNAL_STRINGS_TO_FILE";
    private static final int DEFAULT = 0;
    private static final int TOFILE = 1;
    private static final int UNIT_TEST = 2;
    private static int s_mode = 0;
    private static PasswordPrompter s_pp;
    private static String s_progName;
    private static ReferenceWorker s_worker;

    private DatabaseProviderHelper() {
    }

    public static Logger getLogger() {
        return Logger.getLogger("oracle.jdeveloper.db.adapter");
    }

    public static void setProgramName(String string) {
        s_progName = string;
    }

    public static String getProgramName() {
        return s_progName;
    }

    public static void setUTMode(boolean bl) {
        if (s_mode != 1) {
            int n = s_mode = bl ? 2 : 0;
            if (bl && s_worker == null) {
                s_worker = ReferenceWorker.createDefaultWorker(UUID.randomUUID().toString());
            }
        }
    }

    public static boolean useMe() {
        return s_mode == 2;
    }

    public static ReferenceWorker getDefaultWorker() {
        return DatabaseProviderHelper.getDefaultWorker(true);
    }

    static ReferenceWorker getDefaultWorker(boolean bl) {
        return !bl || s_mode != 0 ? s_worker : null;
    }

    public static void setDefaultWorker(ReferenceWorker referenceWorker) {
        if (s_worker == null && referenceWorker != null) {
            s_worker = referenceWorker;
            s_mode = 1;
        }
    }

    public static void setPasswordPrompter(PasswordPrompter passwordPrompter) {
        s_pp = passwordPrompter;
    }

    @Deprecated
    public static void setPasswordPrompter(oracle.jdevimpl.db.adapter.PasswordPrompter passwordPrompter) {
    }

    public static PasswordPrompter getPasswordPrompter() {
        return s_pp;
    }

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        while (clazz != null) {
            linkedHashSet.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return linkedHashSet.toArray(new Class[linkedHashSet.size()]);
    }

    static String goingOut(String string) {
        try {
            byte[] byArray = string.getBytes();
            byte[] byArray2 = Checksum.MD5((byte[])byArray, null);
            return RepConversion.bArray2String(byArray2);
        }
        catch (Throwable throwable) {
            DatabaseProviderHelper.getLogger().log(Level.FINE, "Legacy encryption failed", throwable);
            return null;
        }
    }

    public static String comingIn(String string) {
        try {
            byte[] byArray = RepConversion.convertHexStringToByte(string);
            byte[] byArray2 = Checksum.SHA((byte[])byArray, null);
            return new String(byArray2);
        }
        catch (Throwable throwable) {
            DatabaseProviderHelper.getLogger().log(Level.FINE, "Legacy decryption failed", throwable);
            return null;
        }
    }

    public static abstract class PasswordPrompter {
        @Deprecated
        public Connection promptForPassword(Properties properties, String string, ConnectionCreator connectionCreator) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        public Connection promptForPassword(DatabaseProvider databaseProvider) throws SQLException {
            return this.promptForPassword(databaseProvider.getProperties(), databaseProvider.getName(), DatabaseProvider.getCreator(databaseProvider));
        }

        public void disconnect(Properties properties) {
        }

        public final void disconnect(DatabaseProvider databaseProvider) {
            this.disconnect(databaseProvider.getProperties());
        }

        public void cache(Properties properties) {
        }

        public final void cache(DatabaseProvider databaseProvider) {
            this.cache(databaseProvider.getProperties());
        }
    }

    private static class RepConversion {
        private RepConversion() {
        }

        private static byte nibbleToHex(byte by) {
            return (byte)((by = (byte)(by & 0xF)) < 10 ? by + 48 : by - 10 + 65);
        }

        private static String bArray2String(byte[] byArray) {
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append((char)RepConversion.nibbleToHex((byte)((byArray[i] & 0xF0) >> 4)));
                stringBuffer.append((char)RepConversion.nibbleToHex((byte)(byArray[i] & 0xF)));
            }
            return stringBuffer.toString();
        }

        private static int convertCharToInt(char c) {
            switch (c) {
                case '0': {
                    return 0;
                }
                case '1': {
                    return 1;
                }
                case '2': {
                    return 2;
                }
                case '3': {
                    return 3;
                }
                case '4': {
                    return 4;
                }
                case '5': {
                    return 5;
                }
                case '6': {
                    return 6;
                }
                case '7': {
                    return 7;
                }
                case '8': {
                    return 8;
                }
                case '9': {
                    return 9;
                }
                case 'A': 
                case 'a': {
                    return 10;
                }
                case 'B': 
                case 'b': {
                    return 11;
                }
                case 'C': 
                case 'c': {
                    return 12;
                }
                case 'D': 
                case 'd': {
                    return 13;
                }
                case 'E': 
                case 'e': {
                    return 14;
                }
                case 'F': 
                case 'f': {
                    return 15;
                }
            }
            return 48;
        }

        private static byte[] convertHexStringToByte(String string) {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                int n = RepConversion.convertCharToInt(string.charAt(i));
                Integer n2 = new Integer(0xF0 & n << 4);
                byArray[i / 2] = n2.byteValue();
                n = RepConversion.convertCharToInt(string.charAt(i + 1));
                n2 = new Integer(0xF & n);
                int n3 = i / 2;
                byArray[n3] = (byte)(byArray[n3] | n2.byteValue());
            }
            return byArray;
        }
    }
}

