/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class SQLiteConnectionCreator
extends AbstractConnectionCreator {
    public static final String SQLITE_DRIVER_CLASS = "org.sqlite.JDBC";
    public static final String SUBTYPE_SQLITE = "SQLite";

    @Override
    public Connection getConnection(Properties properties) throws SQLException {
        return super.getConnection(properties);
    }

    @Override
    public String getDriverClassName(Properties properties) throws SQLException {
        String string = super.getDriverClassName(properties);
        if (this.hasLength(string)) {
            return string;
        }
        return SQLITE_DRIVER_CLASS;
    }

    @Override
    public String getConnectionURL(Properties properties) throws SQLException {
        String string;
        String string2 = super.getConnectionURL(properties);
        if (this.hasLength(string2)) {
            string = string2;
        } else {
            String string3 = properties.getProperty("dataSourceName");
            if (string3 == null) {
                string3 = properties.getProperty("parameters");
            }
            if (!this.hasLength(string3)) {
                this.throwMissingPropertyException("dataSourceName");
            }
            string = "jdbc:sqlite:" + string3;
        }
        return string;
    }

    @Override
    protected void setCustomProperties(Properties properties, Properties properties2) {
        if (properties.containsKey("dataSourceName")) {
            super.setCustomProperties(properties, properties2);
        }
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> collection = super.listAllowedProperties();
        collection.remove("user");
        collection.remove("password");
        collection.add("dataSourceName");
        return collection;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        return Collections.singleton("dataSourceName");
    }
}

