/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.ssh.SSHConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHTunnelConfiguration;
import oracle.jdeveloper.db.ssh.SSHTunnelException;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public class MySQLConnectionCreator
extends AbstractConnectionCreator
implements SSHConnectionCreator {
    public static final String MYSQL_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    public static final String SUBTYPE_MYSQL = "MYSQL";

    @Override
    protected boolean allowNullPassword() {
        return true;
    }

    @Override
    public Connection getConnection(Properties properties) throws SQLException {
        return super.getConnection(properties);
    }

    @Override
    public String getDriverClassName(Properties properties) throws SQLException {
        String string = super.getDriverClassName(properties);
        if (this.hasLength(string)) {
            return string;
        }
        return MYSQL_DRIVER_CLASS;
    }

    @Override
    public String getConnectionURL(Properties properties) throws SQLException {
        String string;
        String string2 = super.getConnectionURL(properties);
        if (this.hasLength(string2)) {
            string = string2;
        } else {
            String string3 = this.getPropertyOrThrow(properties, "hostname");
            String string4 = properties.getProperty("port");
            String string5 = this.getPropertyOrThrow(properties, "dataSourceName");
            StringBuilder stringBuilder = new StringBuilder("jdbc:mysql://");
            stringBuilder.append(string3);
            if (string4 != null) {
                stringBuilder.append(':').append(string4);
            }
            stringBuilder.append('/').append(string5);
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> collection = super.listAllowedProperties();
        collection.add("hostname");
        collection.add("port");
        collection.add("dataSourceName");
        return collection;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("hostname");
        hashSet.add("dataSourceName");
        return hashSet;
    }

    @Override
    public SSHTunnelConfiguration getConfiguration(DatabaseProvider databaseProvider) throws SQLException {
        Matcher matcher;
        String string = databaseProvider.getConnectionURL();
        Object object = Pattern.compile("(?i)jdbc:mysql://([^,:\\s]+)/.*");
        Object object2 = ((Pattern)object).matcher(string);
        if (((Matcher)object2).matches()) {
            string = string.substring(0, ((Matcher)object2).end(1)) + ":3306" + string.substring(((Matcher)object2).end(1));
        }
        if ((matcher = ((Pattern)(object2 = Pattern.compile("(?i)jdbc:mysql://([^,:\\s]+):([0-9]+)/.*"))).matcher(string)).matches()) {
            object = SSHTunnelConfiguration.createFromMatcher(string, matcher, 1, 2);
        } else if (string.toLowerCase().startsWith("jdbc:mysql://address=(")) {
            object = SSHTunnelConfiguration.parseAddressSyntax(string);
        } else {
            throw new SSHTunnelException(DBAdapterBundle.get("SSH_URL_PARSE_FAILED"));
        }
        return object;
    }
}

