/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

public abstract class AbstractOracleConnCreator
extends AbstractConnectionCreator {
    protected AbstractOracleConnCreator() {
    }

    @Override
    protected void setCustomProperties(Properties properties, Properties properties2) {
        String string = properties.getProperty("role");
        if (this.hasLength(string)) {
            properties2.put("internal_logon", string);
        }
        AbstractOracleConnCreator.setSessionProps(properties2);
        super.setCustomProperties(properties, properties2);
    }

    private static void addPropertyIfSet(Properties properties, String string, String string2) {
        String string3 = System.getProperty(string, null);
        if (string3 != null) {
            AbstractOracleConnCreator.setProperty(properties, string2, string3);
        }
    }

    private static void setSessionProps(Properties properties) {
        String string;
        AbstractOracleConnCreator.addPropertyIfSet(properties, "jdbc.terminal", "v$session.terminal");
        AbstractOracleConnCreator.addPropertyIfSet(properties, "jdbc.machine", "v$session.machine");
        String string2 = System.getProperty("jdbc.program", null);
        if (string2 == null) {
            string2 = DatabaseProviderHelper.getProgramName();
        }
        if (string2 != null) {
            AbstractOracleConnCreator.setProperty(properties, "v$session.program", string2);
        }
        if ((string = System.getProperty("jdbc.process", null)) == null) {
            String string3 = System.getProperty("java.vm.name");
            if (!(System.getProperty("disablePIDCheck") != null || string3 != null && string3.equals("OJVM Client VM"))) {
                try {
                    int n;
                    String string4;
                    RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                    if (runtimeMXBean != null && (string4 = runtimeMXBean.getName()) != null && (n = string4.indexOf(64)) >= 0) {
                        string = string4.substring(0, n);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (string != null) {
            AbstractOracleConnCreator.setProperty(properties, "v$session.process", string);
        }
        AbstractOracleConnCreator.setProperty(properties, "oracle.net.CONNECT_TIMEOUT", "300000");
    }

    private static void setProperty(Properties properties, String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        }
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        AbstractOracleConnCreator.setSessionProps(properties);
        AbstractOracleConnCreator.dumpProps(properties);
        System.out.println("\nSystem Properties:");
        AbstractOracleConnCreator.dumpProps(System.getProperties());
    }

    private static void dumpProps(Properties properties) {
        for (Object object : properties.keySet()) {
            System.out.println(object + "\t => \t" + properties.get(object));
        }
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> collection = super.listAllowedProperties();
        collection.add("role");
        collection.add("hostname");
        collection.add("port");
        collection.add("sid");
        return collection;
    }
}

