/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.awt.EventQueue;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.rdfgraph.ui.RDFSourceTable;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchProgress;

public class RDFSourceTableSearchRunnable
implements Runnable {
    private final SearchProgress _progress;
    private final SearchCategory _category;
    private final String _text;
    private final int BATCH_COUNT = 10;
    private TableActionControl resultTablecontrol;
    private Connection connection;

    RDFSourceTableSearchRunnable(SearchProgress searchProgress, SearchCategory searchCategory, String string) {
        this._progress = searchProgress;
        this._category = searchCategory;
        this._text = string.toUpperCase();
    }

    public void setResultTablecontrol(TableActionControl tableActionControl) {
        this.resultTablecontrol = tableActionControl;
    }

    public TableActionControl getResultTablecontrol() {
        return this.resultTablecontrol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<RDFSourceTable> arrayList = new ArrayList<RDFSourceTable>(10);
        try {
            String[] stringArray;
            this._progress.setDeterminate(this.getNumberOfThingsToSearch());
            String string = null;
            String string2 = this._text;
            if (this._text.contains(".") && (stringArray = this._text.split(Pattern.quote("."), 2)).length > 1) {
                string = stringArray[0];
                string2 = stringArray[1];
            }
            stringArray = DBUtil.getInstance((Connection)this.connection);
            String string3 = "SELECT owner, object_name, object_type from all_objects where object_name like '%' || :tname || '%'";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (string != null) {
                string3 = string3 + " AND owner like '%' || :sname || '%'";
                hashMap.put("sname", string);
            }
            string3 = string3 + " AND object_type IN ('TABLE', 'VIEW') AND ROWNUM<= 50";
            hashMap.put("tname", string2);
            List list = stringArray.executeReturnList(string3, hashMap);
            int n = 0;
            for (Map map : list) {
                arrayList.add(new RDFSourceTable((String)map.get("OWNER"), (String)map.get("OBJECT_NAME")));
                if (++n >= 50) continue;
                this._progress.setProgress(n);
            }
        }
        finally {
            this.addToModel(arrayList);
            this._progress.finish();
        }
    }

    private int getNumberOfThingsToSearch() {
        return 50;
    }

    private boolean isMatch(RDFSourceTable rDFSourceTable, SearchCategory searchCategory, String string) {
        return false;
    }

    private void addToModel(final List<RDFSourceTable> list) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RDFSourceTableSearchRunnable.this.getResultTablecontrol().setRows(list);
            }
        });
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }
}

