/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.SearchAndSelectActionControl;
import oracle.dbtools.rdfgraph.ui.SourceRow;

public class CreateSPARQLEndpointConfigDialog
extends ActionDialog {
    private Connection connection;
    private String title = RdfgraphArb.getString("CreateSPARQLEndpointConfigDialog.SPARQL_ENDPOINT_CONFIGURATION_FILE");
    SearchAndSelectActionControl srchModels;
    SearchAndSelectActionControl srchRulebases;
    BooleanCheckBoxActionControl chkUseOrCreateVirtual;
    BooleanCheckBoxActionControl hasQuads;
    private final String CONN_STRING = "jdbc:oracle:thin:@<host>:<port>:<sid>";
    String rbQuery = "SELECT OWNER, RULEBASE_NAME, STATUS from MDSYS.SEM_RULEBASE_INFO WHERE STATUS='VALID' AND RULEBASE_NAME like '%' || :rulebase_name || '%'";
    String modelQuery = "SELECT model_name from MDSYS.RDF_MODEL$ WHERE model_name like '%' || :model_name || '%'";

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.setConnection(connection);
        this.chkUseOrCreateVirtual = new BooleanCheckBoxActionControl("use_or_create_vm", RdfgraphArb.getString("CreateSPARQLEndpointConfigDialog.USE_OR_CREATE_VIRTUAL_MODEL"), false);
        this.hasQuads = new BooleanCheckBoxActionControl("has_quads", RdfgraphArb.getString("CreateSPARQLEndpointConfigDialog.HAS_QUADS"), false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(CreateSPARQLEndpointConfigDialog.this.chkUseOrCreateVirtual);
                this.add(CreateSPARQLEndpointConfigDialog.this.hasQuads);
            }
        };
        return arrayList;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        final ActionDialogTab actionDialogTab = new ActionDialogTab("models_in", RdfgraphArb.getString("MODELS")){

            protected List<ActionControl> createControls(Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        CreateSPARQLEndpointConfigDialog.this.srchModels = new SearchAndSelectActionControl("", CreateSPARQLEndpointConfigDialog.this.getConnection(), CreateSPARQLEndpointConfigDialog.this.modelQuery, new String[]{"model_name"}, "model_name");
                        this.add(CreateSPARQLEndpointConfigDialog.this.srchModels);
                    }
                };
                return arrayList;
            }
        };
        final ActionDialogTab actionDialogTab2 = new ActionDialogTab("rulebases_in", RdfgraphArb.getString("RULEBASES")){

            protected List<ActionControl> createControls(Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        CreateSPARQLEndpointConfigDialog.this.srchRulebases = new SearchAndSelectActionControl("", CreateSPARQLEndpointConfigDialog.this.getConnection(), CreateSPARQLEndpointConfigDialog.this.rbQuery, new String[]{"OWNER", "RULEBASE_NAME", "STATUS"}, "rulebase_name");
                        this.add(CreateSPARQLEndpointConfigDialog.this.srchRulebases);
                    }
                };
                return arrayList;
            }
        };
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>(){
            {
                this.add(actionDialogTab);
                this.add(actionDialogTab2);
            }
        };
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = "";
        String string2 = "";
        if (this.srchModels.getSelectedRows().size() <= 0) {
            return "--Please select at least one model";
        }
        string2 = this.srchModels.getSelectedRows().get(0).getValue(0);
        string = "--Replace the oracle:defaultModel section in your joseki-config.ttl\n";
        string = string + "--or config-oracle.ttl (Fuseki) configuration file with the following: \n";
        string = string + "oracle:defaultModel [ oracle:firstModel \"" + string2 + "\"; \n";
        for (SourceRow sourceRow : this.srchModels.getSelectedRows().subList(1, this.srchModels.getSelectedRows().size())) {
            string = string + "                  oracle:modelName   \"" + sourceRow.getValue(0) + "\";\n";
        }
        for (SourceRow sourceRow : this.srchRulebases.getSelectedRows()) {
            string = string + "                  oracle:rulebaseName   \"" + sourceRow.getValue(1) + "\";\n";
        }
        string = string + " ] .";
        return string;
    }

    protected String getTitle() {
        return this.title;
    }
}

