/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.JPanelActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControlPanel;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.RDFSourceTable;
import oracle.dbtools.rdfgraph.ui.RDFSourceTableSearchRunnable;
import oracle.dbtools.rdfgraph.utils.ParamListGenerator;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class CreateRDFViewDMAction
extends ActionDialog {
    private Connection connection;
    private String title;
    private JPanelActionControl panelControl;
    private TextBoxActionControl txtControl;
    private TextBoxActionControl txtControl2;
    private TextBoxActionControl txtModelName;
    private TextBoxActionControl txtURLPrefix;
    private BooleanCheckBoxActionControl chkCONFORMANCE;
    private BooleanCheckBoxActionControl chkGENERATE_ONLY;
    private BooleanCheckBoxActionControl chkKEY_BASED_REF_PROPERTY;
    private BooleanCheckBoxActionControl chkSCALAR_COLUMNS_ONLY;
    private TextBoxActionControl txtAddtionalFlags;
    SearchField tblSearch;
    TableActionControl leftTable;
    JTable tblRDFViewAvailableSource;
    TableActionControl rightTable;
    JTable tblRDFViewSource;
    List<RDFSourceTable> selectedTables;

    public CreateRDFViewDMAction() {
        this(RdfgraphArb.getString("CreateRDFViewDMAction.CREATE_RDFVIEW_USING_DIRECT_MAPPING"));
    }

    public CreateRDFViewDMAction(String string) {
        this.title = string;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add(RdfgraphArb.getString("OWNER"));
        arrayList3.add(RdfgraphArb.getString("RDFViewSourceTableModel.TABLE_NAME"));
        this.leftTable = new TableActionControl("available_tables", arrayList3, arrayList, 10);
        this.leftTable.setTitle(RdfgraphArb.getString("CreateRDFViewDMAction.AVAILABLE_TABLES__DOUBLE_CLICK_TO_ADD_"));
        this.tblRDFViewAvailableSource = ((TableActionControlPanel)this.leftTable.getUI()).getTable();
        this.selectedTables = new ArrayList<RDFSourceTable>();
        this.rightTable = new TableActionControl("available_tables", arrayList3, arrayList, 10);
        this.rightTable.setTitle(RdfgraphArb.getString("CreateRDFViewDMAction.SELECTED_TABLES__DOUBLE_CLICK_TO_REMOVE_"));
        this.tblRDFViewSource = ((TableActionControlPanel)this.rightTable.getUI()).getTable();
        this.rightTable.setRows(this.selectedTables);
        this.tblRDFViewAvailableSource.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int n = jTable.rowAtPoint(point);
                if (mouseEvent.getClickCount() == 2) {
                    String string = (String)jTable.getModel().getValueAt(n, 0);
                    String string2 = (String)jTable.getModel().getValueAt(n, 1);
                    CreateRDFViewDMAction.this.selectedTables.add(new RDFSourceTable(string, string2));
                    CreateRDFViewDMAction.this.rightTable.setRows(CreateRDFViewDMAction.this.selectedTables);
                }
            }
        });
        this.tblRDFViewSource.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int n = jTable.rowAtPoint(point);
                if (mouseEvent.getClickCount() == 2) {
                    CreateRDFViewDMAction.this.selectedTables.remove(n);
                    CreateRDFViewDMAction.this.rightTable.setRows(CreateRDFViewDMAction.this.selectedTables);
                }
            }
        });
        this.tblSearch = new SearchField();
        this.tblSearch.setStyle(SearchField.Style.SEARCH);
        this.tblSearch.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                RDFSourceTableSearchRunnable rDFSourceTableSearchRunnable = new RDFSourceTableSearchRunnable(searchEvent.getSearchProgress(), searchEvent.getSearchCategory(), searchEvent.getSearchText());
                rDFSourceTableSearchRunnable.setResultTablecontrol(CreateRDFViewDMAction.this.leftTable);
                rDFSourceTableSearchRunnable.setConnection(CreateRDFViewDMAction.this.connection);
                Thread thread = new Thread((Runnable)rDFSourceTableSearchRunnable, RdfgraphArb.getString("SEARCHING"));
                thread.start();
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.tblSearch, "Center");
        final JPanelActionControl jPanelActionControl = new JPanelActionControl("search_panel", "", jPanel);
        final SideBySideActionControl sideBySideActionControl = new SideBySideActionControl(null, null, (ActionControl)this.leftTable, (ActionControl)this.rightTable);
        sideBySideActionControl.getUI().setPreferredSize(new Dimension(500, 200));
        final ActionDialogTab actionDialogTab = new ActionDialogTab("source_tables", RdfgraphArb.getString("CreateRDFViewDMAction.SOURCE_TABLES")){

            protected List<ActionControl> createControls(Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        this.add(jPanelActionControl);
                        this.add(sideBySideActionControl);
                    }
                };
                return arrayList;
            }
        };
        ArrayList<ActionDialogTab> arrayList4 = new ArrayList<ActionDialogTab>(){
            {
                this.add(actionDialogTab);
            }
        };
        return arrayList4;
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.setconnection(connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", this.getObjectName());
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        String string = dBUtil.executeOracleReturnOneCol(this.getQuery(connection, "getUser"), hashMap);
        this.txtModelName = new TextBoxActionControl("model_name", RdfgraphArb.getString("CreateRDFViewDMAction.MODEL_NAME"), "modelDM");
        this.txtURLPrefix = new TextBoxActionControl("url_prefix", RdfgraphArb.getString("CreateRDFViewDMAction.URL_PREFIX"), "http://example.org/");
        final PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl("options", null);
        JPanel jPanel = propertyPanelActionControl.getUI();
        jPanel.setBorder(BorderFactory.createTitledBorder(RdfgraphArb.getString("OPTIONS")));
        this.chkCONFORMANCE = new BooleanCheckBoxActionControl("CONFORMANCE", "CONFORMANCE=T", false, false);
        this.chkGENERATE_ONLY = new BooleanCheckBoxActionControl("GENERATE_ONLY", "GENERATE_ONLY=T", false, false);
        this.chkKEY_BASED_REF_PROPERTY = new BooleanCheckBoxActionControl("KEY_BASED_REF_PROPERTY", "KEY_BASED_REF_PROPERTY=T", false, false);
        this.chkSCALAR_COLUMNS_ONLY = new BooleanCheckBoxActionControl("SCALAR_COLUMNS_ONLY", "SCALAR_COLUMNS_ONLY=T", false, false);
        this.txtAddtionalFlags = new TextBoxActionControl("additional_flags", RdfgraphArb.getString("CreateRDFViewDMAction.ADDITIONAL_FLAGS"), "");
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(CreateRDFViewDMAction.this.chkCONFORMANCE);
                this.add(CreateRDFViewDMAction.this.chkGENERATE_ONLY);
                this.add(CreateRDFViewDMAction.this.chkKEY_BASED_REF_PROPERTY);
                this.add(CreateRDFViewDMAction.this.chkSCALAR_COLUMNS_ONLY);
                this.add(CreateRDFViewDMAction.this.txtAddtionalFlags);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(CreateRDFViewDMAction.this.txtModelName);
                this.add(CreateRDFViewDMAction.this.txtURLPrefix);
                this.add(propertyPanelActionControl);
            }
        };
        return arrayList;
    }

    public String getScript(ActionDialog.Values values) {
        String string = this.getQuery(this.connection, "CREATE_RDFVIEW_DM");
        string = string.replaceAll("#model_name#", values.get("model_name"));
        string = string.replaceAll("#table_list#", ParamListGenerator.getSelectedTablesODCIVarchar2List(this.selectedTables));
        string = string.replaceAll("#prefix#", values.get("url_prefix"));
        string = string.replaceAll("#options#", this.getOptionsString(values));
        return string;
    }

    public String getOptionsString(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        if (values.get("options/KEY_BASED_REF_PROPERTY").equals("true")) {
            stringBuilder.append(" KEY_BASED_REF_PROPERTY ");
        }
        if (values.get("options/SCALAR_COLUMNS_ONLY").equals("true")) {
            stringBuilder.append(" SCALAR_COLUMNS_ONLY=T ");
        }
        if (values.get("options/CONFORMANCE").equals("true")) {
            stringBuilder.append(" CONFORMANCE=T ");
        }
        if (values.get("options/GENERATE_ONLY").equals("true")) {
            stringBuilder.append(" GENERATE_ONLY=T ");
        }
        if (values.get("options/additional_flags").trim().length() > 0) {
            stringBuilder.append(" " + values.get("options/additional_flags").trim() + " ");
        }
        if (stringBuilder.length() == 0) {
            return "null";
        }
        return "'" + stringBuilder.toString() + "'";
    }

    protected String getTitle() {
        return this.title;
    }

    private void setconnection(Connection connection) {
        this.connection = connection;
    }
}

