/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.panels.ShuttlePanel;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.sparql.SPARQLArb;

public class RulebaseSelectionDialog
extends JDialog
implements LayoutControl {
    private List<String> sources;
    private List<String> initialList = null;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private Action okAction;
    private Action cancelAction;
    private Action helpAction;
    private ShuttlePanel shuttle;
    private Connection connection;
    private String helpTopicID;
    private JPanel panel;

    private RulebaseSelectionDialog(Window window, Component component, List<String> list, Connection connection) {
        super(window);
        this.connection = connection;
        this.initialList = list;
        this.setName("RulebaseSelectionDialog");
        this.setModal(true);
        this.setLocationRelativeTo(component);
        this.setTitle(SPARQLArb.getString("RULEBASE_S"));
        this.initUI();
    }

    private void initUI() {
        this.okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulebaseSelectionDialog.this.sources = RulebaseSelectionDialog.this.shuttle.getSelected();
                RulebaseSelectionDialog.this.setVisible(false);
            }
        };
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulebaseSelectionDialog.this.sources = RulebaseSelectionDialog.this.initialList;
                RulebaseSelectionDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.okButton = new JButton();
        this.okButton.setName("okButton");
        this.cancelButton = new JButton();
        this.cancelButton.setName("cancelButton");
        this.helpButton = new JButton();
        this.helpButton.setName("helpButton");
        this.shuttle = this.initShuttle();
        this.shuttle.setName("shuttle");
        this.helpButton.setAction(this.helpAction);
        this.helpButton.setText(StringUtils.stripMnemonic((String)RdfgraphArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)RdfgraphArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.okButton.setAction(this.okAction);
        this.okButton.setText(RdfgraphArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.cancelButton.setAction(this.cancelAction);
        this.cancelButton.setText(RdfgraphArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        this.panel = new JPanel();
        this.panel.setName("panel");
        this.getContentPane().add(LayoutControl.GBC.createDialogMainPanel((Component)this.panel));
        this.panel.setLayout(new GridBagLayout());
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        GridBagConstraints gridBagConstraints = LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.shuttle.getPanel(), gridBagConstraints);
        gridBagConstraints = LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panel.add((Component)dialogButtonBar, gridBagConstraints);
    }

    private ShuttlePanel initShuttle() {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
        String string = "SELECT RULEBASE_NAME from MDSYS.SEM_RULEBASE_INFO WHERE STATUS='VALID'";
        List list = dBUtil.executeReturnList(string, Collections.emptyMap()).stream().map(map -> (String)map.get("RULEBASE_NAME")).collect(Collectors.toList());
        list.removeAll(this.initialList);
        this.shuttle = new ShuttlePanel(list, this.initialList);
        return this.shuttle;
    }

    public static List<String> showDialog(Window window, Component component, List<String> list, Connection connection) {
        RulebaseSelectionDialog rulebaseSelectionDialog = new RulebaseSelectionDialog(window, component, list, connection);
        rulebaseSelectionDialog.pack();
        rulebaseSelectionDialog.setVisible(true);
        return rulebaseSelectionDialog.getSelectedSources();
    }

    private List<String> getSelectedSources() {
        return this.sources;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

