/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.language;

import java.util.HashSet;
import java.util.List;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateMap;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.TermMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;

public class PredicateObjectMap
extends R2RMLNode {
    public static final String BASE_LABEL = R2RMLArb.getString("PREDICATE_OBJECT_MAP");

    public PredicateObjectMap(String string) {
        super(string, "<http://www.w3.org/ns/r2rml#PredicateObjectMap>");
    }

    @Override
    public String toString() {
        return BASE_LABEL;
    }

    @Override
    public void compile() {
        super.compile();
        TriplesMapNode triplesMapNode = (TriplesMapNode)this.getFirstChildOfClass(TriplesMapNode.class);
        if (triplesMapNode != null) {
            String string = triplesMapNode.getCleanSource();
            this.setDescription(R2RMLArb.getString("REFERENCES") + " " + string);
        } else {
            this.setDescription(this.compileDescription());
        }
    }

    private String compileDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getSimplePredicate() != null) {
            stringBuilder.append(this.getSimplePredicate().getValue() + "");
            stringBuilder.append(" -> ");
        }
        if (this.getSimpleObject() != null) {
            stringBuilder.append(R2RMLNode.stripQuotes(this.getSimpleObject().getValue()) + "");
        }
        return stringBuilder.toString();
    }

    public R2RMLNode getSimplePredicate() {
        String string = this.getPredicateMappingtype();
        R2RMLNode r2RMLNode = null;
        if (string.equals(R2RMLArb.getString("CONSTANT"))) {
            r2RMLNode = this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#predicate>");
            if (r2RMLNode != null) {
                return r2RMLNode;
            }
            r2RMLNode = this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#predicateMap>");
            r2RMLNode = r2RMLNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#constant>");
            return r2RMLNode;
        }
        if (string.equals(R2RMLArb.getString("TEMPLATE"))) {
            r2RMLNode = this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#predicateMap>");
            r2RMLNode = r2RMLNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#template>");
            return r2RMLNode;
        }
        if (string.equals(R2RMLArb.getString("COLUMN"))) {
            r2RMLNode = this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#predicateMap>");
            r2RMLNode = r2RMLNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#column>");
            return r2RMLNode;
        }
        return r2RMLNode;
    }

    public R2RMLNode getSimpleObject() {
        String string = this.getObjectMappingtype();
        R2RMLNode r2RMLNode = null;
        if (string.equals(R2RMLArb.getString("CONSTANT"))) {
            r2RMLNode = this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#object>");
            if (r2RMLNode != null) {
                return r2RMLNode;
            }
            r2RMLNode = this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#objectMap>");
            r2RMLNode = r2RMLNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#constant>");
            return r2RMLNode;
        }
        if (string.equals(R2RMLArb.getString("TEMPLATE"))) {
            r2RMLNode = this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#objectMap>");
            r2RMLNode = r2RMLNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#template>");
            return r2RMLNode;
        }
        if (string.equals(R2RMLArb.getString("COLUMN_BASED"))) {
            r2RMLNode = this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#objectMap>");
            r2RMLNode = r2RMLNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#column>");
            return r2RMLNode;
        }
        if (string.equals(R2RMLArb.getString("REFERENCE"))) {
            r2RMLNode = this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#objectMap>");
            r2RMLNode = r2RMLNode.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#parentTriplesMap>");
            return r2RMLNode;
        }
        return r2RMLNode;
    }

    public String getPredicateMappingtype() {
        String string = "<http://www.w3.org/ns/r2rml#predicate>";
        String string2 = "<http://www.w3.org/ns/r2rml#predicateMap>";
        String string3 = "<http://www.w3.org/ns/r2rml#constant>";
        String string4 = "<http://www.w3.org/ns/r2rml#column>";
        String string5 = "<http://www.w3.org/ns/r2rml#template>";
        if (this.getFirstChildByPredicate(string) != null) {
            return R2RMLArb.getString("CONSTANT");
        }
        PredicateMap predicateMap = (PredicateMap)this.getFirstChildByPredicate(string2);
        if (predicateMap == null) {
            return null;
        }
        if (predicateMap.getFirstChildByPredicate(string3) != null) {
            return R2RMLArb.getString("CONSTANT");
        }
        if (predicateMap.getFirstChildByPredicate(string4) != null) {
            return R2RMLArb.getString("COLUMN");
        }
        if (predicateMap.getFirstChildByPredicate(string5) != null) {
            return R2RMLArb.getString("TEMPLATE");
        }
        return null;
    }

    public String getObjectMappingtype() {
        String string = "<http://www.w3.org/ns/r2rml#object>";
        String string2 = "<http://www.w3.org/ns/r2rml#objectMap>";
        String string3 = "<http://www.w3.org/ns/r2rml#constant>";
        String string4 = "<http://www.w3.org/ns/r2rml#column>";
        String string5 = "<http://www.w3.org/ns/r2rml#template>";
        String string6 = "<http://www.w3.org/ns/r2rml#parentTriplesMap>";
        if (this.getFirstChildByPredicate(string) != null) {
            return R2RMLArb.getString("CONSTANT");
        }
        TermMapNode termMapNode = (TermMapNode)this.getFirstChildByPredicate(string2);
        if (termMapNode == null) {
            return null;
        }
        if (termMapNode.getFirstChildByPredicate(string6) != null) {
            return R2RMLArb.getString("REFERENCE");
        }
        if (termMapNode.getFirstChildByPredicate(string3) != null) {
            return R2RMLArb.getString("CONSTANT");
        }
        if (termMapNode.getFirstChildByPredicate(string4) != null) {
            return R2RMLArb.getString("COLUMN_BASED");
        }
        if (termMapNode.getFirstChildByPredicate(string5) != null) {
            return R2RMLArb.getString("TEMPLATE");
        }
        return null;
    }

    public List<R2RMLNode> getPredicateMaps() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("<http://www.w3.org/ns/r2rml#predicate>");
        hashSet.add("<http://www.w3.org/ns/r2rml#predicateMap>");
        return this.getChildrenByPredicateSet(hashSet);
    }

    public List<R2RMLNode> getObjectMaps() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("<http://www.w3.org/ns/r2rml#object>");
        hashSet.add("<http://www.w3.org/ns/r2rml#objectMap>");
        return this.getChildrenByPredicateSet(hashSet);
    }

    public List<R2RMLNode> getGraphMaps() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("<http://www.w3.org/ns/r2rml#graph>");
        hashSet.add("<http://www.w3.org/ns/r2rml#graphMap>");
        return this.getChildrenByPredicateSet(hashSet);
    }
}

