/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.objectmap;

import javax.swing.table.AbstractTableModel;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.language.ColumnNameNode;
import oracle.dbtools.rdfgraph.r2rml.language.JoinConditionNode;
import oracle.dbtools.rdfgraph.r2rml.language.ObjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;

public class JoinConditionTableModel
extends AbstractTableModel {
    private static final int CHILD_COL_IDX = 0;
    private static final int PARENT_COL_IDX = 1;
    private final String[] headers = new String[]{R2RMLArb.getString("JoinConditionTableModel.CHILD"), R2RMLArb.getString("JoinConditionTableModel.PARENT")};
    ObjectMapNode node;

    public JoinConditionTableModel(ObjectMapNode objectMapNode) {
        this.node = objectMapNode;
    }

    @Override
    public int getRowCount() {
        return this.node.getJoinConditions().size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        JoinConditionNode joinConditionNode = (JoinConditionNode)this.node.getJoinConditions().get(n);
        if (n2 == 0) {
            return joinConditionNode.getChildColumn().getValue();
        }
        if (n2 == 1) {
            return joinConditionNode.getParentColumn().getValue();
        }
        return "(INVALID)";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        JoinConditionNode joinConditionNode = (JoinConditionNode)this.node.getJoinConditions().get(n);
        if (n2 == 0) {
            joinConditionNode.setChildColumn(new ColumnNameNode((String)object));
            return;
        }
        if (n2 == 1) {
            joinConditionNode.setParentColumn(new ColumnNameNode((String)object));
            return;
        }
    }

    @Override
    public String getColumnName(int n) {
        return this.headers[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    void removeRow(int n) {
        R2RMLNode r2RMLNode = this.node.getJoinConditions().get(n);
        this.node.removeChild(r2RMLNode);
        this.fireTableDataChanged();
    }
}

