/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.generators.RestCodeGenResults;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestRole;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.utils.RestLoadData;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;

public class RestExecuteScript {
    private static final int CREATE = 1;
    private static final int DELETE = 2;
    private static final int UPDATE = 3;
    private static final int RENAME = 4;
    private static final int ADD = 5;

    public static void createRestPrivilege(Context context, RestPrivilege restPrivilege) {
        new RestExecuteScript().createPrivilege(context, restPrivilege);
    }

    public static void createRestRole(Context context, RestRole restRole) {
        new RestExecuteScript().createRole(context, restRole);
    }

    public static void updateRestModule(Context context, RestModule restModule) {
        new RestExecuteScript().updateModule(context, restModule);
    }

    public static void updateRestTemplate(Context context, RestTemplate restTemplate) {
        new RestExecuteScript().updateTemplate(context, restTemplate);
    }

    public static void updateRenameRestTemplate(Context context, RestTemplate restTemplate) {
        new RestExecuteScript().updateRenameTemplate(context, restTemplate);
    }

    public static void updateRestPrivilege(Context context, RestPrivilege restPrivilege) {
        new RestExecuteScript().updatePrivilege(context, restPrivilege);
    }

    public static void deleteRestModule(Context context) {
        new RestExecuteScript().deleteModule(context);
    }

    public static void deleteRestTemplate(Context context) {
        new RestExecuteScript().deleteTemplate(context);
    }

    public static void deleteRestHandler(Context context) {
        new RestExecuteScript().deleteHandler(context);
    }

    public static void deleteRestPrivilege(Context context) {
        new RestExecuteScript().deletePrivilege(context);
    }

    public static void renameRestRole(Context context, String string, String string2) {
        new RestExecuteScript().renameRole(context, string, string2);
    }

    public static void renameRestPrivilege(Context context, String string, String string2) {
        new RestExecuteScript().renamePrivilege(context, string, string2);
    }

    public static void renameRestModule(Context context, String string, String string2, String string3) {
        new RestExecuteScript().renameModule(context, string, string2, string3);
    }

    public static void deleteRestRole(Context context) {
        new RestExecuteScript().deleteRole(context);
    }

    private void updateModule(Context context, RestModule restModule) {
        String string;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && (string = (String)this.lookup("MODULE_NAME", dBObject.getDictionary())) != null) {
            restModule.setTemplates(RestLoadData.createRestTemplatesHandlers(context));
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string2 = restCodeGenResults.generateModuleTemplatesHandlers(restModule, true);
            String string3 = dBObject.getConnectionName();
            this.executeScript(string3, string2, 3, context);
        }
    }

    private void updateTemplate(Context context, RestTemplate restTemplate) {
        String string;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && (string = (String)this.lookup("MODULE_NAME", dBObject.getDictionary())) != null) {
            List<RestResourceHandler> list = RestLoadData.createRestHandlers(context);
            restTemplate.setResourceHandlers(list);
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string2 = restCodeGenResults.generateTemplateHandlers(string, restTemplate, true);
            String string3 = dBObject.getConnectionName();
            this.executeScript(string3, string2, 3, context);
        }
    }

    private void updateRenameTemplate(Context context, RestTemplate restTemplate) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            String string = (String)this.lookup("MODULE_NAME", dBObject.getDictionary());
            Object object = this.lookup("TEMPLATE_ID", dBObject.getDictionary());
            long l = 0L;
            if (object != null && object instanceof BigDecimal) {
                l = ((BigDecimal)object).longValue();
            }
            if (string != null && l != 0L) {
                RestModule restModule = RestLoadData.createModuleTemplateHandlerExcludeTemplate(context, l);
                List<RestResourceHandler> list = RestLoadData.createRestHandlers(context);
                restTemplate.setResourceHandlers(list);
                restModule.addTemplate(restTemplate);
                RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
                String string2 = restCodeGenResults.generateModuleTemplatesHandlers(restModule, true);
                String string3 = dBObject.getConnectionName();
                this.executeScript(string3, string2, 3, context);
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The module name: " + string + " or template: " + l + " is null");
            }
        }
    }

    private void deleteModule(Context context) {
        String string;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && (string = (String)this.lookup("MODULE_NAME", dBObject.getDictionary())) != null) {
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string2 = restCodeGenResults.getDeleteModule(string, true);
            String string3 = dBObject.getConnectionName();
            this.executeScript(string3, string2, 2, context);
        }
    }

    private void deleteTemplate(Context context) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            String string = (String)this.lookup("MODULE_NAME", dBObject.getDictionary());
            Object object = this.lookup("TEMPLATE_ID", dBObject.getDictionary());
            long l = 0L;
            if (object != null && object instanceof BigDecimal) {
                l = ((BigDecimal)object).longValue();
            }
            if (string != null && l != 0L) {
                RestModule restModule = RestLoadData.createModuleTemplateHandlerExcludeTemplate(context, l);
                RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
                String string2 = restCodeGenResults.generateModuleTemplatesHandlers(restModule, true);
                String string3 = dBObject.getConnectionName();
                this.executeScript(string3, string2, 2, context);
            }
        }
    }

    private void deleteHandler(Context context) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            String string = (String)this.lookup("MODULE_NAME", dBObject.getDictionary());
            String string2 = (String)this.lookup("URI_TEMPLATE", dBObject.getDictionary());
            String string3 = (String)this.lookup("METHOD", dBObject.getDictionary());
            if (string3 != null && string2 != null) {
                RestTemplate restTemplate = RestLoadData.createTemplateHandlerExcludMethod(context, string3);
                RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
                String string4 = restCodeGenResults.generateTemplateHandlers(string, restTemplate, true);
                String string5 = dBObject.getConnectionName();
                this.executeScript(string5, string4, 2, context);
            }
        }
    }

    private void deletePrivilege(Context context) {
        String string;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && (string = (String)this.lookup("PRIVILEGE_NAME", dBObject.getDictionary())) != null) {
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string2 = restCodeGenResults.getDeletePrivilege(string, true);
            String string3 = dBObject.getConnectionName();
            this.executeScript(string3, string2, 2, context);
        }
    }

    private void deleteRole(Context context) {
        String string;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && (string = (String)this.lookup("NAME", dBObject.getDictionary())) != null) {
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string2 = restCodeGenResults.getDeleteRole(string, true);
            String string3 = dBObject.getConnectionName();
            this.executeScript(string3, string2, 2, context);
        }
    }

    private void createPrivilege(Context context, RestPrivilege restPrivilege) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string = restCodeGenResults.generatePrivilege(restPrivilege, true);
            String string2 = dBObject.getConnectionName();
            this.executeScript(string2, string, 1, context);
        }
    }

    private void updatePrivilege(Context context, RestPrivilege restPrivilege) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string = restCodeGenResults.generatePrivilege(restPrivilege, true);
            String string2 = dBObject.getConnectionName();
            this.executeScript(string2, string, 3, context);
        }
    }

    private void createRole(Context context, RestRole restRole) {
        String string;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && (string = restRole.getName()) != null) {
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string2 = restCodeGenResults.getCreateRole(string, true);
            String string3 = dBObject.getConnectionName();
            this.executeScript(string3, string2, 1, context);
        }
    }

    private void renameModule(Context context, String string, String string2, String string3) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string4 = restCodeGenResults.getRenameModule(string, string2, string3, true);
            String string5 = dBObject.getConnectionName();
            this.executeScript(string5, string4, 4, context);
        }
    }

    private void renamePrivilege(Context context, String string, String string2) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string3 = restCodeGenResults.getRenamePrivilege(string, string2, true);
            String string4 = dBObject.getConnectionName();
            this.executeScript(string4, string3, 4, context);
        }
    }

    private void renameRole(Context context, String string, String string2) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null) {
            RestCodeGenResults restCodeGenResults = this.getCodeGen(dBObject.getDBVersion());
            String string3 = restCodeGenResults.getRenameRole(string, string2, true);
            String string4 = dBObject.getConnectionName();
            this.executeScript(string4, string3, 4, context);
        }
    }

    private void executeScript(final String string, final String string2, final int n, final Context context) {
        final WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(RestArb.getString("EXECUTING_SCRIPTS"), true, IRaptorTaskRunMode.MODAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                block11: {
                    Connection connection = null;
                    try {
                        connection = Connections.getInstance().getConnection(string);
                        if (Connections.getInstance().lock(connection)) {
                            if (!RestUtils.nullOrEmpty(string2)) {
                                ISQLCommand[] iSQLCommandArray;
                                ScriptParser scriptParser = new ScriptParser(string2, connection);
                                scriptParser.parse();
                                for (ISQLCommand iSQLCommand : iSQLCommandArray = scriptParser.getSqlStatements()) {
                                    String string3 = iSQLCommand.getSql().replace("\r", " ");
                                    try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
                                        preparedStatement.execute();
                                    }
                                }
                                break block11;
                            }
                            throw new Exception(RestArb.getString("ERR_CODE_NOT_GEN"));
                        }
                        throw new Exception(RestArb.getString("ERR_EXECUTE_SCRIPT"));
                    }
                    catch (Exception exception) {
                        throw new TaskException((Throwable)exception);
                    }
                    finally {
                        Connections.getInstance().unlock(connection);
                    }
                }
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = raptorTaskEvent.getThrowable();
                while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                    throwable2 = throwable;
                }
                ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                this.cleanup();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        switch (n) {
                            case 1: {
                                RestExecuteScript.this.refreshFolder(context);
                                break;
                            }
                            case 5: {
                                RestExecuteScript.this.refreshParentNode(context);
                            }
                            case 4: {
                                RestExecuteScript.this.refreshFolder(context);
                                break;
                            }
                            case 2: {
                                if (context.getElement() instanceof ObjectFolder) {
                                    RestExecuteScript.this.refreshFolder(context);
                                    break;
                                }
                                RestExecuteScript.this.refreshParentNode(context);
                                break;
                            }
                            case 3: {
                                DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
                                if (dBObject.getObjectType().equals("REST_TEMPLATE")) {
                                    RestExecuteScript.this.refreshParentNode(context);
                                    break;
                                }
                                RestExecuteScript.this.refreshFolder(context);
                            }
                        }
                        waitCursor.hide();
                    }
                });
            }

            private void cleanup() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
            }
        });
        waitCursor.show();
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private Object lookup(String string, Map<String, Object> map) {
        if (map != null) {
            return map.get(string);
        }
        return null;
    }

    private RestCodeGenResults getCodeGen(String string) {
        return new RestCodeGenResults(string);
    }

    private void refreshFolder(Context context) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        if (navigatorTreeNode != null) {
            View view = context.getView();
            NavigatorTree navigatorTree = null;
            if (view instanceof NavigatorWindow) {
                navigatorTree = ((NavigatorWindow)view).getTree();
            } else {
                NavigatorWindow navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow();
                if (navigatorWindow != null) {
                    navigatorTree = navigatorWindow.getTree();
                }
            }
            if (navigatorTree != null) {
                navigatorTreeNode = navigatorTreeNode.findAncestorTreeNode(ObjectFolder.class, false);
                navigatorTree.refresh(navigatorTreeNode);
            }
        }
    }

    private void refreshParentNode(Context context) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        if (navigatorTreeNode != null) {
            NavigatorWindow navigatorWindow;
            View view = context.getView();
            NavigatorTree navigatorTree = null;
            if (view instanceof NavigatorWindow) {
                navigatorTree = ((NavigatorWindow)view).getTree();
            } else {
                navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow();
                if (navigatorWindow != null) {
                    navigatorTree = navigatorWindow.getTree();
                }
            }
            if (navigatorTree != null) {
                navigatorWindow = (NavigatorTreeNode)navigatorTreeNode.getParent();
                navigatorTree.refresh((NavigatorTreeNode)navigatorWindow);
            }
        }
    }
}

