/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.navigator;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.connection.RestConnection;
import oracle.dbtools.rest.connection.RestDownload;
import oracle.dbtools.rest.connection.RestUpload;
import oracle.dbtools.rest.editor.RestEditor;
import oracle.dbtools.rest.editor.RestHandlerEditor;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.navigator.RestFolder;
import oracle.dbtools.rest.navigator.RestHandlerEditorNode;
import oracle.dbtools.rest.navigator.RestHandlerNode;
import oracle.dbtools.rest.navigator.RestModuleFolder;
import oracle.dbtools.rest.navigator.RestModuleNode;
import oracle.dbtools.rest.navigator.RestNavigatorWindow;
import oracle.dbtools.rest.navigator.RestRoot;
import oracle.dbtools.rest.navigator.RestSecurityFolder;
import oracle.dbtools.rest.navigator.RestSecurityNode;
import oracle.dbtools.rest.navigator.RestTemplateNode;
import oracle.dbtools.rest.ui.RestBaseDialog;
import oracle.dbtools.rest.ui.RestModuleDialog;
import oracle.dbtools.rest.ui.RestResourceHandlerDialog;
import oracle.dbtools.rest.ui.RestSecurityDialog;
import oracle.dbtools.rest.ui.RestTemplateDialog;
import oracle.dbtools.rest.ui.RestValidateDialog;
import oracle.dbtools.rest.utils.RestCache;
import oracle.dbtools.rest.utils.RestOpenAdmin;
import oracle.dbtools.rest.utils.RestSaveAdmin;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.wizard.RestWizard;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class RestNavigatorController
implements Controller {
    public static final int CONNECT_ID = Ide.findOrCreateCmdID((String)"rest.CONNECT");
    public static final int DISCONNECT_ID = Ide.findOrCreateCmdID((String)"rest.DISCONNECT");
    public static final int OPEN_FILE_ID = Ide.findOrCreateCmdID((String)"rest.OPEN_FILE");
    public static final int RETRIEVE_ADMIN_ID = Ide.findOrCreateCmdID((String)"rest.RETRIEVE_ADMIN");
    public static final int SAVE_FILE_ID = Ide.findOrCreateCmdID((String)"rest.SAVE_FILE");
    public static final int UPLOAD_ADMIN_ID = Ide.findOrCreateCmdID((String)"rest.UPLOAD_ADMIN");
    public static final int VALIDATE_ADMIN_ID = Ide.findOrCreateCmdID((String)"rest.VALIDATE_ADMIN");
    public static final int ADD_GET_HANDLER_ID = Ide.findOrCreateCmdID((String)"rest.ADD_GET_HANDLER");
    public static final int ADD_DELETE_HANDLER_ID = Ide.findOrCreateCmdID((String)"rest.ADD_DELETE_HANDLER");
    public static final int ADD_POST_HANDLER_ID = Ide.findOrCreateCmdID((String)"rest.ADD_POST_HANDLER");
    public static final int ADD_PUT_HANDLER_ID = Ide.findOrCreateCmdID((String)"rest.ADD_PUT_HANDLER");
    public static final int ADD_TEMPLATE_ID = Ide.findOrCreateCmdID((String)"rest.ADD_TEMPLATE");
    public static final int DELETE_ID = Ide.findOrCreateCmdID((String)"rest.DELETE");
    public static final int EDIT_ID = Ide.findOrCreateCmdID((String)"rest.EDIT");
    public static final int NEW_ADMIN_ID = Ide.findOrCreateCmdID((String)"rest.NEW_ADMIN");
    public static final int NEW_MODULE_ID = Ide.findOrCreateCmdID((String)"rest.NEW_MODULE");
    public static final int NEW_PRIVILEGE_ID = Ide.findOrCreateCmdID((String)"rest.NEW_PRIVILEGE");
    public static final int OPEN_ID = Ide.findOrCreateCmdID((String)"rest.OPEN");
    public static final int VALIDATE_ID = Ide.findOrCreateCmdID((String)"rest.VALIDATE");
    public static final int UPLOAD_ID = Ide.findOrCreateCmdID((String)"rest.UPLOAD");
    public static final int RETRIEVE_ID = Ide.findOrCreateCmdID((String)"rest.RETRIEVE");
    private static RestNavigatorController INSTANCE;
    private RestResourceHandler.HTTP_METHOD_TYPE _methodType;
    private static boolean _loaded;
    private static boolean _imported;
    private RESTTask<?> _backgroundTask;
    private final Object taskLock = new Object();

    public static synchronized RestNavigatorController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestNavigatorController();
        }
        return INSTANCE;
    }

    private RestNavigatorController() {
        this.initActions();
    }

    public void initActions() {
        boolean bl = RestConnection.getInstance().isConnectionOpen();
        IdeAction.get((int)CONNECT_ID).setEnabled(!bl);
        IdeAction.get((int)DISCONNECT_ID).setEnabled(bl);
        IdeAction.get((int)RETRIEVE_ADMIN_ID).setEnabled(bl);
        IdeAction.get((int)UPLOAD_ADMIN_ID).setEnabled(false);
        IdeAction.get((int)SAVE_FILE_ID).setEnabled(_loaded);
        IdeAction.get((int)VALIDATE_ID).setEnabled(_loaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restConnect() {
        boolean bl = RestConnection.getInstance().connect();
        if (bl) {
            Object object;
            boolean bl2 = true;
            if (_loaded) {
                object = RestArb.getString("REST_CONNECT_RETRIEVE").concat(System.getProperty("line.separator")).concat(RestArb.getString("QUESTION_CONTINUE"));
                bl2 = MessageDialog.confirm(null, (Object)object, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
            }
            if (bl2) {
                object = new WaitCursor((Component)Ide.getMainWindow());
                try {
                    object.show();
                    this.removeEditors(null, true);
                    _loaded = RestDownload.downloadRestAdmin();
                    if (_loaded) {
                        _imported = false;
                        RestCache.getInstance().resetCache();
                    }
                    UpdateMessage.fireStructureChanged((Subject)RestRoot.getInstance());
                }
                finally {
                    object.hide();
                }
            }
        }
    }

    public void restDisconnect() {
        RestConnection.getInstance().disconnect();
        RestCache.getInstance().resetCache();
    }

    private void retrieveRESTfulServices() {
        if (RestConnection.getInstance().isConnectionOpen()) {
            Object object;
            boolean bl;
            if (_loaded && !(bl = MessageDialog.confirm(null, (Object)(object = RestArb.getString("REST_ADMIN_RETRIEVE").concat(" ").concat(RestArb.getString("WARN_UPDATES_NOT_SAVED")).concat("\n\n").concat(RestArb.getString("QUESTION_CONTINUE"))), (String)RestArb.getString("REST_ADMIN_TITLE"), null))) {
                return;
            }
            object = new WaitCursor((Component)Ide.getMainWindow());
            try {
                object.show();
                this.removeEditors(null, true);
                _loaded = RestDownload.downloadRestAdmin();
            }
            finally {
                object.hide();
            }
            if (_loaded) {
                _imported = false;
                RestCache.getInstance().resetCache();
            }
        }
    }

    private void newRESTfulServices() {
        if (_loaded) {
            String string = RestArb.getString("REST_ADMIN_CREATE").concat(" ").concat(RestArb.getString("WARN_UPDATES_NOT_SAVED")).concat("\n\n").concat(RestArb.getString("QUESTION_CONTINUE"));
            boolean bl = MessageDialog.confirm(null, (Object)string, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
            if (!bl) {
                return;
            }
            this.removeEditors(null, true);
        }
        RestRoot.getInstance().newRestfulServices();
        UpdateMessage.fireStructureChanged((Subject)RestRoot.getInstance());
        _loaded = false;
    }

    private void openRESTfulServices() {
        if (_loaded) {
            String string = RestArb.getString("REST_ADMIN_OPEN").concat(" ").concat(RestArb.getString("WARN_UPDATES_NOT_SAVED")).concat("\n\n").concat(RestArb.getString("QUESTION_CONTINUE"));
            boolean bl = MessageDialog.confirm(null, (Object)string, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
            if (!bl) {
                return;
            }
            this.removeEditors(null, true);
        }
        _imported = RestOpenAdmin.openAdminFromFile();
        UpdateMessage.fireStructureChanged((Subject)RestRoot.getInstance());
        _loaded = _imported;
    }

    private void saveRESTfulServices() {
        if (_loaded) {
            this.saveEditors();
            RestSaveAdmin.save();
        }
    }

    private void validateRESTfulServices() {
        this.saveEditors();
        RestValidateDialog.validateRESTfulServices(RestUtils.getModules(), RestUtils.getPrivileges());
    }

    private void retrieve(Context context) {
        if (context.getNode() instanceof RestModuleNode) {
            this.retrieveModule(context);
        } else if (context.getNode() instanceof RestSecurityNode) {
            this.retrievePrivilege(context);
        }
    }

    private void retrieveModule(final Context context) {
        final RestModule restModule = ((RestModuleNode)context.getNode()).getModule();
        String string = RestArb.format("REST_ADMIN_RETRIEVE_SINGLE", RestArb.getString("LABEL_MODULE"), restModule.getName()).concat(System.getProperty("line.separator")).concat(RestArb.getString("QUESTION_CONTINUE"));
        boolean bl = MessageDialog.confirm(null, (Object)string, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
        if (bl) {
            this.startTask(new RESTTask<RestModule>(RestArb.getString("TASK_RETRIEVE_MODULE")){

                protected RestModule doWork() throws TaskException {
                    return RestDownload.downloadModule(restModule);
                }
            }, new RESTHandler<RestModule>(){

                @Override
                protected void handleTaskFinished(RestModule restModule2) {
                    String string = restModule.getName();
                    List<String> list = RestUtils.getModuleNames(string);
                    if (list.contains(restModule2.getName())) {
                        MessageDialog.error(null, (Object)RestArb.format("ERROR_RETRIEVE_DUPLICATE_NAME", RestArb.getString("LABEL_MODULE"), restModule2.getName()), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                        return;
                    }
                    RestFolder restFolder = RestNavigatorController.this.getParentNode(context);
                    RestNavigatorController.this.removeModuleChildren(context);
                    restFolder.remove(context.getElement());
                    UpdateMessage.fireChildRemoved((Subject)restFolder, (Element)context.getNode());
                    RestModuleNode restModuleNode = RestUtils.createModuleNode(restModule2);
                    UpdateMessage.fireChildAdded((Subject)restFolder, (Element)restModuleNode);
                    restFolder.markDirty(false);
                }
            });
        }
    }

    private void retrievePrivilege(final Context context) {
        final RestPrivilege restPrivilege = ((RestSecurityNode)context.getNode()).getSecurity();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RestArb.format("REST_ADMIN_RETRIEVE_SINGLE", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName())).append(System.getProperty("line.separator")).append(RestArb.getString("QUESTION_CONTINUE"));
        boolean bl = MessageDialog.confirm(null, (Object)stringBuffer, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
        if (bl) {
            this.startTask(new RESTTask<RestPrivilege>(RestArb.getString("TASK_RETRIEVE_PRIV")){

                protected RestPrivilege doWork() throws TaskException {
                    return RestDownload.downloadPrivilege(restPrivilege);
                }
            }, new RESTHandler<RestPrivilege>(){

                @Override
                protected void handleTaskFinished(RestPrivilege restPrivilege2) {
                    String string = restPrivilege.getName();
                    List<String> list = RestUtils.getPrivilegeNames(string);
                    if (list.contains(restPrivilege2.getName())) {
                        MessageDialog.error(null, (Object)RestArb.format("ERROR_RETRIEVE_DUPLICATE_NAME", RestArb.getString("LABEL_MODULE"), restPrivilege2.getName()), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                        return;
                    }
                    RestSecurityNode restSecurityNode = (RestSecurityNode)context.getNode();
                    restSecurityNode.setSecurity(restPrivilege2);
                    boolean bl = ModelUtil.areDifferent((Object)string, (Object)restPrivilege2.getName());
                    if (bl) {
                        try {
                            restSecurityNode.setURL(new URL(RestNavigatorController.this.getParentURL(context) + "/" + restPrivilege2.getName()));
                        }
                        catch (MalformedURLException malformedURLException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
                        }
                        UpdateMessage.fireStructureChanged((Subject)restSecurityNode);
                        UpdateMessage.fireObjectRenamed((Subject)restSecurityNode);
                    } else {
                        UpdateMessage.fireStructureChanged((Subject)restSecurityNode);
                    }
                }
            });
        }
    }

    private void upload(Context context) {
        Node node = context.getNode();
        final boolean bl = _imported;
        if (node instanceof RestModuleNode) {
            if (this.validate(context, false)) {
                final RestModule restModule = ((RestModuleNode)node).getModule();
                this.startTask(new RESTTask<Void>(RestArb.getString("TASK_UPLOAD_MODULE")){

                    protected Void doWork() throws TaskException {
                        RestUpload.uploadModule(restModule, bl);
                        return null;
                    }
                }, new VoidHandler());
            }
        } else if (node instanceof RestSecurityNode && this.validate(context, false)) {
            final RestPrivilege restPrivilege = ((RestSecurityNode)node).getSecurity();
            this.startTask(new RESTTask<Void>(RestArb.getString("TASK_UPLOAD_PRIV")){

                protected Void doWork() throws TaskException {
                    RestUpload.uploadPrivilege(restPrivilege, bl);
                    return null;
                }
            }, new VoidHandler());
        }
    }

    private void saveModuleHandlers(RestModuleNode restModuleNode) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = restModuleNode.getChildren();
        if (iterator != null) {
            Object object;
            Object object2 = iterator;
            while (object2.hasNext()) {
                object = (RestTemplateNode)((Object)object2.next());
                this.buildHandlerNodeIdList((RestTemplateNode)((Object)object), arrayList);
            }
            if (!arrayList.isEmpty()) {
                object2 = EditorManager.getEditorManager().getAllEditors();
                object = object2.iterator();
                while (object.hasNext()) {
                    RestHandlerEditor restHandlerEditor;
                    Editor editor = (Editor)object.next();
                    if (!(editor instanceof RestHandlerEditor) || !arrayList.contains(new Integer((restHandlerEditor = (RestHandlerEditor)editor).getNodeId()))) continue;
                    restHandlerEditor.saveResourceHandler();
                }
            }
        }
    }

    private boolean validate(Context context, boolean bl) {
        if (context.getNode() instanceof RestModuleNode) {
            this.saveModuleHandlers((RestModuleNode)context.getNode());
            return RestValidateDialog.isModuleValid(((RestModuleNode)context.getNode()).getModule(), bl);
        }
        if (context.getNode() instanceof RestSecurityNode) {
            return RestValidateDialog.isPrivilegeValid(((RestSecurityNode)context.getNode()).getSecurity(), bl);
        }
        return false;
    }

    private void createModuleViaWizard(Context context) {
        if (context.getNode() instanceof RestModuleFolder) {
            RestModule restModule = RestWizard.getInstance().launchCreateRESTfulModule(RestUtils.getModuleNames(null), RestUtils.getModuleUriPrefixes(null));
            if (restModule == null) {
                return;
            }
            RestModuleNode restModuleNode = RestUtils.createModuleNode(restModule);
            UpdateMessage.fireChildAdded((Subject)context.getNode(), (Element)restModuleNode);
            if (!_loaded) {
                _loaded = true;
            }
        }
    }

    private void createTemplate(Context context) {
        if (context.getNode() instanceof RestModuleNode) {
            RestModuleNode restModuleNode = (RestModuleNode)context.getNode();
            RestModule restModule = restModuleNode.getModule();
            RestTemplate restTemplate = RestWizard.getInstance().launchCreateRESTfulTemplate(RestUtils.getExistingURIs((RestFolder)context.getNode(), null), restModule.getURIPrefix(), restModule.getPaginationSize());
            if (restTemplate == null) {
                return;
            }
            RestTemplateNode restTemplateNode = new RestTemplateNode(restTemplate);
            restTemplateNode.setParentURIPrefix(restModule.getURIPrefix());
            this.createNode(restModuleNode, restTemplateNode);
            restModule.addTemplate(restTemplate);
            this.createHandlerFromTemplate(restTemplateNode);
        }
    }

    private void createHandlerFromTemplate(RestTemplateNode restTemplateNode) {
        RestTemplate restTemplate = restTemplateNode.getTemplate();
        HashMap hashMap = restTemplate.getResourceHandlers();
        if (hashMap != null && !hashMap.isEmpty()) {
            RestResourceHandler restResourceHandler = null;
            for (RestResourceHandler.HTTP_METHOD_TYPE hTTP_METHOD_TYPE : hashMap.keySet()) {
                restResourceHandler = (RestResourceHandler)hashMap.get(hTTP_METHOD_TYPE);
                if (restResourceHandler == null) continue;
                RestHandlerNode restHandlerNode = new RestHandlerNode(restResourceHandler);
                restHandlerNode.setTemplateURI(restTemplate.getURIPattern());
                restHandlerNode.setModuleURI(restTemplateNode.getParentURIPrefix());
                this.createNode(restTemplateNode, restHandlerNode);
            }
        }
    }

    private void createHandler(Context context, RestResourceHandler.HTTP_METHOD_TYPE hTTP_METHOD_TYPE) {
        this._methodType = hTTP_METHOD_TYPE;
        RestHandlerNode restHandlerNode = (RestHandlerNode)this.create(context);
        if (restHandlerNode != null) {
            RestTemplate restTemplate = ((RestTemplateNode)context.getNode()).getTemplate();
            restHandlerNode.setTemplateURI(restTemplate.getURIPattern());
            restHandlerNode.setModuleURI(((RestTemplateNode)context.getNode()).getParentURIPrefix());
            restTemplate.addResourceHandler(hTTP_METHOD_TYPE, restHandlerNode.getHandler());
            RestHandlerEditorNode restHandlerEditorNode = new RestHandlerEditorNode(restHandlerNode);
            this.showEditor(restHandlerEditorNode, false);
        }
    }

    private void createNode(RestFolder restFolder, RestFolder restFolder2) {
        try {
            restFolder2.setURL(new URL(restFolder.getURL() + "/" + restFolder2.getShortLabel()));
            restFolder.add((Element)restFolder2);
            UpdateMessage.fireChildAdded((Subject)restFolder, (Element)restFolder2);
            restFolder.markDirty(false);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private RestFolder create(Context context) {
        RestBaseDialog restBaseDialog = null;
        if (context.getNode() instanceof RestTemplateNode) {
            restBaseDialog = new RestResourceHandlerDialog(this._methodType);
        } else if (context.getNode() instanceof RestSecurityFolder) {
            restBaseDialog = new RestSecurityDialog(null, RestUtils.getPrivilegeNames(null), RestUtils.getRoles(), RestUtils.getModuleNames(null));
        } else {
            return null;
        }
        RestFolder restFolder = null;
        if (restBaseDialog.runDialog() && restBaseDialog.getObject() != null) {
            RestFolder restFolder2 = (RestFolder)context.getNode();
            if (context.getNode() instanceof RestTemplateNode) {
                restFolder = new RestHandlerNode((RestResourceHandler)restBaseDialog.getObject());
            } else if (context.getNode() instanceof RestSecurityFolder) {
                restFolder = new RestSecurityNode((RestPrivilege)restBaseDialog.getObject());
                if (!_loaded) {
                    _loaded = true;
                }
            }
            this.createNode(restFolder2, restFolder);
            return restFolder;
        }
        return restFolder;
    }

    private boolean edit(Context context) {
        RestFolder restFolder = null;
        RestFolder restFolder2 = null;
        RestBaseDialog restBaseDialog = null;
        if (context.getNode() instanceof RestModuleNode) {
            restFolder = (RestModuleNode)context.getNode();
            restFolder2 = this.getParentNode(context);
            restBaseDialog = new RestModuleDialog((RestModule)restFolder.getUserObject(), RestUtils.getModuleNames(((RestModule)restFolder.getUserObject()).getName()), RestUtils.getModuleUriPrefixes(((RestModule)restFolder.getUserObject()).getURIPrefix()));
        } else if (context.getNode() instanceof RestTemplateNode) {
            restFolder = (RestTemplateNode)context.getNode();
            restFolder2 = this.getParentNode(context);
            restBaseDialog = new RestTemplateDialog((RestTemplate)restFolder.getUserObject(), RestUtils.getExistingURIs(restFolder2, ((RestTemplate)restFolder.getUserObject()).getURIPattern()), ((RestModule)restFolder2.getUserObject()).getURIPrefix());
        } else if (context.getNode() instanceof RestHandlerNode) {
            restFolder = (RestHandlerNode)context.getNode();
            restBaseDialog = new RestResourceHandlerDialog((RestResourceHandler)restFolder.getUserObject());
        } else if (context.getNode() instanceof RestSecurityNode) {
            restFolder = (RestSecurityNode)context.getNode();
            restFolder2 = this.getParentNode(context);
            restBaseDialog = new RestSecurityDialog((RestPrivilege)restFolder.getUserObject(), RestUtils.getPrivilegeNames(((RestPrivilege)restFolder.getUserObject()).getName()), RestUtils.getRoles(), RestUtils.getModuleNames(null));
        } else {
            return false;
        }
        String string = restFolder.getShortLabel();
        String string2 = null;
        if (context.getNode() instanceof RestModuleNode && ((RestModuleNode)restFolder).getModule() != null) {
            string2 = ((RestModuleNode)restFolder).getModule().getURIPrefix();
        }
        if (restBaseDialog.runDialog() && restBaseDialog.getObject() != null) {
            String string3;
            restFolder.setUserObject(restBaseDialog.getObject());
            String string4 = restFolder.getShortLabel();
            boolean bl = ModelUtil.areDifferent((Object)string, (Object)string4);
            if (bl) {
                try {
                    restFolder.setURL(new URL(this.getParentURL(context) + "/" + restFolder.getShortLabel()));
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
                }
                if (context.getNode() instanceof RestTemplateNode) {
                    this.handleURIPrefixRename(restFolder);
                }
                UpdateMessage.fireStructureChanged((Subject)restFolder);
                UpdateMessage.fireObjectRenamed((Subject)restFolder);
            } else {
                UpdateMessage.fireStructureChanged((Subject)restFolder);
            }
            restFolder.markDirty(false);
            boolean bl2 = false;
            if (context.getNode() instanceof RestModuleNode && (bl2 = ModelUtil.areDifferent((Object)string2, (Object)(string3 = ((RestModuleNode)restFolder).getModule().getURIPrefix())))) {
                this.handleURIPrefixRename(restFolder);
            }
            return true;
        }
        return false;
    }

    private void delete(final Context context) {
        boolean bl;
        String string = "";
        final Node node = context.getNode();
        String string2 = null;
        if (node instanceof RestModuleNode) {
            string = RestArb.getString("LABEL_MODULE");
            if (((RestModuleNode)node).getUserObject().getURL() != null && RestConnection.getInstance().isConnectionOpen()) {
                string2 = RestArb.format("DELETE_ON_SERVER", string, node.getShortLabel()) + "\n" + RestArb.format("DELETE_CONFIRMATION", string, node.getShortLabel());
            }
        } else if (node instanceof RestTemplateNode) {
            string = RestArb.getString("LABEL_TEMPLATE");
        } else if (node instanceof RestHandlerNode) {
            string = RestArb.getString("LABEL_RESOURCE_HANDLER");
        } else if (node instanceof RestSecurityNode) {
            string = RestArb.getString("LABEL_PRIVILEGE");
            if (((RestSecurityNode)node).getSecurity().getURL() != null && RestConnection.getInstance().isConnectionOpen()) {
                string2 = RestArb.format("DELETE_ON_SERVER", string, node.getShortLabel()) + "\n" + RestArb.format("DELETE_CONFIRMATION", string, node.getShortLabel());
            }
        } else {
            return;
        }
        if (string2 == null) {
            string2 = RestArb.format("DELETE_CONFIRMATION", string, node.getShortLabel());
        }
        if (bl = MessageDialog.confirm(null, string2, (String)RestArb.format("DELETE_TITLE", string), null)) {
            class DeleteHandler
            extends RESTHandler<Boolean> {
                String _restType;

                DeleteHandler(String string) {
                    this._restType = string;
                }

                protected void successImpl() {
                }

                @Override
                protected void handleTaskFinished(Boolean bl) {
                    if (Boolean.TRUE.equals(bl)) {
                        this.successImpl();
                        RestNavigatorController.this.removeFromParent(node, restFolder);
                        RestNavigatorController.this.checkRESTfulDataExists();
                    } else {
                        String string = node instanceof RestModuleNode ? ((RestModuleNode)node).getUserObject().getName() : ((RestSecurityNode)node).getSecurity().getName();
                        String string2 = RestArb.format("ERROR_DELETE", this._restType, string);
                        if (RestConnection.getInstance().getErrorMessage() != null) {
                            string2 = string2 + "\n" + RestConnection.getInstance().getErrorMessage();
                        }
                        MessageDialog.error(null, (Object)string2, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                    }
                }
            }
            final RestFolder restFolder = this.getParentNode(context);
            if (node instanceof RestModuleNode) {
                final RestModule restModule = ((RestModuleNode)node).getUserObject();
                DeleteHandler deleteHandler = new DeleteHandler(string){
                    {
                        super(RestNavigatorController.this, string, node2, restFolder2);
                    }

                    @Override
                    protected void successImpl() {
                        RestNavigatorController.this.removeModuleChildren(context);
                    }
                };
                if (!RestUtils.emptyValue(restModule.getURL()) && RestConnection.getInstance().isConnectionOpen()) {
                    this.startTask(new RESTTask<Boolean>(RestArb.getString("TASK_DELETE_MODULE")){

                        protected Boolean doWork() throws TaskException {
                            return RestConnection.getInstance().delete(restModule.getURL(), restModule.getEntityTag(), restModule.getName());
                        }
                    }, deleteHandler);
                } else {
                    deleteHandler.handleTaskFinished(Boolean.TRUE);
                }
            } else if (node instanceof RestSecurityNode) {
                final RestPrivilege restPrivilege = ((RestSecurityNode)node).getSecurity();
                DeleteHandler deleteHandler = new DeleteHandler(string);
                if (!RestUtils.emptyValue(restPrivilege.getURL()) && RestConnection.getInstance().isConnectionOpen()) {
                    this.startTask(new RESTTask<Boolean>(RestArb.getString("TASK_DELETE_PRIV")){

                        protected Boolean doWork() throws TaskException {
                            return RestConnection.getInstance().delete(restPrivilege.getURL(), restPrivilege.getEntityTag(), restPrivilege.getName());
                        }
                    }, deleteHandler);
                } else {
                    deleteHandler.handleTaskFinished(Boolean.TRUE);
                }
            } else {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                if (node instanceof RestTemplateNode) {
                    RestTemplateNode restTemplateNode = (RestTemplateNode)node;
                    this.buildHandlerNodeIdList(restTemplateNode, arrayList);
                    this.removeChildren(restTemplateNode);
                    RestModule restModule = ((RestModuleNode)restFolder).getModule();
                    restModule.removeTemplate(restTemplateNode.getUserObject());
                } else if (node instanceof RestHandlerNode) {
                    Integer n = new Integer(((RestHandlerNode)node).getNodeId());
                    arrayList.add(n);
                    RestTemplate restTemplate = ((RestTemplateNode)restFolder).getUserObject();
                    restTemplate.removeResourceHandler(((RestHandlerNode)node).getMethodType());
                }
                if (!arrayList.isEmpty()) {
                    this.removeEditors(arrayList);
                }
                this.removeFromParent(node, restFolder);
            }
        }
    }

    private void removeFromParent(Node node, RestFolder restFolder) {
        restFolder.remove((Element)node);
        UpdateMessage.fireChildRemoved((Subject)restFolder, (Element)node);
        restFolder.markDirty(false);
    }

    private void removeModuleChildren(Context context) {
        RestModuleNode restModuleNode = (RestModuleNode)context.getNode();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = restModuleNode.getChildren();
        if (iterator != null) {
            RestTemplateNode restTemplateNode;
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                restTemplateNode = (RestTemplateNode)((Object)iterator2.next());
                this.buildHandlerNodeIdList(restTemplateNode, arrayList);
            }
            if (!arrayList.isEmpty()) {
                this.removeEditors(arrayList);
            }
            iterator2 = iterator = restModuleNode.getChildren();
            while (iterator2.hasNext()) {
                restTemplateNode = (RestTemplateNode)((Object)iterator2.next());
                this.removeChildren(restTemplateNode);
                restTemplateNode.delete();
            }
        }
    }

    private void removeChildren(RestFolder restFolder) {
        Iterator iterator = restFolder.getChildren();
        if (iterator != null) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                RestFolder restFolder2 = (RestFolder)((Object)iterator2.next());
                restFolder2.delete();
            }
        }
    }

    private List<Integer> buildHandlerNodeIdList(RestTemplateNode restTemplateNode, List<Integer> list) {
        Iterator iterator;
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        if ((iterator = restTemplateNode.getChildren()) != null) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                RestHandlerNode restHandlerNode = (RestHandlerNode)((Object)iterator2.next());
                list.add(new Integer(restHandlerNode.getNodeId()));
            }
        }
        return list;
    }

    private void removeEditors(List<Integer> list) {
        this.removeEditors(list, false);
    }

    private void removeEditors(List<Integer> list, boolean bl) {
        List list2 = EditorManager.getEditorManager().getAllEditors();
        ArrayList<RestHandlerEditor> arrayList = new ArrayList<RestHandlerEditor>();
        for (Editor editor : list2) {
            if (!(editor instanceof RestHandlerEditor)) continue;
            RestHandlerEditor restHandlerEditor = (RestHandlerEditor)editor;
            if (!bl && (list == null || !list.contains(new Integer(restHandlerEditor.getNodeId())))) continue;
            arrayList.add(restHandlerEditor);
        }
        if (!arrayList.isEmpty()) {
            EditorManager.getEditorManager().closeEditors(arrayList);
        }
    }

    private void saveEditors() {
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            if (!(editor instanceof RestHandlerEditor)) continue;
            RestHandlerEditor restHandlerEditor = (RestHandlerEditor)editor;
            restHandlerEditor.saveResourceHandler();
        }
    }

    private RestHandlerEditor openEditor(RestHandlerNode restHandlerNode, boolean bl) {
        if (!(restHandlerNode instanceof RestHandlerNode)) {
            return null;
        }
        RestHandlerEditorNode restHandlerEditorNode = null;
        boolean bl2 = false;
        List list = EditorManager.getEditorManager().getAllEditors();
        if (!bl && list.size() > 0) {
            RestEditor restEditor = null;
            boolean bl3 = false;
            for (Editor editor : list) {
                if (!(editor instanceof RestHandlerEditor)) continue;
                RestHandlerEditor restHandlerEditor = (RestHandlerEditor)editor;
                if (restHandlerEditor.getNodeId() == restHandlerNode.getNodeId()) {
                    restEditor = restHandlerEditor;
                    bl3 = true;
                    break;
                }
                if (restHandlerEditor.isPinned() || restEditor != null) continue;
                restEditor = restHandlerEditor;
            }
            if (restEditor != null) {
                restHandlerEditorNode = (RestHandlerEditorNode)restEditor.getNode();
                if (!bl3) {
                    ((RestHandlerEditor)restEditor).saveResourceHandler();
                    restHandlerEditorNode.setViewedObject(restHandlerNode);
                    bl2 = true;
                }
            }
        }
        if (restHandlerEditorNode == null) {
            restHandlerEditorNode = new RestHandlerEditorNode(restHandlerNode);
        }
        return this.showEditor(restHandlerEditorNode, bl2);
    }

    private RestHandlerEditor showEditor(RestHandlerEditorNode restHandlerEditorNode, boolean bl) {
        Context context = Context.newIdeContext((Node)restHandlerEditorNode);
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        openEditorOptions.setFlags(5);
        RestHandlerEditor restHandlerEditor = (RestHandlerEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
        if (bl) {
            restHandlerEditor.refresh();
        }
        return restHandlerEditor;
    }

    public RestFolder getParentNode(Context context) {
        NavigatorTreeNode navigatorTreeNode;
        RestFolder restFolder = null;
        NavigatorTreeNode navigatorTreeNode2 = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        if (navigatorTreeNode2 != null && (navigatorTreeNode = (NavigatorTreeNode)navigatorTreeNode2.getParent()) != null) {
            restFolder = (RestFolder)navigatorTreeNode.getElement();
        }
        return restFolder;
    }

    private URL getParentURL(Context context) {
        RestFolder restFolder = this.getParentNode(context);
        return restFolder != null ? restFolder.getURL() : null;
    }

    private void handleURIPrefixRename(RestFolder restFolder) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (restFolder instanceof RestModuleNode) {
            Iterator iterator;
            RestModuleNode restModuleNode = (RestModuleNode)restFolder;
            Iterator iterator2 = iterator = restModuleNode.getChildren();
            while (iterator2.hasNext()) {
                Iterator iterator3;
                RestTemplateNode restTemplateNode = (RestTemplateNode)((Object)iterator2.next());
                restTemplateNode.setParentURIPrefix(restModuleNode.getModule().getURIPrefix());
                Iterator iterator4 = iterator3 = restTemplateNode.getChildren();
                while (iterator4.hasNext()) {
                    RestHandlerNode restHandlerNode = (RestHandlerNode)((Object)iterator4.next());
                    restHandlerNode.setModuleURI(restModuleNode.getModule().getURIPrefix());
                    arrayList.add(new Integer(restHandlerNode.getNodeId()));
                }
            }
        } else if (restFolder instanceof RestTemplateNode) {
            Iterator iterator;
            RestTemplateNode restTemplateNode = (RestTemplateNode)restFolder;
            Iterator iterator5 = iterator = restTemplateNode.getChildren();
            while (iterator5.hasNext()) {
                RestHandlerNode restHandlerNode = (RestHandlerNode)((Object)iterator5.next());
                restHandlerNode.setTemplateURI(restTemplateNode.getTemplate().getURIPattern());
                arrayList.add(new Integer(restHandlerNode.getNodeId()));
            }
        } else {
            return;
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            this.renameEditors(arrayList);
        }
    }

    private void renameEditors(List<Integer> list) {
        List list2 = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list2) {
            RestHandlerEditor restHandlerEditor;
            if (!(editor instanceof RestHandlerEditor) || !list.contains(new Integer((restHandlerEditor = (RestHandlerEditor)editor).getNodeId()))) continue;
            UpdateMessage.fireObjectRenamed((Subject)restHandlerEditor.getNode());
        }
    }

    public void attachMouseListener(CustomTree customTree) {
        customTree.addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                CustomTree customTree;
                NavigatorTreeNode navigatorTreeNode;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK").booleanValue() || mouseEvent.getClickCount() == 2) && mouseEvent.getSource() instanceof CustomTree && (navigatorTreeNode = (NavigatorTreeNode)(customTree = (CustomTree)mouseEvent.getSource()).getLastSelectedPathComponent()) != null && navigatorTreeNode.getElement() != null && navigatorTreeNode.getElement() instanceof RestHandlerNode) {
                    WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                    try {
                        waitCursor.show();
                        RestNavigatorController.this.openEditor((RestHandlerNode)navigatorTreeNode.getElement(), false);
                    }
                    finally {
                        waitCursor.hide();
                    }
                }
            }
        });
    }

    private void checkRESTfulDataExists() {
        _loaded = !RestUtils.getModules().isEmpty() || !RestUtils.getPrivileges().isEmpty();
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        block22: {
            int n = ideAction.getCommandId();
            try {
                if (n == CONNECT_ID) {
                    this.restConnect();
                    break block22;
                }
                if (n == DISCONNECT_ID) {
                    this.restDisconnect();
                    break block22;
                }
                if (n == RETRIEVE_ADMIN_ID) {
                    this.retrieveRESTfulServices();
                    break block22;
                }
                if (n == UPLOAD_ADMIN_ID) break block22;
                if (n == OPEN_FILE_ID) {
                    this.openRESTfulServices();
                    break block22;
                }
                if (n == SAVE_FILE_ID) {
                    this.saveRESTfulServices();
                    break block22;
                }
                if (n == NEW_ADMIN_ID) {
                    this.newRESTfulServices();
                    break block22;
                }
                if (n == NEW_PRIVILEGE_ID) {
                    this.create(context);
                    break block22;
                }
                if (n == NEW_MODULE_ID) {
                    this.createModuleViaWizard(context);
                    break block22;
                }
                if (n == ADD_TEMPLATE_ID) {
                    this.createTemplate(context);
                    break block22;
                }
                if (n == ADD_GET_HANDLER_ID) {
                    this.createHandler(context, RestResourceHandler.HTTP_METHOD_TYPE.GET);
                    break block22;
                }
                if (n == ADD_POST_HANDLER_ID) {
                    this.createHandler(context, RestResourceHandler.HTTP_METHOD_TYPE.POST);
                    break block22;
                }
                if (n == ADD_PUT_HANDLER_ID) {
                    this.createHandler(context, RestResourceHandler.HTTP_METHOD_TYPE.PUT);
                    break block22;
                }
                if (n == ADD_DELETE_HANDLER_ID) {
                    this.createHandler(context, RestResourceHandler.HTTP_METHOD_TYPE.DELETE);
                    break block22;
                }
                if (n == EDIT_ID) {
                    this.edit(context);
                    break block22;
                }
                if (n == DELETE_ID) {
                    this.delete(context);
                    break block22;
                }
                if (n == UPLOAD_ID) {
                    this.upload(context);
                    break block22;
                }
                if (n == RETRIEVE_ID) {
                    this.retrieve(context);
                    break block22;
                }
                if (n == OPEN_ID) {
                    this.openEditor((RestHandlerNode)context.getNode(), false);
                    break block22;
                }
                if (n == VALIDATE_ADMIN_ID) {
                    this.validateRESTfulServices();
                    break block22;
                }
                if (n == VALIDATE_ID) {
                    this.validate(context, true);
                    break block22;
                }
                return false;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        try {
            if (context.getView() instanceof RestNavigatorWindow) {
                boolean bl2 = this.isTaskRunning();
                int n = ideAction.getCommandId();
                if (n == CONNECT_ID) {
                    ideAction.setEnabled(!RestConnection.getInstance().isConnectionOpen());
                } else if (n == DISCONNECT_ID) {
                    ideAction.setEnabled(RestConnection.getInstance().isConnectionOpen());
                } else if (n == RETRIEVE_ADMIN_ID) {
                    ideAction.setEnabled(RestConnection.getInstance().isConnectionOpen());
                } else if (n == UPLOAD_ADMIN_ID) {
                    ideAction.setEnabled(false);
                } else if (n == VALIDATE_ADMIN_ID) {
                    ideAction.setEnabled(_loaded);
                } else if (n == RETRIEVE_ID) {
                    if (context.getNode() instanceof RestModuleNode) {
                        RestModule restModule = ((RestModuleNode)context.getNode()).getModule();
                        boolean bl3 = !bl2 && restModule != null && !RestUtils.emptyValue(restModule.getURL()) && RestConnection.getInstance().isConnectionOpen();
                        ideAction.setEnabled(bl3);
                    } else if (context.getNode() instanceof RestSecurityNode) {
                        RestPrivilege restPrivilege = ((RestSecurityNode)context.getNode()).getUserObject();
                        boolean bl4 = !bl2 && restPrivilege != null && !RestUtils.emptyValue(restPrivilege.getURL()) && RestConnection.getInstance().isConnectionOpen();
                        ideAction.setEnabled(bl4);
                    }
                } else if (n == UPLOAD_ID) {
                    ideAction.setEnabled(!bl2 && RestConnection.getInstance().isConnectionOpen());
                } else if (n == VALIDATE_ID) {
                    if (context.getNode() instanceof RestModuleNode) {
                        RestModule restModule = ((RestModuleNode)context.getNode()).getModule();
                        ideAction.setEnabled(restModule != null);
                    } else if (context.getNode() instanceof RestSecurityNode) {
                        ideAction.setEnabled(true);
                    }
                } else if (n == SAVE_FILE_ID) {
                    ideAction.setEnabled(_loaded);
                } else if (context.getNode() instanceof RestTemplateNode) {
                    RestTemplate restTemplate = ((RestTemplateNode)context.getNode()).getUserObject();
                    if (restTemplate != null) {
                        if (n == ADD_GET_HANDLER_ID) {
                            ideAction.setEnabled(!restTemplate.handlerExists(RestResourceHandler.HTTP_METHOD_TYPE.GET));
                        } else if (n == ADD_POST_HANDLER_ID) {
                            ideAction.setEnabled(!restTemplate.handlerExists(RestResourceHandler.HTTP_METHOD_TYPE.POST));
                        } else if (n == ADD_PUT_HANDLER_ID) {
                            ideAction.setEnabled(!restTemplate.handlerExists(RestResourceHandler.HTTP_METHOD_TYPE.PUT));
                        } else if (n == ADD_DELETE_HANDLER_ID) {
                            ideAction.setEnabled(!restTemplate.handlerExists(RestResourceHandler.HTTP_METHOD_TYPE.DELETE));
                        }
                    }
                } else if (n == DELETE_ID) {
                    ideAction.setEnabled(!bl2);
                }
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void startTask(final RESTTask<T> rESTTask, final RESTHandler<T> rESTHandler) {
        rESTTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                try {
                    rESTHandler.handleCancel();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
                }
                RestNavigatorController.this.clearTask();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                try {
                    rESTHandler.handleFailure();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
                }
                RestNavigatorController.this.clearTask();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    final Object object = rESTTask.getResult();
                    if (object != null) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                rESTHandler.handleTaskFinished(object);
                            }
                        };
                        if (SwingUtilities.isEventDispatchThread()) {
                            runnable.run();
                        } else {
                            SwingUtilities.invokeLater(runnable);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
                }
                RestNavigatorController.this.clearTask();
            }
        });
        Object object = this.taskLock;
        synchronized (object) {
            RaptorTaskManager.getInstance().addTask(rESTTask);
            this._backgroundTask = rESTTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTaskRunning() {
        Object object = this.taskLock;
        synchronized (object) {
            return this._backgroundTask != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTask() {
        Object object = this.taskLock;
        synchronized (object) {
            this._backgroundTask = null;
        }
    }

    static {
        _loaded = false;
        _imported = false;
    }

    private static final class VoidHandler
    extends RESTHandler<Void> {
        private VoidHandler() {
        }

        @Override
        protected void handleTaskFinished(Void void_) {
        }
    }

    private static abstract class RESTHandler<V> {
        private RESTHandler() {
        }

        protected abstract void handleTaskFinished(V var1);

        protected void handleCancel() {
        }

        protected void handleFailure() {
        }
    }

    private static abstract class RESTTask<V>
    extends RaptorTask<V> {
        protected RESTTask(String string) {
            super(string, true, IRaptorTaskRunMode.MODAL_OPTIONAL);
            this.setCancellable(false);
            this.setPausable(false);
        }
    }
}

