/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.config.RestConfig;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.dbtools.rest.install.RestInstallController;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;

public class InstallWizSummaryPanel
extends DefaultTraversablePanel {
    private JTree _summary = new JTree();
    private RestInstallConstants.InstallType m_installType;
    private int m_installID;

    public InstallWizSummaryPanel() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this._summary.setCellRenderer(new NodeRenderer());
        jScrollPane.setViewportView(this._summary);
        this.add(jScrollPane, new GridBagConstraints(0, 0, 5, 5, 1.0, 1.0, 18, 1, new Insets(10, 8, 0, 0), 0, 0));
    }

    private void buildSummaryTree(TraversableContext traversableContext) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        this._summary.removeAll();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(RestArb.getString("WIZ_INSTALL_SUMMARY_ROOT"));
        Map map = (Map)traversableContext.get("ORDS_PARAMS");
        this.m_installType = (RestInstallConstants.InstallType)((Object)map.get("config.status"));
        this.m_installID = (Integer)map.get("INSTALL_ID");
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        DefaultMutableTreeNode defaultMutableTreeNode3 = this.getWarFileNode(map);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        String string = ((File)map.get("config.dir")).getPath();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.format(RestArb.getString("WIZ_SUMMARY_CONFIG_DIR"), string)));
        DefaultMutableTreeNode defaultMutableTreeNode4 = null;
        DefaultMutableTreeNode defaultMutableTreeNode5 = null;
        if (this.m_installID != RestInstallController.RUN_STANDALONE_CMD_ID) {
            defaultMutableTreeNode4 = this.getDBInfoNode(map2);
            defaultMutableTreeNode2.add(defaultMutableTreeNode4);
            defaultMutableTreeNode5 = this.getUpgradeeNode(map, map2);
            if (defaultMutableTreeNode5 != null) {
                defaultMutableTreeNode2.add(defaultMutableTreeNode5);
            }
        }
        if ((defaultMutableTreeNode = this.getStandAloneNode(map2)) != null) {
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        }
        this._summary.setModel(new DefaultTreeModel(defaultMutableTreeNode2));
        this._summary.expandPath(new TreePath(defaultMutableTreeNode3.getPath()));
        if (defaultMutableTreeNode4 != null) {
            this._summary.expandPath(new TreePath(defaultMutableTreeNode4.getPath()));
        }
        if (defaultMutableTreeNode5 != null) {
            this._summary.expandPath(new TreePath(defaultMutableTreeNode5.getPath()));
        }
        if (defaultMutableTreeNode != null) {
            this._summary.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    private DefaultMutableTreeNode getWarFileNode(Map<String, Object> map) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_WAR_FILE"));
        File file = (File)map.get("ords.warfile");
        String string = file != null ? file.getPath() : "";
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("WIZ_SUMMARY_WAR_FILE_NAME"), string)));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("WIZ_SUMMARY_WAR_VERSION"), (String)map.get("product.version"))));
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getDBInfoNode(Map<String, String> map) {
        boolean bl;
        DefaultMutableTreeNode defaultMutableTreeNode;
        String string;
        boolean bl2;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_DB_CONN"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.format(RestArb.getString("HOST"), map.get("db.hostname"))));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.format(RestArb.getString("PORT"), map.get("db.port"))));
        if (map.containsKey("db.sid")) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.format(RestArb.getString("SID"), map.get("db.sid"))));
        } else if (map.containsKey("db.servicename")) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.format(RestArb.getString("SERVICE_NAME"), map.get("db.servicename"))));
        }
        if (this.m_installType == RestInstallConstants.InstallType.REQUIRES_CONFIG && (bl2 = Boolean.valueOf(map.get("plsql.gateway.add")).booleanValue())) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.format(RestArb.getString("WIZ_SUMMARY_PLSQL_GATEWAY_USER"), map.get("db.username"))));
        }
        if ((string = map.get("installer")) != null) {
            if (string.equals("install")) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_CREATE_SCHEMA"));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(this.format(RestArb.getString("SCHEMA"), "ORDS_METADATA")));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(this.format(RestArb.getString("DEFAULT_TABLESPACE"), map.get("schema.tablespace.default"))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(this.format(RestArb.getString("TEMP_TABLESPACE"), map.get("schema.tablespace.temp"))));
                defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_CREATE_USER"));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("USER"), "ORDS_PUBLIC_USER")));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("DEFAULT_TABLESPACE"), map.get("user.tablespace.default"))));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("TEMP_TABLESPACE"), map.get("user.tablespace.temp"))));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
            } else if (string.equals("none")) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.format(RestArb.getString("WIZ_SUMMARY_SCHEMA_VERSION"), map.get("schema.version"))));
            } else {
                boolean bl3 = Boolean.valueOf(map.get("rest.services.ords.add"));
                if (!bl3) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(RestArb.getString("SKIP_INSTALL_SCHEMA")));
                }
            }
        }
        if (this.m_installType == RestInstallConstants.InstallType.REQUIRES_CONFIG) {
            boolean bl4 = Boolean.valueOf(map.get("rest.services.apex.add"));
            if (bl4) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_USE_APEX_REST"));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("USER"), map.get("user.name.apex.restpublic"))));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("USER"), map.get("user.name.apex.listener"))));
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
            } else {
                boolean bl5 = Boolean.valueOf(map.get("migrate.apex.rest"));
                if (bl5) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(RestArb.getString("WIZ_SUMMARY_MIGRATE_APEX_REST"), bl5)));
                }
            }
        } else if ((this.m_installType == RestInstallConstants.InstallType.MIGRATE_V2 || this.m_installType == RestInstallConstants.InstallType.VERIFY_SCHEMA) && string != null && string.equals("install") && (bl = Boolean.valueOf(map.get("migrate.apex.rest")).booleanValue())) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(RestArb.getString("WIZ_SUMMARY_MIGRATE_APEX_REST"), bl)));
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode getUpgradeeNode(Map<String, Object> map, Map<String, String> map2) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        String string = map2.get("installer");
        if (string != null && string.equals("upgrade")) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_UPGRADE_SCHEMA"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(RestArb.format("WIZ_SUMMARY_UPGRADE_FROM_TO", map2.get("schema.version"), map.get("product.version"))));
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getStandAloneNode(Map<String, String> map) {
        boolean bl = Boolean.valueOf(map.get("standalone.mode"));
        if (bl) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("WIZ_RUN_STANDALONE"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("HTTP_PORT"), map.get("standalone.http.port"))));
            if (map.containsKey("standalone.static.images")) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("WIZ_APEX_IMAGE_DIR2"), map.get("standalone.static.images"))));
            }
            if (this.m_installType == RestInstallConstants.InstallType.REQUIRES_CONFIG) {
                if (map.containsKey("ords.admin.username")) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("ORDS_ADMIN"), map.get("ords.admin.username"))));
                }
                if (map.containsKey("ords.sqldev.username")) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("ORDS_USER"), map.get("ords.sqldev.username"))));
                }
                if (map.containsKey("security.verifySSL")) {
                    boolean bl2 = Boolean.parseBoolean(map.get("security.verifySSL"));
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getLabel(RestArb.getString("WIZ_VERIFY_SSL"), bl2)));
                }
            }
            return defaultMutableTreeNode;
        }
        return new DefaultMutableTreeNode(this.getLabel(RestArb.getString("WIZ_RUN_STANDALONE"), bl));
    }

    public JLabel getLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return jLabel;
    }

    public JLabel getLabel(String string) {
        JLabel jLabel = new JLabel();
        String string2 = string != null ? string : "";
        jLabel.setText(string2);
        return jLabel;
    }

    private String format(String string, String string2) {
        if (string2 != null && !string2.trim().isEmpty()) {
            return string + " " + string2;
        }
        return string;
    }

    public void onEntry(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 1) {
            this.buildSummaryTree(traversableContext);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            boolean bl;
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            if (this.m_installID != RestInstallController.RUN_STANDALONE_CMD_ID) {
                boolean bl2;
                boolean bl3;
                bl = Boolean.valueOf((String)map2.get("rest.services.ords.add"));
                if (!bl) {
                    map2.remove("user.public.password");
                }
                if (!(bl3 = Boolean.valueOf((String)map2.get("plsql.gateway.add")).booleanValue())) {
                    map2.remove("db.username");
                    map2.remove("db.password");
                }
                if (!(bl2 = Boolean.valueOf((String)map2.get("rest.services.apex.add")).booleanValue())) {
                    map2.remove("user.name.apex.listener");
                    map2.remove("user.apex.listener.password");
                    map2.remove("user.name.apex.restpublic");
                    map2.remove("user.apex.restpublic.password");
                }
            }
            if (bl = ((Boolean)map.get("use.sqldev.configdir")).booleanValue()) {
                String string = ((File)map.get("config.dir")).getPath();
                RestConfig.getInstance().setString("SQLDEV_ORDS_CONFIGDIR", string);
            }
        }
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

