/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.wizard.InstallDBAUserDialog;

public class InstallVerifySchemaDialog
extends InstallDBAUserDialog {
    private String m_schemaVersion;
    private String m_url;
    private boolean m_isRoot;

    public InstallVerifySchemaDialog() {
        super(RestArb.getString("VERIFY_ORDS_SCHEMA"), RestArb.getString("VERIFY_SCHEMA_DBA_PRIV_DESCRIP"), "install_verify_schema_dba_credentials_html");
    }

    public InstallVerifySchemaDialog(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public boolean checkSchema(String string) {
        this.m_url = string;
        return this.runDialog();
    }

    public String getSchemaVersion() {
        return this.m_schemaVersion;
    }

    public boolean isCDBRoot() {
        return this.m_isRoot;
    }

    @Override
    protected boolean validInfo() {
        if (super.validInfo()) {
            return this.verifySchemaVersion();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifySchemaVersion() {
        boolean bl = false;
        Connection connection = null;
        String string = InstallDBUtils.getDBAUsername(this.getUsername());
        try {
            connection = DriverManager.getConnection(this.m_url, string, new String(this.getPassword()));
            if (InstallDBUtils.isCDBRoot(connection)) {
                this.m_isRoot = true;
            }
            this.m_schemaVersion = InstallDBUtils.getORDSVersion(connection);
            if (InstallUtils.nullOrEmpty(this.m_schemaVersion)) {
                if (InstallDBUtils.userExist(connection, "ORDS_METADATA")) {
                    this.getErrMsg().append("\nThe ORDS version is null, but the ORDS_METADATA schema exists.");
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            if (this.getErrMsg().length() > 0) {
                this.getErrMsg().append("\n");
            }
            this.getErrMsg().append(RestArb.format("ERR_CONN_FAILED", string, this.m_url, sQLException.getLocalizedMessage()));
        }
        catch (Exception exception) {
            if (this.getErrMsg().length() > 0) {
                this.getErrMsg().append("\n");
            }
            this.getErrMsg().append(RestArb.format("ERR_CONN_FAILED", string, this.m_url, exception.getLocalizedMessage()));
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }
}

