/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.text;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.text.LabelGeometry;
import oracle.bali.ewt.text.LineInfo;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.text.NoWrapper;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;

public class MultiLineLabel
extends ScrollableComponent
implements Accessible {
    public static final int NOT_SET = -1;
    public static final int ALIGNMENT_DEFAULT = 0;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 3;
    public static final String PROPERTY_TEXT = "text";
    public static final float ASPECTRATIO_NONE = 0.0f;
    private boolean _useFullJustification;
    private float _preferredAspectRatio;
    private LabelGeometry _geometry;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private int _preferredRows = -1;
    private int _preferredColumns = -1;
    private boolean _foregroundDefaulted = true;
    private int _maximumColumns = -1;
    private int _maximumRows = -1;
    private int _minimumColumns = -1;
    private int _minimumRows = -1;
    private Dimension _originalPreferredSize;
    private Dimension _currentPreferredSize;
    private boolean _isVerticalShrinking = true;
    private boolean _forceFit;
    private static final String _ELLIPSIS = "...";

    public MultiLineLabel() {
        this("");
    }

    public MultiLineLabel(String text) {
        this(NoWrapper.getTextWrapper(), text);
    }

    public MultiLineLabel(TextWrapper wrapper, String text) {
        if (text == null) {
            text = "";
        }
        if (wrapper == null) {
            wrapper = NoWrapper.getTextWrapper();
        }
        this._geometry = new LabelGeometry(this, wrapper, text);
        this._preferredAspectRatio = 4.0f;
        this.setOpaque(false);
        this.updateUI();
    }

    public void setText(String label) {
        String newAccessibleName;
        String oldLabel;
        if (label == null) {
            label = "";
        }
        String oldAccessibleName = null;
        if (this.accessibleContext != null) {
            oldAccessibleName = this.accessibleContext.getAccessibleName();
        }
        if (label != (oldLabel = this.getText())) {
            this._originalPreferredSize = null;
        }
        this._geometry._setText(label);
        this.firePropertyChange(PROPERTY_TEXT, oldLabel, label);
        if (this.accessibleContext != null && (newAccessibleName = this.accessibleContext.getAccessibleName()) != oldAccessibleName) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldAccessibleName, newAccessibleName);
        }
    }

    public String getText() {
        return this._geometry._getText();
    }

    public void setTextWrapper(TextWrapper newWrapper) {
        if (newWrapper == null) {
            newWrapper = NoWrapper.getTextWrapper();
        }
        if (newWrapper != this.getTextWrapper()) {
            this._originalPreferredSize = null;
        }
        this._geometry._setTextWrapper(newWrapper);
        this.repaint();
    }

    public TextWrapper getTextWrapper() {
        return this._geometry._getTextWrapper();
    }

    public int getMaximumColumns() {
        return this._maximumColumns;
    }

    public void setMaximumColumns(int columns) {
        if (columns != this._maximumColumns) {
            this._maximumColumns = columns;
            this.invalidateCanvas();
        }
    }

    public int getMaximumRows() {
        return this._maximumRows;
    }

    public void setMaximumRows(int rows) {
        if (rows != this._maximumRows) {
            this._maximumRows = rows;
            this.invalidateCanvas();
        }
    }

    @Override
    public Dimension getMaximumSize() {
        return this._computeSize(super.getMaximumSize(), this._maximumRows, this._maximumColumns);
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
        if (maximumSize != null) {
            this._maximumRows = -1;
            this._maximumColumns = -1;
        }
        super.setMaximumSize(maximumSize);
    }

    public int getMinimumColumns() {
        return this._minimumColumns;
    }

    public void setMinimumColumns(int columns) {
        if (columns != this._minimumColumns) {
            this._minimumColumns = columns;
            this.invalidateCanvas();
        }
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        if (minimumSize != null) {
            this._minimumRows = -1;
            this._minimumColumns = -1;
        }
        super.setMinimumSize(minimumSize);
    }

    public int getMinimumRows() {
        return this._minimumRows;
    }

    public void setMinimumRows(int rows) {
        if (rows != this._minimumRows) {
            this._minimumRows = rows;
            this.invalidateCanvas();
        }
    }

    public void setPreferredColumns(int columns) {
        if (columns == this._preferredColumns) {
            return;
        }
        this._preferredColumns = columns;
        this._originalPreferredSize = null;
        this.invalidateMultiLineLabelCanvas();
    }

    public int getPreferredColumns() {
        return this._preferredColumns;
    }

    public void setPreferredRows(int rows) {
        if (rows == this._preferredRows) {
            return;
        }
        this._preferredRows = rows;
        this._originalPreferredSize = null;
        this.invalidateMultiLineLabelCanvas();
    }

    public int getPreferredRows() {
        return this._preferredRows;
    }

    public void setFullJustification(boolean useFullJustification) {
        if (this._useFullJustification != useFullJustification) {
            this._useFullJustification = useFullJustification;
            this.repaint();
        }
    }

    public boolean isFullyJustified() {
        return this._useFullJustification;
    }

    public void setPreferredAspectRatio(float preferredAspectRation) {
        if (this._preferredAspectRatio != preferredAspectRation) {
            this._preferredAspectRatio = preferredAspectRation;
            this._originalPreferredSize = null;
            this.invalidateMultiLineLabelCanvas();
        }
    }

    public float getPreferredAspectRatio() {
        return this._preferredAspectRatio;
    }

    public void setVerticalShrinking(boolean shrink) {
        if (this._isVerticalShrinking != shrink) {
            this._isVerticalShrinking = shrink;
            this.invalidateMultiLineLabelCanvas();
        }
    }

    public boolean isVerticalShrinking() {
        return this._isVerticalShrinking;
    }

    public void setForceWrapping(boolean forceFit) {
        if (forceFit != this._forceFit) {
            this._forceFit = forceFit;
            this._originalPreferredSize = null;
            this.invalidateMultiLineLabelCanvas();
        }
    }

    public boolean isForceWrapping() {
        return this._forceFit;
    }

    @Override
    public Color getForeground() {
        if (this._foregroundDefaulted) {
            return this.getPaintContext().getPaintUIDefaults().getColor("Label.foreground");
        }
        return super.getForeground();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this._foregroundDefaulted = false;
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        this._originalPreferredSize = null;
        this._geometry._setFontMetrics(this.getFontMetrics(this.getFont()));
    }

    @Override
    public void setLocale(Locale newLocale) {
        if (newLocale != LocaleUtils.getDefaultableLocale(this)) {
            super.setLocale(newLocale);
            this.invalidate();
        }
    }

    @Override
    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        boolean oldForegroundDefaulted = this._foregroundDefaulted;
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
        this._foregroundDefaulted = oldForegroundDefaulted;
    }

    @Override
    public void doLayout() {
        this._geometry._validate();
        super.doLayout();
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    @Override
    protected int getVMaximum() {
        return this._geometry.getLineCount();
    }

    @Override
    protected int getVOffsetOfValue(int value) {
        return -this._geometry.getFontMetrics().getHeight() * value;
    }

    @Override
    protected int getVValueOfOffset(int y) {
        return -y / this._geometry.getFontMetrics().getHeight();
    }

    @Override
    protected Dimension layoutCanvas() {
        if (this.getViewport() != null) {
            FontMetrics metrics = this._geometry.getFontMetrics();
            int canvasHt = 0;
            if (metrics != null) {
                canvasHt = this._geometry.getLineCount() * metrics.getHeight();
            }
            return new Dimension(Math.max(this.getInnerWidth(), this._geometry.getMaxPixelWidth()), canvasHt);
        }
        return new Dimension(this._getPreferredInnerSize());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._originalPreferredSize = null;
        this._geometry._setFontMetrics(this.getFontMetrics(this.getFont()));
    }

    @Override
    protected void paintCanvasInterior(Graphics g) {
        this._setWrapWidthOnGeometry();
        if (!this.isEnabled()) {
            UIDefaults defaults = this.getUIDefaults();
            g.setColor(defaults.getColor("controlLtHighlight"));
            g.translate(1, 1);
            this._paintCanvasInterior(g);
            g.setColor(defaults.getColor("controlInactiveText"));
            g.translate(-1, -1);
        }
        this._paintCanvasInterior(g);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension prefSize = this._getPreferredInnerSize();
        prefSize = this.convertInnerToOuterSize(prefSize.width, prefSize.height);
        return prefSize;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (!(this.getTextWrapper() instanceof NoWrapper)) {
            return true;
        }
        return super.getScrollableTracksViewportWidth();
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.isMinimumSizeSet() && this._minimumRows == -1 && this._minimumColumns == -1) {
            return this.getPreferredSize();
        }
        return this._computeSize(super.getMinimumSize(), this._minimumRows, this._minimumColumns);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiLineLabel();
        }
        return this.accessibleContext;
    }

    void invalidateMultiLineLabelCanvas() {
        this._currentPreferredSize = null;
        this.invalidateCanvas();
    }

    private Dimension _computeSize(Dimension base, int rows, int columns) {
        if (rows != -1 || columns != -1) {
            base = new Dimension(base);
            ImmInsets insets = this.getBorderInsets();
            FontMetrics metrics = this._geometry.getFontMetrics();
            if (metrics != null) {
                if (rows != -1) {
                    base.height = metrics.getHeight() * rows + (insets.top + insets.bottom);
                }
                if (columns != -1) {
                    base.width = FontUtils.getAverageWidth(this.getFont()) * columns + (insets.left + insets.right);
                }
            }
        }
        return base;
    }

    private void _paintCanvasInterior(Graphics g) {
        LabelGeometry geometry = this._geometry;
        FontMetrics metrics = geometry.getFontMetrics();
        int lineHt = metrics.getHeight();
        Rectangle drawRect = g.getClipBounds();
        if (drawRect.width == 0 || drawRect.height == 0) {
            return;
        }
        int currLine = drawRect.y / lineHt;
        if (currLine < 0) {
            currLine = 0;
        }
        int y = currLine * lineHt + metrics.getAscent() + metrics.getLeading();
        int lineCount = geometry.getLineCount();
        int wrapWidth = geometry.getWrapWidth();
        int bottom = drawRect.y + drawRect.height;
        int alignment = this.getActualAlignment();
        LineInfo currLineInfo = new LineInfo();
        int descent = metrics.getDescent();
        ImmInsets insets = this.getBorderInsets();
        int height = this.getHeight();
        height = Math.max(0, height - (insets.top + insets.bottom));
        int width = this.getWidth();
        width = Math.max(0, width - (insets.left + insets.right));
        while (currLine < lineCount && (y + descent <= height || currLine == 0)) {
            if ((currLineInfo = geometry.getLineInfo(currLine, currLineInfo)) == null) {
                return;
            }
            String currString = currLineInfo.text;
            if (y + descent + lineHt > height && currLine != lineCount - 1 || currLineInfo.pixelWidth > width) {
                int diff;
                if (currString == null) {
                    currString = "";
                }
                if ((diff = currLineInfo.pixelWidth + metrics.stringWidth(_ELLIPSIS) - wrapWidth) > 0) {
                    if (currLineInfo.pixelWidth > diff) {
                        int index;
                        for (index = currString.length() - 1; index >= 0 && diff > 0; diff -= metrics.charWidth(currString.charAt(index)), --index) {
                        }
                        currString = currString.substring(0, index + 1) + _ELLIPSIS;
                    } else {
                        currString = _ELLIPSIS;
                    }
                } else {
                    currString = currString + _ELLIPSIS;
                }
                currLineInfo.text = currString;
                currLineInfo.pixelWidth = metrics.stringWidth(currString);
            }
            if (currString != null) {
                if (this._useFullJustification && !currLineInfo.isNotWrapped) {
                    this._paintFullJustified(g, 0, y, currLineInfo);
                } else {
                    int deltaX = 0;
                    if (alignment != 1) {
                        deltaX = wrapWidth - currLineInfo.pixelWidth;
                        if (alignment == 3) {
                            deltaX >>= 1;
                        }
                    }
                    GraphicUtils.drawString(g, currString, deltaX, y);
                }
            }
            if (y > bottom) break;
            y += lineHt;
            ++currLine;
        }
    }

    private void _setWrapWidthOnGeometry() {
        boolean useCurrWidth = this.getPreferredRows() == -1 && this.getPreferredColumns() == -1 && this.getPreferredAspectRatio() == 0.0f ? true : this.isVerticalShrinking();
        int newWrapWidth = useCurrWidth ? this.getInnerWidth() : Math.min(this.getInnerWidth(), this._getOriginalPreferredSize().width);
        this._geometry._setWrapWidth(newWrapWidth);
    }

    private Dimension _getOriginalPreferredSize() {
        if (this._originalPreferredSize == null) {
            FontMetrics metrics;
            Dimension preferredSize = new Dimension(0, 0);
            Font f = this.getFont();
            FontMetrics fontMetrics = metrics = f == null ? null : this.getFontMetrics(f);
            if (metrics != null) {
                int lineCount;
                int stringWidth = metrics.stringWidth(this.getText());
                int lineHeight = metrics.getHeight();
                int width = 0;
                int avgWidth = FontUtils.getAverageWidth(metrics);
                int preferredColumns = this._preferredColumns;
                if (preferredColumns == -1 && this._preferredRows == -1) {
                    float aspectRatio = this.getPreferredAspectRatio();
                    int innerWidth = this.getInnerWidth();
                    if (aspectRatio == 0.0f && innerWidth == 0) {
                        aspectRatio = 4.0f;
                    }
                    width = aspectRatio != 0.0f ? (int)Math.sqrt((float)stringWidth * (float)lineHeight * aspectRatio) + 1 : innerWidth;
                } else {
                    if (preferredColumns != -1) {
                        width = avgWidth * preferredColumns;
                    }
                    if (this._preferredRows != -1) {
                        preferredSize.height = this._preferredRows * lineHeight;
                        if (preferredColumns == -1) {
                            int newLineCount = 0;
                            int i = 0;
                            while ((i = this.getText().indexOf(10, i) + 1) > 0) {
                                ++newLineCount;
                            }
                            if (newLineCount + 1 >= this._preferredRows) {
                                preferredColumns = width = Integer.MAX_VALUE;
                            } else {
                                width = stringWidth / this._preferredRows * 21 / 20;
                            }
                        }
                    }
                }
                boolean wasBig = false;
                do {
                    LabelGeometry preferredGeometry = new LabelGeometry(this, this.getTextWrapper(), this.getText(), metrics, width, true);
                    preferredSize.width = preferredGeometry.getMaxPixelWidth();
                    lineCount = preferredGeometry.getLineCount();
                    if (preferredColumns != -1 || this._preferredRows == -1) break;
                    if (this._preferredRows < lineCount) {
                        width += avgWidth;
                        wasBig = true;
                        continue;
                    }
                    if (this._preferredRows <= lineCount || wasBig) break;
                    width -= avgWidth;
                } while (width > 0);
                preferredSize.height = Math.max(preferredSize.height, lineCount * lineHeight);
            }
            this._originalPreferredSize = preferredSize;
        }
        return this._originalPreferredSize;
    }

    private Dimension _getPreferredInnerSize() {
        if (this._currentPreferredSize == null) {
            boolean canUseCurrentWidth;
            FontMetrics metrics;
            Dimension prefSize = new Dimension(0, 0);
            boolean useOriginalSize = this._originalPreferredSize == null;
            Dimension d = this._getOriginalPreferredSize();
            int innerWidth = this.getInnerWidth();
            Font f = this.getFont();
            FontMetrics fontMetrics = metrics = f == null ? null : this.getFontMetrics(f);
            boolean bl = useOriginalSize ? false : (canUseCurrentWidth = this.getPreferredRows() == -1 && this.getPreferredColumns() == -1 && this.getPreferredAspectRatio() == 0.0f || innerWidth > d.width && this.isVerticalShrinking());
            if (canUseCurrentWidth && metrics != null && innerWidth != 0) {
                LabelGeometry prefGeometry = new LabelGeometry(this, this.getTextWrapper(), this.getText(), metrics, innerWidth, true);
                prefSize.width = prefGeometry.getMaxPixelWidth();
                prefSize.height = prefGeometry.getLineCount() * metrics.getHeight();
            } else {
                prefSize.width = d.width;
                prefSize.height = d.height;
            }
            this._currentPreferredSize = prefSize;
        }
        return this._currentPreferredSize;
    }

    private static int _getWhiteSpacePixels(FontMetrics metrics, char[] textChars, int firstIndex, int lastIndex) {
        int totalWhiteSpace = 0;
        for (int currIndex = firstIndex; currIndex <= lastIndex; ++currIndex) {
            char currChar = textChars[currIndex];
            if (!Character.isWhitespace(currChar)) continue;
            totalWhiteSpace += metrics.charWidth(currChar);
        }
        return totalWhiteSpace;
    }

    private static int _getFirstNonWhiteSpaceIndex(char[] textChars) {
        int currIndex;
        int numChars = textChars.length;
        for (currIndex = 0; currIndex < numChars && Character.isWhitespace(textChars[currIndex]); ++currIndex) {
        }
        return currIndex;
    }

    private int _getLastNonWhiteSpaceIndex(char[] textChars) {
        int currIndex;
        for (currIndex = textChars.length - 1; currIndex >= 0 && Character.isWhitespace(textChars[currIndex]); --currIndex) {
        }
        return currIndex;
    }

    private void _paintFullJustified(Graphics g, int x, int y, LineInfo currLineInfo) {
        LabelGeometry geometry = this._geometry;
        String lineString = currLineInfo.text;
        char[] textChars = lineString.toCharArray();
        int numChars = textChars.length;
        int firstIndex = MultiLineLabel._getFirstNonWhiteSpaceIndex(textChars);
        if (firstIndex == numChars) {
            return;
        }
        int lastIndex = this._getLastNonWhiteSpaceIndex(textChars);
        int slop = geometry.getWrapWidth() - currLineInfo.pixelWidth;
        if (slop == 0 && firstIndex == 0 && lastIndex == numChars - 1) {
            GraphicUtils.drawString(g, lineString, x, y);
        } else {
            int whiteSpace;
            float multiplier;
            FontMetrics metrics = geometry.getFontMetrics();
            if (firstIndex != 0) {
                int frontExteriorWhiteSpace = metrics.charsWidth(textChars, 0, firstIndex);
                if (currLineInfo.isNewParagraph) {
                    x += frontExteriorWhiteSpace;
                } else {
                    slop += frontExteriorWhiteSpace;
                }
            }
            if (lastIndex != numChars - 1) {
                slop += metrics.charsWidth(textChars, lastIndex + 1, numChars - (lastIndex + 1));
            }
            if ((multiplier = (float)slop / (float)(whiteSpace = MultiLineLabel._getWhiteSpacePixels(metrics, textChars, firstIndex, lastIndex)) + 1.0f) < 0.0f) {
                multiplier = 0.0f;
            }
            whiteSpace += slop;
            float error = 0.0f;
            boolean collectWhiteSpace = false;
            int currIndex = firstIndex;
            int nextIndex = firstIndex;
            int charIndex = firstIndex;
            while (currIndex <= lastIndex) {
                if (collectWhiteSpace) {
                    float scaledSpace;
                    int advance;
                    while (Character.isWhitespace(textChars[nextIndex])) {
                        if (++nextIndex <= lastIndex) continue;
                        g.drawChars(textChars, charIndex, nextIndex - charIndex, x += whiteSpace, y);
                        return;
                    }
                    int spaceWidth = metrics.charsWidth(textChars, currIndex, nextIndex - currIndex);
                    if (spaceWidth != (advance = (int)(scaledSpace = (float)spaceWidth * multiplier + error))) {
                        if (charIndex != currIndex) {
                            g.drawChars(textChars, charIndex, currIndex - charIndex, x, y);
                            x += metrics.charsWidth(textChars, charIndex, currIndex - charIndex);
                        }
                        x += advance;
                        currIndex = nextIndex;
                        charIndex = nextIndex;
                    }
                    whiteSpace -= advance;
                    error = scaledSpace - (float)advance;
                } else {
                    while (!Character.isWhitespace(textChars[nextIndex])) {
                        if (++nextIndex <= lastIndex) continue;
                        g.drawChars(textChars, charIndex, nextIndex - charIndex, x += whiteSpace, y);
                        return;
                    }
                    currIndex = nextIndex;
                }
                collectWhiteSpace = !collectWhiteSpace;
            }
        }
    }

    private class AccessibleMultiLineLabel
    extends JComponent.AccessibleJComponent {
        private AccessibleMultiLineLabel() {
            super(MultiLineLabel.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (MultiLineLabel.this.getText() == null) {
                return super.getAccessibleName();
            }
            return MultiLineLabel.this.getText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

