/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

public class SpinAccelerator {
    private int _series = 0;
    private int _index = 0;
    private int[] _intervals;
    private int[] _counts;
    private int[] _increments;
    private static final int _DEFAULT_INTERVAL = 100;

    public SpinAccelerator() {
        this(100);
    }

    public SpinAccelerator(int interval) {
        this._intervals = new int[1];
        this._intervals[0] = interval;
    }

    public SpinAccelerator(int slow, int fast, int count, int increment) {
        int[] intervals = new int[]{slow, fast};
        this._intervals = intervals;
        this._counts = new int[1];
        this._counts[0] = count;
        if (increment == 1) {
            this._increments = null;
        } else {
            int[] increments = new int[]{1, increment};
            this._increments = increments;
        }
    }

    public SpinAccelerator(int[] intervals, int[] counts, int[] increments) {
        if (intervals == null) {
            throw new NullPointerException();
        }
        if (increments != null && increments.length != intervals.length) {
            throw new IllegalArgumentException();
        }
        if (counts == null ? increments.length != 1 : counts.length != intervals.length - 1) {
            throw new IllegalArgumentException();
        }
        this._intervals = intervals;
        this._counts = counts;
        this._increments = increments;
    }

    public static SpinAccelerator createDefaultAccelerator(int size) {
        if (size < 10) {
            return new SpinAccelerator(200);
        }
        if (size < 60) {
            return new SpinAccelerator(200, 40, 10, 1);
        }
        int[] intervals = new int[]{200, 100, 40};
        int[] counts = new int[]{10, 10};
        int[] increments = new int[]{1, 1, size / 30};
        return new SpinAccelerator(intervals, counts, increments);
    }

    public void advance() {
        int series;
        if ((series = this._series++) != this._intervals.length - 1) {
            ++this._index;
            if (this._index == this._counts[series]) {
                this._index = 0;
            }
        }
    }

    public void reset() {
        this._series = 0;
        this._index = 0;
    }

    public int getInterval() {
        return this._intervals[this._series];
    }

    public int getIncrement() {
        if (this._increments == null) {
            return 1;
        }
        return this._increments[this._series];
    }
}

