/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.elaf.EWTGridUI;
import oracle.bali.ewt.geometry.GeneralGeometryManager;
import oracle.bali.ewt.geometry.GeometryEvent;
import oracle.bali.ewt.geometry.GeometryListener;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.geometry.ReversedGeometryManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.Graphics2DProxy;
import oracle.bali.ewt.graphics.GraphicsProxy;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridAutoScroller;
import oracle.bali.ewt.grid.GridEditListener;
import oracle.bali.ewt.grid.GridEvent;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.grid.GridValidateEvent;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.SingleAppearanceManager;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.print.PrintGraphicsProxy;
import oracle.bali.ewt.print.PrinterGraphics2DProxy;
import oracle.bali.ewt.print.PrinterGraphicsProxy;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.InputEventUtils;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.collection.Range;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

public class Grid
extends ScrollableComponent
implements Accessible {
    public static final int ANCHOR_NONE = -1;
    public static final String CELL_KEY = "Cell";
    public static final String APPEARANCE_KEY = "Appearance";
    public static final String MODEL_KEY = "Model";
    public static final String GRID_KEY = "Grid";
    public static final String CLIP_RECT_KEY = "grid.clipRect";
    public static final String HORIZONTAL_SEPARATOR_COLOR_KEY = "horizontalSeparatorColor";
    public static final String VERTICAL_SEPARATOR_COLOR_KEY = "verticalSeparatorColor";
    public static final String PROPERTY_FOCUSCELL = "focusCell";
    public static final String PROPERTY_SELECTION = "selection";
    public static final String PROPERTY_SELECTION_MANAGER = "gridSelectionManager";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_COLUMN_GEOMETRY_MANAGER = "columnGeometryManager";
    public static final String PROPERTY_ROW_GEOMETRY_MANAGER = "rowGeometryManager";
    public static final Object DISPLAY_HORIZONTAL_SEPARATOR = "grid.dispHSep";
    public static final Object DISPLAY_VERTICAL_SEPARATOR = "grid.dispVSep";
    public static final Object DISPLAY_FOCUS_CELL = "grid.dispFocus";
    public static final Object DISPLAY_SELECTION_BORDER = "grid.dispSelBorder";
    private int _firstColumn = -1;
    private int _firstRow = -1;
    private transient Component _editControl;
    Cell _focusCell;
    static final String _PAGE_UP = "_PAGE_UP";
    static final String _PAGE_DOWN = "_PAGE_DOWN";
    static final String _TAB = "_TAB";
    private static final String _IMAGE = "GRID_IMAGE";
    private static final String _UNKNOWN = "UNKNOWN";
    private static final String _RESOURCE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _SPANMM = "BIGCELL.SPAN_MULTIPLE_COLUMN_MULTIPLE_ROW";
    private static final String _SPANSM = "BIGCELL.SPAN_SINGLE_COLUMN_MULTIPLE_ROW";
    private static final String _SPANMS = "BIGCELL.SPAN_MULTIPLE_COLUMN_SINGLE_ROW";
    private static final String _SPANSS = "BIGCELL.SPAN_SINGLE_COLUMN_SINGLE_ROW";
    private static final String _FULL_CELL_NAME = "SPREADTABLE.FULL_CELL_NAME";
    private static final String _COLUMNONLY_CELL_NAME = "SPREADTABLE.COLUMNONLY_CELL_NAME";
    private static final String _ROWONLY_CELL_NAME = "SPREADTABLE.ROWONLY_CELL_NAME";
    private static final String _NULL_CELL_BOTH = "SPREADTABLE.NULL_CELL_BOTH";
    private static final String _NULL_CELL_COLUMN = "SPREADTABLE.NULL_CELL_COLUMN";
    private static final String _NULL_CELL_ROW = "SPREADTABLE.NULL_CELL_ROW";
    private static HashSet _sFocusForwardTraversalKeys;
    private static HashSet _sFocusBackwardTraversalKeys;
    private ListenerManager _editListeners;
    private GridKeyHandler _keyHandler;
    private AppearanceManager _appearanceManager;
    private GridSelectionManager _gridSelectionManager;
    private GeometryManager _columnGM;
    private GeometryManager _rowGM;
    private TwoDModel _model;
    private boolean[][] _enabledStates;
    private DSListen _dsListener;
    private RowGeometryChangeListener _rowGeometryChangeListener;
    private ColumnGeometryChangeListener _columnGeometryChangeListener;
    private Painter _defaultPainter;
    private CellInputHandler _defaultInputHandler;
    private boolean _horizontalSeparatorsVisible;
    private boolean _verticalSeparatorsVisible;
    private Painter _horizontalPainter;
    private Painter _verticalPainter;
    private int _vpWidth;
    private boolean _drawFocusCellHighlite;
    private boolean _alwaysDrawFocusCellHighlite;
    private boolean _overlayVisible;
    private int _preferredRows;
    private int _preferredColumns;
    private ArrayOneDModel _painters;
    private ArrayOneDModel _cellInputHandlers;
    private GridKeyListener _keyListener;
    private FocusAdapter _focusListener;
    private ChangeListener _changeListener;
    private SelectionListener _selectionListener;
    private transient Cell _mouseGrabCell;
    private boolean _mouseGrabCellArmed;
    private Cell _moveCell;
    private Cell _anchorCell;
    private boolean _scrollByColumn;
    private boolean _scrollByRow;
    private transient boolean _removing;
    private transient boolean _handlingMousePressed;
    private boolean _isUpperLeft;
    private boolean _isUpperRight;
    private boolean _isLowerLeft;
    private boolean _isLowerRight;
    private boolean _defaultRowHeightSet;
    private boolean _defaultColumnWidthSet;
    private transient int _lastColumn;
    private transient int _lastRow;
    private transient Object _scrollLock = new Object();
    private boolean _ignoreSelectionRepaints = false;
    private boolean _cancelEdit = false;
    private GridToolTipManager _toolTipManager = null;
    private transient Object _paintLock = new Object();
    private boolean _drawSelectionBorder;
    private boolean _selectionTransparent;
    private static final int _ALPHA = 60;
    private boolean _borderVisible = true;
    private Color _horizontalSeparatorColor;
    private Color _verticalSeparatorColor;
    private boolean _canRequestFocus = true;
    private Component[] _editControlChildren;
    private Color _extraBackground;
    private AbstractAction _moveToNextCell;

    public Grid() {
        this(null);
    }

    public Grid(TwoDModel model) {
        this(model, null, NullInputHandler.getCellInputHandler());
    }

    public Grid(TwoDModel model, Painter painter, CellInputHandler inputHandler) {
        if (model == null) {
            model = NullTwoDModel.getTwoDModel();
        }
        super.setLayout(null);
        this._model = model;
        this._updateEnabledStates();
        this._defaultPainter = painter;
        this._defaultInputHandler = inputHandler;
        this._dsListener = new DSListen();
        this._model.addModelListener(this._dsListener);
        this._scrollByColumn = true;
        this._scrollByRow = true;
        this._drawFocusCellHighlite = true;
        this.setHorizontalSeparatorsVisible(true);
        this.setVerticalSeparatorsVisible(true);
        this._changeListener = new Change();
        long mask = 62L;
        this.enableEvents(mask);
        this._registerKeyboardActions();
        this.updateUI();
    }

    public void dispose() {
        this.cancelCellEdit();
        this.setToolTipManager(null);
        this._unregisterKeyboardActions();
        this._focusCell = null;
        this._mouseGrabCell = null;
        this._moveCell = null;
        this._anchorCell = null;
        this._editListeners = null;
        this._keyHandler = null;
        if (this._appearanceManager != null) {
            this._appearanceManager.setGrid(null);
        }
        this._appearanceManager = null;
        if (this._gridSelectionManager != null) {
            this._gridSelectionManager.removeVetoableChangeListener(this._selectionListener);
            this._gridSelectionManager.removePropertyChangeListener(this._selectionListener);
        }
        this._selectionListener = null;
        this._gridSelectionManager = null;
        if (this._columnGM != null) {
            this._columnGM.removeGeometryListener(this._columnGeometryChangeListener);
        }
        this._columnGM = null;
        this._columnGeometryChangeListener = null;
        if (this._rowGM != null) {
            this._rowGM.removeGeometryListener(this._rowGeometryChangeListener);
        }
        this._rowGM = null;
        this._rowGeometryChangeListener = null;
        this._model.removeModelListener(this._dsListener);
        this._model = null;
        this._dsListener = null;
        this._defaultPainter = null;
        this._defaultInputHandler = null;
        this._horizontalPainter = null;
        this._verticalPainter = null;
        this._editControl = null;
        this._keyListener = null;
        this._focusListener = null;
        if (this._painters != null && this._painters.getItemCount() != 0) {
            this._painters.removeItems(0, this._painters.getItemCount());
        }
        this._painters = null;
        if (this._cellInputHandlers != null && this._cellInputHandlers.getItemCount() != 0) {
            this._cellInputHandlers.removeItems(0, this._cellInputHandlers.getItemCount());
        }
        this._cellInputHandlers = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            ((JViewport)parent).removeChangeListener(this._changeListener);
        }
        this._changeListener = null;
        this.setUI(null);
    }

    @Override
    public String getUIClassID() {
        return "EWTGridUI";
    }

    public EWTGridUI getEWTGridUI() {
        return (EWTGridUI)this.ui;
    }

    public void setColumnGeometryManager(GeometryManager geometryManager) {
        if (geometryManager == null) {
            throw new NullPointerException();
        }
        GeometryListener cgml = this._getColumnGeometryChangeListener();
        if (this._columnGM != null) {
            this._columnGM.removeGeometryListener(cgml);
        }
        if (this.getActualReadingDirection() == 2) {
            geometryManager = new ReversedGeometryManager(geometryManager);
        }
        GeometryManager oldGM = this._columnGM;
        this._columnGM = geometryManager;
        this._columnGM.addGeometryListener(cgml);
        this._columnGM.resetAll(this.getColumnCount());
        this.firePropertyChange(PROPERTY_COLUMN_GEOMETRY_MANAGER, oldGM, this._columnGM);
    }

    public GeometryManager getColumnGeometryManager() {
        GeometryManager gm = this._getColumnGeometryManager();
        if (gm instanceof ReversedGeometryManager) {
            return ((ReversedGeometryManager)gm).getWrappedGeometryManager();
        }
        return gm;
    }

    public void setRowGeometryManager(GeometryManager geometryManager) {
        if (geometryManager == null) {
            throw new NullPointerException();
        }
        GeometryListener rgml = this._getRowGeometryChangeListener();
        if (this._rowGM != null) {
            this._rowGM.removeGeometryListener(rgml);
        }
        GeometryManager oldGM = this._rowGM;
        this._rowGM = geometryManager;
        this._rowGM.addGeometryListener(rgml);
        this._rowGM.resetAll(this.getRowCount());
        this.firePropertyChange(PROPERTY_ROW_GEOMETRY_MANAGER, oldGM, this._rowGM);
    }

    public GeometryManager getRowGeometryManager() {
        if (this._rowGM == null) {
            int rowHeight = this.getEWTGridUI().getDefaultRowHeight(this);
            GeneralGeometryManager gm = new GeneralGeometryManager();
            gm.setDefaultItemSize(rowHeight);
            this.setRowGeometryManager(gm);
        }
        return this._rowGM;
    }

    public void setToolTipManager(GridToolTipManager manager) {
        GridToolTipManager oldManager = this._toolTipManager;
        this._toolTipManager = manager;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        if (this._toolTipManager == null) {
            if (oldManager != null) {
                ttm.unregisterComponent(this);
            }
        } else if (oldManager == null) {
            ttm.registerComponent(this);
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        }
    }

    public GridToolTipManager getToolTipManager() {
        return this._toolTipManager;
    }

    @Override
    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this._toolTipManager == null) {
            return super.getToolTipText(event);
        }
        Point canvasPoint = this.convertOuterToCanvas(event.getX(), event.getY());
        int column = this.getColumnAt(canvasPoint.x);
        int row = this.getRowAt(canvasPoint.y);
        if (column < 0 || row < 0) {
            return null;
        }
        return this._toolTipManager.getCellToolTipValue(this, column, row);
    }

    public int getColumnCount() {
        return this._model.getColumnCount();
    }

    public final int getVisibleColumnCount() {
        return this._getColumnGeometryManager().getVisibleItemCount();
    }

    public int getRowCount() {
        return this._model.getRowCount();
    }

    public final int getVisibleRowCount() {
        return this.getRowGeometryManager().getVisibleItemCount();
    }

    public void setSelection(TwoDSelection selection) throws PropertyVetoException {
        this.getGridSelectionManager().setSelection(selection, null);
    }

    public TwoDSelection getSelection() {
        return this.getGridSelectionManager().getSelection();
    }

    public void selectAll() throws PropertyVetoException {
        int col1 = this.getNextVisibleColumn(-1);
        int col2 = this.getPreviousVisibleColumn(this.getColumnCount());
        int row1 = this.getNextVisibleRow(-1);
        int row2 = this.getPreviousVisibleRow(this.getRowCount());
        TwoDSelection sel = this.getModelRangeSelection(col1, row1, col2, row2);
        this.setSelection(sel);
    }

    public void deselectAll() throws PropertyVetoException {
        this.setSelection(TwoDSelection.getEmptySelection());
    }

    public TwoDModel getModel() {
        return this._model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(TwoDModel model) {
        TwoDModel oldDS = this.getModel();
        if (model == null) {
            model = NullTwoDModel.getTwoDModel();
        }
        if (model != oldDS) {
            this.freezeRepaints();
            try {
                oldDS.removeModelListener(this._dsListener);
                model.addModelListener(this._dsListener);
                this._model = model;
                this._updateEnabledStates();
                this._cellInputHandlers = null;
                this._painters = null;
                if (this._appearanceManager != null) {
                    this._appearanceManager.setGrid(null);
                    this._appearanceManager.setGrid(this);
                }
                try {
                    this.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.getColumnGeometryManager().resetAll(this.getColumnCount());
                this.getRowGeometryManager().resetAll(this.getRowCount());
                this._mouseGrabCell = null;
                this._moveCell = null;
                this.setAnchorCell(null);
                this._focusCell = null;
                this._firstColumn = Math.min(this._firstColumn, this.getColumnCount() - 1);
                this._firstRow = Math.min(this._firstRow, this.getRowCount() - 1);
            }
            finally {
                this.unfreezeRepaints();
            }
            this.invalidateCanvas();
            this.firePropertyChange(PROPERTY_MODEL, oldDS, model);
        }
    }

    public void setDefaultPainter(Painter painter) {
        this._defaultPainter = painter;
    }

    public Painter getDefaultPainter() {
        if (this._defaultPainter == null) {
            this._defaultPainter = (Painter)UIManager.get("Grid.DefaultCellPainter");
        }
        return this._defaultPainter;
    }

    public CellInputHandler getDefaultInputHandler() {
        return this._defaultInputHandler;
    }

    public void setDefaultInputHandler(CellInputHandler handler) {
        this._defaultInputHandler = handler == null ? NullInputHandler.getCellInputHandler() : handler;
    }

    public void setAppearanceManager(AppearanceManager manager) {
        if (this._appearanceManager != null) {
            this._appearanceManager.setGrid(null);
        }
        this._appearanceManager = manager;
        if (this._appearanceManager != null) {
            this._appearanceManager.setGrid(this);
            this._appearanceManager.updateUI();
        }
        this.repaintInterior();
    }

    public AppearanceManager getAppearanceManager() {
        if (this._appearanceManager == null) {
            this._appearanceManager = new SingleAppearanceManager();
            this._appearanceManager.setGrid(this);
        }
        return this._appearanceManager;
    }

    public synchronized void addEditListener(GridEditListener listener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener((EventListener)listener);
    }

    public synchronized void removeEditListener(GridEditListener listener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener((EventListener)listener);
        }
    }

    public boolean isEditing() {
        return this._editControl != null;
    }

    public void cancelCellEdit() {
        this._doneEditing(false);
    }

    public void commitCellEdit() {
        this._doneEditing(true);
    }

    public void setGridSelectionManager(GridSelectionManager gridSelectionManager) {
        SelectionListener listen = this._getSelectionListener();
        if (gridSelectionManager == null) {
            gridSelectionManager = GeneralGridSelectionManager.getNullGridSelectionManager();
        }
        if (gridSelectionManager != this._gridSelectionManager) {
            if (this._gridSelectionManager != null) {
                this._gridSelectionManager.removeVetoableChangeListener(listen);
                this._gridSelectionManager.removePropertyChangeListener(listen);
            }
            GridSelectionManager oldSM = this._gridSelectionManager;
            this._gridSelectionManager = gridSelectionManager;
            this._gridSelectionManager.addVetoableChangeListener(listen);
            this._gridSelectionManager.addPropertyChangeListener(listen);
            this.repaintInterior();
            this.firePropertyChange(PROPERTY_SELECTION_MANAGER, oldSM, this._gridSelectionManager);
        }
    }

    public GridSelectionManager getGridSelectionManager() {
        if (this._gridSelectionManager == null) {
            this.setGridSelectionManager(new GeneralGridSelectionManager());
        }
        return this._gridSelectionManager;
    }

    public int getPreviousVisibleColumn(int index) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        int visibleIndex = index < this.getColumnCount() ? columnGM.getItemVisibleIndex(index) : index;
        int i = visibleIndex - 1;
        if (i < 0) {
            return -1;
        }
        while (i >= 0) {
            int modelIndex = columnGM.visibleIndexToIndex(i);
            if (columnGM.isItemVisible(modelIndex)) {
                return modelIndex;
            }
            --i;
        }
        return -1;
    }

    public int getPreviousVisibleRow(int index) {
        GeometryManager rowGM = this.getRowGeometryManager();
        int visibleIndex = index < this.getRowCount() ? rowGM.getItemVisibleIndex(index) : index;
        for (int i = visibleIndex - 1; i >= 0; --i) {
            int modelIndex = rowGM.visibleIndexToIndex(i);
            if (!rowGM.isItemVisible(modelIndex)) continue;
            return modelIndex;
        }
        return -1;
    }

    public int getNextVisibleColumn(int index) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        int visibleIndex = index >= 0 ? columnGM.getItemVisibleIndex(index) : index;
        int columns = this.getColumnCount();
        for (int i = visibleIndex + 1; i < columns; ++i) {
            int modelIndex = columnGM.visibleIndexToIndex(i);
            if (!columnGM.isItemVisible(modelIndex)) continue;
            return modelIndex;
        }
        return -1;
    }

    public int getNextVisibleRow(int index) {
        GeometryManager rowGM = this.getRowGeometryManager();
        int visibleIndex = index >= 0 ? rowGM.getItemVisibleIndex(index) : index;
        int rows = this.getRowCount();
        for (int i = visibleIndex + 1; i < rows; ++i) {
            int modelIndex = rowGM.visibleIndexToIndex(i);
            if (!rowGM.isItemVisible(modelIndex)) continue;
            return modelIndex;
        }
        return -1;
    }

    public void setHorizontalSeparatorsVisible(boolean visible) {
        if (this._horizontalSeparatorsVisible != visible) {
            this._horizontalSeparatorsVisible = visible;
            this.invalidateCanvas();
        }
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this._horizontalSeparatorsVisible;
    }

    public void setHorizontalSeparatorPainter(Painter painter) {
        if (this._horizontalPainter != painter) {
            this._horizontalPainter = painter;
            this.invalidateCanvas();
        }
    }

    public Painter getHorizontalSeparatorPainter() {
        if (this._horizontalPainter == null) {
            return NullPainter.getPainter();
        }
        return this._horizontalPainter;
    }

    public void setVerticalSeparatorsVisible(boolean visible) {
        if (this._verticalSeparatorsVisible != visible) {
            this._verticalSeparatorsVisible = visible;
            this.invalidateCanvas();
        }
    }

    public boolean getVerticalSeparatorsVisible() {
        return this._verticalSeparatorsVisible;
    }

    public void setVerticalSeparatorPainter(Painter painter) {
        if (this._verticalPainter != painter) {
            this._verticalPainter = painter;
            int oldWidth = this._vpWidth;
            this._vpWidth = painter == null ? 0 : painter.getPreferredSize((PaintContext)this.getPaintContext()).width;
            if (this.getVerticalSeparatorsVisible()) {
                this.invalidateCanvas();
            }
        }
    }

    public Painter getVerticalSeparatorPainter() {
        if (this._verticalPainter == null) {
            return NullPainter.getPainter();
        }
        return this._verticalPainter;
    }

    public void setHorizontalSeparatorColor(Color color) {
        if (color != this._horizontalSeparatorColor) {
            this._horizontalSeparatorColor = color;
            this.repaintInterior();
        }
    }

    public Color getHorizontalSeparatorColor() {
        return this._horizontalSeparatorColor;
    }

    public void setVerticalSeparatorColor(Color color) {
        if (color != this._verticalSeparatorColor) {
            this._verticalSeparatorColor = color;
            this.repaintInterior();
        }
    }

    public Color getVerticalSeparatorColor() {
        return this._verticalSeparatorColor;
    }

    public void setExtraCanvasBackground(Color color) {
        Color oldColor = this.getExtraCanvasBackground();
        this._extraBackground = color;
        if (oldColor != null ? !oldColor.equals(color) : color != null) {
            this.repaint();
        }
    }

    public Color getExtraCanvasBackground() {
        return this._extraBackground;
    }

    public Cell getFocusCell() {
        if (this._focusCell == null) {
            return null;
        }
        return new Cell(this._focusCell.column, this._focusCell.row);
    }

    public void setFocusCell(Cell cell) {
        this.requestFocus(cell.column, cell.row, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestFocus(int column, int row, AWTEvent event) {
        if (this._focusCell != null && this._focusCell.column == column && this._focusCell.row == row) {
            return true;
        }
        Cell oldValue = this._focusCell == null ? null : new Cell(this._focusCell.column, this._focusCell.row);
        Cell newValue = new Cell(column, row);
        try {
            this.fireVetoableChange(PROPERTY_FOCUSCELL, oldValue, newValue);
        }
        catch (PropertyVetoException pve) {
            return false;
        }
        this.freezeRepaints();
        try {
            Grid grid = this;
            synchronized (grid) {
                CellInputHandler handler;
                TwoDSelection sel = this.getSelection();
                boolean paintSelection = false;
                if (this._focusCell != null) {
                    int oldFocusColumn = this._focusCell.column;
                    int oldFocusRow = this._focusCell.row;
                    handler = this.getColumnCellInputHandler(oldFocusColumn);
                    if (!handler.validateFocus(this, oldFocusColumn, oldFocusRow)) {
                        // empty if block
                    }
                    this.commitCellEdit();
                    handler.focusLost(event, this, oldFocusColumn, oldFocusRow);
                    this._focusCell = null;
                    if (this.getDrawFocusCellHighlite()) {
                        this.paintCell(oldFocusColumn, oldFocusRow);
                    }
                    if (this.getDrawSelectionBorder() && sel.containsCell(oldFocusColumn, oldFocusRow)) {
                        paintSelection = true;
                    }
                }
                this._focusCell = new Cell(column, row);
                if (this.isCellEnabled(column, row)) {
                    handler = this.getColumnCellInputHandler(this._focusCell.column);
                    handler.focusGained(event, this, column, row);
                }
                this.firePropertyChange(PROPERTY_FOCUSCELL, oldValue, newValue);
                if (this.getDrawFocusCellHighlite()) {
                    this.paintCell(column, row);
                }
                if (this.getDrawSelectionBorder() && sel.containsCell(this._focusCell)) {
                    paintSelection = true;
                }
                if (paintSelection) {
                    this._paintSelections(sel);
                }
            }
        }
        finally {
            this.unfreezeRepaints();
        }
        return true;
    }

    public void setDrawFocusCellHighlite(boolean draw) {
        if (this.getDrawFocusCellHighlite() != draw) {
            this._drawFocusCellHighlite = draw;
            if (this._focusCell != null) {
                this.paintCell(this._focusCell.column, this._focusCell.row);
            }
        }
    }

    public boolean getDrawFocusCellHighlite() {
        return this._drawFocusCellHighlite;
    }

    public void setAlwaysDrawFocusCellHighlite(boolean always) {
        if (this.isAlwaysDrawFocusCellHighlite() != always) {
            this._alwaysDrawFocusCellHighlite = always;
            if (this._focusCell != null) {
                this.paintCell(this._focusCell.column, this._focusCell.row);
            }
        }
    }

    public boolean isAlwaysDrawFocusCellHighlite() {
        return this._alwaysDrawFocusCellHighlite;
    }

    public void setDrawSelectionBorder(boolean draw) {
        this._setDrawSelectionBorder(draw, true);
    }

    public boolean getDrawSelectionBorder() {
        return this._drawSelectionBorder;
    }

    public void setSelectionTransparent(boolean transparent) {
        if (transparent != this._selectionTransparent) {
            this._selectionTransparent = transparent;
            this._paintSelections(this.getSelection());
        }
    }

    public boolean isSelectionTransparent() {
        return this._selectionTransparent;
    }

    public final void setDefaultColumnWidth(int width) {
        this._defaultColumnWidthSet = true;
        if (width == 0) {
            width = this.getEWTGridUI().getDefaultColumnWidth(this);
            this._defaultColumnWidthSet = false;
        }
        this._getColumnGeometryManager().setDefaultItemSize(width);
        this.invalidateCanvas();
    }

    public final int getDefaultColumnWidth() {
        GeometryManager columnGM = this._getColumnGeometryManager();
        int size = columnGM.getDefaultItemSize();
        if (size == 0) {
            size = this.getEWTGridUI().getDefaultColumnWidth(this);
            columnGM.setDefaultItemSize(size);
            this.invalidateCanvas();
        }
        return size;
    }

    public final void setDefaultRowHeight(int height) {
        this._defaultRowHeightSet = true;
        if (height == 0) {
            height = this.getEWTGridUI().getDefaultRowHeight(this);
            this._defaultRowHeightSet = false;
        }
        this.getRowGeometryManager().setDefaultItemSize(height);
        this.invalidateCanvas();
    }

    public final int getDefaultRowHeight() {
        GeometryManager rowGM = this.getRowGeometryManager();
        int size = rowGM.getDefaultItemSize();
        if (size == 0) {
            size = this.getEWTGridUI().getDefaultRowHeight(this);
            rowGM.setDefaultItemSize(size);
            this.invalidateCanvas();
        }
        return size;
    }

    public int getOnScreenRowCount() {
        GeometryManager rowGM = this.getRowGeometryManager();
        int firstRow = this.getFirstRowOnScreen();
        int rowCount = this.getRowCount();
        if (rowCount == 0 || firstRow == -1) {
            return 0;
        }
        Point p = this.getCanvasOrigin();
        Dimension canvasSize = this.getCanvasSize();
        Dimension d = this.getInnerSize();
        int onScreenRowCount = 0;
        int max = -p.y + d.height;
        if (max > canvasSize.height) {
            max = canvasSize.height;
        }
        for (int i = rowGM.getItemVisibleIndex(firstRow); i < rowCount; ++i) {
            int temp = rowGM.visibleIndexToIndex(i);
            if (!rowGM.isItemVisible(temp)) continue;
            int pos = rowGM.getItemPosition(temp);
            if (pos > max) break;
            ++onScreenRowCount;
        }
        return onScreenRowCount;
    }

    public int getOnScreenColumnCount() {
        GeometryManager columnGM = this._getColumnGeometryManager();
        int firstColumn = this.getFirstColumnOnScreen();
        int columnCount = this.getColumnCount();
        if (columnCount == 0 || firstColumn == -1) {
            return 0;
        }
        Point p = this.getCanvasOrigin();
        Dimension canvasSize = this.getCanvasSize();
        Dimension d = this.getInnerSize();
        int onScreenColumnCount = 0;
        int max = -p.x + d.width;
        if (max > canvasSize.width) {
            max = canvasSize.width;
        }
        for (int i = columnGM.getItemVisibleIndex(firstColumn); i < columnCount; ++i) {
            int temp = columnGM.visibleIndexToIndex(i);
            if (!columnGM.isItemVisible(temp)) continue;
            int pos = columnGM.getItemPosition(temp);
            if (pos > max) break;
            ++onScreenColumnCount;
        }
        return onScreenColumnCount;
    }

    public int getFirstRowOnScreen() {
        if (this._firstRow != -1) {
            return this._firstRow;
        }
        Point p = this.getCanvasOrigin();
        return this.getRowGeometryManager().getItemAt(-p.y);
    }

    public void setFirstRowOnScreen(int index) {
        GeometryManager rowGM = this.getRowGeometryManager();
        if (index < 0 || index >= this.getRowCount() || !rowGM.isItemVisible(index)) {
            throw new IllegalArgumentException("Illegal row " + index);
        }
        if (this.getCanvasHeight() == 0) {
            this._firstRow = index;
        } else {
            int innerHeight;
            this._firstRow = -1;
            int offset = rowGM.getItemPosition(index);
            int h = rowGM.getTotalSize();
            if (h - offset < (innerHeight = this.getInnerSize().height)) {
                offset = h - innerHeight;
            }
            if (offset < 0) {
                offset = 0;
            }
            offset = -offset;
            if (this.getCanvasOriginY() != offset) {
                this.commitCellEdit();
                this.setCanvasOrigin(this.getCanvasOriginX(), offset);
            }
        }
    }

    public int getFirstColumnOnScreen() {
        if (this._firstColumn != -1) {
            return this._firstColumn;
        }
        Point p = this.getCanvasOrigin();
        return this._getColumnGeometryManager().getItemAt(-p.x);
    }

    public void setFirstColumnOnScreen(int index) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        if (index < 0 || index >= this.getColumnCount() || !columnGM.isItemVisible(index)) {
            throw new IllegalArgumentException();
        }
        if (this.getCanvasWidth() == 0) {
            this._firstColumn = index;
        } else {
            int innerWidth;
            this._firstColumn = -1;
            int offset = columnGM.getItemPosition(index);
            int w = columnGM.getTotalSize();
            if (w - offset < (innerWidth = this.getInnerSize().width)) {
                offset = w - innerWidth;
            }
            if (offset < 0) {
                offset = 0;
            }
            offset = -offset;
            if (this.getCanvasOriginX() != offset) {
                this.commitCellEdit();
                this.setCanvasOrigin(offset, this.getCanvasOriginY());
            }
        }
    }

    public void setPreferredRowsOnScreen(int rows) {
        this._preferredRows = rows;
    }

    public int getPreferredRowsOnScreen() {
        return this._preferredRows;
    }

    public void setPreferredColumnsOnScreen(int columns) {
        this._preferredColumns = columns;
    }

    public int getPreferredColumnsOnScreen() {
        return this._preferredColumns;
    }

    public final void setAnchorCell(Cell newAnchor) {
        if (newAnchor == null) {
            this.setAnchorCell(-1, -1);
        } else {
            this.setAnchorCell(newAnchor.column, newAnchor.row);
        }
    }

    public void setAnchorCell(int column, int row) {
        this._anchorCell = column == -1 || row == -1 ? null : new Cell(column, row);
    }

    public Cell getAnchorCell() {
        return this._anchorCell;
    }

    public void setGridKeyHandler(GridKeyHandler manager) {
        HashSet focusForwardTraversalKeys = null;
        HashSet focusBackwardTraversalKeys = null;
        if (manager instanceof StandardGridKeyHandler && ((StandardGridKeyHandler)manager).__isTabAsAroow()) {
            Grid._updateTraversalKeys();
            focusForwardTraversalKeys = _sFocusForwardTraversalKeys;
            focusBackwardTraversalKeys = _sFocusBackwardTraversalKeys;
            this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0, false), _TAB);
            if (this._moveToNextCell == null) {
                this._moveToNextCell = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        KeyEvent event = new KeyEvent(Grid.this, 401, 0L, evt.getModifiers(), 9, '\t');
                        Grid.this._sendKeyToHandler(event);
                    }
                };
            }
            this.getActionMap().put(_TAB, this._moveToNextCell);
        }
        this.setFocusTraversalKeys(0, focusForwardTraversalKeys);
        this.setFocusTraversalKeys(1, focusBackwardTraversalKeys);
        this._keyHandler = manager;
    }

    public GridKeyHandler getGridKeyHandler() {
        if (this._keyHandler == null) {
            this._keyHandler = StandardGridKeyHandler.getGridKeyHandler();
        }
        return this._keyHandler;
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    public void setScrollByColumn(boolean byColumn) {
        if (byColumn != this.getScrollByColumn()) {
            this._scrollByColumn = byColumn;
            Dimension d = this.getCanvasSize();
            this.setCanvasSize(d.width, d.height);
            this.revalidate();
        }
    }

    public boolean getScrollByColumn() {
        return this._scrollByColumn;
    }

    public void setScrollByRow(boolean byRow) {
        if (byRow != this.getScrollByRow()) {
            this._scrollByRow = byRow;
            Dimension d = this.getCanvasSize();
            this.setCanvasSize(d.width, d.height);
            this.revalidate();
        }
    }

    public boolean getScrollByRow() {
        return this._scrollByRow;
    }

    @Override
    public void setLayout(LayoutManager layout) {
        super.setLayout(null);
    }

    public void setCellEnabled(boolean enabled, int col, int row) {
        if (this._enabledStates == null) {
            return;
        }
        int colCount = this._model.getColumnCount();
        int rowCount = this._model.getRowCount();
        if (!(col >= 0 && col < colCount || row >= 0 && row < rowCount)) {
            throw new IllegalArgumentException();
        }
        if (col >= 0 && col < colCount && (row < 0 || row >= rowCount)) {
            if (row != -1) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < rowCount; ++i) {
                this._enabledStates[col][i] = enabled;
            }
            this.paintColumn(col);
            return;
        }
        if ((col < 0 || col >= colCount) && row >= 0 && row < rowCount) {
            if (col != -1) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < colCount; ++i) {
                this._enabledStates[i][row] = enabled;
            }
            this.paintRow(row);
            return;
        }
        this._enabledStates[col][row] = enabled;
        this.paintCell(col, row);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            this.commitCellEdit();
        }
    }

    public final synchronized void setColumnVisibleIndex(int modelIndex, int visibleIndex) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        if (this.getColumnVisibleIndex(modelIndex) != visibleIndex) {
            int oldPos = columnGM.getItemPosition(modelIndex);
            boolean wasOnScreen = this.isColumnOnScreen(modelIndex);
            columnGM.setItemVisibleIndex(modelIndex, visibleIndex);
            Dimension d = this.layoutCanvas();
            this.setCanvasSize(d.width, d.height);
            boolean onScreen = this.isColumnOnScreen(modelIndex);
            if (onScreen || wasOnScreen) {
                if (!onScreen || !wasOnScreen) {
                    this.repaintInterior();
                } else {
                    d = this.getInnerSize();
                    int pos = columnGM.getItemPosition(modelIndex);
                    if (oldPos < pos) {
                        pos = oldPos;
                    }
                    Point p = this.getCanvasOrigin();
                    this.repaintCanvas(pos - 1, -p.y, d.width, d.height);
                }
            }
        }
    }

    public final int getColumnVisibleIndex(int modelIndex) {
        return this._getColumnGeometryManager().getItemVisibleIndex(modelIndex);
    }

    public final synchronized void setRowVisibleIndex(int modelIndex, int visibleIndex) {
        GeometryManager rowGM = this.getRowGeometryManager();
        if (this.getRowVisibleIndex(modelIndex) != visibleIndex) {
            int oldPos = rowGM.getItemPosition(modelIndex);
            boolean wasOnScreen = this.isRowOnScreen(modelIndex);
            rowGM.setItemVisibleIndex(modelIndex, visibleIndex);
            Dimension d = this.layoutCanvas();
            this.setCanvasSize(d.width, d.height);
            boolean onScreen = this.isRowOnScreen(modelIndex);
            if (onScreen || wasOnScreen) {
                if (!onScreen || !wasOnScreen) {
                    this.repaintInterior();
                } else {
                    d = this.getInnerSize();
                    int pos = rowGM.getItemPosition(modelIndex);
                    if (oldPos < pos) {
                        pos = oldPos;
                    }
                    Point p = this.getCanvasOrigin();
                    this.repaintCanvas(-p.x, pos - 1, d.width, d.height);
                }
            }
        }
    }

    public final int getRowVisibleIndex(int modelIndex) {
        return this.getRowGeometryManager().getItemVisibleIndex(modelIndex);
    }

    public final void setColumnVisible(int index, boolean visible) {
        this._getColumnGeometryManager().setItemVisible(index, visible);
    }

    public final boolean isColumnVisible(int index) {
        return this._getColumnGeometryManager().isItemVisible(index);
    }

    public final void setRowVisible(int index, boolean visible) {
        this.getRowGeometryManager().setItemVisible(index, visible);
    }

    public final boolean isRowVisible(int index) {
        return this.getRowGeometryManager().isItemVisible(index);
    }

    public final void setColumnWidth(int index, int width) {
        if (this.getColumnWidth(index) != width) {
            int focusedColumn;
            GeometryManager gm = this._getColumnGeometryManager();
            gm.setItemSize(index, width);
            Dimension d = this.layoutCanvas();
            this.setCanvasSize(d.width, d.height);
            if (this.isColumnOnScreen(index)) {
                d = this.getInnerSize();
                Point p = this.getCanvasOrigin();
                int pos = gm.getItemPosition(index);
                if (pos < -p.x) {
                    pos = -p.x;
                }
                this.repaintCanvas(pos, -p.y, d.width, d.height);
            }
            int n = focusedColumn = this._focusCell == null ? -1 : this._focusCell.column;
            if (this.isEditing() && (this.getActualReadingDirection() == 2 || gm.getItemVisibleIndex(index) <= gm.getItemVisibleIndex(focusedColumn))) {
                this._moveEditControl();
            }
            this.revalidate();
        }
    }

    public final int getColumnWidth(int index) {
        return this._getColumnGeometryManager().getItemSize(index);
    }

    public final void setRowHeight(int index, int height) {
        if (this.getRowHeight(index) != height) {
            int focusedRow;
            GeometryManager gm = this.getRowGeometryManager();
            gm.setItemSize(index, height);
            Dimension d = this.layoutCanvas();
            this.setCanvasSize(d.width, d.height);
            if (this.isRowOnScreen(index)) {
                d = this.getInnerSize();
                Point p = this.getCanvasOrigin();
                int pos = gm.getItemPosition(index);
                if (pos < -p.y) {
                    pos = -p.y;
                }
                this.repaintCanvas(-p.x, pos, d.width, d.height);
            }
            int n = focusedRow = this._focusCell == null ? -1 : this._focusCell.row;
            if (this.isEditing() && gm.getItemVisibleIndex(index) <= gm.getItemVisibleIndex(focusedRow)) {
                this._moveEditControl();
            }
            this.revalidate();
        }
    }

    public final int getRowHeight(int index) {
        return this.getRowGeometryManager().getItemSize(index);
    }

    public void setColumnPainter(int index, Painter painter) {
        if (this._painters == null) {
            this._painters = new ArrayOneDModel(this.getColumnCount());
        }
        this._painters.setData(index, painter);
        this.paintColumn(index);
    }

    public Painter getColumnPainter(int index) {
        Object data;
        if (this._painters != null && (data = this._painters.getData(index)) != null) {
            return (Painter)data;
        }
        return this.getDefaultPainter();
    }

    public void setColumnCellInputHandler(int index, CellInputHandler inputHandler) {
        inputHandler.updateUI();
        if (this._cellInputHandlers == null) {
            this._cellInputHandlers = new ArrayOneDModel(this.getColumnCount());
        }
        this._cellInputHandlers.setData(index, inputHandler);
    }

    public CellInputHandler getColumnCellInputHandler(int index) {
        Object data;
        if (this._cellInputHandlers != null && (data = this._cellInputHandlers.getData(index)) != null) {
            return (CellInputHandler)data;
        }
        return this.getDefaultInputHandler();
    }

    @Override
    public void addNotify() {
        GeometryManager columnGM;
        GeometryManager rowGM;
        int size;
        super.addNotify();
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            this.setBorder(null);
            ((JViewport)parent).addChangeListener(this._changeListener);
            Container gp = parent.getParent();
            if (gp instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)gp;
                LookAndFeel.installBorder(pane, "EWTGrid.scrollPaneBorder");
            }
        }
        if ((size = (rowGM = this.getRowGeometryManager()).getDefaultItemSize()) == 0) {
            size = this.getEWTGridUI().getDefaultRowHeight(this);
            rowGM.setDefaultItemSize(size);
            this.invalidateCanvas();
        }
        if ((size = (columnGM = this.getColumnGeometryManager()).getDefaultItemSize()) == 0) {
            size = this.getEWTGridUI().getDefaultColumnWidth(this);
            columnGM.setDefaultItemSize(size);
            this.invalidateCanvas();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCellEdit(final int column, final int row) {
        Grid grid = this;
        synchronized (grid) {
            if (this.isEditing() && this._focusCell != null && this._focusCell.column == column && this._focusCell.row == row) {
                return;
            }
        }
        this.commitCellEdit();
        this.freezeRepaints();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Grid.this._startCellEdit(column, row);
                }
                finally {
                    Grid.this.unfreezeRepaints();
                }
            }
        });
    }

    public boolean isRowOnScreen(int index) {
        if (!this.isRowVisible(index)) {
            return false;
        }
        GeometryManager rowGM = this.getRowGeometryManager();
        Point p = this.getCanvasOrigin();
        Dimension d = this.getInnerSize();
        int pos = rowGM.getItemPosition(index);
        int size = rowGM.getItemSize(index);
        p.y = -p.y;
        return pos + size >= p.y && pos <= p.y + d.height;
    }

    public boolean isColumnOnScreen(int index) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        if (!this.isColumnVisible(index)) {
            return false;
        }
        Point p = this.getCanvasOrigin();
        Dimension d = this.getInnerSize();
        int pos = columnGM.getItemPosition(index);
        int size = columnGM.getItemSize(index);
        p.x = -p.x;
        return pos + size >= p.x && pos <= p.x + d.width;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public boolean isManagingFocus() {
        return !FocusUtils.areNewFocusAPIsAvailable();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dummy = this._calculateCanvasSize();
        int preferredColumns = this.getPreferredColumnsOnScreen();
        int preferredRows = this.getPreferredRowsOnScreen();
        int rows = this.getVisibleRowCount();
        int columns = this.getVisibleColumnCount();
        int width = this._getColumnGeometryManager().getTotalSize();
        int height = this.getRowGeometryManager().getTotalSize();
        int prefWidth = width == 0 ? preferredColumns * this.getDefaultColumnWidth() : (preferredColumns != 0 && columns != 0 ? preferredColumns * width / columns : width);
        int prefHeight = height == 0 ? preferredRows * this.getDefaultRowHeight() : (preferredRows != 0 && rows != 0 ? preferredRows * height / rows : height);
        return this.convertInnerToOuterSize(prefWidth, prefHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        int minWidth = this.getDefaultColumnWidth();
        int minHeight = this.getDefaultRowHeight();
        return this.convertInnerToOuterSize(minWidth, minHeight);
    }

    public final int getColumnPosition(int column) {
        return this._getColumnGeometryManager().getItemPosition(column);
    }

    public final int getRowPosition(int row) {
        return this.getRowGeometryManager().getItemPosition(row);
    }

    public final int getColumnAt(int canvasX) {
        return this._getColumnGeometryManager().getItemAt(canvasX);
    }

    public final int getRowAt(int canvasY) {
        return this.getRowGeometryManager().getItemAt(canvasY);
    }

    public void setUpperLeft(boolean isUpperLeft) {
        if (this._isUpperLeft != isUpperLeft) {
            this._isUpperLeft = isUpperLeft;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isUpperLeft() {
        return this._isUpperLeft;
    }

    public void setUpperRight(boolean isUpperRight) {
        if (this._isUpperRight != isUpperRight) {
            this._isUpperRight = isUpperRight;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isUpperRight() {
        return this._isUpperRight;
    }

    public void setLowerLeft(boolean isLowerLeft) {
        if (this._isLowerLeft != isLowerLeft) {
            this._isLowerLeft = isLowerLeft;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isLowerLeft() {
        return this._isLowerLeft;
    }

    public void setLowerRight(boolean isLowerRight) {
        if (this._isLowerRight != isLowerRight) {
            this._isLowerRight = isLowerRight;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isLowerRight() {
        return this._isLowerRight;
    }

    public boolean isOverlayBorderVisible() {
        return this._overlayVisible;
    }

    public void setOverlayBorderVisible(boolean visible) {
        if (this._overlayVisible != visible) {
            this._overlayVisible = visible;
            this.repaint();
        }
    }

    public PaintContext getCellPaintContext(int column, int row) {
        return new CellPaintContext(this.getPaintContext(), column, row);
    }

    public PaintContext getCellPrintPaintContext(Graphics printGraphics, int column, int row) {
        return new CellPrintPaintContext(this.getPrintPaintContext(printGraphics), column, row);
    }

    public final void fireCellEvent(int columnIndex, int rowIndex, int id) {
        GridEvent event = new GridEvent(this, id, columnIndex, rowIndex);
        this.processEvent(event);
    }

    public final boolean fireCancelableCellEvent(int columnIndex, int rowIndex, int eventID) {
        if (eventID == 2001 && this._cancelEdit) {
            return true;
        }
        GridValidateEvent event = new GridValidateEvent(this, eventID, columnIndex, rowIndex);
        this.processEvent(event);
        return event.isCancelled();
    }

    public void repaintColumn(int index) {
        this._paintColumn(index, false);
    }

    public void paintColumn(int index) {
        this._paintColumn(index, true);
    }

    public void repaintRow(int index) {
        this._paintRow(index, false);
    }

    public void paintRow(int index) {
        this._paintRow(index, true);
    }

    public void paintVisibleCellRange(CellRange cr) {
        GeometryManager colGM = this._getColumnGeometryManager();
        GeometryManager rowGM = this.getRowGeometryManager();
        Cell c1 = cr.getLowerLimit();
        Cell c2 = cr.getUpperLimit();
        this.validate();
        int col1 = colGM.visibleIndexToIndex(c1.column);
        int col2 = colGM.visibleIndexToIndex(c2.column);
        int row1 = rowGM.visibleIndexToIndex(c1.row);
        int row2 = rowGM.visibleIndexToIndex(c2.row);
        int x1 = this._getColumnX(col1) - 1;
        int y1 = rowGM.getItemPosition(row1) - 1;
        int x2 = this._getColumnX(col2) - 1;
        int y2 = rowGM.getItemPosition(row2) - 1;
        int width = x2 - x1 + colGM.getItemSize(col2) + 2;
        int height = y2 - y1 + rowGM.getItemSize(row2) + 2;
        this.paintImmediateInterior(x1, y1, width, height);
    }

    public void repaintCell(int columnIndex, int rowIndex) {
        this._paintCell(columnIndex, rowIndex, false);
    }

    public void paintCell(int columnIndex, int rowIndex) {
        this._paintCell(columnIndex, rowIndex, true);
    }

    @Override
    public void setCanvasSize(int width, int height) {
        int innerWidth;
        int oldCanvasWidth = this.getCanvasSize().width;
        super.setCanvasSize(width, height);
        if (this.getActualReadingDirection() == 2 && (innerWidth = this.getInnerSize().width) != 0) {
            int newOriginX;
            int canvasWidth = this.getCanvasSize().width;
            Point oldOrigin = this.getCanvasOrigin();
            if (oldCanvasWidth <= 0) {
                newOriginX = innerWidth - canvasWidth;
            } else {
                newOriginX = oldOrigin.x + oldCanvasWidth - canvasWidth;
                if (newOriginX > 0) {
                    if (canvasWidth > innerWidth) {
                        newOriginX = 0;
                    } else if (newOriginX + canvasWidth > innerWidth) {
                        newOriginX = innerWidth - canvasWidth;
                    }
                }
            }
            this.setCanvasOrigin(newOriginX, oldOrigin.y);
        }
    }

    @Override
    public void setCanvasOrigin(int x, int y) {
        int innerWidth;
        int canvasWidth;
        if (this.getActualReadingDirection() == 2 && x + (canvasWidth = this.getCanvasSize().width) < (innerWidth = this.getInnerSize().width)) {
            x = innerWidth - canvasWidth;
        }
        super.setCanvasOrigin(x, y);
    }

    @Override
    public void removeNotify() {
        GridAutoScroller.getAutoScroller().cancel(this);
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            ((JViewport)parent).removeChangeListener(this._changeListener);
            Container gp = parent.getParent();
            if (gp instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)gp;
                LookAndFeel.uninstallBorder(pane);
            }
        }
        super.removeNotify();
    }

    @Override
    public void updateUI() {
        this.setUI((EWTGridUI)UIManager.getUI(this));
        this.updateGeometry(false);
        this._updateCellInputHandlerUI();
        if (this._appearanceManager != null) {
            this._appearanceManager.updateUI();
        }
    }

    public void updateGeometry(boolean setUI) {
        if (setUI) {
            this.setUI((EWTGridUI)UIManager.getUI(this));
        }
        if (!this._defaultRowHeightSet || this.getRowGeometryManager().getDefaultItemSize() == 0) {
            this.setDefaultRowHeight(0);
        }
        if (!this._defaultColumnWidthSet || this.getColumnGeometryManager().getDefaultItemSize() == 0) {
            this.setDefaultColumnWidth(0);
        }
    }

    @Override
    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        int size;
        Painter p;
        GraphicsProxy gp = g instanceof PrintGraphics ? new PrintGraphicsProxy(g, (PrintGraphics)((Object)g)) : (g instanceof PrinterGraphics ? (g instanceof Graphics2D ? new PrinterGraphics2DProxy((Graphics2D)g, (PrinterGraphics)((Object)g)) : new PrinterGraphicsProxy(g, (PrinterGraphics)((Object)g))) : new GraphicsProxy(g));
        Rectangle rect = g.getClipBounds();
        if (gp instanceof Graphics2DProxy) {
            ((Graphics2DProxy)((Object)gp)).put(CLIP_RECT_KEY, rect);
        } else {
            ((GraphicsProxy)gp).put(CLIP_RECT_KEY, rect);
        }
        if (context == null) {
            context = this.getPrintPaintContext(g);
        }
        boolean showFocus = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_FOCUS_CELL, true);
        boolean oldValue = this.getDrawSelectionBorder();
        this._setDrawSelectionBorder(PrinterUtils.getPrinterProperty(printProperties, DISPLAY_SELECTION_BORDER, false), false);
        this._paintGrid(context, gp, showFocus);
        this._setDrawSelectionBorder(oldValue, false);
        boolean showHorizontal = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_HORIZONTAL_SEPARATOR, true);
        boolean showVertical = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_VERTICAL_SEPARATOR, true);
        SeparatorContext sContext = null;
        if (showHorizontal || showVertical) {
            sContext = new SeparatorContext(context);
        }
        if (showHorizontal && (p = this.getHorizontalSeparatorPainter()) != null) {
            int width = rect.width;
            int canvasWidth = this.getColumnGeometryManager().getTotalSize();
            if (rect.x + width > canvasWidth) {
                width = canvasWidth - rect.x;
            }
            size = p.getPreferredSize((PaintContext)sContext).height;
            p.paint(sContext, g, rect.x, rect.y, width, size);
        }
        if (showVertical && (p = this.getVerticalSeparatorPainter()) != null) {
            int height = rect.height;
            int canvasHeight = this.getRowGeometryManager().getTotalSize();
            if (rect.y + height > canvasHeight) {
                height = canvasHeight - rect.y;
            }
            size = p.getPreferredSize((PaintContext)sContext).width;
            p.paint(sContext, g, rect.x, rect.y, size, height);
        }
    }

    @Override
    public Dimension getDocumentSize(PaintContext context, Dictionary printProperties) {
        GeometryManager columnGM = this.getColumnGeometryManager();
        GeometryManager rowGM = this.getRowGeometryManager();
        int width = columnGM.getTotalSize();
        int height = rowGM.getTotalSize();
        return new Dimension(width, height);
    }

    @Override
    public Rectangle getPageBounds(PaintContext context, Dictionary printProperties, int pageXOrigin, int pageYOrigin, int pageWidth, int pageHeight) {
        GeometryManager columnGM = this.getColumnGeometryManager();
        GeometryManager rowGM = this.getRowGeometryManager();
        int lastXPixel = pageXOrigin + pageWidth;
        int lastYPixel = pageYOrigin + pageHeight;
        int startColumn = columnGM.getItemAt(pageXOrigin);
        int startRow = rowGM.getItemAt(pageYOrigin);
        int endColumn = columnGM.getItemAt(lastXPixel);
        int endRow = rowGM.getItemAt(lastYPixel);
        int xSeparatorSize = 0;
        int ySeparatorSize = 0;
        if (endColumn != -1 && startColumn != endColumn) {
            pageWidth = columnGM.getItemPosition(endColumn) - pageXOrigin;
            xSeparatorSize = columnGM.getSeparatorSize();
        }
        if (endRow != -1 && startRow != endRow) {
            pageHeight = rowGM.getItemPosition(endRow) - pageYOrigin;
            ySeparatorSize = rowGM.getSeparatorSize();
        }
        Rectangle gridPageBounds = new Rectangle(pageWidth, pageHeight, pageWidth, pageHeight);
        return gridPageBounds;
    }

    public Cell getCellAt(int x, int y) {
        int column = this._getColumnGeometryManager().getItemAt(x);
        int row = this.getRowGeometryManager().getItemAt(y);
        if (column < 0 || row < 0) {
            return null;
        }
        return new Cell(column, row);
    }

    public Rectangle getCellBounds(int column1, int row1, int column2, int row2) {
        EWTGridUI ui;
        BorderPainter painter;
        int temp;
        int lowerCol = column1;
        int lowerRow = row1;
        GeometryManager cgm = this._getColumnGeometryManager();
        GeometryManager rgm = this.getRowGeometryManager();
        int x1 = this._getColumnX(column1);
        int y1 = rgm.getItemPosition(row1);
        int x2 = this._getColumnX(column2);
        int y2 = rgm.getItemPosition(row2);
        if (x1 > x2) {
            lowerCol = column2;
            temp = x2;
            x2 = x1;
            x1 = temp;
        }
        if (y1 > y2) {
            lowerRow = row2;
            temp = y2;
            y2 = y1;
            y1 = temp;
        }
        int width = x2 - x1 + cgm.getItemSize(column2);
        int height = y2 - y1 + rgm.getItemSize(row2);
        ImmInsets insets = null;
        if (this.isOverlayBorderVisible() && (painter = (ui = this.getEWTGridUI()).getOverlayBorderPainter(this)) != null) {
            insets = painter.getInsets(this.getPaintContext());
        }
        if (insets == null) {
            insets = ImmInsets.getEmptyInsets();
        }
        int firstCol = this.getFirstColumnOnScreen();
        int firstRow = this.getFirstRowOnScreen();
        if (lowerCol == firstCol) {
            x1 += insets.left;
            width -= insets.left;
        }
        if (lowerRow == firstRow) {
            y1 += insets.top;
            height -= insets.top;
        }
        return new Rectangle(x1, y1, width, height);
    }

    @Override
    protected Component getScrollParent() {
        Container parent = this.getParent();
        if (parent instanceof SpreadTable) {
            return parent;
        }
        return this;
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        int oldInnerWidth = this.getInnerSize().width;
        super.reshape(x, y, width, height);
        Dimension d = this.getCanvasSize();
        this._checkForFirstColumnRow(d);
        if (this.getActualReadingDirection() == 2) {
            int canvasWidth = d.width;
            int innerWidth = this.getInnerSize().width;
            if (oldInnerWidth <= 0) {
                this.setCanvasOrigin(innerWidth - canvasWidth, this.getCanvasOrigin().y);
            } else if (oldInnerWidth != innerWidth) {
                this.commitCellEdit();
                Point oldOrigin = this.getCanvasOrigin();
                int newOriginX = oldOrigin.x + innerWidth - oldInnerWidth;
                if (newOriginX > 0) {
                    if (canvasWidth > innerWidth) {
                        newOriginX = 0;
                    } else if (newOriginX + canvasWidth > innerWidth) {
                        newOriginX = innerWidth - canvasWidth;
                    }
                }
                this.setCanvasOrigin(newOriginX, oldOrigin.y);
            }
        }
        Dimension s = this.getInnerSize();
        this._getColumnGeometryManager().setTotalSize(s.width);
        this.getRowGeometryManager().setTotalSize(s.height);
    }

    public void setCellBorderVisible(boolean visible) {
        if (this.isCellBorderVisible() != visible) {
            this._borderVisible = visible;
            this.repaint();
        }
    }

    public boolean isCellBorderVisible() {
        return this._borderVisible;
    }

    @Override
    protected void processContainerEvent(ContainerEvent event) {
        super.processContainerEvent(event);
        if (event.getID() == 301 && event.getChild() == this._editControl && !this._removing) {
            this.commitCellEdit();
        }
    }

    @Override
    protected void processEventImpl(AWTEvent e) {
        if (e instanceof GridEvent) {
            switch (e.getID()) {
                case 2001: 
                case 2002: {
                    this.processEditEvent((GridEvent)e);
                }
            }
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processEditEvent(GridEvent e) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumer = this._editListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 2001: {
                while (enumer.hasMoreElements()) {
                    ((GridEditListener)enumer.nextElement()).cellEditing(e);
                }
                break;
            }
            case 2002: {
                while (enumer.hasMoreElements()) {
                    ((GridEditListener)enumer.nextElement()).cellEdited(e);
                }
                break;
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            if (mouseEvent.isConsumed() && mouseEvent.getID() == 502) {
                GridAutoScroller.getAutoScroller().cancel(this);
                this._cancelEdit = false;
            }
            return;
        }
        Point canvasPoint = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        Cell cell = this.getCellAt(canvasPoint.x, canvasPoint.y);
        CellInputHandler handler = null;
        if (cell != null) {
            handler = this.getColumnCellInputHandler(cell.column);
        }
        switch (mouseEvent.getID()) {
            case 500: {
                this._handleMouseClicked(mouseEvent, cell, handler);
                break;
            }
            case 504: {
                this._handleMouseEntered(mouseEvent, cell, handler);
                break;
            }
            case 505: {
                this._handleMouseExited(mouseEvent, cell, handler);
                break;
            }
            case 501: {
                this._handleMousePressed(mouseEvent, cell, handler);
                break;
            }
            case 502: {
                this._handleMouseReleased(mouseEvent, cell, handler);
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (e.isConsumed() || !this.isEnabled()) {
            return;
        }
        Point p = this.convertOuterToCanvas(e.getX(), e.getY());
        Cell cell = this.getCellAt(p.x, p.y);
        CellInputHandler handler = null;
        if (cell != null) {
            handler = this.getColumnCellInputHandler(cell.column);
        }
        switch (e.getID()) {
            case 503: {
                this._handleMouseMoved(e, cell, handler);
                break;
            }
            case 506: {
                this._handleMouseDragged(e, cell, handler);
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            if (this._focusCell != null) {
                this._fireActiveEvent(null, this._focusCell);
            } else {
                Cell cell;
                int col = this.getNextVisibleColumn(-1);
                int row = this.getNextVisibleRow(-1);
                TwoDSelection sel = this.getSelection();
                if (sel.isEmpty() && !this._handlingMousePressed && col != -1 && row != -1) {
                    try {
                        this.setSelection(new TwoDSelection(col, row));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (!sel.isEmpty() && (cell = sel.getSingleCell()) != null) {
                    row = cell.row;
                    col = cell.column;
                }
                if (col != -1 && row != -1) {
                    this.requestFocus(col, row, null);
                }
            }
        }
        this.repaintInterior();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (!(e.isConsumed() || e.isControlDown() || e.isMetaDown() || e.getID() != 401 || e.getKeyCode() != 9)) {
            FocusManager fm = FocusManager.getCurrentManager();
            if (e.isShiftDown()) {
                fm.focusPreviousComponent(this);
            } else {
                fm.focusNextComponent(this);
            }
            e.consume();
        }
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (this._editControl != null) {
            this._editControl.requestFocus();
            return;
        }
        int eventID = keyEvent.getID();
        if (eventID == 401) {
            this._handleKeyPressed(keyEvent);
        } else if (eventID == 400) {
            this._handleKeyTyped(keyEvent);
        } else if (eventID == 402) {
            this._handleKeyReleased(keyEvent);
        }
    }

    @Override
    public int getHMaximum() {
        if (!this.getScrollByColumn()) {
            return super.getHMaximum();
        }
        return this.getVisibleColumnCount();
    }

    @Override
    public int getHValueOfOffset(int x) {
        if (!this.getScrollByColumn()) {
            return super.getHValueOfOffset(x);
        }
        GeometryManager columnGM = this._getColumnGeometryManager();
        int temp = columnGM.getItemAt(-x);
        int visIndex = columnGM.getItemVisibleIndex(temp);
        if (temp >= 0 && columnGM.getItemPosition(temp) < -x) {
            ++visIndex;
        }
        return visIndex;
    }

    @Override
    public int getHOffsetOfValue(int value) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        if (!this.getScrollByColumn()) {
            return super.getHOffsetOfValue(value);
        }
        if (value >= this.getHMaximum()) {
            value = this.getHMaximum() - 1;
        }
        int temp = this._convertVisibleColumnIndexToColumnIndex(value);
        temp = columnGM.visibleIndexToIndex(temp);
        int offset = columnGM.getItemPosition(temp);
        int canvasWidth = this.getCanvasSize().width;
        int innerWidth = this.getInnerSize().width;
        int minimumOffset = 0;
        if (canvasWidth > innerWidth && canvasWidth != 0 && innerWidth != 0) {
            minimumOffset = innerWidth - canvasWidth;
        }
        if (-offset < minimumOffset) {
            offset = -minimumOffset;
        }
        return -offset;
    }

    @Override
    public int getVMaximum() {
        if (!this.getScrollByRow()) {
            return super.getVMaximum();
        }
        return this.getVisibleRowCount();
    }

    @Override
    public int getVValueOfOffset(int y) {
        if (!this.getScrollByRow()) {
            return super.getVValueOfOffset(y);
        }
        GeometryManager rowGM = this.getRowGeometryManager();
        int temp = rowGM.getItemAt(-y);
        return rowGM.getItemVisibleIndex(temp);
    }

    @Override
    public int getVOffsetOfValue(int value) {
        if (!this.getScrollByRow()) {
            return super.getVOffsetOfValue(value);
        }
        if (value >= this.getVMaximum()) {
            value = this.getVMaximum() - 1;
        }
        GeometryManager rowGM = this.getRowGeometryManager();
        int temp = this._convertVisibleRowIndexToRowIndex(value);
        temp = rowGM.visibleIndexToIndex(temp);
        int offset = rowGM.getItemPosition(temp);
        return -offset;
    }

    @Override
    public Dimension layoutCanvas() {
        Dimension d = this._calculateCanvasSize();
        this._checkForFirstColumnRow(d);
        return d;
    }

    @Override
    public void paintCanvasInterior(Graphics g) {
        this._paintGrid(this.getPaintContext(), g, true);
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        super.fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected void paintFocusCell(Graphics g) {
        if (this._focusCell != null) {
            Rectangle drawRect = this._getCellRect(this._focusCell.column, this._focusCell.row);
            if (drawRect == null) {
                return;
            }
            this._paintBorderAroundCells(drawRect, g);
        }
    }

    protected boolean paintSelectionBorder(Graphics g) {
        Rectangle selBounds = this._getSelectionBounds();
        if (selBounds == null) {
            return false;
        }
        this._paintBorderAroundCells(selBounds, g);
        return true;
    }

    public void scrollCellIntoView(int column, int row) {
        Rectangle cellRect = this._getCellRect(column, row, false);
        this.scrollRectToVisible(cellRect);
    }

    public void scrollColumnIntoView(int column) {
        Rectangle columnRect = this._getColumnRect(column);
        this.scrollRectToVisible(columnRect);
    }

    public void scrollRowIntoView(int row) {
        Rectangle rowRect = this._getRowRect(row);
        this.scrollRectToVisible(rowRect);
    }

    protected int getCellPaintState(int baseState, int column, int row) {
        if (this._enabledStates == null) {
            return baseState;
        }
        if (this._enabledStates[column][row]) {
            return baseState;
        }
        return baseState |= 1;
    }

    @Override
    protected Object getPaintData(Object key) {
        Object data = null;
        if (MODEL_KEY.equals(key)) {
            data = this.getModel();
        } else if (GRID_KEY.equals(key)) {
            data = this;
        } else if (HORIZONTAL_SEPARATOR_COLOR_KEY.equals(key)) {
            data = this.getHorizontalSeparatorColor();
        } else if (VERTICAL_SEPARATOR_COLOR_KEY.equals(key)) {
            data = this.getVerticalSeparatorColor();
        }
        if (data == null) {
            data = super.getPaintData(key);
        }
        return data;
    }

    protected final boolean isCellEnabled(int column, int row) {
        PaintContext context = this.getCellPaintContext(column, row);
        return (context.getPaintState() & 1) == 0;
    }

    protected TwoDSelection getModelRangeSelection(int modelColumn1, int modelRow1, int modelColumn2, int modelRow2) {
        GeometryManager cgm = this._getColumnGeometryManager();
        GeometryManager rgm = this.getRowGeometryManager();
        int visibleColumn1 = cgm.getItemVisibleIndex(modelColumn1);
        int visibleColumn2 = cgm.getItemVisibleIndex(modelColumn2);
        int visibleRow1 = rgm.getItemVisibleIndex(modelRow1);
        int visibleRow2 = rgm.getItemVisibleIndex(modelRow2);
        CellRange[] crs = new CellRange[]{new CellRange(visibleColumn1, visibleRow1, visibleColumn2, visibleRow2)};
        CellRange[] result = this._modelCellRangesFromVisibleCellRanges(crs);
        TwoDSelection sel = new TwoDSelection(null, null, result);
        return sel;
    }

    void focusLost(FocusEvent e) {
        if (!this._removing) {
            Component opp;
            if (this._editControlChildren != null && (opp = FocusUtils.getOppositeComponent(e)) != null) {
                int count = this._editControlChildren.length;
                for (int i = 0; i < count; ++i) {
                    if (opp != this._editControlChildren[i]) continue;
                    return;
                }
            }
            this._canRequestFocus = false;
            this.commitCellEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalRowsAdded(TwoDModelEvent modelEvent) {
        int firstRow = this.getFirstRowOnScreen();
        int startIndex = modelEvent.getRowStartIndex();
        int numberOfRows = modelEvent.getRowCount();
        int numberOfCols = this.getColumnCount();
        if (numberOfCols != 0) {
            if (this._enabledStates != null) {
                int j;
                int i;
                int prevRowLen = this._enabledStates[0].length;
                int prevColLen = this._enabledStates.length;
                boolean[][] newEnabledStates = new boolean[prevColLen][prevRowLen + numberOfRows];
                for (i = 0; i < prevColLen; ++i) {
                    for (j = 0; j < startIndex; ++j) {
                        newEnabledStates[i][j] = this._enabledStates[i][j];
                    }
                }
                for (i = 0; i < prevColLen; ++i) {
                    for (j = 0; j < numberOfRows; ++j) {
                        newEnabledStates[i][j + startIndex] = true;
                    }
                }
                int restRowsStart = startIndex + numberOfRows;
                int prevRestRows = prevRowLen - startIndex;
                for (int i2 = 0; i2 < prevColLen; ++i2) {
                    for (int j2 = 0; j2 < prevRestRows; ++j2) {
                        newEnabledStates[i2][j2 + restRowsStart] = this._enabledStates[i2][j2 + startIndex];
                    }
                }
                this._enabledStates = newEnabledStates;
                newEnabledStates = null;
            } else {
                this._enabledStates = new boolean[numberOfCols][numberOfRows];
                for (int i = 0; i < numberOfCols; ++i) {
                    for (int j = 0; j < numberOfRows; ++j) {
                        this._enabledStates[i][j] = true;
                    }
                }
            }
        }
        this.freezeRepaints();
        try {
            OneDModelListener oddsl;
            TwoDModelListener tddl;
            GridSelectionManager gs;
            TwoDModelListener tddl2;
            AppearanceManager am = this.getAppearanceManager();
            if (am != null && (tddl2 = am.getTwoDModelListener()) != null) {
                tddl2.rowsAdded(modelEvent);
            }
            if ((gs = this.getGridSelectionManager()) != null && (tddl = gs.getTwoDModelListener()) != null) {
                this._ignoreSelectionRepaints = true;
                tddl.rowsAdded(modelEvent);
                this._ignoreSelectionRepaints = false;
            }
            if (this._rowGM != null && (oddsl = this._rowGM.getOneDModelListener()) != null) {
                oddsl.itemsAdded(new OneDModelEvent(this, 2001, startIndex, numberOfRows));
            }
            this._focusCell = this._addRowsToCell(this._focusCell, startIndex, numberOfRows);
            this.setAnchorCell(this._addRowsToCell(this.getAnchorCell(), startIndex, numberOfRows));
            this._moveCell = this._addRowsToCell(this._moveCell, startIndex, numberOfRows);
            this._mouseGrabCell = this._addRowsToCell(this._mouseGrabCell, startIndex, numberOfRows);
            Dimension oldCanvasSize = this.getCanvasSize();
            Point oldCanvasOrigin = this.getCanvasOrigin();
            Dimension canvasSize = this.layoutCanvas();
            this.setCanvasSize(canvasSize.width, canvasSize.height);
            int prevRowCount = this.getRowCount() - numberOfRows;
            if (prevRowCount == 0) {
                this.setFirstRowOnScreen(0);
            } else if (startIndex <= firstRow) {
                this.setFirstRowOnScreen(firstRow + numberOfRows);
            }
            this.revalidate();
        }
        finally {
            this.unfreezeRepaints();
            int temp = startIndex;
            if (temp == this.getRowCount()) {
                --temp;
            }
            if (this.isRowOnScreen(temp)) {
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalRowsRemoved(TwoDModelEvent modelEvent) {
        int startIndex = modelEvent.getRowStartIndex();
        int numberOfRows = modelEvent.getRowCount();
        int numberOfCols = this.getColumnCount();
        boolean repaint = false;
        if (numberOfCols != 0 && this._enabledStates != null) {
            int prevRowLen = this._enabledStates[0].length;
            int prevColLen = this._enabledStates.length;
            if (prevRowLen - numberOfRows == 0) {
                this._enabledStates = null;
            } else {
                boolean[][] newEnabledStates = new boolean[prevColLen][prevRowLen - numberOfRows];
                for (int i = 0; i < prevColLen; ++i) {
                    for (int j = 0; j < startIndex; ++j) {
                        newEnabledStates[i][j] = this._enabledStates[i][j];
                    }
                }
                int restRowsStart = startIndex + numberOfRows;
                int prevRestRows = prevRowLen - restRowsStart;
                for (int i = 0; i < prevColLen; ++i) {
                    for (int j = 0; j < prevRestRows; ++j) {
                        newEnabledStates[i][j + startIndex] = this._enabledStates[i][j + restRowsStart];
                    }
                }
                this._enabledStates = newEnabledStates;
                newEnabledStates = null;
            }
        }
        this.freezeRepaints();
        try {
            OneDModelListener oddsl;
            TwoDModelListener tddl;
            GridSelectionManager gs;
            TwoDModelListener tddl2;
            int firstIndex = this.getFirstRowOnScreen();
            int lastIndex = firstIndex + this.getOnScreenRowCount();
            if (startIndex >= firstIndex && startIndex <= lastIndex) {
                repaint = true;
            } else if (startIndex < firstIndex && startIndex + numberOfRows > startIndex) {
                repaint = true;
            }
            AppearanceManager am = this.getAppearanceManager();
            if (am != null && (tddl2 = am.getTwoDModelListener()) != null) {
                tddl2.rowsRemoved(modelEvent);
            }
            if ((gs = this.getGridSelectionManager()) != null && (tddl = gs.getTwoDModelListener()) != null) {
                this._ignoreSelectionRepaints = true;
                tddl.rowsRemoved(modelEvent);
                this._ignoreSelectionRepaints = false;
            }
            if (this._rowGM != null && (oddsl = this._rowGM.getOneDModelListener()) != null) {
                oddsl.itemsRemoved(new OneDModelEvent(this, 2002, startIndex, numberOfRows));
            }
            if (this._focusCell != null && this._focusCell.row >= startIndex && this._focusCell.row < startIndex + numberOfRows && this.isEditing()) {
                this.cancelCellEdit();
            }
            this._focusCell = this._removeRowsFromCell(this._focusCell, startIndex, numberOfRows);
            this.setAnchorCell(this._removeRowsFromCell(this.getAnchorCell(), startIndex, numberOfRows));
            this._moveCell = this._removeRowsFromCell(this._moveCell, startIndex, numberOfRows);
            this._mouseGrabCell = this._removeRowsFromCell(this._mouseGrabCell, startIndex, numberOfRows);
            if (this._focusCell == null) {
                int focusColumn = this.getNextVisibleColumn(-1);
                int focusRow = this.getNextVisibleRow(-1);
                if (focusColumn != -1 && focusRow != -1) {
                    this._focusCell = new Cell(focusColumn, focusRow);
                }
            }
            Dimension oldCanvasSize = this.getCanvasSize();
            Point oldCanvasOrigin = this.getCanvasOrigin();
            Dimension canvasSize = this.layoutCanvas();
            this.setCanvasSize(canvasSize.width, canvasSize.height);
            if (startIndex <= firstIndex) {
                if (startIndex + numberOfRows - 1 < firstIndex) {
                    this.setFirstRowOnScreen(firstIndex - numberOfRows);
                } else {
                    int i = this.getNextVisibleRow(-1);
                    int next = this.getNextVisibleRow(i);
                    while (next < startIndex && next != -1) {
                        i = next;
                        next = this.getNextVisibleRow(next);
                    }
                    if (i != -1) {
                        this.setFirstRowOnScreen(i);
                    } else {
                        this._firstRow = -1;
                        this.setCanvasOrigin(this.getCanvasOrigin().x, 0);
                    }
                }
            }
            this.revalidate();
        }
        finally {
            this.unfreezeRepaints();
            if (repaint) {
                this.repaint();
            }
        }
    }

    void internalInvalidateRows(TwoDModelEvent e) {
        GeometryManager rowGM = this.getRowGeometryManager();
        int startRow = e.getRowStartIndex();
        int endRow = startRow + e.getRowCount() - 1;
        int x = 0;
        int y = rowGM.getItemPosition(startRow);
        int width = this._getColumnGeometryManager().getTotalSize();
        int height = rowGM.getItemPosition(endRow) + rowGM.getItemSize(endRow);
        this.repaintCanvas(x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalColumnsAdded(TwoDModelEvent e) {
        int firstColumn = this.getFirstColumnOnScreen();
        int startIndex = e.getColumnStartIndex();
        int numberOfColumns = e.getColumnCount();
        int numberOfRows = this.getRowCount();
        if (numberOfRows != 0) {
            if (this._enabledStates != null) {
                int j;
                int i;
                int prevRowLen = this._enabledStates[0].length;
                int prevColLen = this._enabledStates.length;
                boolean[][] newEnabledStates = new boolean[prevColLen + numberOfColumns][prevRowLen];
                for (i = 0; i < startIndex; ++i) {
                    for (j = 0; j < prevRowLen; ++j) {
                        newEnabledStates[i][j] = this._enabledStates[i][j];
                    }
                }
                for (i = 0; i < numberOfColumns; ++i) {
                    for (j = 0; j < prevRowLen; ++j) {
                        newEnabledStates[i + startIndex][j] = true;
                    }
                }
                int restColsStart = startIndex + numberOfColumns;
                int prevRestCols = prevColLen - startIndex;
                for (int i2 = 0; i2 < prevRestCols; ++i2) {
                    for (int j2 = 0; j2 < prevRowLen; ++j2) {
                        newEnabledStates[i2 + restColsStart][j2] = this._enabledStates[i2 + startIndex][j2];
                    }
                }
                this._enabledStates = newEnabledStates;
                newEnabledStates = null;
            } else {
                this._enabledStates = new boolean[numberOfColumns][numberOfRows];
                for (int i = 0; i < numberOfColumns; ++i) {
                    for (int j = 0; j < numberOfRows; ++j) {
                        this._enabledStates[i][j] = true;
                    }
                }
            }
        }
        this.freezeRepaints();
        try {
            OneDModelListener oddsl;
            TwoDModelListener tddl;
            GridSelectionManager gs;
            TwoDModelListener tddl2;
            this._columnsAdded(startIndex, numberOfColumns);
            AppearanceManager am = this.getAppearanceManager();
            if (am != null && (tddl2 = am.getTwoDModelListener()) != null) {
                tddl2.columnsAdded(e);
            }
            if ((gs = this.getGridSelectionManager()) != null && (tddl = gs.getTwoDModelListener()) != null) {
                this._ignoreSelectionRepaints = true;
                tddl.columnsAdded(e);
                this._ignoreSelectionRepaints = false;
            }
            if (this._columnGM != null && (oddsl = this._columnGM.getOneDModelListener()) != null) {
                oddsl.itemsAdded(new OneDModelEvent(this, 2001, startIndex, numberOfColumns));
            }
            this._focusCell = this._addColumnsToCell(this._focusCell, startIndex, numberOfColumns);
            this.setAnchorCell(this._addColumnsToCell(this.getAnchorCell(), startIndex, numberOfColumns));
            this._moveCell = this._addColumnsToCell(this._moveCell, startIndex, numberOfColumns);
            this._mouseGrabCell = this._addColumnsToCell(this._mouseGrabCell, startIndex, numberOfColumns);
            Dimension oldCanvasSize = this.getCanvasSize();
            Point oldCanvasOrigin = this.getCanvasOrigin();
            Dimension canvasSize = this.layoutCanvas();
            this.setCanvasSize(canvasSize.width, canvasSize.height);
            int prevColumnCount = this.getColumnCount() - numberOfColumns;
            if (prevColumnCount == 0) {
                this.setFirstColumnOnScreen(0);
            } else if (startIndex <= firstColumn) {
                this.setFirstColumnOnScreen(firstColumn + numberOfColumns);
            }
            this.revalidate();
        }
        finally {
            boolean repaint;
            this.unfreezeRepaints();
            int temp = startIndex;
            if (temp == this.getColumnCount()) {
                --temp;
            }
            if (repaint = this.isColumnOnScreen(temp)) {
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalColumnsRemoved(TwoDModelEvent e) {
        int startIndex = e.getColumnStartIndex();
        int numberOfColumns = e.getColumnCount();
        int numberOfRows = this.getRowCount();
        boolean repaint = false;
        if (numberOfRows != 0 && this._enabledStates != null) {
            int prevRowLen = this._enabledStates[0].length;
            int prevColLen = this._enabledStates.length;
            if (prevColLen - numberOfColumns <= 0) {
                this._enabledStates = null;
            } else {
                boolean[][] newEnabledStates = new boolean[prevColLen - numberOfColumns][prevRowLen];
                for (int i = 0; i < startIndex; ++i) {
                    for (int j = 0; j < prevRowLen; ++j) {
                        newEnabledStates[i][j] = this._enabledStates[i][j];
                    }
                }
                int restColsStart = startIndex + numberOfColumns;
                int prevRestCols = prevColLen - restColsStart;
                for (int i = 0; i < prevRestCols; ++i) {
                    for (int j = 0; j < prevRowLen; ++j) {
                        newEnabledStates[i + startIndex][j] = this._enabledStates[i + restColsStart][j];
                    }
                }
                this._enabledStates = newEnabledStates;
                newEnabledStates = null;
            }
        }
        this.freezeRepaints();
        try {
            OneDModelListener oddsl;
            TwoDModelListener tddl;
            GridSelectionManager gs;
            TwoDModelListener tddl2;
            int firstIndex = this.getFirstColumnOnScreen();
            int lastIndex = firstIndex + this.getOnScreenColumnCount();
            if (startIndex >= firstIndex && startIndex <= lastIndex) {
                repaint = true;
            } else if (startIndex < firstIndex && startIndex + numberOfColumns > startIndex) {
                repaint = true;
            }
            AppearanceManager am = this.getAppearanceManager();
            if (am != null && (tddl2 = am.getTwoDModelListener()) != null) {
                tddl2.columnsRemoved(e);
            }
            if ((gs = this.getGridSelectionManager()) != null && (tddl = gs.getTwoDModelListener()) != null) {
                this._ignoreSelectionRepaints = true;
                tddl.columnsRemoved(e);
                this._ignoreSelectionRepaints = false;
            }
            this._columnsRemoved(startIndex, numberOfColumns);
            if (this._columnGM != null && (oddsl = this._columnGM.getOneDModelListener()) != null) {
                oddsl.itemsRemoved(new OneDModelEvent(this, 2002, startIndex, numberOfColumns));
            }
            if (this._focusCell != null && this._focusCell.column >= startIndex && this._focusCell.column < startIndex + numberOfColumns && this.isEditing()) {
                this.cancelCellEdit();
            }
            this._focusCell = this._removeColumnsFromCell(this._focusCell, startIndex, numberOfColumns);
            this.setAnchorCell(this._removeColumnsFromCell(this.getAnchorCell(), startIndex, numberOfColumns));
            this._moveCell = this._removeColumnsFromCell(this._moveCell, startIndex, numberOfColumns);
            this._mouseGrabCell = this._removeColumnsFromCell(this._mouseGrabCell, startIndex, numberOfColumns);
            if (this._focusCell == null) {
                int focusColumn = this.getNextVisibleColumn(-1);
                int focusRow = this.getNextVisibleRow(-1);
                if (focusColumn != -1 && focusRow != -1) {
                    this._focusCell = new Cell(focusColumn, focusRow);
                }
            }
            Dimension oldCanvasSize = this.getCanvasSize();
            Point oldCanvasOrigin = this.getCanvasOrigin();
            Dimension canvasSize = this.layoutCanvas();
            this.setCanvasSize(canvasSize.width, canvasSize.height);
            if (startIndex <= firstIndex) {
                if (startIndex + numberOfColumns - 1 < firstIndex) {
                    this.setFirstColumnOnScreen(firstIndex - numberOfColumns);
                } else {
                    int i = this.getNextVisibleColumn(-1);
                    int next = this.getNextVisibleColumn(i);
                    while (next < startIndex && next != -1) {
                        i = next;
                        next = this.getNextVisibleColumn(next);
                    }
                    if (i != -1) {
                        this.setFirstColumnOnScreen(i);
                    } else {
                        this._firstColumn = -1;
                        this.setCanvasOrigin(0, this.getCanvasOrigin().y);
                    }
                }
            }
            this.revalidate();
        }
        finally {
            this.unfreezeRepaints();
            if (repaint) {
                this.repaint();
            }
        }
    }

    void internalInvalidateColumns(TwoDModelEvent e) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        int startColumn = e.getColumnStartIndex();
        int endColumn = startColumn + e.getColumnCount() - 1;
        int x = columnGM.getItemPosition(startColumn);
        int y = 0;
        int width = columnGM.getItemPosition(endColumn) + columnGM.getItemSize(endColumn);
        int height = this.getRowGeometryManager().getTotalSize();
        this.repaintCanvas(x, y, width, height);
    }

    void internalInvalidateCells(TwoDModelEvent e) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        GeometryManager rowGM = this.getRowGeometryManager();
        int startColumn = e.getColumnStartIndex();
        int endColumn = startColumn + e.getColumnCount() - 1;
        int startRow = e.getRowStartIndex();
        int endRow = startRow + e.getRowCount() - 1;
        int x = columnGM.getItemPosition(startColumn);
        int y = rowGM.getItemPosition(startRow);
        int width = columnGM.getItemPosition(endColumn) + columnGM.getItemSize(endColumn);
        int height = rowGM.getItemPosition(endRow) + rowGM.getItemSize(endRow);
        this.repaintCanvas(x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _doneEditing(boolean doCommit) {
        int focusRow;
        int focusColumn;
        Component editControl;
        Grid grid = this;
        synchronized (grid) {
            editControl = this._editControl;
            if (editControl == null || this._focusCell == null) {
                return;
            }
            focusColumn = this._focusCell.column;
            focusRow = this._focusCell.row;
            this._removing = true;
            CellInputHandler handler = this.getColumnCellInputHandler(focusColumn);
            if (doCommit) {
                Object data = handler.commitEdit(this, focusColumn, focusRow);
                if (handler.isDirty(this, focusColumn, focusRow)) {
                    this.getModel().setData(focusColumn, focusRow, data);
                }
            } else {
                handler.cancelEdit(this, focusColumn, focusRow);
            }
            this._removeListeners(this._editControlChildren);
            this._editControlChildren = null;
            this._editControl = null;
        }
        editControl.setVisible(false);
        this.remove(editControl);
        if (this._canRequestFocus) {
            this.requestFocus();
        } else {
            this._canRequestFocus = true;
        }
        this._removing = false;
        this.fireCellEvent(focusColumn, focusRow, 2002);
    }

    void setLastRowOnScreen(int modelIndex) {
        GeometryManager rowGM = this.getRowGeometryManager();
        if (modelIndex < 0 || modelIndex >= this.getRowCount() || !rowGM.isItemVisible(modelIndex)) {
            throw new IllegalArgumentException("Illegal row " + modelIndex);
        }
        if (this.getCanvasHeight() != 0) {
            int origin = rowGM.getItemPosition(modelIndex) - (this.getInnerSize().height - rowGM.getItemSize(modelIndex) - rowGM.getSeparatorSize());
            if (origin < 0) {
                origin = 0;
            }
            origin = -origin;
            if (this.getCanvasOriginY() != origin) {
                this.commitCellEdit();
                this.setCanvasOrigin(this.getCanvasOriginX(), origin);
            }
        }
    }

    private static void _updateTraversalKeys() {
        if (_sFocusForwardTraversalKeys == null) {
            _sFocusForwardTraversalKeys = new HashSet(1);
            _sFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        }
        if (_sFocusBackwardTraversalKeys == null) {
            _sFocusBackwardTraversalKeys = new HashSet(1);
            _sFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        }
    }

    private GeometryManager _getColumnGeometryManager() {
        if (this._columnGM == null) {
            int columnWidth = this.getEWTGridUI().getDefaultColumnWidth(this);
            GeneralGeometryManager gm = new GeneralGeometryManager();
            gm.setDefaultItemSize(columnWidth);
            this.setColumnGeometryManager(gm);
        }
        return this._columnGM;
    }

    private void _addListeners(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            component.addFocusListener(this._getFocusListener());
            component.addKeyListener(this._getKeyListener());
        }
    }

    private void _removeListeners(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            component.removeKeyListener(this._getKeyListener());
            component.removeFocusListener(this._getFocusListener());
        }
    }

    private void _addNextFocus(Component[] components) {
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            JComponent c = (JComponent)components[i];
            c.setNextFocusableComponent(this);
        }
    }

    private void _paintColumn(int index, boolean synchronously) {
        if (this.getVisibleRowCount() == 0 || !this.isColumnVisible(index) || !this.isColumnOnScreen(index)) {
            return;
        }
        this.validate();
        Rectangle rect = this._getColumnRect(index);
        if (synchronously) {
            this.paintImmediateInterior(rect.x, rect.y, rect.width, rect.height);
        } else {
            this.repaintInterior(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private void _paintRow(int index, boolean synchronously) {
        if (this.getVisibleColumnCount() == 0 || !this.isRowVisible(index) || !this.isRowOnScreen(index)) {
            return;
        }
        this.validate();
        Rectangle rect = this._getRowRect(index);
        if (synchronously) {
            this.paintImmediateInterior(rect.x, rect.y, rect.width, rect.height);
        } else {
            this.repaintInterior(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private void _paintCell(int columnIndex, int rowIndex, boolean synchronously) {
        if (!this.isColumnVisible(columnIndex) || !this.isRowVisible(rowIndex)) {
            return;
        }
        GeometryManager rowGM = this.getRowGeometryManager();
        this.validate();
        int x = this._getColumnX(columnIndex) - 1;
        int y = rowGM.getItemPosition(rowIndex) - 1;
        int width = this._getColumnGeometryManager().getItemSize(columnIndex) + 1;
        int height = rowGM.getItemSize(rowIndex) + 1;
        if (synchronously) {
            this.paintImmediateInterior(x, y, width, height);
        } else {
            this.repaintInterior(x, y, width, height);
        }
    }

    private void _sendKeyToHandler(KeyEvent e) {
        GridKeyHandler handler = this.getGridKeyHandler();
        if (handler != null) {
            handler.handleKeyEvent(this, e);
        }
    }

    private CellRange[] _modelCellRangesFromVisibleCellRanges(CellRange[] visibleCellRanges) {
        return this._transformCellRanges(visibleCellRanges, false);
    }

    private CellRange[] _visibleCellRangesFromModelCellRanges(CellRange[] modelCellRanges) {
        return this._transformCellRanges(modelCellRanges, true);
    }

    private CellRange[] _transformCellRanges(CellRange[] cellRanges, boolean modelToVisible) {
        int i;
        if (cellRanges == null) {
            return null;
        }
        GeometryManager cgm = this._getColumnGeometryManager();
        GeometryManager rgm = this.getRowGeometryManager();
        Vector<Range> columnRangeVector = new Vector<Range>();
        Vector<Range> rowRangeVector = new Vector<Range>();
        for (i = 0; i < cellRanges.length; ++i) {
            int c1 = cellRanges[i].getLowerLimit().column;
            int c2 = cellRanges[i].getUpperLimit().column;
            int r1 = cellRanges[i].getLowerLimit().row;
            int r2 = cellRanges[i].getUpperLimit().row;
            columnRangeVector.addElement(new Range(c1, c2));
            rowRangeVector.addElement(new Range(r1, r2));
        }
        Object[] columnRanges = new Range[columnRangeVector.size()];
        columnRangeVector.copyInto(columnRanges);
        Object[] rowRanges = new Range[rowRangeVector.size()];
        rowRangeVector.copyInto(rowRanges);
        if (modelToVisible) {
            columnRanges = cgm.rangesToVisibleRanges((Range[])columnRanges);
            rowRanges = rgm.rangesToVisibleRanges((Range[])rowRanges);
        } else {
            columnRanges = cgm.visibleRangesToRanges((Range[])columnRanges);
            rowRanges = rgm.visibleRangesToRanges((Range[])rowRanges);
        }
        Vector<CellRange> resultVector = new Vector<CellRange>();
        for (i = 0; i < columnRanges.length; ++i) {
            for (int j = 0; j < rowRanges.length; ++j) {
                CellRange cr = new CellRange(columnRanges[i].getLowerLimit(), rowRanges[j].getLowerLimit(), columnRanges[i].getUpperLimit(), rowRanges[j].getUpperLimit());
                resultVector.addElement(cr);
            }
        }
        Object[] result = new CellRange[resultVector.size()];
        resultVector.copyInto(result);
        return result;
    }

    private CellRange[] _convertModelToVisibleRanges(CellRange[] cellRanges) {
        if (cellRanges == null || cellRanges.length == 0) {
            return null;
        }
        GeometryManager cgm = this._getColumnGeometryManager();
        GeometryManager rgm = this.getRowGeometryManager();
        CellRange[] result = null;
        for (int i = 0; i < cellRanges.length; ++i) {
            Cell minCell = cellRanges[i].getLowerLimit();
            Cell maxCell = cellRanges[i].getUpperLimit();
            Range[] colRange = new Range[]{new Range(minCell.column, maxCell.column)};
            Range[] rowRange = new Range[]{new Range(minCell.row, maxCell.row)};
            colRange = cgm.rangesToVisibleRanges(colRange);
            rowRange = rgm.rangesToVisibleRanges(rowRange);
            for (int j = 0; j < colRange.length; ++j) {
                for (int k = 0; k < rowRange.length; ++k) {
                    CellRange[] cr = new CellRange[]{new CellRange(colRange[j].getLowerLimit(), rowRange[k].getLowerLimit(), colRange[j].getUpperLimit(), rowRange[k].getUpperLimit())};
                    result = CellRange.addCellRanges(result, cr);
                }
            }
        }
        return result;
    }

    private Cell _addColumnsToCell(Cell c, int startIndex, int numberOfColumns) {
        if (c != null && c.column >= startIndex) {
            c.column += numberOfColumns;
        }
        return c;
    }

    private Cell _removeColumnsFromCell(Cell c, int startIndex, int numberOfColumns) {
        if (c != null) {
            if (c.column >= startIndex && c.column < startIndex + numberOfColumns) {
                c.column = startIndex;
                if (c.column >= this.getColumnCount()) {
                    c.column = this.getColumnCount() - 1;
                }
                if (c.column < 0) {
                    c = null;
                }
            } else if (c.column >= startIndex + numberOfColumns) {
                c.column -= numberOfColumns;
            }
        }
        return c;
    }

    private Cell _addRowsToCell(Cell c, int startIndex, int numberOfRows) {
        if (c != null && c.row >= startIndex) {
            c.row += numberOfRows;
        }
        return c;
    }

    private Cell _removeRowsFromCell(Cell c, int startIndex, int numberOfRows) {
        if (c != null) {
            if (c.row >= startIndex && c.row < startIndex + numberOfRows) {
                c.row = startIndex;
                if (c.row >= this.getRowCount()) {
                    c.row = this.getRowCount() - 1;
                }
                if (c.row < 0) {
                    c = null;
                }
            } else if (c.row >= startIndex + numberOfRows) {
                c.row -= numberOfRows;
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _paintGrid(PaintContext context, Graphics g, boolean paintFocusCell) {
        Object object = this._paintLock;
        synchronized (object) {
            EWTGridUI ui;
            BorderPainter painter;
            this._paintExtraCanvas(g);
            if (this.getVisibleColumnCount() != 0 && this.getVisibleRowCount() != 0) {
                this._paintCells(context, g, paintFocusCell);
            }
            boolean print = g instanceof PrintGraphics || g instanceof PrinterGraphics;
            if (this.isOverlayBorderVisible() & !print && (this.getExtraCanvasBackground() == null || this.getFill() != null) && (painter = (ui = this.getEWTGridUI()).getOverlayBorderPainter(this)) != null) {
                painter.paint(context, g, 0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private void _paintExtraCanvas(Graphics g) {
        Color extraBg = this.getExtraCanvasBackground();
        if (extraBg != null && this.getFill() == null) {
            Color old = g.getColor();
            g.setColor(extraBg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(old);
        }
    }

    private Dimension _calculateCanvasSize() {
        Painter painter;
        GeometryManager rowGM = this.getRowGeometryManager();
        GeometryManager columnGM = this._getColumnGeometryManager();
        int size = !this.getHorizontalSeparatorsVisible() ? 0 : ((painter = this.getHorizontalSeparatorPainter()) == null ? 0 : painter.getPreferredSize((PaintContext)this.getPaintContext()).height);
        rowGM.setSeparatorSize(size);
        size = !this.getVerticalSeparatorsVisible() ? 0 : this._vpWidth;
        columnGM.setSeparatorSize(size);
        int width = columnGM.getTotalSize();
        int height = rowGM.getTotalSize();
        return new Dimension(width, height);
    }

    private void _paintCells(PaintContext context, Graphics g, boolean paintFocusCell) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        GeometryManager rowGM = this.getRowGeometryManager();
        Rectangle clip = g.getClipBounds();
        if (clip.x < 0) {
            clip.width += clip.x;
            clip.x = 0;
        }
        if (clip.y < 0) {
            clip.height += clip.y;
            clip.y = 0;
        }
        int startColumn = columnGM.getItemAt(clip.x);
        int startRow = rowGM.getItemAt(clip.y);
        if (startColumn != -1 && startRow != -1) {
            startColumn = columnGM.getItemVisibleIndex(startColumn);
            startRow = rowGM.getItemVisibleIndex(startRow);
            int endColumn = columnGM.getItemAt(clip.x + clip.width - 1);
            if (endColumn == -1) {
                endColumn = this.getPreviousVisibleColumn(this.getColumnCount());
            }
            endColumn = columnGM.getItemVisibleIndex(endColumn);
            int endRow = rowGM.getItemAt(clip.y + clip.height - 1);
            if (endRow == -1) {
                endRow = this.getPreviousVisibleRow(this.getRowCount());
            }
            endRow = rowGM.getItemVisibleIndex(endRow);
            if (startColumn < 0 || startRow < 0 || endColumn < 0 || endRow < 0) {
                return;
            }
            if (startColumn > endColumn) {
                int temp = endColumn;
                endColumn = startColumn;
                startColumn = temp;
            }
            SeparatorContext sContext = new SeparatorContext(context);
            for (int i = startColumn; i <= endColumn; ++i) {
                int index = columnGM.visibleIndexToIndex(i);
                if (!columnGM.isItemVisible(index)) continue;
                this._paintColumn(sContext, g, clip, index, startRow, endRow);
            }
            if (startRow != 0) {
                --startRow;
            }
            if (startColumn != 0) {
                --startColumn;
            }
            this._paintVerticalGridLines(sContext, g, clip, startRow, endRow, startColumn, endColumn);
            this._paintHorizontalGridLines(sContext, g, clip, startColumn, endColumn, startRow, endRow);
            this._paintFocusCellOrSelectionBorder(g, paintFocusCell);
        }
    }

    private void _paintColumn(PaintContext context, Graphics g, Rectangle clip, int column, int startRow, int endRow) {
        GeometryManager rowGM = this.getRowGeometryManager();
        Shape oldClip = g.getClip();
        Painter painter = this.getColumnPainter(column);
        boolean printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        CellPaintContext cellContext = null;
        int x = this._getColumnX(column);
        int width = this._getColumnGeometryManager().getItemSize(column);
        boolean extraBg = this.getFill() == null && this.getExtraCanvasBackground() != null;
        for (int i = startRow; i <= endRow; ++i) {
            int index = rowGM.visibleIndexToIndex(i);
            if (!rowGM.isItemVisible(index)) continue;
            int y = rowGM.getItemPosition(index);
            int height = this.getRowGeometryManager().getItemSize(index);
            g.setClip(oldClip);
            g.clipRect(x, y, width, height);
            if (cellContext == null) {
                cellContext = !printing ? new CellPaintContext(context, column, index) : new CellPrintPaintContext(context, column, index);
            } else {
                cellContext.setCell(column, index);
            }
            ImmInsets insets = cellContext.getAppearance().getInsets();
            BorderPainter cellBorderP = cellContext.getAppearance().getBorderPainter();
            ImmInsets finsets = cellBorderP != null && this.isCellBorderVisible() ? cellBorderP.getFillInsets(cellContext) : ImmInsets.getEmptyInsets();
            Color bgColor = null;
            bgColor = extraBg ? cellContext.getPaintBackground() : cellContext.getUsefulPaintBackground();
            if (bgColor != null) {
                g.setColor(bgColor);
                g.fillRect(x + finsets.left, y + finsets.top, width - (finsets.left + finsets.right), height - (finsets.top + finsets.bottom));
            }
            g.setColor(cellContext.getPaintForeground());
            g.setFont(cellContext.getPaintFont());
            if (cellBorderP != null && this.isCellBorderVisible()) {
                ImmInsets bInsets = cellBorderP.getInsets(cellContext);
                insets = new ImmInsets(insets.top + bInsets.top, insets.left + bInsets.left, insets.bottom + bInsets.bottom, insets.right + bInsets.right);
                cellBorderP.paint(cellContext, g, x, y, width, height);
            }
            painter.paint(cellContext, g, x + insets.left, y + insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
        }
        g.setClip(oldClip);
    }

    private void _paintHorizontalGridLines(PaintContext context, Graphics g, Rectangle clip, int startColumn, int endColumn, int startRow, int endRow) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        GeometryManager rowGM = this.getRowGeometryManager();
        if (this.getHorizontalSeparatorsVisible() || this.getVerticalSeparatorsVisible()) {
            Painter vertical;
            Painter painter = this.getHorizontalSeparatorPainter();
            if (painter == null) {
                return;
            }
            int size = painter.getPreferredSize((PaintContext)context).height;
            if (!this.getHorizontalSeparatorsVisible()) {
                startRow = endRow = this.getRowCount() - 1;
            }
            int index = columnGM.visibleIndexToIndex(startColumn);
            int startLine = this._getColumnX(index);
            index = columnGM.visibleIndexToIndex(endColumn);
            int width = this._getColumnX(index) + columnGM.getItemSize(index) - startLine + 1;
            if (this.getVerticalSeparatorsVisible() && (vertical = this.getVerticalSeparatorPainter()) != null) {
                int vSize = vertical.getPreferredSize((PaintContext)context).width;
                startLine -= vSize;
                width += vSize;
            }
            for (int i = startRow; i <= endRow; ++i) {
                index = rowGM.visibleIndexToIndex(i);
                if (!rowGM.isItemVisible(index)) continue;
                int pos = rowGM.getItemSize(index) + rowGM.getItemPosition(index);
                painter.paint(context, g, startLine, pos, width, size);
            }
        }
    }

    private void _paintVerticalGridLines(PaintContext context, Graphics g, Rectangle clip, int startRow, int endRow, int startColumn, int endColumn) {
        if (this.getVerticalSeparatorsVisible() || this.getHorizontalSeparatorsVisible()) {
            Painter horizontal;
            boolean l2r = this.getActualReadingDirection() == 1;
            Painter painter = this.getVerticalSeparatorPainter();
            if (painter == null) {
                return;
            }
            GeometryManager rowGM = this.getRowGeometryManager();
            GeometryManager columnGM = this._getColumnGeometryManager();
            int size = painter.getPreferredSize((PaintContext)context).width;
            if (!this.getVerticalSeparatorsVisible()) {
                startColumn = endColumn = this.getColumnCount() - 1;
            }
            int index = rowGM.visibleIndexToIndex(startRow);
            int startLine = rowGM.getItemPosition(index);
            index = rowGM.visibleIndexToIndex(endRow);
            int height = rowGM.getItemPosition(index) + rowGM.getItemSize(index) - startLine + 1;
            if (this.getHorizontalSeparatorsVisible() && (horizontal = this.getHorizontalSeparatorPainter()) != null) {
                int hSize = horizontal.getPreferredSize((PaintContext)context).height;
                startLine -= hSize;
                height += hSize;
            }
            for (int i = startColumn; i <= endColumn; ++i) {
                index = columnGM.visibleIndexToIndex(i);
                if (!columnGM.isItemVisible(index)) continue;
                int pos = columnGM.getItemPosition(index);
                if (l2r) {
                    pos += columnGM.getItemSize(index);
                }
                painter.paint(context, g, pos, startLine, size, height);
            }
        }
    }

    private int _convertVisibleColumnIndexToColumnIndex(int index) {
        GeometryManager columnGM = this._getColumnGeometryManager();
        if (this.getVisibleColumnCount() == this.getColumnCount()) {
            return index;
        }
        int i = 0;
        int visibleIndex = -1;
        while (visibleIndex < index) {
            int temp = columnGM.visibleIndexToIndex(i);
            if (columnGM.isItemVisible(temp)) {
                ++visibleIndex;
            }
            ++i;
        }
        return i - 1;
    }

    private int _convertVisibleRowIndexToRowIndex(int index) {
        if (this.getVisibleRowCount() == this.getRowCount()) {
            return index;
        }
        int i = 0;
        int visibleIndex = -1;
        GeometryManager rowGM = this.getRowGeometryManager();
        while (visibleIndex < index) {
            int temp = rowGM.visibleIndexToIndex(i);
            if (rowGM.isItemVisible(temp)) {
                ++visibleIndex;
            }
            ++i;
        }
        return i - 1;
    }

    private void _handleKeyTyped(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.getVisibleColumnCount() == 0 || this.getVisibleRowCount() == 0) {
            return;
        }
        if (this._focusCell != null && this.isCellEnabled(this._focusCell.column, this._focusCell.row)) {
            CellInputHandler handler = this.getColumnCellInputHandler(this._focusCell.column);
            char c = e.getKeyChar();
            if (c == '\u001b' || c == '\r' || c == '\t' || c == '\n') {
                e.consume();
            }
            if (!e.isConsumed()) {
                handler.keyTyped(e, this, this._focusCell.column, this._focusCell.row);
            }
        }
        if (!e.isConsumed()) {
            this._sendKeyToHandler(e);
        }
    }

    private void _handleKeyReleased(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.getVisibleColumnCount() == 0 || this.getVisibleRowCount() == 0) {
            return;
        }
        if (this._focusCell != null && this.isCellEnabled(this._focusCell.column, this._focusCell.row)) {
            CellInputHandler handler = this.getColumnCellInputHandler(this._focusCell.column);
            handler.keyReleased(e, this, this._focusCell.column, this._focusCell.row);
        }
    }

    private void _handleKeyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.getVisibleColumnCount() == 0 || this.getVisibleRowCount() == 0) {
            return;
        }
        if (this._focusCell != null && this.isCellEnabled(this._focusCell.column, this._focusCell.row)) {
            CellInputHandler handler = this.getColumnCellInputHandler(this._focusCell.column);
            handler.keyPressed(e, this, this._focusCell.column, this._focusCell.row);
        }
        if (!e.isConsumed()) {
            this._sendKeyToHandler(e);
        }
    }

    private Rectangle _getColumnRect(int column) {
        Point origin = this.getCanvasOrigin();
        Dimension size = this.getInnerSize();
        Rectangle rect = new Rectangle();
        rect.x = this._getColumnX(column);
        rect.y = -origin.y;
        rect.width = this._getColumnGeometryManager().getItemSize(column);
        rect.height = size.height;
        return rect;
    }

    private Rectangle _getRowRect(int row) {
        GeometryManager rowGM = this.getRowGeometryManager();
        Point origin = this.getCanvasOrigin();
        Dimension size = this.getInnerSize();
        Rectangle rect = new Rectangle();
        rect.x = -origin.x;
        rect.y = rowGM.getItemPosition(row);
        rect.width = size.width;
        rect.height = rowGM.getItemSize(row);
        return rect;
    }

    private void _updateEnabledStates() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        if (rows == 0 || cols == 0) {
            this._enabledStates = null;
            return;
        }
        if (this._enabledStates == null || cols != this._enabledStates.length || rows != this._enabledStates[0].length) {
            this._enabledStates = new boolean[cols][rows];
        }
        for (int i = 0; i < cols; ++i) {
            for (int j = 0; j < rows; ++j) {
                this._enabledStates[i][j] = true;
            }
        }
    }

    private Rectangle _getCellRect(int column, int row) {
        return this._getCellRect(column, row, true);
    }

    private Rectangle _getCellRect(int column, int row, boolean requireOnScreen) {
        if (!(!requireOnScreen || this.isColumnOnScreen(column) && this.isRowOnScreen(row))) {
            return null;
        }
        GeometryManager rowGM = this.getRowGeometryManager();
        Rectangle rect = new Rectangle();
        rect.x = this._getColumnX(column);
        rect.y = rowGM.getItemPosition(row);
        rect.width = this._getColumnGeometryManager().getItemSize(column);
        rect.height = rowGM.getItemSize(row);
        if (this.isOverlayBorderVisible()) {
            ImmInsets insets;
            EWTGridUI ui = this.getEWTGridUI();
            BorderPainter painter = ui.getOverlayBorderPainter(this);
            ImmInsets immInsets = insets = painter == null ? null : painter.getInsets(this.getPaintContext());
            if (column == this.getFirstColumnOnScreen() && insets != null) {
                rect.x += insets.left;
                rect.width -= insets.left;
            }
            if (row == this.getFirstRowOnScreen() && insets != null) {
                rect.y += insets.top;
                rect.height -= insets.top;
            }
        }
        return rect;
    }

    private int _getColumnX(int column) {
        int x = this._getColumnGeometryManager().getItemPosition(column);
        if (this.getActualReadingDirection() == 2 && this.getVerticalSeparatorsVisible()) {
            x += this._vpWidth;
        }
        return x;
    }

    private void _moveEditControl() {
        if (this._editControl == null || this._focusCell == null) {
            return;
        }
        CellInputHandler h = this.getColumnCellInputHandler(this._focusCell.column);
        Rectangle rect = h.getEditControlBounds(this, this._focusCell.column, this._focusCell.row);
        if (rect != null) {
            rect.x += this._getColumnX(this._focusCell.column);
            rect.y += this.getRowGeometryManager().getItemPosition(this._focusCell.row);
        } else {
            rect = this._getCellRect(this._focusCell.column, this._focusCell.row);
        }
        Point p = this.getCanvasOrigin();
        if (rect == null) {
            this._editControl.setVisible(false);
        } else {
            ImmInsets insets = this.getBorderInsets();
            rect.x += insets.left;
            rect.y += insets.top;
            this._editControl.setBounds(rect.x, rect.y, rect.width, rect.height);
            this._editControl.setVisible(true);
            this._editControl.validate();
            this._editControl.repaint();
        }
    }

    private boolean _isRowCompletelyOnScreen(int row) {
        GeometryManager rowGM = this.getRowGeometryManager();
        Point p = this.getCanvasOrigin();
        Dimension d = this.getInnerSize();
        int pos = rowGM.getItemPosition(row);
        int size = rowGM.getItemSize(row);
        p.y = -p.y;
        if (pos < p.y || pos > p.y + d.height) {
            return false;
        }
        return pos + size <= p.y + d.height || size >= d.height;
    }

    private GridKeyListener _getKeyListener() {
        if (this._keyListener == null) {
            this._keyListener = new GridKeyListener();
        }
        return this._keyListener;
    }

    private FocusAdapter _getFocusListener() {
        if (this._focusListener == null) {
            this._focusListener = new EditFocus();
        }
        return this._focusListener;
    }

    private GeometryListener _getRowGeometryChangeListener() {
        if (this._rowGeometryChangeListener == null) {
            this._rowGeometryChangeListener = new RowGeometryChangeListener();
        }
        return this._rowGeometryChangeListener;
    }

    private GeometryListener _getColumnGeometryChangeListener() {
        if (this._columnGeometryChangeListener == null) {
            this._columnGeometryChangeListener = new ColumnGeometryChangeListener();
        }
        return this._columnGeometryChangeListener;
    }

    private void _handleMouseClicked(MouseEvent e, Cell cell, CellInputHandler handler) {
        if (cell != null && this.isCellEnabled(cell.column, cell.row)) {
            int x = -this.getColumnPosition(cell.column);
            int y = -this.getRowPosition(cell.row);
            e.translatePoint(x, y);
            handler.mouseClicked(e, this, cell.column, cell.row);
            e.translatePoint(-x, -y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleMousePressed(MouseEvent mouseEvent, Cell cell, CellInputHandler handler) {
        this._handlingMousePressed = true;
        boolean isLeftButton = SwingUtilities.isLeftMouseButton(mouseEvent);
        boolean isShiftDown = mouseEvent.isShiftDown();
        boolean isControlDown = mouseEvent.isControlDown();
        this._cancelEdit = isShiftDown || isControlDown;
        this.freezeRepaints();
        try {
            if (isLeftButton) {
                this.requestFocus();
            }
            this._mouseGrabCell = cell;
            this._mouseGrabCellArmed = true;
            if (cell != null) {
                if (this.isCellEnabled(cell.column, cell.row)) {
                    int x = -this.getColumnPosition(cell.column);
                    int y = -this.getRowPosition(cell.row);
                    mouseEvent.translatePoint(x, y);
                    handler.mousePressed(mouseEvent, this, cell.column, cell.row);
                    mouseEvent.translatePoint(-x, -y);
                }
                if (mouseEvent.isConsumed() || !isLeftButton) {
                    return;
                }
                GridSelectionManager selection = this.getGridSelectionManager();
                if (isShiftDown) {
                    if (this.getAnchorCell() == null) {
                        this.setAnchorCell(cell);
                    }
                    TwoDSelection sel = this.getModelRangeSelection(cell.column, cell.row, this.getAnchorCell().column, this.getAnchorCell().row);
                    if (isControlDown) {
                        selection.addSelection(sel);
                    } else {
                        selection.setSelection(sel, null);
                    }
                } else {
                    TwoDSelection sel = new TwoDSelection(null, null, cell);
                    if (isControlDown) {
                        if (selection.getSelection().containsCell(cell)) {
                            selection.removeSelection(sel);
                        } else {
                            selection.addSelection(sel);
                        }
                    } else {
                        selection.setSelection(sel, null);
                    }
                    this.setAnchorCell(cell);
                }
                mouseEvent.consume();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        finally {
            this.unfreezeRepaints();
            this._handlingMousePressed = false;
        }
    }

    private void _handleMouseEntered(MouseEvent e, Cell cell, CellInputHandler handler) {
        this._moveCell = cell;
        if (this._moveCell != null && this.isCellEnabled(cell.column, cell.row)) {
            int x = -this.getColumnPosition(this._moveCell.column);
            int y = -this.getRowPosition(this._moveCell.row);
            e.translatePoint(x, y);
            handler.mouseEntered(e, this, this._moveCell.column, this._moveCell.row);
            e.translatePoint(-x, -y);
        }
    }

    private void _handleMouseExited(MouseEvent e, Cell cell, CellInputHandler handler) {
        if (this._moveCell != null && this.isCellEnabled(this._moveCell.column, this._moveCell.row)) {
            CellInputHandler h = this.getColumnCellInputHandler(this._moveCell.column);
            int x = -this.getColumnPosition(this._moveCell.column);
            int y = -this.getRowPosition(this._moveCell.row);
            e.translatePoint(x, y);
            h.mouseExited(e, this, this._moveCell.column, this._moveCell.row);
            e.translatePoint(-x, -y);
        }
    }

    private void _handleMouseReleased(MouseEvent mouseEvent, Cell cell, CellInputHandler handler) {
        if (cell != null) {
            this.scrollCellIntoView(cell.column, cell.row);
        }
        GridAutoScroller.getAutoScroller().cancel();
        if (this._mouseGrabCell != null) {
            if (this.isCellEnabled(this._mouseGrabCell.column, this._mouseGrabCell.row)) {
                int mouseGrabColumn = this._mouseGrabCell.column;
                int mouseGrabRow = this._mouseGrabCell.row;
                CellInputHandler mouseGrabHandler = this.getColumnCellInputHandler(mouseGrabColumn);
                int x = -this.getColumnPosition(mouseGrabColumn);
                int y = -this.getRowPosition(mouseGrabRow);
                mouseEvent.translatePoint(x, y);
                mouseGrabHandler.mouseReleased(mouseEvent, this, mouseGrabColumn, mouseGrabRow);
                mouseEvent.translatePoint(-x, -y);
            }
            this._mouseGrabCell = null;
            this._mouseGrabCellArmed = false;
        }
        this._cancelEdit = false;
    }

    private void _handleMouseMoved(MouseEvent e, Cell cell, CellInputHandler handler) {
        int x = e.getX();
        int y = e.getY();
        int newColumn = -1;
        int newRow = -1;
        int oldColumn = -1;
        int oldRow = -1;
        if (cell != null) {
            newColumn = cell.column;
            newRow = cell.row;
        }
        if (this._moveCell != null) {
            oldColumn = this._moveCell.column;
            oldRow = this._moveCell.row;
        }
        if (newColumn != oldColumn || newRow != oldRow) {
            CellInputHandler h;
            MouseEvent newEvent;
            if (this._moveCell != null && this.isCellEnabled(this._moveCell.column, this._moveCell.row)) {
                newEvent = new MouseEvent(this, 505, e.getWhen(), e.getModifiers(), x - this.getColumnPosition(oldColumn), y - this.getRowPosition(oldRow), e.getClickCount(), e.isPopupTrigger());
                h = this.getColumnCellInputHandler(oldColumn);
                h.mouseExited(newEvent, this, oldColumn, oldRow);
            }
            if (cell != null && this.isCellEnabled(cell.column, cell.row)) {
                newEvent = new MouseEvent(this, 504, e.getWhen(), e.getModifiers(), x - this.getColumnPosition(newColumn), y - this.getRowPosition(newRow), e.getClickCount(), e.isPopupTrigger());
                h = this.getColumnCellInputHandler(newColumn);
                h.mouseEntered(newEvent, this, newColumn, newRow);
            }
            this._moveCell = cell;
        }
        if (this._moveCell != null && this.isCellEnabled(this._moveCell.column, this._moveCell.row)) {
            int xOff = -this.getColumnPosition(this._moveCell.column);
            int yOff = -this.getRowPosition(this._moveCell.row);
            e.translatePoint(xOff, yOff);
            handler.mouseMoved(e, this, this._moveCell.column, this._moveCell.row);
            e.translatePoint(-xOff, -yOff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleMouseDragged(MouseEvent mouseEvent, Cell cell, CellInputHandler handler) {
        if (this._mouseGrabCell != null) {
            int mouseGrabColumn = this._mouseGrabCell.column;
            int mouseGrabRow = this._mouseGrabCell.row;
            if (this.isCellEnabled(mouseGrabColumn, mouseGrabRow)) {
                CellInputHandler mouseGrabHandler = this.getColumnCellInputHandler(mouseGrabColumn);
                int x = -this.getColumnPosition(mouseGrabColumn);
                int y = -this.getRowPosition(mouseGrabRow);
                mouseEvent.translatePoint(x, y);
                this._mouseGrabCellArmed = mouseEvent.getX() >= 0 && mouseEvent.getX() <= this.getColumnWidth(mouseGrabColumn) && mouseEvent.getY() >= 0 && mouseEvent.getY() <= this.getRowHeight(mouseGrabRow);
                mouseGrabHandler.mouseDragged(mouseEvent, this, mouseGrabColumn, mouseGrabRow);
                mouseEvent.translatePoint(-x, -y);
            }
            if (!mouseEvent.isConsumed() && (InputEventUtils.getMods(mouseEvent) & 7) == 0 && cell != null) {
                this.freezeRepaints();
                try {
                    GridSelectionManager selection = this.getGridSelectionManager();
                    Object object = this._scrollLock;
                    synchronized (object) {
                        try {
                            selection.setSelection(this.getModelRangeSelection(mouseGrabColumn, mouseGrabRow, cell.column, cell.row), this._mouseGrabCell);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        this._moveFocus(cell);
                        this._lastColumn = cell.column;
                        this._lastRow = cell.row;
                    }
                }
                finally {
                    this.unfreezeRepaints();
                }
            }
        }
        this._checkScroller(mouseEvent);
    }

    private void _moveFocus(Cell cell) {
        GridSelectionManager selection = this.getGridSelectionManager();
        TwoDSelection sel = selection.getSelection();
        Cell fCell = this.getFocusCell();
        if (fCell != null && !sel.containsCell(fCell)) {
            OneDSelection csel = sel.getColumnSelection();
            OneDSelection rsel = sel.getRowSelection();
            int col = -1;
            int row = -1;
            if (!csel.isEmpty()) {
                col = csel.getSingleItem();
            }
            if (!rsel.isEmpty()) {
                row = rsel.getSingleItem();
            }
            if (col == -1) {
                col = cell.column;
            }
            if (row == -1) {
                row = cell.row;
            }
            Cell newCell = new Cell(col, row);
            this.setFocusCell(newCell);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void growSelection(boolean growColumn, int index) {
        if (this._mouseGrabCell != null) {
            GridSelectionManager selection = this.getGridSelectionManager();
            Object object = this._scrollLock;
            synchronized (object) {
                if (growColumn) {
                    this._lastColumn = index;
                } else {
                    this._lastRow = index;
                }
                TwoDSelection newSel = this.getModelRangeSelection(this._mouseGrabCell.column, this._mouseGrabCell.row, this._lastColumn, this._lastRow);
                Cell cell = new Cell(this._lastColumn, this._lastRow);
                try {
                    selection.setSelection(newSel, this._mouseGrabCell);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this._moveFocus(cell);
            }
        }
    }

    private void _checkScroller(MouseEvent mouseEvent) {
        int averageItemSize;
        GridAutoScroller autoScroller = GridAutoScroller.getAutoScroller();
        boolean needHorizontal = false;
        boolean needVertical = false;
        boolean horizontalDecrease = false;
        boolean verticalDecrease = false;
        int pointToCheck = mouseEvent.getX() + this.getCanvasOriginX();
        int max = this.getInnerSize().width;
        int count = this.getColumnCount();
        int n = averageItemSize = count == 0 ? 0 : this._getColumnGeometryManager().getTotalSize() / count;
        if (pointToCheck < (averageItemSize /= 2)) {
            needHorizontal = true;
            horizontalDecrease = true;
        } else if (pointToCheck > max - averageItemSize) {
            needHorizontal = true;
            horizontalDecrease = false;
        }
        pointToCheck = mouseEvent.getY() + this.getCanvasOriginY();
        max = this.getInnerSize().height;
        count = this.getRowCount();
        int n2 = averageItemSize = count == 0 ? 0 : this.getRowGeometryManager().getTotalSize() / count;
        if (pointToCheck < (averageItemSize /= 2)) {
            needVertical = true;
            verticalDecrease = true;
        } else if (pointToCheck > max - averageItemSize) {
            needVertical = true;
            verticalDecrease = false;
        }
        if (!needVertical & !needHorizontal) {
            autoScroller.cancel();
        } else {
            autoScroller.schedule(this, needHorizontal, horizontalDecrease, needVertical, verticalDecrease);
        }
    }

    private void _columnsAdded(int start, int number) {
        if (this._painters != null) {
            this._painters.addItems(start, number);
        }
        if (this._cellInputHandlers != null) {
            this._cellInputHandlers.addItems(start, number);
        }
    }

    private void _columnsRemoved(int start, int number) {
        if (this._painters != null) {
            this._painters.removeItems(start, number);
        }
        if (this._cellInputHandlers != null) {
            this._cellInputHandlers.removeItems(start, number);
        }
    }

    private void _checkForFirstColumnRow(Dimension d) {
        int index;
        Dimension size = this.getInnerSize();
        if (this._firstColumn != -1) {
            if (d.width != 0) {
                this.setFirstColumnOnScreen(this._firstColumn);
            }
        } else if (size.width >= d.width && d.width != 0 && (index = this.getNextVisibleColumn(-1)) != -1) {
            this.setFirstColumnOnScreen(index);
        }
        if (this._firstRow != -1) {
            if (d.height != 0) {
                this.setFirstRowOnScreen(this._firstRow);
            }
        } else if (size.height >= d.height && d.height != 0 && (index = this.getNextVisibleRow(-1)) != -1) {
            this.setFirstRowOnScreen(index);
        }
    }

    private void _unregisterKeyboardActions() {
        KeyStroke s = KeyStroke.getKeyStroke(33, 0);
        this.unregisterKeyboardAction(s);
        s = KeyStroke.getKeyStroke(34, 0);
        this.unregisterKeyboardAction(s);
    }

    private void _registerKeyboardActions() {
        Key l = new Key();
        KeyStroke s = KeyStroke.getKeyStroke(33, 0);
        this.registerKeyboardAction(l, _PAGE_UP, s, 0);
        s = KeyStroke.getKeyStroke(34, 0);
        this.registerKeyboardAction(l, _PAGE_DOWN, s, 0);
    }

    private void _updateCellInputHandlerUI() {
        if (this._cellInputHandlers != null) {
            int count = this._cellInputHandlers.getItemCount();
            for (int i = 0; i < count; ++i) {
                Object data = this._cellInputHandlers.getData(i);
                if (data == null) continue;
                ((CellInputHandler)data).updateUI();
            }
        }
        CellInputHandler h = this.getDefaultInputHandler();
        h.updateUI();
    }

    private SelectionListener _getSelectionListener() {
        if (this._selectionListener == null) {
            this._selectionListener = new SelectionListener();
        }
        return this._selectionListener;
    }

    private void _paintSelections(TwoDSelection sel) {
        this.freezeRepaints();
        try {
            this._paintColumnRanges(sel.getColumnSelection().getRanges());
            this._paintRowRanges(sel.getRowSelection().getRanges());
            this._paintCellRanges(sel.getCellRanges());
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void _paintColumnRanges(Range[] ranges) {
        int n = ranges == null ? 0 : ranges.length;
        for (int i = 0; i < n; ++i) {
            for (int j = ranges[i].getLowerLimit(); j <= ranges[i].getUpperLimit(); ++j) {
                this.paintColumn(j);
            }
        }
    }

    private void _paintRowRanges(Range[] ranges) {
        int n = ranges == null ? 0 : ranges.length;
        for (int i = 0; i < n; ++i) {
            for (int j = ranges[i].getLowerLimit(); j <= ranges[i].getUpperLimit(); ++j) {
                this.paintRow(j);
            }
        }
    }

    private void _paintCellRanges(CellRange[] ranges) {
        int n = (ranges = this._visibleCellRangesFromModelCellRanges(ranges)) == null ? 0 : ranges.length;
        for (int i = 0; i < n; ++i) {
            this.paintVisibleCellRange(ranges[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startCellEdit(int column, int row) {
        Grid grid = this;
        synchronized (grid) {
            if (this.isEditing() && this._focusCell != null && this._focusCell.column == column && this._focusCell.row == row) {
                return;
            }
        }
        CellInputHandler inputHandler = this.getColumnCellInputHandler(column);
        Component editControl = inputHandler.getEditControl(this, column, row);
        if (editControl == null) {
            return;
        }
        if (this.fireCancelableCellEvent(column, row, 2001)) {
            return;
        }
        this._editControl = editControl;
        this._editControlChildren = inputHandler.getFocusableComponents(this, column, row);
        this._addListeners(this._editControlChildren);
        editControl.setVisible(false);
        this.add(editControl);
        AppearanceManager am = this.getAppearanceManager();
        Appearance appearance = am.getCellPaintingAppearance(column, row);
        Font font = appearance.getFont();
        if (font == null) {
            font = this.getFont();
        }
        editControl.setFont(font);
        this._addNextFocus(this._editControlChildren);
        this.freezeRepaints();
        try {
            this.requestFocus(column, row, null);
            this.scrollCellIntoView(column, row);
            Object data = this.getModel().getData(column, row);
            try {
                inputHandler.startEdit(this, column, row, data);
            }
            catch (Exception e) {
                this._doneEditing(false);
                this.unfreezeRepaints();
                return;
            }
            this._moveEditControl();
            if (editControl.isVisible()) {
                editControl.requestFocus();
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void _setDrawSelectionBorder(boolean draw, boolean requestPaint) {
        if (draw != this._drawSelectionBorder) {
            this._drawSelectionBorder = draw;
            if (requestPaint) {
                this._paintSelections(this.getSelection());
            }
        }
    }

    private void _paintFocusCellOrSelectionBorder(Graphics g, boolean paintFocusCell) {
        if (this.hasFocus() || this.isAlwaysDrawFocusCellHighlite()) {
            boolean selPaint = false;
            if (this.getDrawSelectionBorder()) {
                Cell focusCell = this.getFocusCell();
                TwoDSelection sel = this.getSelection();
                if (focusCell == null || sel.containsCell(focusCell)) {
                    selPaint = this.paintSelectionBorder(g);
                }
            }
            if (!selPaint && paintFocusCell && this.getDrawFocusCellHighlite()) {
                this.paintFocusCell(g);
            }
        }
    }

    private void _paintBorderAroundCells(Rectangle drawRect, Graphics g) {
        BorderPainter ptr = (BorderPainter)UIManager.get("Grid.focusPainter");
        if (ptr != null) {
            ptr.paint(this.getPaintContext(), g, drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        }
    }

    private Rectangle _getSelectionBounds() {
        CellRange[] vRange;
        Range[] rowRanges;
        TwoDSelection sel = this.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        int minRow = -1;
        int minCol = -1;
        int maxRow = -1;
        int maxCol = -1;
        GeometryManager cgm = this._getColumnGeometryManager();
        GeometryManager rgm = this.getRowGeometryManager();
        Range[] colRanges = sel.getColumnSelection().getRanges();
        if (colRanges != null && colRanges.length != 0) {
            Range[] vRange2 = cgm.rangesToVisibleRanges(colRanges);
            for (int i = 0; i < vRange2.length; ++i) {
                minCol = minCol == -1 ? vRange2[i].getLowerLimit() : Math.min(minCol, vRange2[i].getLowerLimit());
                maxCol = maxCol == -1 ? vRange2[i].getUpperLimit() : Math.max(maxCol, vRange2[i].getUpperLimit());
            }
            Range[] result = new Range[]{new Range(minCol, maxCol)};
            if (Range.rangesContain((Range[])vRange2, (Range[])result)) {
                minRow = 0;
                maxRow = this.getVisibleRowCount() - 1;
            } else {
                maxCol = -1;
                minCol = -1;
            }
        }
        if ((rowRanges = sel.getRowSelection().getRanges()) != null && rowRanges.length != 0) {
            vRange = rgm.rangesToVisibleRanges(rowRanges);
            for (int i = 0; i < vRange.length; ++i) {
                minRow = minRow == -1 ? vRange[i].getLowerLimit() : Math.min(minRow, vRange[i].getLowerLimit());
                maxRow = maxRow == -1 ? vRange[i].getUpperLimit() : Math.max(maxRow, vRange[i].getUpperLimit());
            }
            Range[] result = new Range[]{new Range(minRow, maxRow)};
            if (Range.rangesContain((Range[])vRange, (Range[])result)) {
                minCol = 0;
                maxCol = this.getVisibleColumnCount() - 1;
            } else {
                maxRow = -1;
                minRow = -1;
            }
        }
        if ((vRange = this._convertModelToVisibleRanges(sel.getCellRanges())) != null && vRange.length != 0) {
            for (int i = 0; i < vRange.length; ++i) {
                Cell minCell = vRange[i].getLowerLimit();
                Cell maxCell = vRange[i].getUpperLimit();
                minCol = minCol == -1 ? minCell.column : Math.min(minCol, minCell.column);
                maxCol = maxCol == -1 ? maxCell.column : Math.max(maxCol, maxCell.column);
                minRow = minRow == -1 ? minCell.row : Math.min(minRow, minCell.row);
                maxRow = maxRow == -1 ? maxCell.row : Math.max(maxRow, maxCell.row);
            }
            CellRange[] result = new CellRange[]{new CellRange(minCol, minRow, maxCol, maxRow)};
            if (!CellRange.cellRangesContain(vRange, result)) {
                maxCol = -1;
                maxRow = -1;
                minCol = -1;
                minRow = -1;
            }
        }
        if (minRow == -1 || minCol == -1 || maxCol == -1 || maxRow == -1) {
            return null;
        }
        minCol = cgm.visibleIndexToIndex(minCol);
        minRow = rgm.visibleIndexToIndex(minRow);
        maxCol = cgm.visibleIndexToIndex(maxCol);
        maxRow = rgm.visibleIndexToIndex(maxRow);
        return this.getCellBounds(minCol, minRow, maxCol, maxRow);
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.createAccessibleGrid();
        }
        return this.accessibleContext;
    }

    public AccessibleGrid getAccessibleGrid() {
        return (AccessibleGrid)this.accessibleContext;
    }

    protected AccessibleGrid createAccessibleGrid() {
        return new AccessibleGrid();
    }

    void _fireActiveEvent(Cell oldCell, Cell newCell) {
        AccessibleGrid ac = this.getAccessibleGrid();
        if (ac != null) {
            Accessible oldA = null;
            Accessible newA = null;
            if (oldCell != null) {
                int oldIndex = ac.getAccessibleIndexAt(oldCell.column, oldCell.row);
                oldA = ac.getAccessibleChild(oldIndex);
            }
            if (newCell != null) {
                int newIndex = ac.getAccessibleIndexAt(newCell.column, newCell.row);
                newA = ac.getAccessibleChild(newIndex);
            }
            ac.firePropertyChange("AccessibleActiveDescendant", oldA, newA);
        }
    }

    private class SeparatorContext
    extends PaintContextProxy {
        private PaintContext _context;

        public SeparatorContext(PaintContext context) {
            this._context = context;
        }

        @Override
        protected PaintContext getPaintContext() {
            return this._context;
        }

        @Override
        public Object getPaintData(Object key) {
            Object data = super.getPaintData(key);
            if (data == null) {
                data = Grid.this.getPaintData(key);
            }
            return data;
        }
    }

    private class CellPaintContext
    extends PaintContextProxy {
        private int _column;
        private int _row;
        private int _paintState;
        private PaintContext _context;

        public CellPaintContext(PaintContext context, int column, int row) {
            this._context = context;
            this.setCell(column, row);
        }

        public void setCell(int column, int row) {
            this._column = column;
            this._row = row;
            this._paintState = this._getPaintState();
        }

        @Override
        protected PaintContext getPaintContext() {
            return this._context;
        }

        @Override
        public int getPaintState() {
            return this._paintState;
        }

        private int _getPaintState() {
            Cell grab;
            int state = super.getPaintState();
            GridSelectionManager sm = Grid.this.getGridSelectionManager();
            if (Grid.this.isEnabled()) {
                Cell focusCell = Grid.this.getFocusCell();
                TwoDSelection sel = sm.getSelection();
                if ((sel.containsCell(this._column, this._row) || sel.containsColumn(this._column) || sel.containsRow(this._row)) && (!Grid.this.isEditing() || focusCell == null || this._column != focusCell.column || this._row != focusCell.row)) {
                    state |= 0x20;
                }
                if (focusCell != null && focusCell.column == this._column && focusCell.row == this._row) {
                    if (((state |= 0x40) & 0x20) != 0 && Grid.this.getDrawSelectionBorder() && ((state & 4) == 0 && Grid.this.hasFocus() || Grid.this.isAlwaysDrawFocusCellHighlite())) {
                        state &= 0xFFFFFFDF;
                    }
                } else {
                    state &= 0xFFFFFFBF;
                }
            }
            if ((grab = Grid.this._mouseGrabCell) != null && grab.column == this._column && grab.row == this._row && Grid.this._mouseGrabCellArmed) {
                state |= 2;
            }
            return Grid.this.getCellPaintState(state, this._column, this._row);
        }

        @Override
        public Color getPaintForeground() {
            int state = this.getPaintState();
            if ((state & 1) != 0) {
                return this.getPaintContext().getPaintUIDefaults().getColor("textInactiveText");
            }
            if ((state & 0x20) == 0 || Grid.this.isSelectionTransparent()) {
                Color fgColor = this.getAppearance().getForeground();
                if (fgColor == null) {
                    fgColor = super.getPaintForeground();
                }
                return fgColor;
            }
            return this.getAppearance().getSelectForeground();
        }

        @Override
        public Font getPaintFont() {
            int state = this.getPaintState();
            Font font = null;
            if ((state & 0x20) != 0 && !Grid.this.isSelectionTransparent()) {
                font = this.getAppearance().getSelectFont();
            }
            if (font == null) {
                font = this.getAppearance().getFont();
            }
            if (font == null) {
                font = super.getPaintFont();
            }
            return font;
        }

        @Override
        public Color getPaintBackground() {
            Color color = this.getUsefulPaintBackground();
            if (color == null) {
                color = super.getPaintBackground();
            }
            return color;
        }

        Color getUsefulPaintBackground() {
            boolean disabled;
            int state = this.getPaintState();
            Color color = null;
            boolean selected = (state & 0x20) != 0;
            boolean active = (state & 4) == 0;
            boolean bl = disabled = (state & 1) != 0;
            if (disabled) {
                return UIManager.getColor("Grid.disabledBackground");
            }
            if (selected) {
                if (active) {
                    color = this.getAppearance().getSelectBackground();
                    if (Grid.this.isSelectionTransparent() && color != null) {
                        Color base = this.getAppearance().getBackground();
                        if (base == null) {
                            base = super.getPaintBackground();
                        }
                        if (base != null) {
                            color = ColorUtils.getTransparentColor(base, color, 60);
                        }
                    }
                } else {
                    color = UIManager.getColor("Grid.inactiveSelectedBackground");
                }
            }
            if (color == null) {
                color = this.getAppearance().getBackground();
            }
            return color;
        }

        @Override
        public float getInteriorAlignmentX() {
            float align;
            Appearance a = this.getAppearance();
            int hJustify = a.getHorizontalJustify();
            if (hJustify == 0) {
                int direction = a.getReadingDirection();
                switch (direction) {
                    case 0: {
                        return super.getInteriorAlignmentX();
                    }
                }
                hJustify = LocaleUtils.getAlignmentForReadingDirection(direction);
            }
            switch (hJustify) {
                case 3: {
                    align = 0.5f;
                    break;
                }
                case 2: {
                    align = 1.0f;
                    break;
                }
                default: {
                    align = 0.0f;
                }
            }
            return align;
        }

        @Override
        public float getInteriorAlignmentY() {
            int hJustify = this.getAppearance().getVerticalJustify();
            float align = 0.0f;
            switch (hJustify) {
                case 1: {
                    align = 0.5f;
                    break;
                }
                case 0: {
                    align = 0.0f;
                    break;
                }
                case 2: {
                    align = 1.0f;
                }
            }
            return align;
        }

        @Override
        public int getReadingDirection() {
            int direction = this.getAppearance().getReadingDirection();
            if (direction == 0) {
                direction = super.getReadingDirection();
            }
            return direction;
        }

        @Override
        public Object getPaintData(Object key) {
            int column = this._column;
            if (key == PaintContext.MNEMONIC_INDEX_KEY) {
                return null;
            }
            if (Grid.APPEARANCE_KEY.equals(key)) {
                return this.getAppearance();
            }
            if (Grid.CELL_KEY.equals(key)) {
                return new Cell(column, this._row);
            }
            Object data = super.getPaintData(key);
            if (data == null) {
                data = Grid.this.getPaintData(key);
            }
            if (data == null) {
                try {
                    data = Grid.this.getModel().getData(column, this._row);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return data;
        }

        public Appearance getAppearance() {
            AppearanceManager am = Grid.this.getAppearanceManager();
            return am.getCellPaintingAppearance(this._column, this._row);
        }
    }

    private class CellPrintPaintContext
    extends CellPaintContext {
        public CellPrintPaintContext(PaintContext context, int column, int row) {
            super(context, column, row);
        }

        @Override
        public int getPaintState() {
            return this.getPaintContext().getPaintState();
        }
    }

    private class RowGeometryChangeListener
    implements GeometryListener {
        private RowGeometryChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void geometryChanged(GeometryEvent e) {
            int item = e.getItem();
            switch (e.getID()) {
                case 2005: {
                    GeometryManager gm = Grid.this.getRowGeometryManager();
                    Grid.this.freezeRepaints();
                    try {
                        Grid.this.commitCellEdit();
                        Dimension d = Grid.this.layoutCanvas();
                        Grid.this.setCanvasSize(d.width, d.height);
                        if (!Grid.this.isRowOnScreen(item)) break;
                        d = Grid.this.getInnerSize();
                        Point p = Grid.this.getCanvasOrigin();
                        int pos = gm.getItemPosition(item);
                        if (pos < -p.y) {
                            pos = -p.y;
                        }
                        Grid.this.repaintCanvas(-p.x, pos, d.width, d.height);
                        break;
                    }
                    finally {
                        Grid.this.unfreezeRepaints();
                    }
                }
                case 2003: {
                    if (e.getSize() == 0) {
                        if (Grid.this._firstRow == item) {
                            Grid.this._firstRow = Grid.this.getNextVisibleRow(Grid.this._firstRow);
                        }
                        if (Grid.this._focusCell != null && item == Grid.this._focusCell.row) {
                            int col = Grid.this._focusCell.column;
                            int nextRow = Grid.this.getNextVisibleRow(item);
                            if (nextRow == -1) {
                                col = -1;
                            }
                            Grid.this._focusCell = new Cell(col, nextRow);
                        }
                    }
                    Grid.this.invalidateCanvas();
                    break;
                }
                default: {
                    Grid.this.invalidateCanvas();
                }
            }
        }
    }

    private class ColumnGeometryChangeListener
    implements GeometryListener {
        private ColumnGeometryChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void geometryChanged(GeometryEvent e) {
            int item = e.getItem();
            switch (e.getID()) {
                case 2005: {
                    GeometryManager gm = Grid.this._getColumnGeometryManager();
                    Grid.this.freezeRepaints();
                    try {
                        Grid.this.commitCellEdit();
                        Dimension d = Grid.this.layoutCanvas();
                        Grid.this.setCanvasSize(d.width, d.height);
                        if (!Grid.this.isColumnOnScreen(item)) break;
                        d = Grid.this.getInnerSize();
                        Point p = Grid.this.getCanvasOrigin();
                        int pos = gm.getItemPosition(item);
                        if (pos < -p.x) {
                            pos = -p.x;
                        }
                        Grid.this.repaintCanvas(pos, -p.y, d.width, d.height);
                        break;
                    }
                    finally {
                        Grid.this.unfreezeRepaints();
                    }
                }
                case 2003: {
                    if (e.getSize() == 0) {
                        if (Grid.this._firstColumn == item) {
                            Grid.this._firstColumn = Grid.this.getNextVisibleColumn(Grid.this._firstColumn);
                        }
                        if (Grid.this._focusCell != null && item == Grid.this._focusCell.column) {
                            int nextCol = Grid.this.getNextVisibleColumn(item);
                            int row = Grid.this._focusCell.row;
                            if (nextCol == -1) {
                                row = -1;
                            }
                            Grid.this._focusCell = new Cell(nextCol, row);
                        }
                    }
                    Grid.this.invalidateCanvas();
                    break;
                }
                default: {
                    Grid.this.invalidateCanvas();
                }
            }
        }
    }

    private class SelectionListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private SelectionListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Grid.this.fireVetoableChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!Grid.this._ignoreSelectionRepaints) {
                GridSelectionManager gsm = Grid.this.getGridSelectionManager();
                TwoDSelection oldSel = (TwoDSelection)evt.getOldValue();
                TwoDSelection newSel = (TwoDSelection)evt.getNewValue();
                TwoDSelection result = gsm.getRepaintSelection(oldSel, newSel);
                Grid.this._paintSelections(result);
            }
            Grid.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    private class DSListen
    implements TwoDModelListener {
        private DSListen() {
        }

        @Override
        public void rowsAdded(TwoDModelEvent e) {
            Grid.this.internalRowsAdded(e);
        }

        @Override
        public void rowsRemoved(TwoDModelEvent e) {
            Grid.this.internalRowsRemoved(e);
        }

        @Override
        public void invalidateRows(TwoDModelEvent e) {
            Grid.this.internalInvalidateRows(e);
        }

        @Override
        public void columnsAdded(TwoDModelEvent e) {
            Grid.this.internalColumnsAdded(e);
        }

        @Override
        public void columnsRemoved(TwoDModelEvent e) {
            Grid.this.internalColumnsRemoved(e);
        }

        @Override
        public void invalidateColumns(TwoDModelEvent e) {
            Grid.this.internalInvalidateColumns(e);
        }

        @Override
        public void invalidateCells(TwoDModelEvent e) {
            Grid.this.internalInvalidateCells(e);
        }
    }

    private class EditFocus
    extends FocusAdapter {
        private EditFocus() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                Grid.this.focusLost(e);
            }
        }
    }

    private class Change
    implements ChangeListener {
        private Change() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Grid.this._doneEditing(true);
        }
    }

    private class GridKeyListener
    extends KeyAdapter {
        private GridKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                Grid.this.cancelCellEdit();
                e.consume();
            } else if (e.getKeyCode() == 10) {
                Grid.this._sendKeyToHandler(e);
                e.consume();
            }
        }
    }

    private class Key
    implements ActionListener {
        private Key() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            int keyCode = Grid._PAGE_UP.equals(cmd) ? 33 : 34;
            KeyEvent event = new KeyEvent(Grid.this, 401, 0L, e.getModifiers(), keyCode);
            Grid.this._sendKeyToHandler(event);
        }
    }

    public class AccessibleGrid
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    TwoDModelListener,
    GridEditListener,
    GeometryListener {
        public AccessibleGrid() {
            super(Grid.this);
            Grid.this.addPropertyChangeListener(this);
            Grid.this.getModel().addModelListener(this);
            Grid.this.getColumnGeometryManager().addGeometryListener(this);
            Grid.this.getRowGeometryManager().addGeometryListener(this);
            Grid.this.addEditListener(this);
        }

        @Override
        public String getAccessibleName() {
            AccessibleContext context;
            Accessible parent;
            String name = super.getAccessibleName();
            if (name == null && (parent = this.getAccessibleParent()) != null && (context = parent.getAccessibleContext()) != null && context.getAccessibleRole() == AccessibleRole.TABLE) {
                return context.getAccessibleName();
            }
            return name;
        }

        public int getAccessibleRowAtIndex(int i) {
            int count = Grid.this.getColumnCount();
            if (count == 0) {
                return -1;
            }
            return i / count;
        }

        public int getAccessibleColumnAtIndex(int i) {
            int count = Grid.this.getColumnCount();
            if (count == 0) {
                return -1;
            }
            return i % count;
        }

        public int getAccessibleIndexAt(int column, int row) {
            return row * Grid.this.getColumnCount() + column;
        }

        public String getAccessibleName(int column, int row) {
            Object data = Grid.this.getModel().getData(column, row);
            return this.getAccessibleName(column, row, data);
        }

        public String getAccessibleDescription(int column, int row) {
            GridToolTipManager ttm = Grid.this.getToolTipManager();
            if (ttm == null) {
                return null;
            }
            return ttm.getCellToolTipValue(Grid.this, column, row);
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            Point q = Grid.this.convertOuterToCanvas(p.x, p.y);
            Cell c = Grid.this.getCellAt(q.x, q.y);
            if (c != null) {
                return this.getAccessibleChild(this.getAccessibleIndexAt(c.column, c.row));
            }
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return Grid.this.getModel() == null ? 0 : Grid.this.getColumnCount() * Grid.this.getRowCount();
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return new AccessibleGridCell(i);
        }

        @Override
        public int getAccessibleSelectionCount() {
            int result = Grid.this.getSelection().getSelectedCellCount();
            return result;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            TwoDSelection sel = Grid.this.getSelection();
            Cell c = sel.getSelectedCellAtIndex(i);
            if (c != null) {
                int n = this.getAccessibleIndexAt(c.column, c.row);
                return this.getAccessibleChild(n);
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            TwoDSelection sel = Grid.this.getSelection();
            int column = this.getAccessibleColumnAtIndex(i);
            int row = this.getAccessibleRowAtIndex(i);
            if (column != -1 && row != -1) {
                Cell cell = new Cell(column, row);
                return sel.containsCell(cell);
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int i) {
            TwoDSelection sel = Grid.this.getSelection();
            int column = this.getAccessibleColumnAtIndex(i);
            int row = this.getAccessibleRowAtIndex(i);
            if (column != -1 && row != -1) {
                Cell cell = new Cell(column, row);
                try {
                    Grid.this.getGridSelectionManager().addSelection(new TwoDSelection(cell));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void removeAccessibleSelection(int i) {
            TwoDSelection sel = Grid.this.getSelection();
            int column = this.getAccessibleColumnAtIndex(i);
            int row = this.getAccessibleRowAtIndex(i);
            if (column != -1 && row != -1) {
                Cell cell = new Cell(column, row);
                try {
                    Grid.this.getGridSelectionManager().removeSelection(new TwoDSelection(cell));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void clearAccessibleSelection() {
            try {
                Grid.this.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            try {
                Grid.this.selectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object oldValue = e.getOldValue();
            Object newValue = e.getNewValue();
            if (Grid.PROPERTY_MODEL.equals(name)) {
                if (oldValue != null) {
                    ((TwoDModel)oldValue).removeModelListener(this);
                }
                if (newValue != null) {
                    ((TwoDModel)newValue).addModelListener(this);
                }
            } else if (Grid.PROPERTY_COLUMN_GEOMETRY_MANAGER.equals(name) || Grid.PROPERTY_ROW_GEOMETRY_MANAGER.equals(name)) {
                if (oldValue != null) {
                    ((GeometryManager)oldValue).removeGeometryListener(this);
                }
                if (newValue != null) {
                    ((GeometryManager)newValue).addGeometryListener(this);
                }
            } else if (Grid.PROPERTY_SELECTION.equals(name)) {
                this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
            } else if (Grid.PROPERTY_FOCUSCELL.equals(name)) {
                Cell oldCell = (Cell)oldValue;
                Cell newCell = (Cell)newValue;
                Grid.this._fireActiveEvent(oldCell, newCell);
            }
        }

        @Override
        public void rowsAdded(TwoDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void rowsRemoved(TwoDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void invalidateRows(TwoDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void columnsAdded(TwoDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void columnsRemoved(TwoDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void invalidateColumns(TwoDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void invalidateCells(TwoDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void cellEditing(GridEvent e) {
        }

        @Override
        public void cellEdited(GridEvent e) {
            Grid.this._fireActiveEvent(null, e.getCell());
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void geometryChanged(GeometryEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        protected String getAccessibleName(int column, int row, Object data) {
            Painter p;
            AbstractBigCell bigCell = null;
            if (data instanceof AbstractBigCell) {
                bigCell = (AbstractBigCell)data;
                data = bigCell.getData();
            } else if (data instanceof HDataObject) {
                data = ((HDataObject)data).getData();
            }
            String name = null;
            name = data == null ? null : (data instanceof String ? (String)data : (data instanceof Boolean ? data.toString() : (data instanceof Number || data instanceof Date ? ((p = Grid.this.getColumnPainter(column)) instanceof FormatPainter ? ((FormatPainter)p).getFormat().format(data) : data.toString()) : (data instanceof ImageIcon ? ((ImageIcon)data).getDescription() : (data instanceof Image || data instanceof ImageSet || data instanceof Icon ? this.getTranslatedString(Grid._IMAGE) : this.getTranslatedString(Grid._UNKNOWN))))));
            if (bigCell != null) {
                int columns = bigCell.getColumnCount();
                int rows = bigCell.getRowCount();
                if (name == null) {
                    name = "";
                }
                String key = this._getBigCellKey(columns, rows);
                String s = this.getTranslatedString(key);
                MessageFormat form = new MessageFormat(s);
                Object[] args = new Object[]{name, IntegerUtils.getString((int)columns), IntegerUtils.getString((int)rows)};
                name = form.format(args);
            }
            return this.getAccessibleNameForTable(column, row, data, name);
        }

        protected String getAccessibleNameForTable(int column, int row, Object data, String cellName) {
            Accessible parent = this.getAccessibleParent();
            if (parent == null) {
                return cellName;
            }
            AccessibleContext ac = parent.getAccessibleContext();
            if (ac.getAccessibleRole() != AccessibleRole.TABLE) {
                return cellName;
            }
            String columnName = this._getHeaderName(ac, AccessibleRole.COLUMN_HEADER, column);
            String rowName = this._getHeaderName(ac, AccessibleRole.ROW_HEADER, row);
            String totalName = null;
            if (cellName == null) {
                if (columnName != null && rowName != null) {
                    String text = this.getTranslatedString(Grid._NULL_CELL_BOTH);
                    MessageFormat form = new MessageFormat(text);
                    Object[] args = new Object[]{columnName, rowName};
                    totalName = form.format(args);
                } else if (columnName != null) {
                    String text = this.getTranslatedString(Grid._NULL_CELL_COLUMN);
                    MessageFormat form = new MessageFormat(text);
                    Object[] args = new Object[]{columnName};
                    totalName = form.format(args);
                } else if (rowName != null) {
                    String text = this.getTranslatedString(Grid._NULL_CELL_ROW);
                    MessageFormat form = new MessageFormat(text);
                    Object[] args = new Object[]{rowName};
                    totalName = form.format(args);
                }
            } else if (columnName != null && rowName != null) {
                String text = this.getTranslatedString(Grid._FULL_CELL_NAME);
                MessageFormat form = new MessageFormat(text);
                Object[] args = new Object[]{columnName, rowName, cellName};
                totalName = form.format(args);
            } else if (columnName != null) {
                String text = this.getTranslatedString(Grid._COLUMNONLY_CELL_NAME);
                MessageFormat form = new MessageFormat(text);
                Object[] args = new Object[]{columnName, cellName};
                totalName = form.format(args);
            } else if (rowName != null) {
                String text = this.getTranslatedString(Grid._ROWONLY_CELL_NAME);
                MessageFormat form = new MessageFormat(text);
                Object[] args = new Object[]{rowName, cellName};
                totalName = form.format(args);
            } else {
                totalName = cellName;
            }
            return totalName;
        }

        protected String getTranslatedString(String key) {
            ResourceBundle b = ResourceBundle.getBundle(Grid._RESOURCE, this.getLocale());
            return b.getString(key);
        }

        private String _getHeaderName(AccessibleContext ac, AccessibleRole role, int item) {
            int count = ac.getAccessibleChildrenCount();
            for (int i = 0; i < count; ++i) {
                AccessibleContext childContext;
                Accessible child = ac.getAccessibleChild(i);
                if (child == null || (childContext = child.getAccessibleContext()).getAccessibleRole() != role) continue;
                child = childContext.getAccessibleChild(item);
                return child.getAccessibleContext().getAccessibleName();
            }
            return null;
        }

        private String _getBigCellKey(int columns, int rows) {
            if (columns > 1) {
                if (rows > 1) {
                    return Grid._SPANMM;
                }
                return Grid._SPANMS;
            }
            if (rows > 1) {
                return Grid._SPANSM;
            }
            return Grid._SPANSS;
        }

        public class AccessibleGridCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private int _position;

            public AccessibleGridCell(int position) {
                this._position = position;
                this.setAccessibleParent(Grid.this);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            @Override
            public String getAccessibleName() {
                String name;
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && (name = ac.getAccessibleName()) != null && name != "") {
                    return ac.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                if (row != -1 && column != -1) {
                    return AccessibleGrid.this.getAccessibleName(column, row);
                }
                return null;
            }

            @Override
            public void setAccessibleName(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleName(s);
                } else {
                    super.setAccessibleName(s);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleDescription();
                }
                if (this.accessibleDescription != null && this.accessibleDescription != "") {
                    return this.accessibleDescription;
                }
                int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                if (row != -1 && column != -1) {
                    return AccessibleGrid.this.getAccessibleDescription(column, row);
                }
                return null;
            }

            @Override
            public void setAccessibleDescription(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleDescription(s);
                } else {
                    super.setAccessibleDescription(s);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleRole();
                }
                return AccessibleRole.LABEL;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                AccessibleStateSet as = null;
                if (ac != null) {
                    as = ac.getAccessibleStateSet();
                }
                if (as == null) {
                    as = new AccessibleStateSet();
                }
                int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Rectangle rcell = null;
                Cell selectedCell = null;
                if (row != -1 && column != -1) {
                    Cell focusCell;
                    HDataObject hd;
                    rcell = Grid.this._getCellRect(column, row);
                    selectedCell = new Cell(column, row);
                    Object data = Grid.this.getModel().getData(column, row);
                    if (data instanceof HDataObject && (hd = (HDataObject)data).hasChildren()) {
                        as.add(AccessibleState.EXPANDABLE);
                        if (hd.isExpanded()) {
                            as.add(AccessibleState.EXPANDED);
                        } else {
                            as.add(AccessibleState.COLLAPSED);
                        }
                    }
                    if ((focusCell = Grid.this.getFocusCell()) != null && row == focusCell.row && column == focusCell.column) {
                        as.add(AccessibleState.FOCUSED);
                    }
                }
                if (rcell != null) {
                    as.add(AccessibleState.VISIBLE);
                    if (this.isShowing()) {
                        as.add(AccessibleState.SHOWING);
                    } else {
                        as.remove(AccessibleState.SHOWING);
                    }
                } else {
                    as.remove(AccessibleState.VISIBLE);
                    as.remove(AccessibleState.SHOWING);
                }
                as.add(AccessibleState.SELECTABLE);
                as.add(AccessibleState.EDITABLE);
                if (Grid.this.isEnabled()) {
                    as.add(AccessibleState.ENABLED);
                }
                if (selectedCell != null && Grid.this.getSelection().containsCell(selectedCell)) {
                    as.add(AccessibleState.SELECTED);
                } else if (as.contains(AccessibleState.SELECTED)) {
                    as.remove(AccessibleState.SELECTED);
                }
                as.add(AccessibleState.FOCUSABLE);
                as.add(AccessibleState.TRANSIENT);
                return as;
            }

            @Override
            public Accessible getAccessibleParent() {
                return Grid.this;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this._position;
            }

            @Override
            public int getAccessibleChildrenCount() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleChildrenCount();
                }
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    Accessible accessibleChild = ac.getAccessibleChild(i);
                    ac.setAccessibleParent(this);
                    return accessibleChild;
                }
                return null;
            }

            @Override
            public Locale getLocale() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getLocale();
                }
                return Grid.this.getLocale();
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.addPropertyChangeListener(l);
                } else {
                    super.addPropertyChangeListener(l);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.removePropertyChangeListener(l);
                } else {
                    super.removePropertyChangeListener(l);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleAction();
                }
                return null;
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext ctxt = this.getCurrentAccessibleContext();
                if (ctxt != null) {
                    return ctxt.getAccessibleSelection();
                }
                return null;
            }

            @Override
            public AccessibleText getAccessibleText() {
                AccessibleContext ctxt = this.getCurrentAccessibleContext();
                if (ctxt != null) {
                    return ctxt.getAccessibleText();
                }
                return null;
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                AccessibleContext ctxt = this.getCurrentAccessibleContext();
                if (ctxt != null) {
                    return ctxt.getAccessibleValue();
                }
                return null;
            }

            @Override
            public Color getBackground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getBackground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getBackground();
                }
                AppearanceManager am = Grid.this.getAppearanceManager();
                if (am != null) {
                    Color color;
                    int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                    int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                    Appearance a = null;
                    if (row != -1 && column != -1) {
                        a = am.getCellPaintingAppearance(column, row);
                    }
                    if (a != null && (color = a.getBackground()) != null) {
                        return color;
                    }
                }
                return Grid.this.getBackground();
            }

            @Override
            public void setBackground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBackground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setBackground(c);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getForeground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getForeground();
                }
                AppearanceManager am = Grid.this.getAppearanceManager();
                if (am != null) {
                    Color color;
                    int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                    int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                    Appearance a = null;
                    if (row != -1 && column != -1) {
                        a = am.getCellPaintingAppearance(column, row);
                    }
                    if (a != null && (color = a.getForeground()) != null) {
                        return color;
                    }
                }
                return Grid.this.getForeground();
            }

            @Override
            public void setForeground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setForeground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setForeground(c);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getCursor();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getCursor();
                }
                Accessible ap = this.getAccessibleParent();
                if (ap instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ap)).getCursor();
                }
                return Grid.this.getCursor();
            }

            @Override
            public void setCursor(Cursor c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setCursor(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setCursor(c);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFont();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFont();
                }
                AppearanceManager am = Grid.this.getAppearanceManager();
                if (am != null) {
                    Font f;
                    int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                    int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                    Appearance a = null;
                    if (row != -1 && column != -1) {
                        a = am.getCellPaintingAppearance(column, row);
                    }
                    if (a != null && (f = a.getFont()) != null) {
                        return f;
                    }
                }
                return Grid.this.getFont();
            }

            @Override
            public void setFont(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setFont(f);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setFont(f);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFontMetrics(f);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFontMetrics(f);
                }
                return Grid.this.getFontMetrics(f);
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isEnabled();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isEnabled();
                }
                return Grid.this.isEnabled();
            }

            @Override
            public void setEnabled(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setEnabled(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setEnabled(b);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isVisible();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isVisible();
                }
                int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Rectangle rcell = null;
                if (row != -1 && column != -1) {
                    rcell = Grid.this._getCellRect(column, row);
                }
                return rcell != null;
            }

            @Override
            public void setVisible(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setVisible(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setVisible(b);
                    }
                }
            }

            @Override
            public boolean isShowing() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isShowing();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isShowing();
                }
                return Grid.this.isShowing();
            }

            @Override
            public boolean contains(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                    return r.contains(p);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    Rectangle r = c.getBounds();
                    return r.contains(p);
                }
                return this.getBounds().contains(p);
            }

            @Override
            public Point getLocationOnScreen() {
                if (Grid.this != null) {
                    Point parentLocation = Grid.this.getLocationOnScreen();
                    Point componentLocation = this.getLocation();
                    componentLocation.translate(parentLocation.x, parentLocation.y);
                    return componentLocation;
                }
                return null;
            }

            @Override
            public Point getLocation() {
                if (Grid.this != null) {
                    int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                    int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                    Rectangle r = null;
                    if (row != -1 && column != -1) {
                        r = Grid.this._getCellRect(column, row);
                    }
                    if (r != null) {
                        return r.getLocation();
                    }
                }
                return null;
            }

            @Override
            public void setLocation(Point p) {
            }

            @Override
            public Rectangle getBounds() {
                int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                if (Grid.this != null && row != -1 && column != -1) {
                    return new Rectangle(Grid.this.getColumnPosition(column), Grid.this.getRowPosition(row), Grid.this.getColumnWidth(column), Grid.this.getRowHeight(row));
                }
                return null;
            }

            @Override
            public void setBounds(Rectangle r) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBounds(r);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setBounds(r);
                    }
                }
            }

            @Override
            public Dimension getSize() {
                int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                if (Grid.this != null && row != -1 && column != -1) {
                    return new Dimension(Grid.this.getColumnWidth(column), Grid.this.getRowHeight(row));
                }
                return null;
            }

            @Override
            public void setSize(Dimension d) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setSize(d);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setSize(d);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getAccessibleAt(p);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isFocusTraversable();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).requestFocus();
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).addFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.addFocusListener(l);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).removeFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.removeFocusListener(l);
                    }
                }
            }

            protected int getPosition() {
                return this._position;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component c = this.getCurrentComponent();
                if (c != null && c instanceof Accessible) {
                    return ((Accessible)((Object)c)).getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                int row = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int column = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Cell c = Grid.this.getFocusCell();
                if (row != -1 && column != -1 && Grid.this.isEditing() && row == c.row && column == c.column) {
                    return Grid.this._editControl;
                }
                return null;
            }
        }
    }
}

