/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PivotGrippyPainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 3;
    private static final int _GRIPPY_GAP = 4;
    private static final int _GRIPPY_STRIDE = 7;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 7;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 17;
    private boolean _isHorizontal;
    private boolean _ignoreActive;
    private static Painter _sVerticalPainter;
    private static Painter _sHorizontalPainter;
    private static Painter _sIgnoreActiveVerticalPainter;
    private static Painter _sIgnoreActiveHorizontalPainter;

    public static Painter getPainter(boolean horizontal) {
        return PivotGrippyPainter.getPainter(horizontal, false);
    }

    public static Painter getPainter(boolean horizontal, boolean ignoreActive) {
        if (horizontal) {
            if (ignoreActive) {
                if (_sIgnoreActiveHorizontalPainter == null) {
                    _sIgnoreActiveHorizontalPainter = new PivotGrippyPainter(true, true);
                }
                return _sIgnoreActiveHorizontalPainter;
            }
            if (_sHorizontalPainter == null) {
                _sHorizontalPainter = new PivotGrippyPainter(true, false);
            }
            return _sHorizontalPainter;
        }
        if (ignoreActive) {
            if (_sIgnoreActiveVerticalPainter == null) {
                _sIgnoreActiveVerticalPainter = new PivotGrippyPainter(false, true);
            }
            return _sIgnoreActiveVerticalPainter;
        }
        if (_sVerticalPainter == null) {
            _sVerticalPainter = new PivotGrippyPainter(false, false);
        }
        return _sVerticalPainter;
    }

    @Override
    public Dimension getSize(PaintContext context, int width, int height) {
        if (this._isHorizontal) {
            if (width > 17) {
                width = 17;
            }
            if (height > 7) {
                height = 7;
            }
        } else {
            if (width > 7) {
                width = 7;
            }
            if (height > 17) {
                height = 17;
            }
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        if (this._isHorizontal) {
            return new Dimension(17, 7);
        }
        return new Dimension(7, 17);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        int state = 131;
        if (!this._ignoreActive) {
            state |= 4;
        }
        return state;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean paint;
        boolean active;
        int state;
        boolean printing;
        Color savedColor = g.getColor();
        boolean bl = printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        if (!printing) {
            Color grippyColor = UIManager.getColor("EWTPivotPivotGrippy.background");
            g.setColor(grippyColor);
            g.fillRect(x, y, width, height);
            grippyColor = UIManager.getColor("EWTPivotPivotGrippy.border");
            g.setColor(grippyColor);
            g.drawRect(x, y, width, height);
        }
        boolean enabled = ((state = context.getPaintState()) & 1) == 0;
        boolean bl2 = active = (state & 4) == 0;
        if (this._ignoreActive) {
            active = true;
        }
        boolean bl3 = printing ? false : (paint = enabled && active);
        if (paint) {
            boolean isArmed;
            int numGrippies = 3;
            if (this._isHorizontal) {
                numGrippies = 4;
            }
            int grippySize = numGrippies * 3 + (numGrippies - 1) * 4;
            int grippyWidth = 3;
            int grippyHeight = 3;
            int xOffset = 0;
            int yOffset = 0;
            if (this._isHorizontal) {
                grippyWidth = grippySize;
                xOffset = 7;
            } else {
                grippyHeight = grippySize;
                yOffset = 7;
            }
            int grippyX = x + (width - grippyWidth) / 2;
            int grippyY = y + (height - grippyHeight) / 2;
            UIDefaults defaults = context.getPaintUIDefaults();
            Color highlight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            Color shadow = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
            Color dark = defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
            Color black = Color.black;
            boolean bl4 = isArmed = (state & 2) != 0;
            while (numGrippies > 0) {
                if (this._isHorizontal) {
                    PivotGrippyPainter.__drawHorizontalGrippy(g, grippyX, grippyY, highlight, dark, black, isArmed);
                } else {
                    PivotGrippyPainter.__drawVerticalGrippy(g, grippyX, grippyY, highlight, dark, black, isArmed);
                }
                --numGrippies;
                grippyX += xOffset;
                grippyY += yOffset;
            }
        }
        g.setColor(savedColor);
    }

    static void __drawHorizontalGrippy(Graphics g, int x, int y, Color highlight, Color dark, Color black, boolean isArmed) {
        g.setColor(dark);
        g.drawLine(x + 1, y + 2, x + 2, y + 1);
        if (isArmed) {
            g.setColor(highlight);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.setColor(black);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
        } else {
            g.setColor(black);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.setColor(highlight);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
        }
    }

    static void __drawVerticalGrippy(Graphics g, int x, int y, Color highlight, Color dark, Color black, boolean isArmed) {
        g.setColor(dark);
        g.drawLine(x + 1, y + 1, x + 2, y + 2);
        if (isArmed) {
            g.setColor(black);
            g.drawLine(x + 2, y + 1, x + 2, y + 1);
            g.setColor(highlight);
            g.drawLine(x + 1, y + 2, x + 1, y + 2);
        } else {
            g.setColor(highlight);
            g.drawLine(x + 2, y + 1, x + 2, y + 1);
            g.setColor(black);
            g.drawLine(x + 1, y + 2, x + 1, y + 2);
        }
    }

    private PivotGrippyPainter(boolean isHorizontal, boolean ignoreActive) {
        this._isHorizontal = isHorizontal;
        this._ignoreActive = ignoreActive;
    }
}

