/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dialog;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.PaintUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class JEWTDialog
extends JDialog {
    public static final int BUTTON_NONE = 0;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final int BUTTON_HELP = 4;
    public static final int BUTTON_APPLY = 8;
    public static final int BUTTON_CLOSE = 16;
    public static final int BUTTON_DEFAULT = 7;
    public static final String PROPERTY_CLOSED = "closed";
    public static final String ACTION_APPLY = "apply";
    private static boolean _IS_LINUX;
    private static final Border _sButtonBorder;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_APPLY = "WIZARD.APPLY";
    private static final String _KEY_OK = "OK";
    private static final String _KEY_CANCEL = "CANCEL";
    private static final String _KEY_HELP = "HELP";
    private static final String _KEY_CLOSE = "JEWTDIALOG.CLOSE";
    private static final int _DEFAULT_CONTENT_GAP = 8;
    private static final int _DEFAULT_VMSG_GAP = 8;
    private int _buttonMask;
    private Vector _buttons = new Vector();
    private DialogButtonBar _bar;
    private GrayPane _pane;
    private StatusBarLabel _statusBarLabel;
    private JPanel _bottomPanel;
    private JPanel _mainContainer;
    private JPanel _dialogContent;
    private JPanel _contentContainer;
    private Component _header;
    private JButton _ok;
    private JButton _apply;
    private JButton _cancelClose;
    private JButton _help;
    private int _defaultButtonIndex;
    private boolean _cancelled;
    private boolean _oked;
    private UIListener _listener;
    private Component _centerOver;
    private PropertyChangeSupport _propertyChangeSupport;
    private VetoableChangeSupport _vetoableChangeSupport;
    private Component _initialFocus;
    private ListenerManager _actionListeners;
    private JButton _defaultButton;
    private JButton _defaultCustomButton;
    private int _prefWidth;
    private int _prefHeight;
    private Runnable _runnable;
    private int _minWidth = -1;
    private int _minHeight = -1;
    private int _initialWidth = 0;
    private int _initialHeight = 0;
    private int _dialogMaximumWidth = -1;
    private int _dialogMaximumHeight = -1;
    private boolean _isOKDefaulted = true;
    private boolean _isCancelDefaulted = true;
    private ValidationMessagePane _validationPane;
    private static final String _APPLY_NAME = "Apply_Button";
    private static final String _OK_NAME = "OK_Button";
    private static final String _CANCEL_NAME = "Cancel_Button";
    private static final String _HELP_NAME = "Help_Button";
    private static final String _CLOSE_NAME = "Close_Button";

    public static JEWTDialog createDialog(Component owner, String title, int buttonMask) {
        JEWTDialog d = null;
        while (owner != null) {
            if (owner instanceof Dialog) {
                d = new JEWTDialog((Dialog)owner, title, buttonMask);
                break;
            }
            if (owner instanceof Frame) {
                d = new JEWTDialog((Frame)owner, title, buttonMask);
                break;
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (d == null) {
            d = new JEWTDialog((Frame)null, title, buttonMask);
        }
        return d;
    }

    public JEWTDialog() {
        this((Frame)null);
    }

    public JEWTDialog(Frame owner) {
        this(owner, "JEWTDialog");
    }

    public JEWTDialog(Frame owner, String title) {
        this(owner, title, 1);
    }

    public JEWTDialog(Frame owner, String title, int buttonMask) {
        super(owner, title);
        WindowUtils.registerWindow(this);
        this.setModal(true);
        this.setResizable(false);
        this.dialogInit();
        this.setButtonMask(buttonMask);
        this.setDefaultButton(1);
    }

    public JEWTDialog(Dialog owner) {
        this(owner, "JEWTDialog");
    }

    public JEWTDialog(Dialog owner, String title) {
        this(owner, title, 1);
    }

    public JEWTDialog(Dialog owner, String title, int buttonMask) {
        super(owner, title);
        WindowUtils.registerWindow(this);
        this.setModal(true);
        this.setResizable(false);
        this.dialogInit();
        this.setButtonMask(buttonMask);
        this.setDefaultButton(1);
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component centerOver) {
        this._centerOver = centerOver;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public boolean isOked() {
        return this._oked;
    }

    public boolean runDialog() {
        return this.runDialog(null);
    }

    public boolean runDialog(Runnable runnable) {
        this._runnable = runnable;
        this._initStrings();
        this.pack();
        Component centerOver = this.getCenterOver();
        if (centerOver == null) {
            centerOver = this.getParent();
        }
        WindowUtils.centerWindow(this, centerOver);
        this._cancelled = false;
        this._initialWidth = this.getWidth();
        this._initialHeight = this.getHeight();
        if (this._minWidth == -1 || this._minHeight != -1) {
            this._updatePeerMinimumSize(this._initialWidth, this._initialHeight);
        }
        this.setVisible(true);
        return !this._cancelled;
    }

    @Override
    public void dispose() {
        if (this._contentContainer == null) {
            return;
        }
        WindowUtils.unregisterWindow(this);
        this.setCenterOver(null);
        this.setContent(null);
        this._contentContainer = null;
        if (this._bar != null) {
            this._bar.removeAll();
            this._bar = null;
        }
        if (this._buttons != null) {
            this._buttons.removeAllElements();
            this._buttons = null;
        }
        if (this._ok != null) {
            this._ok.removeActionListener(this._listener);
            this._ok.removeFocusListener(this._listener);
        }
        if (this._cancelClose != null) {
            this._cancelClose.removeActionListener(this._listener);
            this._cancelClose.removeFocusListener(this._listener);
        }
        if (this._help != null) {
            this._help.removeActionListener(this._listener);
            this._help.removeFocusListener(this._listener);
        }
        if (this._apply != null) {
            this._apply.removeActionListener(this._listener);
            this._apply.removeFocusListener(this._listener);
        }
        this._listener = null;
        this._apply = null;
        this._help = null;
        this._cancelClose = null;
        this._ok = null;
        this._defaultButton = null;
        this._defaultCustomButton = null;
        this._pane.setContent(null);
        this._pane = null;
        super.dispose();
    }

    @Override
    public final void setPreferredSize(Dimension prefSize) {
        if (prefSize == null) {
            prefSize = new Dimension(-1, -1);
        }
        this.setPreferredSize(prefSize.width, prefSize.height);
    }

    public void setPreferredSize(int width, int height) {
        this._prefWidth = width;
        this._prefHeight = height;
    }

    @Override
    public final void setMinimumSize(Dimension minSize) {
        if (minSize == null) {
            this.setMinimumSize(-1, -1);
        } else {
            this.setMinimumSize(minSize.width, minSize.height);
        }
    }

    public void setMinimumSize(int width, int height) {
        this._minWidth = width;
        this._minHeight = height;
        if (this._minWidth != -1 && this._minHeight != -1) {
            this._updatePeerMinimumSize(this._minWidth, this._minHeight);
        } else {
            this._updatePeerMinimumSize(this._initialWidth, this._initialHeight);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this._minWidth != -1 && this._minHeight != -1) {
            return new Dimension(this._minWidth, this._minHeight);
        }
        return new Dimension(this._initialWidth, this._initialHeight);
    }

    public final void setMaximumInitialSize(Dimension maxInitSize) {
        if (maxInitSize == null) {
            this.setMaximumInitialSize(-1, -1);
        } else {
            this.setMaximumInitialSize(maxInitSize.width, maxInitSize.height);
        }
    }

    public void setMaximumInitialSize(int width, int height) {
        this._dialogMaximumWidth = width;
        this._dialogMaximumHeight = height;
    }

    @Deprecated
    public Dimension getMaximunInitialSize() {
        if (this._dialogMaximumWidth != -1 && this._dialogMaximumHeight != -1) {
            return new Dimension(this._dialogMaximumWidth, this._dialogMaximumHeight);
        }
        return new Dimension(WindowUtils.DIALOG_MAXIMUM_WIDTH, WindowUtils.DIALOG_MAXIMUM_HEIGHT);
    }

    public Dimension getMaximumInitialSize() {
        return this.getMaximunInitialSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = null;
        d = this._prefWidth != -1 && this._prefHeight != -1 ? new Dimension(this._prefWidth, this._prefHeight) : super.getPreferredSize();
        Dimension dim = this.getMaximumInitialSize();
        if (d.width > dim.width) {
            d.width = dim.width;
        }
        if (d.height > dim.height) {
            d.height = dim.height;
        }
        return d;
    }

    public Component getContent() {
        return this._contentContainer == null || this._contentContainer.getComponentCount() == 0 ? null : this._contentContainer.getComponent(0);
    }

    public void setContent(Component content) {
        boolean wasTabbedPane = this.getContent() instanceof JTabbedPane;
        this._contentContainer.removeAll();
        if (content instanceof JTabbedPane && !wasTabbedPane) {
            JPanel rootContent = this._mainContainer;
            rootContent.remove(this._pane);
            rootContent.add("Center", this._dialogContent);
            LookAndFeel.installBorder(this._dialogContent, "EWTDialog.tabbedInnerBorder");
        } else if (wasTabbedPane) {
            JPanel rootContent = this._mainContainer;
            rootContent.remove(this._dialogContent);
            this._pane = new GrayPane(this._dialogContent);
            rootContent.add("Center", this._pane);
            LookAndFeel.installBorder(this._dialogContent, "EWTDialog.innerBorder");
        }
        if (content != null) {
            this._contentContainer.add("Center", content);
        }
        this._dialogContent.revalidate();
    }

    public int getButtonMask() {
        return this._buttonMask;
    }

    public void setButtonMask(int mask) {
        if (mask > 31) {
            throw new IllegalArgumentException("Button Mask out of range");
        }
        if ((mask & 0x12) == 18) {
            throw new IllegalArgumentException("Cancel and Close buttons are exclusive");
        }
        if (mask != this._buttonMask) {
            int removeMask = this._buttonMask & ~mask;
            if ((removeMask & 1) > 0) {
                this._removeOk(this._bar);
            }
            if ((removeMask & 2) > 0 || (removeMask & 0x10) > 0) {
                this._removeCancelClose(this._bar);
            }
            if ((removeMask & 4) > 0) {
                this._removeHelp(this._bar);
            }
            if ((removeMask & 8) > 0) {
                this._removeApply(this._bar);
            }
            this._buttonMask = mask;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            ResourceBundle bundle = ResourceBundle.getBundle(_RESOURCE, locale);
            if ((this._buttonMask & 1) > 0) {
                this._addOk(bundle, this._bar);
            }
            if ((this._buttonMask & 2) > 0 || (this._buttonMask & 0x10) > 0) {
                this._addCancelClose(bundle, this._bar);
            }
            if ((this._buttonMask & 4) > 0) {
                this._addHelp(bundle, this._bar);
            }
            if ((this._buttonMask & 8) > 0) {
                this._addApply(bundle, this._bar);
            }
            this._dialogContent.revalidate();
        }
    }

    public void addCustomButton(Component button) {
        if (!this._buttons.contains(button)) {
            this._bar.add(button);
            this._buttons.addElement(button);
        }
    }

    public void removeCustomButton(Component button) {
        this._bar.remove(button);
        this._buttons.removeElement(button);
    }

    public int getCustomButtonCount() {
        return this._buttons.size();
    }

    public Component getCustomButton(int button) {
        if (this.getCustomButtonCount() > button) {
            return (Component)this._buttons.elementAt(button);
        }
        return null;
    }

    public void setDefaultCustomButton(JButton customButton, boolean transferFocus) {
        if (customButton != null) {
            if (!this._buttons.contains(customButton)) {
                throw new IllegalArgumentException("Custom button is not present in JEWTDialog");
            }
            if (customButton != this._defaultCustomButton) {
                this.setDefaultButton(0);
                JButton b = this.getRootPane().getDefaultButton();
                if (b != null) {
                    b.setDefaultCapable(false);
                }
                this._defaultCustomButton = customButton;
                this.getRootPane().setDefaultButton(this._defaultCustomButton);
                if (this._defaultCustomButton != null) {
                    this._defaultCustomButton.setDefaultCapable(true);
                }
                if (transferFocus && this._defaultCustomButton.isEnabled()) {
                    FocusUtils.requestFocus(this._defaultCustomButton);
                }
            }
        } else {
            this.setDefaultButton(1);
            this._defaultCustomButton = null;
            if (transferFocus && this._ok != null && this._ok.isEnabled()) {
                FocusUtils.requestFocus(this._ok);
            }
        }
    }

    public JButton getDefaultCustomButton() {
        return this._defaultCustomButton;
    }

    public int getDefaultButton() {
        return this._defaultButtonIndex;
    }

    public void setDefaultButton(int button) {
        if (button < 0 || button > 16) {
            throw new IllegalArgumentException("Undefined button constant");
        }
        if (button != this._defaultButtonIndex) {
            JButton b = this.getRootPane().getDefaultButton();
            if (b != null) {
                b.setDefaultCapable(false);
            }
            switch (button) {
                case 1: {
                    this._defaultButton = this._ok;
                    break;
                }
                case 2: {
                    if ((this.getButtonMask() & 2) == 0) {
                        throw new UnsupportedOperationException("Cancel button is unavailable in button mask");
                    }
                    this._defaultButton = this._cancelClose;
                    break;
                }
                case 4: {
                    this._defaultButton = this._help;
                    break;
                }
                case 8: {
                    this._defaultButton = this._apply;
                    break;
                }
                case 16: {
                    if ((this.getButtonMask() & 0x10) == 0) {
                        throw new UnsupportedOperationException("Close button is unavailable in button mask");
                    }
                    this._defaultButton = this._cancelClose;
                    break;
                }
                default: {
                    this._defaultButton = null;
                }
            }
            this._defaultButtonIndex = button;
            this.getRootPane().setDefaultButton(this._defaultButton);
            if (this._defaultButton != null) {
                this._defaultButton.setDefaultCapable(true);
            }
        }
    }

    public void setOKButtonEnabled(boolean enabled) {
        if (this._ok != null) {
            this._ok.setEnabled(enabled);
        }
    }

    public boolean isOKButtonEnabled() {
        return this._ok != null ? this._ok.isEnabled() : false;
    }

    public void setOKButtonText(String translatedText) {
        if (this._ok == null) {
            this.setButtonMask(this.getButtonMask() | 1);
        }
        this._ok.setText(StringUtils.stripMnemonic((String)translatedText));
        this._ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this._isOKDefaulted = false;
    }

    public String getOKButtonText() {
        return this._ok != null ? this._ok.getText() : null;
    }

    public int getOKButtonMnemonic() {
        return this._ok != null ? this._ok.getMnemonic() : -1;
    }

    public void setOKButtonMnemonic(int keyCode) {
        if (this._ok == null) {
            this.setButtonMask(this.getButtonMask() | 1);
        }
        this._ok.setMnemonic(keyCode);
    }

    public void setCancelButtonText(String translatedText) {
        if ((this.getButtonMask() & 0x10) > 0) {
            throw new UnsupportedOperationException("Cancel button is unavailable in button mask");
        }
        if (this._cancelClose == null) {
            this.setButtonMask(this.getButtonMask() | 2);
        }
        this._cancelClose.setText(StringUtils.stripMnemonic((String)translatedText));
        this._cancelClose.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this._isCancelDefaulted = false;
    }

    public String getCancelButtonText() {
        if ((this.getButtonMask() & 0x10) > 0) {
            return null;
        }
        return this._cancelClose != null ? this._cancelClose.getText() : null;
    }

    public int getCancelButtonMnemonic() {
        if ((this.getButtonMask() & 0x10) > 0) {
            return -1;
        }
        return this._cancelClose != null ? this._cancelClose.getMnemonic() : -1;
    }

    public void setCancelButtonMnemonic(int keyCode) {
        if ((this.getButtonMask() & 0x10) > 0) {
            throw new UnsupportedOperationException("Cancel button is unavailable in button mask");
        }
        if (this._cancelClose == null) {
            this.setButtonMask(this.getButtonMask() | 2);
        }
        this._cancelClose.setMnemonic(keyCode);
    }

    public int getButtonMnemonic(int buttonMask) {
        int keyCode = 0;
        switch (buttonMask) {
            case 1: {
                if (this._ok == null) break;
                keyCode = this._ok.getMnemonic();
                break;
            }
            case 2: {
                if (this._cancelClose == null || (this.getButtonMask() & 2) <= 0) break;
                keyCode = this._cancelClose.getMnemonic();
                break;
            }
            case 4: {
                if (this._help == null) break;
                keyCode = this._help.getMnemonic();
                break;
            }
            case 8: {
                if (this._apply == null) break;
                keyCode = this._apply.getMnemonic();
                break;
            }
            case 16: {
                if (this._cancelClose == null || (this.getButtonMask() & 0x10) <= 0) break;
                keyCode = this._cancelClose.getMnemonic();
            }
        }
        return keyCode;
    }

    public void addActionListener(ActionListener listener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener((EventListener)listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this._actionListeners != null) {
            this._actionListeners.removeListener((EventListener)listener);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        final Window w = WindowUtils.getWindow(this);
        w.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (JEWTDialog.this._initialFocus != null) {
                    FocusUtils.requestFocus(JEWTDialog.this._initialFocus);
                } else {
                    Component c = null;
                    JButton defButton = JEWTDialog.this._defaultButton != null ? JEWTDialog.this._defaultButton : JEWTDialog.this._defaultCustomButton;
                    Component content = JEWTDialog.this.getContent();
                    if (content instanceof Container) {
                        c = JEWTDialog.this._getFirstFocusableComponent((Container)content);
                    } else if (content != null && FocusUtils.isFocusable(content) && content.isEnabled() && content.isShowing()) {
                        c = content;
                    }
                    if (c != null) {
                        FocusUtils.requestFocus(c);
                    } else if (defButton != null && defButton.isEnabled()) {
                        FocusUtils.requestFocus(defButton);
                    } else if (JEWTDialog.this._ok != null && JEWTDialog.this._ok.isEnabled()) {
                        FocusUtils.requestFocus(JEWTDialog.this._ok);
                    }
                }
                w.removeWindowListener(this);
            }
        });
    }

    public Component getInitialFocus() {
        return this._initialFocus;
    }

    public void setInitialFocus(Component initialFocus) {
        this._initialFocus = initialFocus;
    }

    public void setDialogHeader(Component component) {
        if (this._header != component) {
            if (this._header != null) {
                this.getContentPane().remove(this._header);
            }
            this._header = component;
            if (this._header != null) {
                this.getContentPane().add("North", this._header);
                LookAndFeel.installBorder(this._mainContainer, "EWTDialog.headerOuterBorder");
            } else {
                LookAndFeel.installBorder(this._mainContainer, "EWTDialog.outerBorder");
            }
        }
    }

    public Component getDialogHeader() {
        return this._header;
    }

    public void setValidationMessagePane(ValidationMessagePane pane) {
        if (this._validationPane != pane) {
            boolean wasShowing = false;
            if (this._validationPane != null) {
                boolean bl = wasShowing = this.isVisible() && this._validationPane.isVisible();
                if (!wasShowing && this._validationPane.isEmpty()) {
                    this._validationPane.removePropertyChangeListener(this._listener);
                }
                this._dialogContent.remove(this._validationPane);
            }
            this._validationPane = pane;
            if (this._validationPane != null) {
                this._dialogContent.add((Component)this._validationPane, "South");
                if (!wasShowing && this._validationPane.isEmpty()) {
                    this._validationPane.setVisible(false);
                    this._validationPane.addPropertyChangeListener(this._listener);
                }
            }
            this._repack(!wasShowing);
        }
    }

    public ValidationMessagePane getValidationMessagePane() {
        return this._validationPane;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoableChangeSupport == null) {
            this._vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this._vetoableChangeSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.removeVetoableChangeListener(listener);
        }
    }

    public final void closeDialog(boolean cancelled) {
        this.dismissDialog(cancelled);
    }

    public static boolean isDialogClosingEvent(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        return PROPERTY_CLOSED.equals(propName) && Boolean.TRUE.equals(newValue) && Boolean.FALSE.equals(oldValue);
    }

    @Override
    public void pack() {
        super.pack();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = super.getAccessibleContext();
            StatusBar bar = new StatusBar();
            this._statusBarLabel = new StatusBarLabel();
            bar.add(this._statusBarLabel);
            bar.setPreferredSize(new Dimension(0, 0));
            this._bottomPanel.add((Component)bar, "South");
        }
        return this.accessibleContext;
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        int originalHeight;
        int originalWidth;
        super.processComponentEvent(e);
        if (e.getID() != 101) {
            return;
        }
        int width = originalWidth = this.getWidth();
        int height = originalHeight = this.getHeight();
        Dimension dim = this.getMinimumSize();
        width = Math.max(dim.width, width);
        height = Math.max(dim.height, height);
        if (originalWidth != width || originalHeight != height) {
            this.setSize(width, height);
        }
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
        this.enableEvents(1L);
        this.setPreferredSize(-1, -1);
        this.setResizable(false);
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle bundle = ResourceBundle.getBundle(_RESOURCE, locale);
        this._listener = new UIListener();
        this._contentContainer = new JPanel(new BorderLayout());
        this._dialogContent = new JPanel(new BorderLayout(0, 8));
        LookAndFeel.installBorder(this._dialogContent, "EWTDialog.innerBorder");
        this._dialogContent.add((Component)this._contentContainer, "Center");
        this._pane = new GrayPane(this._dialogContent);
        this._bar = new DialogButtonBar();
        this._bar.setBorder(_sButtonBorder);
        this._bottomPanel = new JPanel(new BorderLayout());
        this._bottomPanel.add(this._bar);
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BorderLayout());
        this._mainContainer = new JPanel(new BorderLayout(0, 8));
        LookAndFeel.installBorder(this._mainContainer, "EWTDialog.outerBorder");
        this._mainContainer.add((Component)this._pane, "Center");
        this._mainContainer.add((Component)this._bottomPanel, "South");
        content.add("Center", this._mainContainer);
        Color bg = UIManager.getColor("EWTDialog.background");
        if (bg != null) {
            this.setBackground(bg);
            this.getContentPane().setBackground(bg);
        }
        this.enableEvents(64L);
        this._registerKeyboardActions();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.dismissDialog(true);
        } else if (e.getID() == 205 && this._statusBarLabel != null) {
            this._statusBarLabel.setText("");
            String accessName = this.getAccessibleContext().getAccessibleName();
            if (accessName != null && !accessName.equals(this.getTitle())) {
                this._statusBarLabel.setText(accessName);
            }
        }
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled) {
            try {
                this.fireVetoableChange(PROPERTY_CLOSED, Boolean.FALSE, Boolean.TRUE);
            }
            catch (PropertyVetoException pve) {
                return;
            }
        }
        this._cancelled = cancelled;
        if (this.isVisible()) {
            this.setVisible(false);
            if (!this._cancelled && this._runnable != null) {
                PaintUtils.invokeAfterRepaint(this._runnable);
                this._runnable = null;
            }
        }
        this.firePropertyChange(PROPERTY_CLOSED, Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processActionEvent(ActionEvent e) {
        if (this._actionListeners == null) {
            return;
        }
        Enumeration enumer = this._actionListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 1001: {
                while (enumer.hasMoreElements()) {
                    ((ActionListener)enumer.nextElement()).actionPerformed(e);
                }
                break;
            }
        }
    }

    void fireHelpEvent() {
        try {
            Component c = this.getContent();
            if (c == null) {
                c = this;
            }
            HelpUtils.showHelp(c);
        }
        catch (HelpUnavailableException helpUnavailableException) {
            // empty catch block
        }
    }

    private void _registerKeyboardActions() {
        JRootPane c = this.getRootPane();
        c.registerKeyboardAction(this._listener, _KEY_CANCEL, KeyStroke.getKeyStroke(27, 0), 1);
        c.registerKeyboardAction(this._listener, _KEY_HELP, KeyStroke.getKeyStroke(112, 0), 1);
        c.registerKeyboardAction(this._listener, _KEY_HELP, KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void _unregisterKeyboardActions() {
        JRootPane c = this.getRootPane();
        c.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        c.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
        c.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
    }

    private void _initStrings() {
        String translatedText;
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, locale);
        if (this._ok != null && this._isOKDefaulted) {
            translatedText = b.getString(_KEY_OK);
            this._ok.setText(StringUtils.stripMnemonic((String)translatedText));
            this._ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this._apply != null) {
            translatedText = b.getString(_KEY_APPLY);
            this._apply.setText(StringUtils.stripMnemonic((String)translatedText));
            this._apply.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this._cancelClose != null) {
            translatedText = null;
            if ((this.getButtonMask() & 2) > 0) {
                if (this._isCancelDefaulted) {
                    translatedText = b.getString(_KEY_CANCEL);
                }
            } else if ((this.getButtonMask() & 0x10) > 0) {
                translatedText = b.getString(_KEY_CLOSE);
            }
            if (translatedText != null) {
                this._cancelClose.setText(StringUtils.stripMnemonic((String)translatedText));
                this._cancelClose.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            }
        }
        if (this._help != null) {
            translatedText = b.getString(_KEY_HELP);
            this._help.setText(StringUtils.stripMnemonic((String)translatedText));
            this._help.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
    }

    private void _addOk(ResourceBundle b, DialogButtonBar bar) {
        if (this._ok == null) {
            String translatedText = b.getString(_KEY_OK);
            this._ok = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this._ok.setDefaultCapable(true);
            this._ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this._ok.setActionCommand(_KEY_OK);
            this._ok.addActionListener(this._listener);
            this._ok.addFocusListener(this._listener);
            this._ok.setName(_OK_NAME);
        }
        bar.add((Component)this._ok, DialogButtonBar.CONSTRAINT_YES);
    }

    private void _addApply(ResourceBundle b, DialogButtonBar bar) {
        if (this._apply == null) {
            String translatedText = b.getString(_KEY_APPLY);
            this._apply = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this._apply.setDefaultCapable(false);
            this._apply.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this._apply.setActionCommand(_KEY_APPLY);
            this._apply.addActionListener(this._listener);
            this._apply.addFocusListener(this._listener);
            this._apply.setName(_APPLY_NAME);
        }
        bar.add((Component)this._apply, DialogButtonBar.CONSTRAINT_APPLY);
    }

    private void _addCancelClose(ResourceBundle b, DialogButtonBar bar) {
        if (this._cancelClose == null) {
            boolean isCancel = (this.getButtonMask() & 2) > 0;
            String translatedText = isCancel ? b.getString(_KEY_CANCEL) : b.getString(_KEY_CLOSE);
            this._cancelClose = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this._cancelClose.setDefaultCapable(false);
            this._cancelClose.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this._cancelClose.setActionCommand(_KEY_CANCEL);
            this._cancelClose.addActionListener(this._listener);
            this._cancelClose.addFocusListener(this._listener);
            this._cancelClose.setName(isCancel ? _CANCEL_NAME : _CLOSE_NAME);
        }
        bar.add((Component)this._cancelClose, DialogButtonBar.CONSTRAINT_CANCEL);
    }

    private void _addHelp(ResourceBundle b, DialogButtonBar bar) {
        if (this._help == null) {
            String translatedText = b.getString(_KEY_HELP);
            this._help = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this._help.setDefaultCapable(false);
            this._help.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this._help.setActionCommand(_KEY_HELP);
            this._help.addActionListener(this._listener);
            this._help.addFocusListener(this._listener);
            this._help.setName(_HELP_NAME);
        }
        bar.add((Component)this._help, DialogButtonBar.CONSTRAINT_HELP);
    }

    private void _removeOk(DialogButtonBar bar) {
        bar.remove(this._ok);
    }

    private void _removeApply(DialogButtonBar bar) {
        bar.remove(this._apply);
    }

    private void _removeCancelClose(DialogButtonBar bar) {
        bar.remove(this._cancelClose);
    }

    private void _removeHelp(DialogButtonBar bar) {
        bar.remove(this._help);
    }

    private void _kdePackFix() {
        this.setResizable(true);
        super.pack();
        this.setResizable(false);
    }

    private void _revalidate() {
        JComponent content = (JComponent)this.getContentPane();
        content.revalidate();
    }

    private void _repack(boolean pack) {
        if (pack) {
            if (this.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dimension d = JEWTDialog.this.getSize();
                        if (JEWTDialog.this._validationPane != null && JEWTDialog.this._validationPane.isVisible()) {
                            d.height += ((JEWTDialog)JEWTDialog.this)._validationPane.getPreferredSize().height + 8;
                            JEWTDialog.this.setSize(d);
                        }
                    }
                });
            }
        } else {
            this._revalidate();
        }
    }

    private Component _getFirstFocusableComponent(Container container) {
        Container root;
        FocusTraversalPolicy ftp = container.getFocusTraversalPolicy();
        if (ftp == null && (root = container.getFocusCycleRootAncestor()) != null) {
            ftp = root.getFocusTraversalPolicy();
        }
        if (ftp != null) {
            Component first = ftp.getFirstComponent(container);
            if (!container.isAncestorOf(first)) {
                first = null;
            }
            return first;
        }
        return null;
    }

    private void _updatePeerMinimumSize(int width, int height) {
        super.setMinimumSize(new Dimension(width, height));
    }

    public void setInitialFocus(int button) {
        switch (button) {
            case 1: {
                this.setInitialFocus(this._ok);
                break;
            }
            case 2: {
                this.setInitialFocus(this._cancelClose);
                break;
            }
            case 16: {
                this.setInitialFocus(this._cancelClose);
                break;
            }
            case 4: {
                this.setInitialFocus(this._help);
                break;
            }
            case 8: {
                this.setInitialFocus(this._apply);
                break;
            }
        }
    }

    static {
        String os = System.getProperty("os.name");
        _IS_LINUX = os != null && os.indexOf("Linux") != -1;
        _sButtonBorder = new EmptyBorder(0, 10, 0, 10);
    }

    private class StatusBarLabel
    extends JLabel {
        private StatusBarLabel() {
        }

        @Override
        public void setText(String text) {
            String oldText = this.getText();
            super.setText(text);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", oldText, text);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleStatusBarLabel();
            }
            return this.accessibleContext;
        }

        private class AccessibleStatusBarLabel
        extends JLabel.AccessibleJLabel {
            private AccessibleStatusBarLabel() {
                super(StatusBarLabel.this);
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
                super.addPropertyChangeListener(listener);
                String str = StatusBarLabel.this.getText();
                if (str != null) {
                    StatusBarLabel.this.setText("");
                    StatusBarLabel.this.setText(str);
                }
            }
        }
    }

    private class UIListener
    implements ActionListener,
    FocusListener,
    PropertyChangeListener {
        private UIListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JButton source;
            JButton old = JEWTDialog.this.getRootPane().getDefaultButton();
            if (old != (source = (JButton)e.getSource())) {
                if (old != null) {
                    old.setDefaultCapable(false);
                }
                source.setDefaultCapable(true);
                JEWTDialog.this.getRootPane().setDefaultButton(source);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                JButton defButton;
                JButton source = (JButton)e.getSource();
                JButton jButton = defButton = JEWTDialog.this._defaultButton != null ? JEWTDialog.this._defaultButton : JEWTDialog.this._defaultCustomButton;
                if (source != defButton) {
                    source.setDefaultCapable(false);
                    JEWTDialog.this.getRootPane().setDefaultButton(defButton);
                    if (defButton != null) {
                        defButton.setDefaultCapable(true);
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (JEWTDialog._KEY_OK.equals(cmd)) {
                JEWTDialog.this.dismissDialog(false);
                JEWTDialog.this._oked = true;
            } else if (JEWTDialog._KEY_APPLY.equals(cmd)) {
                JEWTDialog.this.processEvent(new ActionEvent(JEWTDialog.this, 1001, JEWTDialog.ACTION_APPLY));
            } else if (JEWTDialog._KEY_CANCEL.equals(cmd)) {
                JEWTDialog.this.dismissDialog(true);
            } else if (JEWTDialog._KEY_HELP.equals(cmd)) {
                JEWTDialog.this.fireHelpEvent();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            if (ValidationMessagePane.PANE_EMPTY.equals(pe.getPropertyName()) && !JEWTDialog.this._validationPane.isEmpty()) {
                JEWTDialog.this._validationPane.setVisible(true);
                JEWTDialog.this._validationPane.removePropertyChangeListener(this);
                JEWTDialog.this._repack(true);
            }
        }
    }
}

