/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.font;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.font.FontPreviewArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.graphics.IconStrip;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class FontPane
extends LWComponent
implements Accessible {
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_FONT_STYLE = "fontStyle";
    public static final String PROPERTY_FONT_BASELINE_STYLE = "fontBaselineStyle";
    public static final String PROPERTY_FONT_WIDTH = "fontWidth";
    public static final String PROPERTY_FONT_HORIZONTAL_ALIGNMENT = "fontHorizontalAlignment";
    public static final String PROPERTY_FONT_VERTICAL_ALIGNMENT = "fontVerticalAlignment";
    public static final String PROPERTY_ACTUAL_FONT_SIZE_USED = "actualFontSizeUsed";
    public static final String PROPERTY_FONT_COLOR = "fontColor";
    public static final String PROPERTY_FONT_BACKGROUND_COLOR = "fontBackgroundColor";
    public static final String PROPERTY_BORDER_COLOR = "borderColor";
    public static final String PROPERTY_COLOR_COMPONENT_MASK = "colorComponentMask";
    public static final String PROPERTY_STYLE_BUTTON_MASK = "styleButtonMask";
    public static final String PROPERTY_ALIGNMENT_BUTTON_MASK = "alignmentButtonMask";
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int STYLE_STRIKETHROUGH = 8;
    public static final int BASELINE_STYLE_REGULAR = 1;
    public static final int BASELINE_STYLE_SUPERSCRIPT = 2;
    public static final int BASELINE_STYLE_SUBSCRIPT = 3;
    public static final int WIDTH_NORMAL = 2;
    public static final int WIDTH_CONDENSED = 0;
    public static final int WIDTH_SEMI_CONDENSED = 1;
    public static final int WIDTH_EXTENDED = 4;
    public static final int WIDTH_SEMI_EXTENDED = 3;
    public static final int HORIZONTAL_ALIGNMENT_FULL = 100;
    public static final int HORIZONTAL_ALIGNMENT_LEFT = 2;
    public static final int HORIZONTAL_ALIGNMENT_CENTER = 0;
    public static final int HORIZONTAL_ALIGNMENT_RIGHT = 4;
    public static final int HORIZONTAL_ALIGNMENT_START = 10;
    public static final int HORIZONTAL_ALIGNMENT_END = 11;
    public static final int VERTICAL_ALIGNMENT_TOP = 1;
    public static final int VERTICAL_ALIGNMENT_MIDDLE = 0;
    public static final int VERTICAL_ALIGNMENT_BOTTOM = 3;
    public static final int BUTTON_STYLE_BOLD = 1;
    public static final int BUTTON_STYLE_ITALIC = 2;
    public static final int BUTTON_STYLE_UNDERLINE = 4;
    public static final int BUTTON_STYLE_STRIKETHROUGH = 8;
    public static final int BUTTON_STYLE_SUPERSCRIPT = 16;
    public static final int BUTTON_STYLE_SUBSCRIPT = 32;
    public static final int BUTTON_ALIGNMENT_FULL = 1;
    public static final int BUTTON_ALIGNMENT_LEFT = 2;
    public static final int BUTTON_ALIGNMENT_CENTER = 4;
    public static final int BUTTON_ALIGNMENT_RIGHT = 8;
    public static final int BUTTON_ALIGNMENT_START = 16;
    public static final int BUTTON_ALIGNMENT_END = 32;
    public static final int BUTTON_ALIGNMENT_TOP = 64;
    public static final int BUTTON_ALIGNMENT_MIDDLE = 128;
    public static final int BUTTON_ALIGNMENT_BOTTOM = 256;
    public static final int COLOR_COMPONENT_FOREGROUND = 1;
    public static final int COLOR_COMPONENT_BACKGROUND = 2;
    public static final int COLOR_COMPONENT_BORDER = 4;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final int DEFAULT_MAXIMUM_FONT_SIZE = 512;
    public static final int NONE_SELECTED_STATE = -1;
    private static final int _MIN_EXAMPLE_HEIGHT = 150;
    static final int _sACCESSIBLE_CHILD_COUNT = 22;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _ACCESS_RESOURCE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _LEFT_CONSTRAINT = "left";
    private static final String _KEY_FONT = "FONTPANE.FONT";
    private static final String _KEY_SIZE = "FONTPANE.SIZE";
    private static final String _KEY_STYLE = "FONTPANE.STYLE";
    private static final String _KEY_WIDTH = "FONTPANE.WIDTH";
    private static final String _KEY_COLOR = "FONTPANE.COLOR";
    private static final String _KEY_ALIGNMENT = "FONTPANE.ALIGNMENT";
    private static final String _KEY_SHOW_ACTUAL = "FONTPANE.SHOW_ACTUAL";
    private static final String _KEY_EXAMPLE = "FONTPANE.EXAMPLE";
    private static final String _KEY_JUSTIFY_FULL = "FONTPANE.JUSTIFY_FULL";
    private static final String _KEY_JUSTIFY_LEFT = "FONTPANE.JUSTIFY_LEFT";
    private static final String _KEY_JUSTIFY_CENTER = "FONTPANE.JUSTIFY_CENTER";
    private static final String _KEY_JUSTIFY_RIGHT = "FONTPANE.JUSTIFY_RIGHT";
    private static final String _KEY_JUSTIFY_TOP = "FONTPANE.JUSTIFY_TOP";
    private static final String _KEY_JUSTIFY_MIDDLE = "FONTPANE.JUSTIFY_MIDDLE";
    private static final String _KEY_JUSTIFY_BOTTOM = "FONTPANE.JUSTIFY_BOTTOM";
    private static final String _KEY_JUSTIFY_START = "FONTPANE.JUSTIFY_START";
    private static final String _KEY_JUSTIFY_END = "FONTPANE.JUSTIFY_END";
    private static final String _KEY_BOLD = "FONTPANE.BOLD";
    private static final String _KEY_ITALIC = "FONTPANE.ITALIC";
    private static final String _KEY_UNDERLINE = "FONTPANE.UNDERLINE";
    private static final String _KEY_STRIKETHRU = "FONTPANE.STRIKETHRU";
    private static final String _KEY_SUPERSCRIPT = "FONTPANE.SUPERSCRIPT";
    private static final String _KEY_SUBSCRIPT = "FONTPANE.SUBSCRIPT";
    private static final String _KEY_CONDENSED = "FONTPANE.CONDENSED";
    private static final String _KEY_SEMI_CONDENSED = "FONTPANE.SEMI_CONDENSED";
    private static final String _KEY_NORMAL = "FONTPANE.NORMAL";
    private static final String _KEY_SEMI_EXPANDED = "FONTPANE.SEMI_EXPANDED";
    private static final String _KEY_EXPANDED = "FONTPANE.EXPANDED";
    private static final String _KEY_TEXT_COLOR = "FONTPANE.TEXT_COLOR";
    private static final String _KEY_BACKGROUND_COLOR = "FONTPANE.BACKGROUND_COLOR";
    private static final String _KEY_BORDER_COLOR = "FONTPANE.BORDER_COLOR";
    private static final String _KEY_EXAMPLE_TEXT = "FONTPANE.EXAMPLE_TEXT";
    private static final int _ICON_BOLD = 0;
    private static final int _ICON_ITALIC = 1;
    private static final int _ICON_UNDERLINE = 2;
    private static final int _ICON_STRIKETHROUGH = 3;
    private static final int _ICON_SUPERSCRIPT = 4;
    private static final int _ICON_SUBSCRIPT = 5;
    private static final int _ICON_COLOR = 6;
    private static final int _ICON_FULL_JUSTIFY = 7;
    private static final int _ICON_LEFT_JUSTIFY = 8;
    private static final int _ICON_CENTER_JUSTIFY = 9;
    private static final int _ICON_RIGHT_JUSTIFY = 10;
    private static final int _ICON_TOP_JUSTIFY = 11;
    private static final int _ICON_MIDDLE_JUSTIFY = 12;
    private static final int _ICON_BOTTOM_JUSTIFY = 13;
    private static final int _ICON_START_JUSTIFY = 14;
    private static final int _ICON_END_JUSTIFY = 15;
    private static final int _ICON_COUNT = 16;
    private static final int _JDK_1_1_DEFAULT_STYLE_BUTTONS = 3;
    private static final int _JDK_1_2_DEFAULT_STYLE_BUTTONS = 63;
    private static final int _DEFAULT_ALIGNMENT_BUTTONS = 462;
    private static final int _DEFAULT_COLOR_BUTTONS = 3;
    private static final Object[] _SIZES = new Object[]{IntegerUtils.getInteger((int)8), IntegerUtils.getInteger((int)9), IntegerUtils.getInteger((int)10), IntegerUtils.getInteger((int)11), IntegerUtils.getInteger((int)12), IntegerUtils.getInteger((int)14), IntegerUtils.getInteger((int)16), IntegerUtils.getInteger((int)18), IntegerUtils.getInteger((int)20), IntegerUtils.getInteger((int)22), IntegerUtils.getInteger((int)24), IntegerUtils.getInteger((int)26), IntegerUtils.getInteger((int)28), IntegerUtils.getInteger((int)36), IntegerUtils.getInteger((int)48), IntegerUtils.getInteger((int)72)};
    private static IconStrip _sIconStrip;
    private static IconStrip _sDisabledIconStrip;
    private static final Insets _sBORDER_COLOR_INSETS;
    private static final Insets _sDEFAULT_INSETS;
    private static final Insets _sLABEL_INSETS;
    private static final Insets _sSEPARATOR_INSETS;
    private String _laggingFontName;
    private int _laggingFontSize;
    private int _laggingFontStyle;
    private int _laggingFontBaselineStyle;
    private int _laggingFontWidth;
    private int _laggingFontHorizontalAlignment;
    private int _laggingFontVerticalAlignment;
    private Color _laggingFontColor;
    private Color _laggingFontBackgroundColor;
    private Color _laggingBorderColor;
    private int _maximumFontSize;
    private JComboBox _fontNames;
    private JComboBox _sizes;
    private JComboBox _widths;
    private JToggleButton _bold;
    private JToggleButton _italic;
    private JToggleButton _underline;
    private JToggleButton _strikeThrough;
    private JToggleButton _superscript;
    private JToggleButton _subscript;
    private JToggleButton _fullJustify;
    private JToggleButton _leftJustify;
    private JToggleButton _centerJustify;
    private JToggleButton _rightJustify;
    private JToggleButton _startJustify;
    private JToggleButton _endJustify;
    private JToggleButton _topJustify;
    private JToggleButton _middleJustify;
    private JToggleButton _bottomJustify;
    private JToggleButton _noneHorizontal;
    private JToggleButton _noneVertical;
    private JLabel _styleLabel;
    private JLabel _widthLabel;
    private JLabel _fontLabel;
    private JLabel _sizeLabel;
    private JLabel _exampleLabel;
    private TitledPane _alignmentComponent;
    private TitledPane _colorComponent;
    private ColorChoice _textColor;
    private ColorChoice _backgroundColor;
    private ColorChoice _borderColor;
    private JLabel _textColorLabel;
    private JLabel _backgroundColorLabel;
    private JLabel _borderColorLabel;
    private JCheckBox _showFontSize;
    private JPanel _exampleArea;
    private FontPreviewArea _exampleComponent;
    private JPanel _clientContainer;
    private int _originalFontWidth = -2;
    private boolean _fontColorSet;
    private boolean _fontBackgroundColorSet;
    private boolean _fontBorderColorSet;
    private static final String _BOLD_NAME = "Style Bold";
    private static final String _ITALIC_NAME = "Style Italic";
    private static final String _UNDERLINE_NAME = "Style Underline";
    private static final String _STRIKETHRU_NAME = "Style Strikethrough";
    private static final String _SUPERSCRIPT_NAME = "Style Superscript";
    private static final String _SUBSCRIPT_NAME = "Style Subscript";
    private static final String _TEXT_COLOR_NAME = "Text Color";
    private static final String _BACKGROUND_COLOR_NAME = "Background Color";
    private static final String _BORDER_COLOR_NAME = "Border Color";
    private static final String _JUSTIFY_FULL_NAME = "Full Alignment";
    private static final String _JUSTIFY_LEFT_NAME = "Left Horizontal Alignment";
    private static final String _JUSTIFY_CENTER_NAME = "Center Horizontal Alignment";
    private static final String _JUSTIFY_RIGHT_NAME = "Right Horizontal Alignment";
    private static final String _JUSTIFY_TOP_NAME = "Top Vertical Alignment";
    private static final String _JUSTIFY_MIDDLE_NAME = "Middle Vertical Alignment";
    private static final String _JUSTIFY_BOTTOM_NAME = "Bottom Vertical Alignment";
    private static final String _JUSTIFY_START_NAME = "Start Horizontal Alignment";
    private static final String _JUSTIFY_END_NAME = "End Horizontal Alignment";
    private static final String _FONT_NAME = "Font_Name_ComboBox";
    private static final String _SIZE_NAME = "Font_Size_ComboBox";
    private static final String _WIDTH_NAME = "Font_Width_ComboBox";
    private static final String _ACTUAL_SIZE_NAME = "Actual_Font_Size_CheckBox";

    public static int showDialog(Component parent, FontPane pane) {
        return FontPane.showDialog(parent, pane, null, false);
    }

    public static int showDialog(Component parent, FontPane pane, String dialogTitle, boolean resizable) {
        if (pane == null) {
            throw new IllegalArgumentException("FontPane must be non-null");
        }
        JEWTDialog d = JEWTDialog.createDialog(parent, dialogTitle, 7);
        Locale l = LocaleUtils.getDefaultableLocale((Component)pane);
        d.setLocale(l);
        d.setContent(pane);
        d.setCenterOver(parent);
        d.setResizable(resizable);
        int ret = d.runDialog() ? 1 : 2;
        d.dispose();
        return ret;
    }

    public FontPane() {
        UIListener listener = new UIListener();
        this._exampleComponent = this.createFontPreviewArea();
        this._fontNames = new JComboBox();
        this._fontNames.setEditable(false);
        this._fontNames.addItemListener(listener);
        this._setFontName();
        this._fontLabel = new JLabel();
        this._fontLabel.setLabelFor(this._fontNames);
        this._sizes = new JComboBox(_SIZES){

            @Override
            public void updateUI() {
                this.setEditable(false);
                super.updateUI();
                this.setEditable(true);
            }
        };
        NumberEditor ne = new NumberEditor();
        this._maximumFontSize = 512;
        ne.setMaximum(this._maximumFontSize);
        this._sizes.setEditor(ne);
        this._sizes.setEditable(true);
        this._sizes.addItemListener(listener);
        this._sizeLabel = new JLabel();
        this._sizeLabel.setLabelFor(ne);
        this._sizes.putClientProperty("labeledBy", this._sizeLabel);
        this._styleLabel = new JLabel();
        this._bold = new JToggleButton();
        this._bold.setIcon(FontPane._createIcon(0));
        this._bold.setDisabledIcon(FontPane._createDisabledIcon(0));
        this._bold.addItemListener(listener);
        this._italic = new JToggleButton();
        this._italic.setIcon(FontPane._createIcon(1));
        this._italic.setDisabledIcon(FontPane._createDisabledIcon(1));
        this._italic.addItemListener(listener);
        this._underline = new JToggleButton();
        this._underline.setIcon(FontPane._createIcon(2));
        this._underline.setDisabledIcon(FontPane._createDisabledIcon(2));
        this._underline.addItemListener(listener);
        this._strikeThrough = new JToggleButton();
        this._strikeThrough.setIcon(FontPane._createIcon(3));
        this._strikeThrough.setDisabledIcon(FontPane._createDisabledIcon(3));
        this._strikeThrough.addItemListener(listener);
        this._superscript = new JToggleButton();
        this._superscript.setIcon(FontPane._createIcon(4));
        this._superscript.setDisabledIcon(FontPane._createDisabledIcon(4));
        this._superscript.addItemListener(listener);
        this._subscript = new JToggleButton();
        this._subscript.setIcon(FontPane._createIcon(5));
        this._subscript.setDisabledIcon(FontPane._createDisabledIcon(5));
        this._subscript.addItemListener(listener);
        this._widths = new JComboBox();
        this._widths.addItemListener(listener);
        this._widthLabel = new JLabel();
        this._widthLabel.setLabelFor(this._widths);
        this._colorComponent = new TitledPane();
        this._colorComponent.setTitle(new JLabel());
        this._textColor = new ColorChoice();
        this._textColor.addPropertyChangeListener(listener);
        this._textColorLabel = new JLabel();
        this._textColorLabel.setLabelFor(this._textColor);
        this._backgroundColor = new ColorChoice();
        this._backgroundColor.addPropertyChangeListener(listener);
        this._backgroundColorLabel = new JLabel();
        this._backgroundColorLabel.setLabelFor(this._backgroundColor);
        this._borderColor = new ColorChoice();
        this._borderColor.addPropertyChangeListener(listener);
        this._borderColorLabel = new JLabel();
        this._borderColorLabel.setLabelFor(this._borderColor);
        this._alignmentComponent = new TitledPane();
        this._alignmentComponent.setTitle(new JLabel());
        this._fullJustify = new JToggleButton();
        this._fullJustify.setIcon(FontPane._createIcon(7));
        this._fullJustify.setDisabledIcon(FontPane._createDisabledIcon(7));
        this._fullJustify.addItemListener(listener);
        this._leftJustify = new JToggleButton();
        this._leftJustify.setIcon(FontPane._createIcon(8));
        this._leftJustify.setDisabledIcon(FontPane._createDisabledIcon(8));
        this._leftJustify.addItemListener(listener);
        this._centerJustify = new JToggleButton();
        this._centerJustify.setIcon(FontPane._createIcon(9));
        this._centerJustify.setDisabledIcon(FontPane._createDisabledIcon(9));
        this._centerJustify.addItemListener(listener);
        this._rightJustify = new JToggleButton();
        this._rightJustify.setIcon(FontPane._createIcon(10));
        this._rightJustify.setDisabledIcon(FontPane._createDisabledIcon(10));
        this._rightJustify.addItemListener(listener);
        this._startJustify = new JToggleButton();
        this._startJustify.setIcon(FontPane._createIcon(14));
        this._startJustify.setDisabledIcon(FontPane._createDisabledIcon(14));
        this._startJustify.addItemListener(listener);
        this._endJustify = new JToggleButton();
        this._endJustify.setIcon(FontPane._createIcon(15));
        this._endJustify.setDisabledIcon(FontPane._createDisabledIcon(15));
        this._endJustify.addItemListener(listener);
        this._noneHorizontal = new JToggleButton();
        ButtonGroup horizontalGroup = new ButtonGroup();
        horizontalGroup.add(this._fullJustify);
        horizontalGroup.add(this._leftJustify);
        horizontalGroup.add(this._centerJustify);
        horizontalGroup.add(this._rightJustify);
        horizontalGroup.add(this._startJustify);
        horizontalGroup.add(this._endJustify);
        horizontalGroup.add(this._noneHorizontal);
        this._leftJustify.setSelected(true);
        this._laggingFontHorizontalAlignment = 2;
        this._topJustify = new JToggleButton();
        this._topJustify.setIcon(FontPane._createIcon(11));
        this._topJustify.setDisabledIcon(FontPane._createDisabledIcon(11));
        this._topJustify.addItemListener(listener);
        this._middleJustify = new JToggleButton();
        this._middleJustify.setIcon(FontPane._createIcon(12));
        this._middleJustify.setDisabledIcon(FontPane._createDisabledIcon(12));
        this._middleJustify.addItemListener(listener);
        this._bottomJustify = new JToggleButton();
        this._bottomJustify.setIcon(FontPane._createIcon(13));
        this._bottomJustify.setDisabledIcon(FontPane._createDisabledIcon(13));
        this._bottomJustify.addItemListener(listener);
        this._noneVertical = new JToggleButton();
        ButtonGroup verticalGroup = new ButtonGroup();
        verticalGroup.add(this._topJustify);
        verticalGroup.add(this._middleJustify);
        verticalGroup.add(this._bottomJustify);
        verticalGroup.add(this._noneVertical);
        this._middleJustify.setSelected(true);
        this._laggingFontVerticalAlignment = 0;
        this._exampleLabel = new JLabel();
        this._showFontSize = new JCheckBox();
        this._showFontSize.setSelected(true);
        this._showFontSize.addItemListener(listener);
        this._setButtonNames();
        JPanel fontArea = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        fontArea.setLayout(layout);
        gbc.gridwidth = -1;
        gbc.insets = _sLABEL_INSETS;
        gbc.anchor = 17;
        layout.setConstraints(this._fontLabel, gbc);
        fontArea.add(this._fontLabel);
        JPanel c1 = new JPanel();
        c1.setLayout(new BorderLayout(10, 0));
        c1.add("West", this._fontNames);
        JPanel c2 = new JPanel();
        c2.setLayout(new BorderLayout(3, 0));
        c2.add("West", this._sizeLabel);
        c2.add("East", this._sizes);
        c1.add("East", c2);
        gbc.gridwidth = 0;
        gbc.insets = _sDEFAULT_INSETS;
        layout.setConstraints(c1, gbc);
        fontArea.add(c1);
        gbc.gridwidth = -1;
        gbc.insets = _sLABEL_INSETS;
        layout.setConstraints(this._styleLabel, gbc);
        fontArea.add(this._styleLabel);
        JPanel styleBar = new JPanel();
        GridBagLayout styleLayout = new GridBagLayout();
        GridBagConstraints styleConstraints = new GridBagConstraints();
        styleConstraints.insets = _sDEFAULT_INSETS;
        styleConstraints.anchor = 17;
        styleBar.setLayout(styleLayout);
        styleLayout.setConstraints(this._bold, styleConstraints);
        styleBar.add(this._bold);
        styleLayout.setConstraints(this._italic, styleConstraints);
        styleBar.add(this._italic);
        styleLayout.setConstraints(this._underline, styleConstraints);
        styleBar.add(this._underline);
        styleLayout.setConstraints(this._strikeThrough, styleConstraints);
        styleBar.add(this._strikeThrough);
        styleConstraints.insets = _sSEPARATOR_INSETS;
        styleLayout.setConstraints(this._superscript, styleConstraints);
        styleBar.add(this._superscript);
        styleConstraints.insets = _sDEFAULT_INSETS;
        styleConstraints.gridwidth = 0;
        styleLayout.setConstraints(this._subscript, styleConstraints);
        styleBar.add(this._subscript);
        gbc.gridwidth = 0;
        gbc.insets = _sDEFAULT_INSETS;
        layout.setConstraints(styleBar, gbc);
        fontArea.add(styleBar);
        gbc.gridwidth = -1;
        gbc.insets = _sLABEL_INSETS;
        layout.setConstraints(this._widthLabel, gbc);
        fontArea.add(this._widthLabel);
        gbc.gridwidth = 0;
        gbc.insets = _sDEFAULT_INSETS;
        layout.setConstraints(this._widths, gbc);
        fontArea.add(this._widths);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        layout.setConstraints(this._colorComponent, gbc);
        fontArea.add(this._colorComponent);
        GridBagLayout colorLayout = new GridBagLayout();
        JPanel colorContent = new JPanel(colorLayout);
        GridBagConstraints colorConstraints = new GridBagConstraints();
        colorConstraints.insets = _sLABEL_INSETS;
        colorConstraints.anchor = 17;
        colorLayout.setConstraints(this._textColorLabel, colorConstraints);
        colorContent.add(this._textColorLabel);
        colorConstraints.insets = _sDEFAULT_INSETS;
        colorLayout.setConstraints(this._textColor, colorConstraints);
        colorContent.add(this._textColor);
        JPanel borderPanel = new JPanel(new BorderLayout(3, 3));
        borderPanel.add("West", this._borderColorLabel);
        borderPanel.add("East", this._borderColor);
        colorConstraints.insets = _sBORDER_COLOR_INSETS;
        colorConstraints.gridwidth = 0;
        colorLayout.setConstraints(borderPanel, colorConstraints);
        colorContent.add(borderPanel);
        colorConstraints.insets = _sLABEL_INSETS;
        colorConstraints.gridwidth = 1;
        colorLayout.setConstraints(this._backgroundColorLabel, colorConstraints);
        colorContent.add(this._backgroundColorLabel);
        colorConstraints.gridwidth = 0;
        colorConstraints.insets = _sDEFAULT_INSETS;
        colorLayout.setConstraints(this._backgroundColor, colorConstraints);
        colorContent.add(this._backgroundColor);
        JPanel dummyColorPanel = new JPanel(new BorderLayout());
        dummyColorPanel.add("West", colorContent);
        this._colorComponent.setContent(dummyColorPanel);
        this._clientContainer = new JPanel();
        this._clientContainer.setLayout(new BorderLayout());
        GridBagLayout alignmentLayout = new GridBagLayout();
        JPanel alignmentBar = new JPanel();
        alignmentBar.setLayout(alignmentLayout);
        alignmentBar.setBorder(new EmptyBorder(3, 0, 0, 0));
        GridBagConstraints alignmentConstraints = new GridBagConstraints();
        alignmentConstraints.insets = _sDEFAULT_INSETS;
        alignmentConstraints.anchor = 17;
        alignmentLayout.setConstraints(this._fullJustify, alignmentConstraints);
        alignmentBar.add(this._fullJustify);
        alignmentLayout.setConstraints(this._leftJustify, alignmentConstraints);
        alignmentBar.add(this._leftJustify);
        alignmentLayout.setConstraints(this._centerJustify, alignmentConstraints);
        alignmentBar.add(this._centerJustify);
        alignmentLayout.setConstraints(this._rightJustify, alignmentConstraints);
        alignmentBar.add(this._rightJustify);
        alignmentConstraints.insets = _sSEPARATOR_INSETS;
        alignmentLayout.setConstraints(this._topJustify, alignmentConstraints);
        alignmentBar.add(this._topJustify);
        alignmentConstraints.insets = _sDEFAULT_INSETS;
        alignmentLayout.setConstraints(this._middleJustify, alignmentConstraints);
        alignmentBar.add(this._middleJustify);
        alignmentLayout.setConstraints(this._bottomJustify, alignmentConstraints);
        alignmentBar.add(this._bottomJustify);
        alignmentConstraints.insets = _sSEPARATOR_INSETS;
        alignmentLayout.setConstraints(this._startJustify, alignmentConstraints);
        alignmentBar.add(this._startJustify);
        alignmentConstraints.insets = _sDEFAULT_INSETS;
        alignmentConstraints.gridwidth = 0;
        alignmentLayout.setConstraints(this._endJustify, alignmentConstraints);
        alignmentBar.add(this._endJustify);
        JPanel dummy = new JPanel(new BorderLayout());
        dummy.add("West", alignmentBar);
        this._alignmentComponent.setContent(dummy);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        layout.setConstraints(this._alignmentComponent, gbc);
        fontArea.add(this._alignmentComponent);
        JPanel left = new JPanel();
        left.setLayout(new BorderLayout(0, 3));
        JPanel topLeft = new JPanel();
        topLeft.setLayout(new BorderLayout(0, 3));
        topLeft.add("West", fontArea);
        left.add("North", topLeft);
        left.add("Center", this._clientContainer);
        this._exampleArea = new JPanel();
        this._exampleArea.setLayout(new BorderLayout(0, 3));
        this._exampleArea.add("North", this._exampleLabel);
        this._exampleArea.add("Center", this._exampleComponent);
        this._exampleArea.add("South", this._showFontSize);
        this.setLayout(new FontPaneLayout());
        this.add(_LEFT_CONSTRAINT, left);
        this.add(this._exampleArea);
        String version = System.getProperty("java.version");
        boolean jdk_1_1 = version == null ? false : version.startsWith("1.1");
        int styleButtons = jdk_1_1 ? 3 : 63;
        int alignmentButtons = 462;
        int colorButtons = 3;
        this.setStyleButtonMask(styleButtons);
        this.setAlignmentButtonMask(alignmentButtons);
        this.setColorComponentMask(colorButtons);
        this.setWidthVisible(false);
        this.setFontSize(12);
    }

    public String[] getFontNames() {
        int count = this._fontNames.getItemCount();
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = this._fontNames.getItemAt(i).toString();
        }
        return names;
    }

    public void setFontNames(String[] fontNames) {
        if (fontNames == null || fontNames.length == 0) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fontNames = ge.getAvailableFontFamilyNames();
        }
        this._fontNames.setModel(new DefaultComboBoxModel<String>(fontNames));
        if (this._fontNames.getModel().getSize() > 0) {
            this._fontNames.setSelectedIndex(0);
        }
    }

    public String getFontName() {
        return (String)this._fontNames.getSelectedItem();
    }

    public void setFontName(String fontName) {
        if (fontName != null) {
            int count = this._fontNames.getItemCount();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                if (!this._fontNames.getItemAt(i).equals(fontName)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("font name not found: " + fontName);
            }
        }
        this._fontNames.setSelectedItem(fontName);
    }

    public int getFontSize() {
        int size = -1;
        Object selected = this._sizes.getSelectedItem();
        if (selected instanceof Number) {
            size = ((Number)selected).intValue();
        }
        return size;
    }

    public void setFontSize(int size) {
        if (size > this._maximumFontSize) {
            throw new IllegalArgumentException("Specified font size(" + size + ") is greater than the maximum font size(" + this._maximumFontSize + ")");
        }
        if (size == -1) {
            this._sizes.setSelectedItem(null);
        } else {
            this._sizes.setSelectedItem(IntegerUtils.getInteger((int)size));
        }
        this.updateExampleFont();
    }

    public void setMaximumFontSize(int maximumSize) {
        if (maximumSize != this._maximumFontSize) {
            if (this.getFontSize() > maximumSize) {
                this.setFontSize(maximumSize);
            }
            this._maximumFontSize = maximumSize;
            ((NumberEditor)this._sizes.getEditor()).setMaximum(this._maximumFontSize);
        }
    }

    public int getMaximumFontSize() {
        return this._maximumFontSize;
    }

    public void setFontStyle(int style) {
        boolean bold = (style & 1) != 0;
        this._bold.setSelected(bold);
        boolean italic = (style & 2) != 0;
        this._italic.setSelected(italic);
        boolean underline = (style & 4) != 0;
        this._underline.setSelected(underline);
        boolean strikethru = (style & 8) != 0;
        this._strikeThrough.setSelected(strikethru);
        this._exampleComponent.setFontStyle(style);
        this._laggingFontStyle = style;
    }

    public int getFontStyle() {
        int style = 0;
        if (this._bold.isSelected()) {
            style |= 1;
        }
        if (this._italic.isSelected()) {
            style |= 2;
        }
        if (this._underline.isSelected()) {
            style |= 4;
        }
        if (this._strikeThrough.isSelected()) {
            style |= 8;
        }
        return style;
    }

    public void setFontBaselineStyle(int style) {
        switch (style) {
            case 2: {
                this._superscript.setSelected(true);
                this._subscript.setSelected(false);
                this._exampleComponent.setBaselineVisible(true);
                break;
            }
            case 3: {
                this._subscript.setSelected(true);
                this._superscript.setSelected(false);
                this._exampleComponent.setBaselineVisible(true);
                break;
            }
            case 1: {
                this._superscript.setSelected(false);
                this._subscript.setSelected(false);
                this._exampleComponent.setBaselineVisible(this._superscript.isVisible() | this._subscript.isVisible());
                break;
            }
        }
        this._laggingFontBaselineStyle = style;
    }

    public int getFontBaselineStyle() {
        if (this._superscript.isSelected()) {
            return 2;
        }
        if (this._subscript.isSelected()) {
            return 3;
        }
        return 1;
    }

    public void setFontWidth(int width) {
        if ((width < 0 || width > 4) && width != -1) {
            width = 2;
        }
        if (this._widths.getItemCount() > 0) {
            this._widths.setSelectedIndex(width);
        } else {
            this._originalFontWidth = width;
        }
        this._laggingFontWidth = width;
    }

    public int getFontWidth() {
        if (this._widths.getItemCount() > 0) {
            return this._widths.getSelectedIndex();
        }
        if (this._originalFontWidth != -2) {
            return this._originalFontWidth;
        }
        return 2;
    }

    public void setFontColor(Color color) {
        Color old = this.getFontColor();
        color = FontPane._trySetColorChoice(this._textColor, color);
        this._exampleComponent.setFontColor(color);
        this.firePropertyChange(PROPERTY_FONT_COLOR, old, color);
        this._laggingFontColor = color;
        this._fontColorSet = true;
    }

    public Color getFontColor() {
        return this._textColor.getSelectedColor();
    }

    public void setFontBackgroundColor(Color color) {
        Color old = this.getFontBackgroundColor();
        color = FontPane._trySetColorChoice(this._backgroundColor, color);
        this._exampleComponent.setFontBackgroundColor(color);
        this.firePropertyChange(PROPERTY_FONT_BACKGROUND_COLOR, old, color);
        this._laggingFontBackgroundColor = color;
        this._fontBackgroundColorSet = true;
    }

    public Color getFontBackgroundColor() {
        return this._backgroundColor.getSelectedColor();
    }

    public void setBorderColor(Color color) {
        Color old = this.getBorderColor();
        color = FontPane._trySetColorChoice(this._borderColor, color);
        this._exampleComponent.setFontBorderColor(color);
        this.firePropertyChange(PROPERTY_BORDER_COLOR, old, color);
        this._laggingBorderColor = color;
        this._fontBorderColorSet = true;
    }

    public Color getBorderColor() {
        return this._borderColor.getSelectedColor();
    }

    public void setFontHorizontalAlignment(int horizontalAlignment) {
        switch (horizontalAlignment) {
            case 100: {
                this._fullJustify.setSelected(true);
                break;
            }
            case 2: {
                this._leftJustify.setSelected(true);
                break;
            }
            case 0: {
                this._centerJustify.setSelected(true);
                break;
            }
            case 4: {
                this._rightJustify.setSelected(true);
                break;
            }
            case 10: {
                this._startJustify.setSelected(true);
                break;
            }
            case 11: {
                this._endJustify.setSelected(true);
                break;
            }
            case -1: {
                this._noneHorizontal.setSelected(true);
                break;
            }
        }
        this._laggingFontHorizontalAlignment = horizontalAlignment;
        this._exampleComponent.setFontHorizontalAlignment(horizontalAlignment);
    }

    public int getFontHorizontalAlignment() {
        if (this._fullJustify.isSelected()) {
            return 100;
        }
        if (this._leftJustify.isSelected()) {
            return 2;
        }
        if (this._centerJustify.isSelected()) {
            return 0;
        }
        if (this._rightJustify.isSelected()) {
            return 4;
        }
        if (this._startJustify.isSelected()) {
            return 10;
        }
        if (this._endJustify.isSelected()) {
            return 11;
        }
        if (this._noneHorizontal.isSelected()) {
            return -1;
        }
        return 0;
    }

    public void setFontVerticalAlignment(int verticalAlignment) {
        switch (verticalAlignment) {
            case 1: {
                this._topJustify.setSelected(true);
                break;
            }
            case 0: {
                this._middleJustify.setSelected(true);
                break;
            }
            case 3: {
                this._bottomJustify.setSelected(true);
                break;
            }
            case -1: {
                this._noneVertical.setSelected(true);
                break;
            }
        }
        this._laggingFontVerticalAlignment = verticalAlignment;
        this._exampleComponent.setFontVerticalAlignment(verticalAlignment);
    }

    public int getFontVerticalAlignment() {
        if (this._topJustify.isSelected()) {
            return 1;
        }
        if (this._middleJustify.isSelected()) {
            return 0;
        }
        if (this._bottomJustify.isSelected()) {
            return 3;
        }
        if (this._noneVertical.isSelected()) {
            return -1;
        }
        return 0;
    }

    public void setStyleButtonMask(int buttonMask) {
        int oldMask = this.getStyleButtonMask();
        this._bold.setVisible((buttonMask & 1) != 0);
        this._italic.setVisible((buttonMask & 2) != 0);
        this._underline.setVisible((buttonMask & 4) != 0);
        this._strikeThrough.setVisible((buttonMask & 8) != 0);
        boolean superscript = (buttonMask & 0x10) != 0;
        boolean subscript = (buttonMask & 0x20) != 0;
        this._superscript.setVisible(superscript);
        this._subscript.setVisible(subscript);
        this._exampleComponent.setBaselineVisible(superscript | subscript | this._superscript.isSelected() | this._subscript.isSelected());
        this._styleLabel.setVisible(buttonMask != 0);
        this.firePropertyChange(PROPERTY_STYLE_BUTTON_MASK, oldMask, buttonMask);
        this.revalidate();
    }

    public int getStyleButtonMask() {
        int buttons = 0;
        if (this._bold.isVisible()) {
            buttons |= 1;
        }
        if (this._italic.isVisible()) {
            buttons |= 2;
        }
        if (this._underline.isVisible()) {
            buttons |= 4;
        }
        if (this._strikeThrough.isVisible()) {
            buttons |= 8;
        }
        if (this._superscript.isVisible()) {
            buttons |= 0x10;
        }
        if (this._subscript.isVisible()) {
            buttons |= 0x20;
        }
        return buttons;
    }

    public void setWidthVisible(boolean visible) {
        this._widths.setVisible(visible);
        this._widthLabel.setVisible(visible);
        this.revalidate();
    }

    public boolean isWidthVisible() {
        return this._widths.isVisible();
    }

    public void setColorComponentMask(int buttonMask) {
        int oldMask = this.getColorComponentMask();
        boolean foreground = (buttonMask & 1) != 0;
        boolean background = (buttonMask & 2) != 0;
        boolean border = (buttonMask & 4) != 0;
        this._textColor.setVisible(foreground);
        this._textColorLabel.setVisible(foreground);
        this._backgroundColor.setVisible(background);
        this._backgroundColorLabel.setVisible(background);
        this._borderColor.setVisible(border);
        this._borderColorLabel.setVisible(border);
        this._exampleComponent.setFontBorderVisible(border);
        this._colorComponent.setVisible(foreground || background || border);
        this.firePropertyChange(PROPERTY_COLOR_COMPONENT_MASK, oldMask, buttonMask);
        this.revalidate();
    }

    public int getColorComponentMask() {
        int buttons = 0;
        if (this._textColor.isVisible()) {
            buttons |= 1;
        }
        if (this._backgroundColor.isVisible()) {
            buttons |= 2;
        }
        if (this._borderColor.isVisible()) {
            buttons |= 4;
        }
        return buttons;
    }

    public void setAlignmentButtonMask(int buttonMask) {
        int oldMask = this.getAlignmentButtonMask();
        this._fullJustify.setVisible((buttonMask & 1) != 0);
        this._leftJustify.setVisible((buttonMask & 2) != 0);
        this._centerJustify.setVisible((buttonMask & 4) != 0);
        this._rightJustify.setVisible((buttonMask & 8) != 0);
        this._startJustify.setVisible((buttonMask & 0x10) != 0);
        this._endJustify.setVisible((buttonMask & 0x20) != 0);
        this._topJustify.setVisible((buttonMask & 0x40) != 0);
        this._middleJustify.setVisible((buttonMask & 0x80) != 0);
        this._bottomJustify.setVisible((buttonMask & 0x100) != 0);
        this._alignmentComponent.setVisible(buttonMask != 0);
        this.firePropertyChange(PROPERTY_ALIGNMENT_BUTTON_MASK, oldMask, buttonMask);
        this.revalidate();
    }

    public int getAlignmentButtonMask() {
        int buttons = 0;
        if (this._fullJustify.isVisible()) {
            buttons |= 1;
        }
        if (this._leftJustify.isVisible()) {
            buttons |= 2;
        }
        if (this._centerJustify.isVisible()) {
            buttons |= 4;
        }
        if (this._rightJustify.isVisible()) {
            buttons |= 8;
        }
        if (this._startJustify.isVisible()) {
            buttons |= 0x10;
        }
        if (this._endJustify.isVisible()) {
            buttons |= 0x20;
        }
        if (this._topJustify.isVisible()) {
            buttons |= 0x40;
        }
        if (this._middleJustify.isVisible()) {
            buttons |= 0x80;
        }
        if (this._bottomJustify.isVisible()) {
            buttons |= 0x100;
        }
        return buttons;
    }

    public void setExtraComponent(Component extraComponent) {
        Component old = this.getExtraComponent();
        if (old != null) {
            this._clientContainer.remove(old);
        }
        if (extraComponent != null) {
            this._clientContainer.add("West", extraComponent);
            extraComponent.setEnabled(this.isEnabled());
        }
        this.revalidate();
    }

    public Component getExtraComponent() {
        int count = this._clientContainer.getComponentCount();
        return count < 1 ? null : this._clientContainer.getComponent(0);
    }

    public void setPreviewAreaVisible(boolean visible) {
        this._exampleArea.setVisible(visible);
        this.revalidate();
        this.repaint();
    }

    public boolean isPreviewAreaVisible() {
        return this._exampleArea.isVisible();
    }

    public Font getCurrentFont() {
        String name = this.getFontName();
        int size = this.getFontSize();
        if (name == null || size == -1) {
            return null;
        }
        boolean bold = this._bold.isSelected();
        boolean italic = this._italic.isSelected();
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italic) {
            style |= 2;
        }
        return new Font(name, style, size);
    }

    public void setCurrentFont(Font font) {
        if (font == null) {
            this.setFontName(null);
            this.setFontStyle(0);
            this.setFontSize(-1);
        } else {
            int style;
            String name = font.getName();
            this._fontNames.setSelectedItem(name);
            this._laggingFontName = name;
            int size = font.getSize();
            if (size > this._maximumFontSize) {
                throw new IllegalArgumentException("Specified font size(" + size + ") is greater than the maximum font size(" + this._maximumFontSize + ")");
            }
            this._sizes.setSelectedItem(IntegerUtils.getInteger((int)size));
            this._laggingFontSize = size;
            this._laggingFontStyle = style = font.getStyle();
            boolean bold = (style & 1) != 0;
            this._bold.setSelected(bold);
            boolean italic = (style & 2) != 0;
            this._italic.setSelected(italic);
            this._setExampleFont(font);
        }
    }

    public Font getFontWithAttributes() {
        Color bgColor;
        String name = this.getFontName();
        int size = this.getFontSize();
        if (name == null || size == -1) {
            return null;
        }
        HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>(11);
        attributes.put(TextAttribute.FAMILY, name);
        if (this._bold.isSelected()) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this._italic.isSelected()) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this._underline.isSelected()) {
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this._strikeThrough.isSelected()) {
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        attributes.put(TextAttribute.SIZE, new Float(size));
        if (this._superscript.isSelected()) {
            attributes.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        } else if (this._subscript.isSelected()) {
            attributes.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        int width = this.getFontWidth();
        switch (width) {
            case 0: {
                attributes.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                break;
            }
            case 4: {
                attributes.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 1: {
                attributes.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
                break;
            }
            case 3: {
                attributes.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
            }
        }
        Color fgColor = this.getFontColor();
        if (fgColor != null) {
            attributes.put(TextAttribute.FOREGROUND, fgColor);
        }
        if ((bgColor = this.getFontBackgroundColor()) != null) {
            attributes.put(TextAttribute.BACKGROUND, bgColor);
        }
        if (this._fullJustify.isSelected()) {
            attributes.put(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_FULL);
        }
        return new Font(attributes);
    }

    public void setFontWithAttributes(Font font) {
        boolean nullFont = false;
        Map<TextAttribute, ?> attributes = null;
        if (font == null) {
            nullFont = true;
        } else {
            attributes = font.getAttributes();
            if (attributes == null) {
                nullFont = true;
            }
        }
        if (nullFont) {
            this.setFontName(null);
            this.setFontStyle(0);
            this.setFontSize(-1);
            this.setFontBaselineStyle(1);
            this.setFontWidth(-1);
            this.setFontColor(null);
            this.setFontBackgroundColor(null);
            this.setFontHorizontalAlignment(-1);
        } else {
            Object value;
            String name = font.getName();
            this.setFontName(name);
            int style = 0;
            if (font.isBold()) {
                style |= 1;
            }
            if (font.isItalic()) {
                style |= 2;
            }
            if (TextAttribute.UNDERLINE_ON.equals(value = attributes.get(TextAttribute.UNDERLINE))) {
                style |= 4;
            }
            if (TextAttribute.STRIKETHROUGH_ON.equals(value = attributes.get(TextAttribute.STRIKETHROUGH))) {
                style |= 8;
            }
            this.setFontStyle(style);
            this.setFontSize(font.getSize());
            int baselinestyle = 1;
            value = attributes.get(TextAttribute.SUPERSCRIPT);
            if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
                baselinestyle = 3;
            } else if (TextAttribute.SUPERSCRIPT_SUPER.equals(value)) {
                baselinestyle = 2;
            }
            this.setFontBaselineStyle(baselinestyle);
            int width = 2;
            value = attributes.get(TextAttribute.WIDTH);
            if (TextAttribute.WIDTH_CONDENSED.equals(value)) {
                width = 0;
            } else if (TextAttribute.WIDTH_EXTENDED.equals(value)) {
                width = 4;
            } else if (TextAttribute.WIDTH_SEMI_CONDENSED.equals(value)) {
                width = 1;
            } else if (TextAttribute.WIDTH_SEMI_EXTENDED.equals(value)) {
                width = 3;
            }
            this.setFontWidth(width);
            value = attributes.get(TextAttribute.FOREGROUND);
            if (value == null) {
                value = this.getUIDefaults().getColor(LookAndFeel.TEXT_TEXT);
            }
            this.setFontColor((Color)value);
            value = attributes.get(TextAttribute.BACKGROUND);
            if (value == null) {
                value = this.getUIDefaults().getColor(LookAndFeel.TEXT);
            }
            this.setFontBackgroundColor((Color)value);
            value = attributes.get(TextAttribute.JUSTIFICATION);
            if (TextAttribute.JUSTIFICATION_FULL.equals(value)) {
                this.setFontHorizontalAlignment(100);
            }
            this._setExampleFont(font);
        }
    }

    public void setActualFontSizeVisible(boolean actualFontSizeVisible) {
        if (actualFontSizeVisible != this._showFontSize.isVisible()) {
            this._showFontSize.setVisible(actualFontSizeVisible);
            this.revalidate();
        }
    }

    public boolean isActualFontSizeVisible() {
        return this._showFontSize == null ? false : this._showFontSize.isVisible();
    }

    public void setActualFontSizeUsed(boolean useActualFontSize) {
        if (useActualFontSize != this._showFontSize.isSelected()) {
            this._showFontSize.setSelected(useActualFontSize);
            this.updateExampleFont();
        }
    }

    public boolean isActualFontSizeUsed() {
        return this._showFontSize == null ? true : this._showFontSize.isSelected();
    }

    public ColorChoice getFontColorChoice() {
        return this._textColor;
    }

    public ColorChoice getFontBackgroundColorChoice() {
        return this._backgroundColor;
    }

    public ColorChoice getBorderColorChoice() {
        return this._borderColor;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._updateLabels(this.getLocale());
        if (!this._fontColorSet) {
            FontPane._trySetColorChoice(this._textColor, this._exampleComponent.getFontColor());
        }
        if (!this._fontBackgroundColorSet) {
            FontPane._trySetColorChoice(this._backgroundColor, this._exampleComponent.getFontBackgroundColor());
        }
        if (!this._fontBorderColorSet) {
            FontPane._trySetColorChoice(this._borderColor, this._exampleComponent.getFontBorderColor());
        }
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._fontLabel != null) {
            this._updateLabels(locale);
        }
        if (this._exampleComponent != null) {
            this._exampleComponent.setLocale(locale);
        }
        if (this._textColor != null) {
            this._textColor.setLocale(locale);
        }
        if (this._backgroundColor != null) {
            this._backgroundColor.setLocale(locale);
        }
        if (this._borderColor != null) {
            this._borderColor.setLocale(locale);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFontPane();
        }
        return this.accessibleContext;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._fontNames.setEnabled(enabled);
        this._sizes.setEnabled(enabled);
        this._bold.setEnabled(enabled);
        this._italic.setEnabled(enabled);
        this._underline.setEnabled(enabled);
        this._strikeThrough.setEnabled(enabled);
        this._superscript.setEnabled(enabled);
        this._subscript.setEnabled(enabled);
        this._widths.setEnabled(enabled);
        this._textColor.setEnabled(enabled);
        this._backgroundColor.setEnabled(enabled);
        this._borderColor.setEnabled(enabled);
        this._fullJustify.setEnabled(enabled);
        this._leftJustify.setEnabled(enabled);
        this._centerJustify.setEnabled(enabled);
        this._rightJustify.setEnabled(enabled);
        this._startJustify.setEnabled(enabled);
        this._endJustify.setEnabled(enabled);
        this._topJustify.setEnabled(enabled);
        this._middleJustify.setEnabled(enabled);
        this._bottomJustify.setEnabled(enabled);
        this._showFontSize.setEnabled(enabled);
        if (this.getExtraComponent() != null) {
            this.getExtraComponent().setEnabled(enabled);
        }
        this._styleLabel.setEnabled(enabled);
        this._widthLabel.setEnabled(enabled);
        this._fontLabel.setEnabled(enabled);
        this._sizeLabel.setEnabled(enabled);
        this._alignmentComponent.getTitle().setEnabled(enabled);
        this._colorComponent.getTitle().setEnabled(enabled);
        this._textColorLabel.setEnabled(enabled);
        this._backgroundColorLabel.setEnabled(enabled);
        this._borderColorLabel.setEnabled(enabled);
        this._exampleComponent.setEnabled(enabled);
        this._exampleLabel.setEnabled(enabled);
    }

    public static String getPreviewText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, locale);
        return b.getString(_KEY_EXAMPLE_TEXT);
    }

    public static String[] getDisplayableFonts() {
        return FontPane.getDisplayableFonts(FontPane.getPreviewText(Locale.getDefault()));
    }

    public static String[] getDisplayableFonts(String previewText) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        if (previewText == null) {
            return fontNames;
        }
        String[] temp = new String[fontNames.length];
        int newCount = 0;
        for (int i = 0; i < fontNames.length; ++i) {
            if (new Font(fontNames[i], 0, 12).canDisplayUpTo(previewText) != -1) continue;
            temp[newCount++] = fontNames[i];
        }
        String[] displayableFontNames = new String[newCount];
        System.arraycopy(temp, 0, displayableFontNames, 0, newCount);
        return displayableFontNames;
    }

    protected FontPreviewArea createFontPreviewArea() {
        return new FontPreviewArea();
    }

    Component __getFirstFocusComponent() {
        return this._fontNames;
    }

    void updateExampleFont() {
        this._setExampleFont(this.getCurrentFont());
    }

    void fireEvent(Object source, boolean selected) {
        if (source == this._fontNames) {
            if (selected) {
                this.firePropertyChange(PROPERTY_FONT_NAME, this._laggingFontName, this.getFontName());
                this._laggingFontName = this.getFontName();
            }
        } else if (source == this._sizes) {
            if (selected) {
                this.firePropertyChange(PROPERTY_FONT_SIZE, this._laggingFontSize, this.getFontSize());
                this._laggingFontSize = this.getFontSize();
            }
        } else if (source == this._bold || source == this._italic || source == this._underline || source == this._strikeThrough) {
            int style = this.getFontStyle();
            this._exampleComponent.setFontStyle(style);
            this.firePropertyChange(PROPERTY_FONT_STYLE, this._laggingFontStyle, style);
            this._laggingFontStyle = style;
        } else if (source == this._superscript || source == this._subscript) {
            if (selected) {
                if (source == this._superscript) {
                    this._subscript.setSelected(false);
                } else {
                    this._superscript.setSelected(false);
                }
            }
            int style = this.getFontBaselineStyle();
            this._exampleComponent.setFontBaselineStyle(style);
            this.firePropertyChange(PROPERTY_FONT_BASELINE_STYLE, this._laggingFontBaselineStyle, style);
            this._laggingFontBaselineStyle = style;
        } else if (source == this._widths) {
            if (selected) {
                this.firePropertyChange(PROPERTY_FONT_WIDTH, this._laggingFontWidth, this.getFontWidth());
                this._exampleComponent.setFontWidth(this.getFontWidth());
                this._laggingFontWidth = this.getFontWidth();
            }
        } else if (source == this._fullJustify || source == this._leftJustify || source == this._rightJustify || source == this._centerJustify || source == this._startJustify || source == this._endJustify) {
            if (selected) {
                int align = this.getFontHorizontalAlignment();
                this._exampleComponent.setFontHorizontalAlignment(align);
                this.firePropertyChange(PROPERTY_FONT_HORIZONTAL_ALIGNMENT, this._laggingFontHorizontalAlignment, align);
                this._laggingFontHorizontalAlignment = align;
            }
        } else if (source == this._topJustify || source == this._bottomJustify || source == this._middleJustify) {
            if (selected) {
                int align = this.getFontVerticalAlignment();
                this._exampleComponent.setFontVerticalAlignment(align);
                this.firePropertyChange(PROPERTY_FONT_VERTICAL_ALIGNMENT, this._laggingFontVerticalAlignment, align);
                this._laggingFontVerticalAlignment = align;
            }
        } else if (source == this._showFontSize) {
            this.firePropertyChange(PROPERTY_ACTUAL_FONT_SIZE_USED, new Boolean(!this.isActualFontSizeUsed()), new Boolean(this.isActualFontSizeUsed()));
        } else if (source == this._textColor) {
            Color c = this._textColor.getSelectedColor();
            this._exampleComponent.setFontColor(c);
            this.firePropertyChange(PROPERTY_FONT_COLOR, this._laggingFontColor, c);
            this._laggingFontColor = c;
        } else if (source == this._borderColor) {
            Color c = this._borderColor.getSelectedColor();
            this._exampleComponent.setFontBorderColor(c);
            this.firePropertyChange(PROPERTY_BORDER_COLOR, this._laggingBorderColor, c);
            this._laggingBorderColor = c;
        } else if (source == this._backgroundColor) {
            Color c = this._backgroundColor.getSelectedColor();
            this._exampleComponent.setFontBackgroundColor(c);
            this.firePropertyChange(PROPERTY_FONT_BACKGROUND_COLOR, this._laggingFontBackgroundColor, c);
            this._laggingFontBackgroundColor = c;
        }
    }

    private static Icon _createIcon(int icon) {
        if (_sIconStrip == null) {
            Image image = ImageUtils.getImageResource(FontPane.class, "icons/fontstrip.gif");
            _sIconStrip = new IconStrip(image, 16, false);
        }
        return _sIconStrip.getIcon(icon);
    }

    private static Icon _createDisabledIcon(int icon) {
        if (_sDisabledIconStrip == null) {
            Image image = ImageUtils.getImageResource(FontPane.class, "icons/fontstrip.gif");
            _sDisabledIconStrip = new IconStrip(image, 16, true);
        }
        return _sDisabledIconStrip.getIcon(icon);
    }

    private static Color _trySetColorChoice(ColorChoice choice, Color color) {
        try {
            boolean inMain = ColorChoice.isColorInPalette(choice.getColorPalette(), color);
            choice.setSelectedColor(color, !inMain);
        }
        catch (IllegalArgumentException e) {
            color = choice.getClosestColor(color);
            choice.setSelectedColor(color);
        }
        return color;
    }

    private static void _setText(JToggleButton button, String text, String accName) {
        button.setToolTipText(text);
        button.getAccessibleContext().setAccessibleName(accName);
        button.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
    }

    private void _setExampleFont(Font font) {
        int size = this.getFontSize();
        if (!this.isActualFontSizeUsed() || size == -1) {
            size = 12;
        }
        if (font != null) {
            font = new Font(font.getName(), font.getStyle(), size);
        } else {
            int style = 0;
            if (this._bold.isSelected()) {
                style |= 1;
            }
            if (this._italic.isSelected()) {
                style |= 2;
            }
            font = new Font(null, style, size);
        }
        this._exampleComponent.setCurrentFont(font);
    }

    private void _setButtonNames() {
        this._bold.setName(_BOLD_NAME);
        this._italic.setName(_ITALIC_NAME);
        this._underline.setName(_UNDERLINE_NAME);
        this._strikeThrough.setName(_STRIKETHRU_NAME);
        this._superscript.setName(_SUPERSCRIPT_NAME);
        this._subscript.setName(_SUBSCRIPT_NAME);
        this._textColor.setName(_TEXT_COLOR_NAME);
        this._backgroundColor.setName(_BACKGROUND_COLOR_NAME);
        this._borderColor.setName(_BORDER_COLOR_NAME);
        this._fullJustify.setName(_JUSTIFY_FULL_NAME);
        this._leftJustify.setName(_JUSTIFY_LEFT_NAME);
        this._centerJustify.setName(_JUSTIFY_CENTER_NAME);
        this._rightJustify.setName(_JUSTIFY_RIGHT_NAME);
        this._topJustify.setName(_JUSTIFY_TOP_NAME);
        this._middleJustify.setName(_JUSTIFY_MIDDLE_NAME);
        this._bottomJustify.setName(_JUSTIFY_BOTTOM_NAME);
        this._startJustify.setName(_JUSTIFY_START_NAME);
        this._endJustify.setName(_JUSTIFY_END_NAME);
        this._fontNames.setName(_FONT_NAME);
        this._sizes.setName(_SIZE_NAME);
        this._widths.setName(_WIDTH_NAME);
        this._showFontSize.setName(_ACTUAL_SIZE_NAME);
    }

    private void _updateLabels(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, locale);
        ResourceBundle ab = ResourceBundle.getBundle(_ACCESS_RESOURCE, locale);
        String translatedText = b.getString(_KEY_FONT);
        this._fontLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._fontLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = b.getString(_KEY_SIZE);
        this._sizeLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._sizeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this._styleLabel.setText(b.getString(_KEY_STYLE));
        FontPane._setText(this._bold, b.getString(_KEY_BOLD), ab.getString(_KEY_BOLD));
        FontPane._setText(this._italic, b.getString(_KEY_ITALIC), ab.getString(_KEY_ITALIC));
        FontPane._setText(this._underline, b.getString(_KEY_UNDERLINE), ab.getString(_KEY_UNDERLINE));
        FontPane._setText(this._strikeThrough, b.getString(_KEY_STRIKETHRU), ab.getString(_KEY_STRIKETHRU));
        FontPane._setText(this._superscript, b.getString(_KEY_SUPERSCRIPT), ab.getString(_KEY_SUPERSCRIPT));
        FontPane._setText(this._subscript, b.getString(_KEY_SUBSCRIPT), ab.getString(_KEY_SUBSCRIPT));
        int index = this._widths.getSelectedIndex();
        if (this._widths.getItemCount() > 0) {
            this._widths.removeAllItems();
        }
        this._widths.addItem(b.getString(_KEY_CONDENSED));
        this._widths.addItem(b.getString(_KEY_SEMI_CONDENSED));
        this._widths.addItem(b.getString(_KEY_NORMAL));
        this._widths.addItem(b.getString(_KEY_SEMI_EXPANDED));
        this._widths.addItem(b.getString(_KEY_EXPANDED));
        if (this._originalFontWidth != -2) {
            index = this._originalFontWidth;
            this._originalFontWidth = -2;
        } else if (index == -1) {
            index = 2;
        }
        this._widths.setSelectedIndex(index);
        translatedText = b.getString(_KEY_WIDTH);
        this._widthLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._widthLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        JLabel label = (JLabel)this._colorComponent.getTitle();
        label.setText(b.getString(_KEY_COLOR));
        translatedText = b.getString(_KEY_TEXT_COLOR);
        this._textColorLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._textColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = b.getString(_KEY_BACKGROUND_COLOR);
        this._backgroundColorLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._backgroundColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = b.getString(_KEY_BORDER_COLOR);
        this._borderColorLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._borderColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        label = (JLabel)this._alignmentComponent.getTitle();
        label.setText(b.getString(_KEY_ALIGNMENT));
        FontPane._setText(this._fullJustify, b.getString(_KEY_JUSTIFY_FULL), ab.getString(_KEY_JUSTIFY_FULL));
        FontPane._setText(this._leftJustify, b.getString(_KEY_JUSTIFY_LEFT), ab.getString(_KEY_JUSTIFY_LEFT));
        FontPane._setText(this._centerJustify, b.getString(_KEY_JUSTIFY_CENTER), ab.getString(_KEY_JUSTIFY_CENTER));
        FontPane._setText(this._rightJustify, b.getString(_KEY_JUSTIFY_RIGHT), ab.getString(_KEY_JUSTIFY_RIGHT));
        FontPane._setText(this._startJustify, b.getString(_KEY_JUSTIFY_START), ab.getString(_KEY_JUSTIFY_START));
        FontPane._setText(this._endJustify, b.getString(_KEY_JUSTIFY_END), ab.getString(_KEY_JUSTIFY_END));
        FontPane._setText(this._topJustify, b.getString(_KEY_JUSTIFY_TOP), ab.getString(_KEY_JUSTIFY_TOP));
        FontPane._setText(this._middleJustify, b.getString(_KEY_JUSTIFY_MIDDLE), ab.getString(_KEY_JUSTIFY_MIDDLE));
        FontPane._setText(this._bottomJustify, b.getString(_KEY_JUSTIFY_BOTTOM), ab.getString(_KEY_JUSTIFY_BOTTOM));
        this._exampleLabel.setText(b.getString(_KEY_EXAMPLE));
        translatedText = b.getString(_KEY_SHOW_ACTUAL);
        this._showFontSize.setText(StringUtils.stripMnemonic((String)translatedText));
        this._showFontSize.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
    }

    private void _setFontName() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.setFontNames(fontNames);
    }

    static {
        _sBORDER_COLOR_INSETS = new Insets(0, 10, 6, 2);
        _sDEFAULT_INSETS = new Insets(0, 0, 6, 2);
        _sLABEL_INSETS = new Insets(0, 0, 6, 3);
        _sSEPARATOR_INSETS = new Insets(0, 6, 6, 3);
    }

    private class NonNullSelComboBox
    extends JComboBox {
        public NonNullSelComboBox() {
        }

        public NonNullSelComboBox(Object[] dataSource) {
            super(dataSource);
        }

        @Override
        public void setSelectedItem(Object item) {
            if (item != null) {
                super.setSelectedItem(item);
            }
        }
    }

    private static class NumberEditor
    extends NumberTextField
    implements ComboBoxEditor {
        private int _maximumValue;

        public NumberEditor() {
            this.setColumns(3);
            this.setBorder(null);
            this.setSigned(false);
            this.setDecimal(false);
        }

        @Override
        public void setBorder(Border b) {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object anObject) {
            String text = anObject == null ? null : anObject.toString();
            this.setText(text);
        }

        @Override
        public Object getItem() {
            return this.getNumber();
        }

        @Override
        public void selectAll() {
            super.selectAll();
            this.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener l) {
            super.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            super.removeActionListener(l);
        }

        public void setMaximum(int value) {
            this._maximumValue = value;
        }

        @Override
        protected boolean validateNumber(Number n) {
            return n.intValue() <= this._maximumValue;
        }
    }

    private class FontPaneLayout
    implements LayoutManager {
        private final int _OFFSET = 10;
        private Component _left;

        private FontPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (FontPane._LEFT_CONSTRAINT.equals(name)) {
                this._left = comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this._left == comp) {
                this._left = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension(this._left.getPreferredSize());
            if (FontPane.this.isPreviewAreaVisible()) {
                d.width += 10;
                Dimension exampleAreaSize = FontPane.this._exampleArea.getPreferredSize();
                exampleAreaSize.width += 8;
                if (exampleAreaSize.height < 150) {
                    exampleAreaSize.height = 150;
                }
                if (exampleAreaSize.width < d.height) {
                    exampleAreaSize.width = d.height;
                }
                d.width += exampleAreaSize.width;
                d.height = Math.max(d.height, exampleAreaSize.height);
            }
            Insets insets = parent.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension d = new Dimension(this._left.getMinimumSize());
            if (FontPane.this.isPreviewAreaVisible()) {
                d.width += 10;
                Dimension exampleAreaSize = FontPane.this._exampleArea.getMinimumSize();
                if (exampleAreaSize.height < 150) {
                    exampleAreaSize.height = 150;
                }
                if (exampleAreaSize.width < d.height) {
                    exampleAreaSize.width = d.height;
                }
                d.width += exampleAreaSize.width;
                d.height = Math.max(d.height, exampleAreaSize.height);
            }
            Insets insets = parent.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            Dimension d = new Dimension(this._left.getPreferredSize());
            Dimension prefSize = null;
            Dimension minSize = null;
            int offset = 0;
            if (FontPane.this.isPreviewAreaVisible()) {
                prefSize = FontPane.this._exampleArea.getPreferredSize();
                minSize = FontPane.this._exampleArea.getMinimumSize();
                offset = 10;
            } else {
                prefSize = minSize = new Dimension(0, 0);
            }
            if (d.width + prefSize.width + offset < size.width) {
                prefSize.width = size.width - d.width;
                if (prefSize.width < minSize.width) {
                    d.width -= prefSize.width - minSize.width;
                    prefSize.width = minSize.width;
                }
            }
            this._left.setBounds(insets.left, insets.top, d.width, size.height);
            if (FontPane.this.isPreviewAreaVisible()) {
                int x = insets.left + d.width + 10;
                int width = size.width - x;
                FontPane.this._exampleArea.setBounds(x, insets.top, width, size.height);
            } else {
                FontPane.this._exampleArea.setBounds(0, 0, 0, 0);
            }
        }
    }

    private class UIListener
    implements ItemListener,
    PropertyChangeListener {
        private UIListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean selected = e.getStateChange() == 1;
            FontPane.this.fireEvent(e.getSource(), selected);
            FontPane.this.updateExampleFont();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("selectedColor".equals(name)) {
                FontPane.this.fireEvent(e.getSource(), true);
            }
            FontPane.this.updateExampleFont();
        }
    }

    private class AccessibleFontPane
    extends JComponent.AccessibleJComponent {
        public AccessibleFontPane() {
            super(FontPane.this);
        }
    }
}

