/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.Token;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.translation.api.TranslationLimitation;

public class TranslationLimitationManager {
    private TranslationHelper m_helper;
    private List<String> m_limitationObjects = new ArrayList<String>();

    public TranslationLimitationManager(TranslationHelper translationHelper) {
        if (translationHelper == null) {
            // empty if block
        }
        this.m_helper = translationHelper;
    }

    public void handleLimitation(AST aST, TranslationLimitation.Type type) {
        if (aST == null || type == null) {
            return;
        }
        TranslationLimitation translationLimitation = new TranslationLimitation(aST.getText(), type, aST.getSourceStartLine(), aST.getSourceStartCol(), aST.getSourceEndLine(), aST.getSourceEndCol(), this.getHelper().getSourceDBObject());
        this.getHelper().getTranslationMetaData().addTranslationLimitation(translationLimitation);
        this.reportLimitation(translationLimitation);
    }

    public void handleLimitation(String string, AST aST, TranslationLimitation.Type type) {
        if (string == null || aST == null || type == null) {
            return;
        }
        TranslationLimitation translationLimitation = new TranslationLimitation(aST.getText(), type, aST.getSourceStartLine(), aST.getSourceStartCol(), aST.getSourceEndLine(), aST.getSourceEndCol(), this.getHelper().getSourceDBObject());
        translationLimitation.setLabel(string);
        this.getHelper().getTranslationMetaData().addTranslationLimitation(translationLimitation);
        this.reportLimitation(translationLimitation);
    }

    public void handleLimitation(String string, AST aST, AST aST2, TranslationLimitation.Type type) {
        if (string == null || aST == null || aST2 == null || type == null) {
            return;
        }
        TranslationLimitation translationLimitation = new TranslationLimitation(aST.getText(), type, aST.getSourceStartLine(), aST.getSourceStartCol(), aST2.getSourceEndLine(), aST2.getSourceEndCol(), this.getHelper().getSourceDBObject());
        translationLimitation.setLabel(string);
        translationLimitation.setEndLine(aST2.getSourceEndLine());
        translationLimitation.setEndColumn(aST2.getSourceEndCol());
        if (type == TranslationLimitation.Type.FUNCTION) {
            String string2 = translationLimitation.getStartLine() + "," + translationLimitation.getStartColumn();
            translationLimitation.setStartLine(aST2.getSourceStartLine());
            translationLimitation.setStartColumn(aST2.getSourceStartCol());
            this.getHelper().getTranslationMetaData().addTranslationLimitation(translationLimitation, string2);
        } else {
            this.getHelper().getTranslationMetaData().addTranslationLimitation(translationLimitation);
        }
        this.reportLimitation(translationLimitation);
    }

    public void handleLimitation(Token token, Token token2, TranslationLimitation.Type type) {
        if (token == null || token2 == null || type == null) {
            return;
        }
        TranslationLimitation translationLimitation = new TranslationLimitation(token.getText(), type, token.getLine(), token.getColumn(), token2.getLine(), token2.getColumn(), this.getHelper().getSourceDBObject());
        this.getHelper().getTranslationMetaData().addTranslationLimitation(translationLimitation);
        if (this.getHelper().getSourceDBObject() != null) {
            this.reportLimitation(translationLimitation);
        }
    }

    private void reportLimitation(TranslationLimitation translationLimitation) {
        this.getHelper();
        if (TranslationHelper.getLogging() != null && translationLimitation != null) {
            this.getHelper();
            TranslationHelper.getLogging().reportLimitation(translationLimitation);
        }
    }

    private TranslationHelper getHelper() {
        return this.m_helper;
    }

    public List<String> getLimitationObjects() {
        return this.m_limitationObjects;
    }

    public void addLimitationObject(String string) {
        this.m_limitationObjects.add(string);
    }
}

